/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.treeBuilder;

import com.syscom.ut.GuiUt;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.schema.node.ColumnNode;
import com.syscom.xml.schema.node.TableNode;
import com.syscom.xml.xtm.XtmDef;
import com.syscom.xml.xtm.XtmInfo;
import com.syscom.xml.xtm.jdbc.WrapParameterMetaData;
import com.syscom.xml.xtm.node.AbstractXtmMutableTreeNode;
import com.syscom.xml.xtm.node.XslTemplateNode;
import com.syscom.xml.xtm.node.XtmColumnNode;
import com.syscom.xml.xtm.node.XtmConnectNode;
import com.syscom.xml.xtm.node.XtmPreparedStatementNode;
import com.syscom.xml.xtm.node.XtmSetParameterNode;
import com.syscom.xml.xtm.node.XtmTableNode;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XtmTreeBuilder {
    public static AbstractXtmMutableTreeNode getTree(String filename) throws Exception {
        XslTemplateNode root = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new File(filename));
        Element e = document.getDocumentElement();
        Element sNode = (Element)XtmDef.searchNode(e, XtmDef.XSL_NAMESPACE, "stylesheet", (short)1);
        if (sNode == null) {
            ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.gui.resource.Res", LocaleManager.getLocale());
            throw new Exception(GuiUt.mapStringForProperty(res.getString("not_valid_xsl_file"), filename));
        }
        Element tNode = (Element)XtmDef.searchNode(sNode, XtmDef.XSL_NAMESPACE, "template", (short)1);
        if (tNode != null) {
            root = new XslTemplateNode(tNode);
        }
        if (root == null) {
            root = new XslTemplateNode();
        }
        return root;
    }

    public static void initXtmSetParameter(AbstractXtmMutableTreeNode current, Connection conn) {
        if (conn == null) {
            return;
        }
        if (current instanceof XtmPreparedStatementNode) {
            XtmPreparedStatementNode xtmStmt = (XtmPreparedStatementNode)current;
            int[] types = null;
            try {
                PreparedStatement pstmt = conn.prepareStatement(xtmStmt.getCommand());
                WrapParameterMetaData pmd = WrapParameterMetaData.getParameterMetaData(pstmt);
                int count = pmd.getParameterCount();
                types = new int[count];
                for (int i = 0; i < count; ++i) {
                    types[i] = pmd.getParameterType(i + 1);
                }
                pstmt.close();
            }
            catch (SQLException sqle) {
                System.out.println(sqle.getMessage());
                sqle.printStackTrace();
            }
            catch (Exception ne) {
                System.out.println(ne.getMessage());
            }
            if (types != null && types.length > 0) {
                int index = 0;
                int size = xtmStmt.getChildCount();
                if (size > 0) {
                    for (AbstractXtmMutableTreeNode child = (AbstractXtmMutableTreeNode)current.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
                        if (child instanceof XtmSetParameterNode) {
                            ((XtmSetParameterNode)child).setType(types[index++]);
                        }
                        if (index >= types.length) break;
                    }
                }
            }
        }
        if (current.getChildCount() > 0) {
            for (AbstractXtmMutableTreeNode child = (AbstractXtmMutableTreeNode)current.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
                XtmTreeBuilder.initXtmSetParameter(child, conn);
            }
        }
    }

    public static void initXtmColumn(AbstractXtmMutableTreeNode current, Connection conn) {
        if (conn == null) {
            return;
        }
        if (current instanceof XtmTableNode) {
            XtmTableNode xtmTable = (XtmTableNode)current;
            Vector v = TableNode.getColumns(conn, xtmTable.getOwner(), xtmTable.getName());
            ColumnNode column = null;
            XtmColumnNode xtmCol = null;
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                column = (ColumnNode)v.elementAt(i);
                xtmCol = xtmTable.searchChild(column.getText());
                if (xtmCol == null) {
                    xtmTable.add(new XtmColumnNode(column.getText(), column.getType()));
                    continue;
                }
                xtmCol.setType(column.getType());
            }
        }
        if (current.getChildCount() > 0) {
            for (AbstractXtmMutableTreeNode child = (AbstractXtmMutableTreeNode)current.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
                XtmTreeBuilder.initXtmColumn(child, conn);
            }
        }
    }

    public static boolean initConnectionDetail(AbstractXtmMutableTreeNode node, XtmInfo info) {
        boolean found = false;
        String temp = null;
        if (node instanceof XtmConnectNode) {
            found = true;
            info.driver = ((XtmConnectNode)node).getDriver();
            info.datasource = ((XtmConnectNode)node).getDatasource();
            temp = ((XtmConnectNode)node).getUesr();
            if (temp != null && temp.length() != 0) {
                info.user = temp;
            }
            if ((temp = ((XtmConnectNode)node).getPassword()) != null && temp.length() != 0) {
                info.password = temp;
            }
        } else if (node.getChildCount() > 0) {
            for (AbstractXtmMutableTreeNode child = (AbstractXtmMutableTreeNode)node.getFirstChild(); child != null && !(found = XtmTreeBuilder.initConnectionDetail(child, info)); child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
            }
        }
        return found;
    }
}

