/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.node;

import com.syscom.tree.AbstractDmMutableTreeNode;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.xml.node.AbstractXmlMutableTreeNode;
import com.syscom.xml.node.AttributeNode;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementNode
extends AbstractXmlMutableTreeNode {
    private static ImageIcon icon = null;
    private static String imagefilename = "/images/tree/xml/element.gif";
    private String namespace = null;
    private String localname = null;
    private String prefix = null;

    @Override
    public void organize() {
        if (this.namespace != null) {
            this.prefix = this.getPrefixByNamespace(this.prefix, this.namespace);
        }
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            ((AbstractXmlMutableTreeNode)this.getChildAt(i)).organize();
        }
    }

    @Override
    public String getLocalName() {
        return this.localname;
    }

    public ElementNode(String name) {
        this.localname = name;
    }

    public ElementNode(Element elm) {
        this.namespace = elm.getNamespaceURI();
        this.localname = elm.getLocalName();
        this.prefix = elm.getPrefix();
        NamedNodeMap attrs = elm.getAttributes();
        Attr attr = null;
        String ns = null;
        Object l = null;
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            attr = (Attr)attrs.item(i);
            ns = attr.getNamespaceURI();
            if (ns != null && ns.equals("http://www.w3.org/2000/xmlns/")) continue;
            this.add(new AttributeNode(attr));
        }
        ElementNode another = null;
        for (Node node = elm.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            another = (ElementNode)this.search(node.getNamespaceURI(), node.getLocalName(), ElementNode.class);
            if (another == null) {
                this.add(new ElementNode((Element)node));
                continue;
            }
            another.merge((Element)node);
        }
    }

    public int getLastAttrPosition() {
        int i;
        int size = this.getChildCount();
        for (i = 0; i < size && !(this.getChildAt(i) instanceof ElementNode); ++i) {
        }
        return i;
    }

    public void add(DefaultMutableTreeNode node) {
        if (node instanceof AttributeNode) {
            int i = this.getLastAttrPosition();
            super.insert(node, i);
        } else {
            super.add(node);
        }
    }

    public void merge(Element elm) {
        NamedNodeMap attrs = elm.getAttributes();
        Attr attr = null;
        String ns = null;
        String lname = null;
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            attr = (Attr)attrs.item(i);
            ns = attr.getNamespaceURI();
            if (this.search(ns, lname = attr.getLocalName(), AttributeNode.class) != null || ns != null && ns.equals("http://www.w3.org/2000/xmlns/")) continue;
            this.add(new AttributeNode(attr));
        }
        ElementNode lastmatch = null;
        ElementNode temp = null;
        for (Node node = elm.getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            ns = node.getNamespaceURI();
            temp = (ElementNode)this.search(ns, lname = node.getLocalName(), ElementNode.class);
            if (temp != null) {
                lastmatch = temp;
                continue;
            }
            ElementNode newNode = new ElementNode((Element)node);
            if (lastmatch != null) {
                this.insert(newNode, this.getIndex(lastmatch));
                lastmatch = newNode;
                continue;
            }
            this.add(newNode);
        }
    }

    @Override
    public boolean isSame(String ns, String lname) {
        return (this.namespace != null && this.namespace.equals(ns) || this.namespace == null && ns == null) && this.localname.equals(lname);
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), imagefilename);
        }
        return icon;
    }

    @Override
    public String getText() {
        if (this.prefix != null) {
            return this.prefix + ":" + this.localname;
        }
        return this.localname;
    }

    @Override
    public String getXPath() {
        TreeNode[] path = this.getPath();
        StringBuffer sb = new StringBuffer();
        String temp = null;
        int size = path.length;
        for (int i = 0; i < size; ++i) {
            temp = ((AbstractDmMutableTreeNode)path[i]).getText();
            if (temp == null || temp.length() <= 0) continue;
            sb.append('/');
            sb.append(temp);
        }
        return sb.toString();
    }

    public AbstractXmlMutableTreeNode searchChild(String name) {
        if (this.getChildCount() == 0) {
            return null;
        }
        for (AbstractXmlMutableTreeNode child = (AbstractXmlMutableTreeNode)this.getFirstChild(); child != null; child = (AbstractXmlMutableTreeNode)child.getNextSibling()) {
            if (child.getLocalName().compareToIgnoreCase(name) != 0) continue;
            return child;
        }
        return null;
    }
}

