/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut.comp;

import com.syscom.ut.comp.DbaFileFilter;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class DbaFileChooser
extends JFileChooser {
    private String path = null;

    @Override
    public File getSelectedFile() {
        File file = super.getSelectedFile();
        FileFilter filter = this.getFileFilter();
        if (filter instanceof DbaFileFilter && file != null && !file.exists()) {
            String extension = ((DbaFileFilter)filter).getExtesion();
            String fileseparator = System.getProperty("file.separator");
            String str = file.getAbsolutePath();
            int dot = str.lastIndexOf(46);
            int separator = str.lastIndexOf(fileseparator);
            if (dot < 0 || dot < separator) {
                file = new File(str + "." + extension);
            }
        }
        return file;
    }

    @Override
    public void setCurrentDirectory(File f) {
        super.setCurrentDirectory(f);
        this.path = f != null ? f.getAbsolutePath() : null;
    }

    public void setCurrentDirectory(String path) {
        this.path = path;
    }

    @Override
    public int showDialog(Component comp, String text) {
        if (this.path != null) {
            super.setCurrentDirectory(new File(this.path));
        } else {
            String p = System.getProperty("dbmaker.filechooser.dir");
            if (p != null) {
                super.setCurrentDirectory(new File(p));
            } else {
                p = System.getProperty("user.dir");
                if (p != null) {
                    super.setCurrentDirectory(new File(p));
                }
            }
        }
        int state = super.showDialog(comp, text);
        if (state == 0) {
            System.setProperty("dbmaker.filechooser.dir", this.getSelectedFile().getPath());
        }
        return state;
    }
}

