/*
 * Decompiled with CFR 0.152.
 */
package wizard.idx;

import com.syscom.tree.DmTree;
import com.syscom.ut.textField.FilePathField;
import com.syscom.xml.node.AbstractXmlMutableTreeNode;
import com.syscom.xml.treeBuilder.DTDHandler;
import com.syscom.xml.treeBuilder.XSDParser;
import com.syscom.xml.treeBuilder.XmlTreeBuilder;
import dbatool.DbFrame;
import dbatool.TableNameObject;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaFileFilter;
import dbaut.comp.GridLayout2;
import dbaut.comp.ReflectionAction;
import dbaut.comp.WizardTextPane;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;
import wizard.AbstractWizardPanel;
import wizard.idx.Panel_idx5;
import wizard.idx.Wizard_idx;

public class Panel_xml
extends AbstractWizardPanel {
    private static final long serialVersionUID = 8139608917559453858L;
    private JComboBox columnComboBox = null;
    private FilePathField xmlField = null;
    private JComboBox udfComboBox = new JComboBox<String>(new String[]{"extract", "extractValue"});
    private Wizard_idx parentWizard = null;
    private JScrollPane treePanel = new JScrollPane();
    private DmTree tree = null;
    private AbstractWizardPanel previous = null;
    private AbstractWizardPanel next = null;

    public Panel_xml(Wizard_idx parent, AbstractWizardPanel previous) {
        super(1);
        try {
            this.parentWizard = parent;
            this.previous = previous;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Panel_xml(Wizard_idx paraWizard) {
        this(paraWizard, null);
    }

    private void jbInit() throws Exception {
        DBAResourceBundle res = this.parentWizard.res;
        this.setTextPanel(new WizardTextPane(20, 14, Color.WHITE, res.getString("create_xml_index_desc")));
        this.setImage(new JLabel(DBAImageResource.getResource(this.getClass(), "/jdbaimages/idxwizard-2.gif")));
        this.columnComboBox = new JComboBox<String>(this.getColumnName());
        this.xmlField = new FilePathField(this, null, new FileFilter[]{new DbaFileFilter("xml", res.getString("XML_Document_Type")), new DbaFileFilter("dtd", res.getString("DTD_Document_dtd_")), new DbaFileFilter("xsd", res.getString("XSD_Document_xsd_"))});
        this.xmlField.setPreferredSize(new Dimension(200, 22));
        this.xmlField.addActionListener(new ReflectionAction(this, "xmlField_actionPerformed"));
        JPanel content = new JPanel(new BorderLayout());
        JPanel top = new JPanel(new GridLayout2(3, 2, 5, 5));
        top.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        top.add(new JLabel(res.getString("xml_column")));
        top.add(this.columnComboBox);
        top.add(new JLabel(res.getString("schema_dtd_xml")));
        top.add(this.xmlField);
        top.add(new JLabel(res.getString("xml_udf")));
        top.add(this.udfComboBox);
        content.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        content.add((Component)top, "North");
        content.add((Component)this.treePanel, "Center");
        this.add((Component)content, "Center");
    }

    private Vector<String> getColumnName() {
        Vector<String> v = new Vector<String>();
        TableNameObject tnObj = this.parentWizard.tnObj;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String queryStr = "select COLUMN_NAME from SYSTEM.SYSCOLUMN  where TABLE_NAME = '" + tnObj.name + "'" + " and TABLE_OWNER = '" + tnObj.owner + "'" + " and (TYPE_NAME = 'XMLTYPE' or TYPE_NAME = 'XMLFILETYPE' )" + " order by COLUMN_ORDER";
            rs = stmt.executeQuery(queryStr);
            while (rs.next()) {
                v.addElement(rs.getString(1).trim());
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException qtne) {
            GuiUt.showSQLException(this, null, qtne);
            System.out.println(qtne.getMessage());
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        return v;
    }

    @Override
    public AbstractWizardPanel previous() {
        return this.previous;
    }

    @Override
    public AbstractWizardPanel next() {
        String txt = null;
        TreePath ps = this.tree.getSelectionPath();
        txt = (String)this.udfComboBox.getSelectedItem();
        txt = txt + "(";
        txt = txt + (String)this.columnComboBox.getSelectedItem();
        txt = txt + ", '";
        txt = txt + ((AbstractXmlMutableTreeNode)ps.getLastPathComponent()).getXPath();
        txt = txt + "', ";
        Hashtable ns = ((AbstractXmlMutableTreeNode)ps.getLastPathComponent()).getNamespaces();
        if (ns == null) {
            txt = txt + "NULL";
        } else {
            txt = txt + "'";
            Enumeration e = ns.keys();
            String prefix = null;
            String namespace = null;
            while (e.hasMoreElements()) {
                namespace = (String)e.nextElement();
                prefix = (String)ns.get(namespace);
                txt = txt + prefix + "=\"" + namespace + "\" ";
            }
            txt = txt + "'";
        }
        this.parentWizard.indexColumns = txt = txt + ")";
        if (this.next == null) {
            this.next = new Panel_idx5(this.parentWizard, this);
        }
        if (this.udfComboBox.getSelectedIndex() == 0) {
            ((Panel_idx5)this.next).unique_CheckBox.setEnabled(false);
            ((Panel_idx5)this.next).unique_CheckBox.setSelected(false);
        } else {
            ((Panel_idx5)this.next).unique_CheckBox.setEnabled(true);
        }
        return this.next;
    }

    @Override
    public String getTitle() {
        return this.parentWizard.res.getString("XML_index");
    }

    @Override
    public String getHelpId() {
        return "Wizard_idx_xmlHelpIDInformation";
    }

    @Override
    public boolean check() {
        if (this.tree == null) {
            GuiUt.showWarningDlg(this.parentWizard, this.parentWizard.res.getString("Warning"), this.parentWizard.res.getString("Please_xml_schema"));
            return false;
        }
        if (this.tree.getSelectionPath() == null) {
            GuiUt.showWarningDlg(this.parentWizard, this.parentWizard.res.getString("Warning"), this.parentWizard.res.getString("Please_select_node"));
            return false;
        }
        return true;
    }

    public void xmlField_actionPerformed(ActionEvent e) {
        if (this.xmlField.isEmpty()) {
            return;
        }
        this.tree = this.buildTree(this.xmlField.getText().trim());
        this.expandTree(this.tree, Integer.MAX_VALUE, 1);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.treePanel.getViewport().add(this.tree);
    }

    private DmTree buildTree(String filename) {
        DmTree t = null;
        AbstractXmlMutableTreeNode node = null;
        String temp = filename.toLowerCase();
        try {
            if (temp.endsWith("dtd")) {
                node = DTDHandler.getTree(filename);
                t = new DmTree(node);
                t.setRootVisible(false);
            } else if (temp.endsWith("xsd")) {
                node = XSDParser.getTree(filename);
                t = new DmTree(node);
                t.setRootVisible(false);
            } else {
                node = XmlTreeBuilder.getTree(filename);
                t = new DmTree(node);
            }
        }
        catch (Exception e1) {
            System.out.println(e1.getMessage());
            e1.printStackTrace();
            return null;
        }
        return t;
    }

    private void expandTree(JTree tree, int max, int cur) {
        if (cur >= max) {
            return;
        }
        int count = tree.getRowCount();
        for (int i = 0; i < count; ++i) {
            tree.expandRow(i);
        }
        if (tree.getRowCount() != count) {
            this.expandTree(tree, max, cur + 1);
        }
    }
}

