/*
 * Decompiled with CFR 0.152.
 */
package wizard.group;

import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.HelpButton;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import wizard.group.GroupMember;
import wizard.group.Panel_group1;
import wizard.group.Panel_group2;
import wizard.group.Panel_group3;
import wizard.group.Panel_group4;

public class Wizard_group
extends JDialog {
    private static final long serialVersionUID = -5568225519610594637L;
    DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.wizard.ResWizard", LocaleManager.getLocale());
    JPanel jPanel1 = new JPanel(new BorderLayout());
    DbaButton Cancel_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancelwizard.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
    DbaButton Next_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Next_"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/next.gif"), new ReflectionAction(this, "Next_Button_actionPerformed"));
    DbaButton Previous_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("_Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/jdbaimages/previous.gif"), new ReflectionAction(this, "Previous_Button_actionPerformed"));
    private Vector panels = new Vector();
    private int cur_step = 0;
    Color sysColor = UIManager.getColor(new UIManager());
    private boolean isMoreTimes = false;
    HelpButton help_Button = new HelpButton();

    public Wizard_group(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Wizard_group(Frame frame) {
        super(frame);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String combineSqlString() {
        Panel_group2 tmpGroup2 = (Panel_group2)this.panels.elementAt(1);
        String sqlString = "create group ";
        sqlString = sqlString + "\"" + tmpGroup2.groupName_TextField.getText().trim() + "\"" + ";\n";
        return sqlString;
    }

    private String addMemberToGroup() {
        Panel_group2 myGroup2 = (Panel_group2)this.panels.elementAt(1);
        Panel_group3 myGroup3 = (Panel_group3)this.panels.elementAt(2);
        int selectedListSize = 0;
        DefaultListModel model = (DefaultListModel)myGroup3.jList2.getModel();
        selectedListSize = model.size();
        GroupMember obj = (GroupMember)model.elementAt(0);
        String sqlStr = "add " + GuiUt.getIDString(obj.name);
        for (int i = 1; i < selectedListSize; ++i) {
            obj = (GroupMember)model.elementAt(i);
            sqlStr = sqlStr + ", " + GuiUt.getIDString(obj.name);
        }
        sqlStr = sqlStr + " to group " + GuiUt.getIDString(myGroup2.groupName_TextField.getText()) + ";\n";
        return sqlStr;
    }

    void setHelpId(int step) {
        String[] ids = new String[]{"Wizard_group_StepOneHelpIDInformation", "Wizard_group_StepTwoHelpIDInformation", "Wizard_group_StepThreeHelpIDInformation", "Wizard_group_StepFourHelpIDInformation"};
        if (step < 0 || step >= ids.length) {
            return;
        }
        DbFrame.frame.enableDialogHelp(this.getRootPane(), this.help_Button, ids[step], null);
    }

    void jbInit() throws Exception {
        this.setName("GroupDialogWizard");
        this.Cancel_Button.setName("CancelButton");
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(new Dimension(640, 480));
        this.setTitle(this.res.getString("Create_Group_Wizard"));
        this.jPanel1.setPreferredSize(new Dimension(640, 480));
        this.jPanel1.setMaximumSize(new Dimension(640, 480));
        this.jPanel1.setMinimumSize(new Dimension(640, 480));
        this.Next_Button.setHorizontalTextPosition(2);
        if (this.cur_step == 0) {
            this.panels.add(this.cur_step, new Panel_group1(this));
            this.jPanel1.add((Component)((Panel_group1)this.panels.elementAt(this.cur_step)), "Center");
            this.Previous_Button.setEnabled(false);
            this.setHelpId(this.cur_step);
            ++this.cur_step;
        }
        this.help_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/help.gif"));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.add(this.Previous_Button);
        bottomPanel.add(this.Next_Button);
        bottomPanel.add(this.Cancel_Button);
        bottomPanel.add(this.help_Button);
        this.jPanel1.add((Component)bottomPanel, "South");
        this.Next_Button.setEnabled(true);
    }

    public void Next_Button_actionPerformed(ActionEvent e) {
        Panel_group4 tmpGroup4;
        JPanel cur_panel = (JPanel)this.panels.elementAt(this.cur_step - 1);
        if (cur_panel instanceof Panel_group4) {
            tmpGroup4 = (Panel_group4)cur_panel;
            String s = tmpGroup4.jEditorPane1.getText().trim();
            if (DatabaseConnection.executeMultiSQL(this, s, false, false)) {
                GuiUt.showInformationDlg(this, this.res.getString("Add_groups_or_users_to_this_group_successfully"));
                this.setVisible(false);
                this.panels.removeAllElements();
                this.dispose();
            }
        } else {
            Panel_group2 group2;
            if (this.panels.size() == this.cur_step) {
                if (this.cur_step == 1) {
                    this.panels.add(this.cur_step, new Panel_group2(this));
                    this.jPanel1.remove((Panel_group1)this.panels.elementAt(this.cur_step - 1));
                    this.jPanel1.add((Component)((Panel_group2)this.panels.elementAt(this.cur_step)), "Center");
                    this.setTitle(this.res.getString("Create_Group_Wizard_Name_the_Group"));
                } else if (this.cur_step == 2) {
                    group2 = (Panel_group2)this.panels.elementAt(this.cur_step - 1);
                    if (DbFrame.conn_DatabaseConnection.isGroupNameExist(group2.groupName_TextField.getText().trim())) {
                        GuiUt.showWarningDlg(this, this.res.getString("Warning"), group2.groupName_TextField.getText().trim() + " " + this.res.getString("already_exist"));
                        --this.cur_step;
                    } else {
                        this.panels.add(this.cur_step, new Panel_group3(this));
                        this.jPanel1.remove((Panel_group2)this.panels.elementAt(this.cur_step - 1));
                        this.jPanel1.add((Component)((Panel_group3)this.panels.elementAt(this.cur_step)), "Center");
                        this.setTitle(this.res.getString("Create_Group_Wizard_To_Be_Other_Group_Members"));
                    }
                } else if (this.cur_step == 3) {
                    tmpGroup4 = new Panel_group4(this);
                    Panel_group3 tmpGroup3 = (Panel_group3)this.panels.elementAt(2);
                    DefaultListModel model = (DefaultListModel)tmpGroup3.jList2.getModel();
                    if (model.size() > 0) {
                        tmpGroup4.jEditorPane1.setText(this.combineSqlString() + this.addMemberToGroup());
                    } else {
                        tmpGroup4.jEditorPane1.setText(this.combineSqlString());
                    }
                    this.panels.add(this.cur_step, tmpGroup4);
                    this.jPanel1.remove((Panel_group3)this.panels.elementAt(this.cur_step - 1));
                    this.jPanel1.add((Component)((Panel_group4)this.panels.elementAt(this.cur_step)), "Center");
                    this.Next_Button.setText(this.res.getString("Finish"));
                    this.Next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"));
                    this.Next_Button.setMnemonic('F');
                    this.Next_Button.setName("FinishButton");
                    this.setTitle(this.res.getString("Create_Group_Wizard_Final_reivew"));
                }
            } else if (this.cur_step == 1) {
                this.jPanel1.remove((Panel_group1)this.panels.elementAt(this.cur_step - 1));
                this.jPanel1.add((Component)((Panel_group2)this.panels.elementAt(this.cur_step)), "Center");
                this.isMoreTimes = true;
                this.setTitle(this.res.getString("Create_Group_Wizard_Name_the_Group"));
            } else if (this.cur_step == 2) {
                group2 = (Panel_group2)this.panels.elementAt(this.cur_step - 1);
                if (DbFrame.conn_DatabaseConnection.isGroupNameExist(group2.groupName_TextField.getText().trim())) {
                    GuiUt.showWarningDlg(this, this.res.getString("Warning"), group2.groupName_TextField.getText().trim() + " " + this.res.getString("already_exist"));
                    --this.cur_step;
                } else {
                    this.jPanel1.remove((Panel_group2)this.panels.elementAt(this.cur_step - 1));
                    this.jPanel1.add((Component)((Panel_group3)this.panels.elementAt(this.cur_step)), "Center");
                    this.setTitle(this.res.getString("Create_Group_Wizard_To_Be_Other_Group_Members"));
                }
            } else if (this.cur_step == 3) {
                tmpGroup4 = (Panel_group4)this.panels.elementAt(this.cur_step);
                Panel_group3 tmpGroup3 = (Panel_group3)this.panels.elementAt(2);
                DefaultListModel model = (DefaultListModel)tmpGroup3.jList2.getModel();
                if (model.size() > 0) {
                    tmpGroup4.jEditorPane1.setText(this.combineSqlString() + this.addMemberToGroup());
                } else {
                    tmpGroup4.jEditorPane1.setText(this.combineSqlString());
                }
                this.jPanel1.remove((Panel_group3)this.panels.elementAt(this.cur_step - 1));
                this.jPanel1.add((Component)((Panel_group4)this.panels.elementAt(this.cur_step)), "Center");
                this.Next_Button.setText(this.res.getString("Finish"));
                this.Next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"));
                this.Next_Button.setMnemonic('F');
                this.Next_Button.setName("FinishButton");
                this.setTitle(this.res.getString("Create_Group_Wizard_Final_reivew"));
            }
            this.Previous_Button.setEnabled(true);
            this.jPanel1.revalidate();
            this.jPanel1.repaint();
            this.setHelpId(this.cur_step);
            ++this.cur_step;
        }
        if (this.isMoreTimes) {
            Panel_group2 myTidx2 = (Panel_group2)this.panels.elementAt(this.cur_step - 1);
            if (myTidx2.groupName_TextField.getText().equalsIgnoreCase("")) {
                this.Next_Button.setEnabled(false);
            } else {
                this.Next_Button.setEnabled(true);
            }
            this.isMoreTimes = false;
        }
    }

    public void Previous_Button_actionPerformed(ActionEvent e) {
        --this.cur_step;
        this.setHelpId(this.cur_step - 1);
        if (this.cur_step == 1) {
            this.jPanel1.remove((Panel_group2)this.panels.elementAt(this.cur_step));
            this.jPanel1.add((Component)((Panel_group1)this.panels.elementAt(this.cur_step - 1)), "Center");
            this.Previous_Button.setEnabled(false);
            this.Next_Button.setEnabled(true);
            this.setTitle(this.res.getString("Create_Group_Wizard"));
        } else if (this.cur_step == 2) {
            this.jPanel1.remove((Panel_group3)this.panels.elementAt(this.cur_step));
            this.jPanel1.add((Component)((Panel_group2)this.panels.elementAt(this.cur_step - 1)), "Center");
            this.setTitle(this.res.getString("Create_Group_Wizard_Name_the_Group"));
        } else if (this.cur_step == 3) {
            this.jPanel1.remove((Panel_group4)this.panels.elementAt(this.cur_step));
            this.jPanel1.add((Component)((Panel_group3)this.panels.elementAt(this.cur_step - 1)), "Center");
            this.setTitle(this.res.getString("Create_Group_Wizard_To_Be_Other_Group_Members"));
        }
        this.Next_Button.setText(this.res.getString("Next_"));
        this.Next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/next.gif"));
        this.Next_Button.setMnemonic('N');
        this.Next_Button.setName("NextButton");
        this.jPanel1.revalidate();
        this.jPanel1.repaint();
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.panels.removeAllElements();
        this.dispose();
    }
}

