/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import dbaut.GuiUt;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import ui.gui.JsqlGUI;
import ui.gui.JsqlHistoryDialog;

public class JsqlToolBar
extends JToolBar {
    private static final int MAX_LEN = 50;
    private JsqlGUI ui = null;
    private JButton connectButton = new JButton();
    private JButton disConnectButton = new JButton();
    private JButton abortCMDButton = new JButton();
    private JButton abortFetchButton = new JButton();
    private JButton historyButton = new JButton();
    private JButton historyListButton = new JButton();
    private JComboBox consList = new JComboBox();
    private ArrayList<String> cmds = null;

    public JsqlToolBar(JsqlGUI ui) {
        this.ui = ui;
        this.init();
    }

    private void init() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setFloatable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add(this.connectButton);
        this.add(this.disConnectButton);
        this.add(this.abortCMDButton);
        this.add(this.abortFetchButton);
        this.add(this.historyButton);
        this.add(this.historyListButton);
        this.consList.setPreferredSize(new Dimension(160, 24));
        for (int i = 0; i < 8; ++i) {
            this.consList.addItem(i + 1 + ": not connected yet");
        }
        this.consList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JsqlToolBar.this.consListItemChanged(e);
            }
        });
        this.consList.setEnabled(false);
        this.add(this.consList);
        this.setButtonTexts();
        this.setNames();
        this.connectButton.addActionListener(new ReflectionAction(this, "connectButtonActionPerformed"));
        this.disConnectButton.addActionListener(new ReflectionAction(this, "disConnectButtonActionPerformed"));
        this.abortCMDButton.addActionListener(new ReflectionAction(this, "abortCMDButtonActionPerformed"));
        this.abortFetchButton.addActionListener(new ReflectionAction(this, "abortFetchButtonActionPerformed"));
        this.historyButton.addActionListener(new ReflectionAction(this, "historyButtonActionPerformed"));
        this.historyListButton.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/down.gif"));
        this.historyListButton.setPreferredSize(new Dimension(15, 27));
        this.historyListButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JsqlToolBar.this.historyListButtonPerformed(e);
            }
        });
        this.setFocusable(false);
        this.disConnectButton.setEnabled(false);
        this.setAbortFetchEnabled(false);
    }

    @Override
    public void setFocusable(boolean isFocusAble) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setFocusable(isFocusAble);
        }
    }

    private void setButtonTexts() {
        this.connectButton.setText("Connect");
        this.disConnectButton.setText("Disconnect");
        this.abortCMDButton.setText("Abort Command");
        this.abortFetchButton.setText("Abort Fetch");
        this.historyButton.setText("History");
    }

    private void setNames() {
        this.setName("JsqlToolBar");
        this.connectButton.setName("ConnectButton");
        this.disConnectButton.setName("DisconnectButton");
        this.abortCMDButton.setName("AbortCMDButton");
        this.abortFetchButton.setName("AbortFetchButton");
        this.historyButton.setName("HistoryButton");
        this.historyListButton.setName("HistoryListButton");
        this.consList.setName("ConnectionsList");
    }

    private void consListItemChanged(ItemEvent e) {
        this.ui.setCurrentConnectionID(this.consList.getSelectedIndex());
        if (this.ui.isCurrentConnectionConnected()) {
            this.ui.getFrame().getJMenuBar().initConPropComps();
            this.ui.getFrame().getJMenuBar().setConPropCompsEnabled(true);
            this.setToolBarStatus(true);
        } else {
            this.ui.getFrame().getJMenuBar().setConPropCompsEnabled(false);
            this.setToolBarStatus(false);
        }
    }

    private void setToolBarStatus(boolean enabled) {
        this.disConnectButton.setEnabled(enabled);
    }

    public void setConnectionsListItem(int index, String value) {
        DefaultComboBoxModel m = (DefaultComboBoxModel)this.consList.getModel();
        m.removeElementAt(index);
        m.insertElementAt(value, index);
        this.consList.setSelectedIndex(index);
    }

    public int getConnectionListIndex() {
        return this.consList.getSelectedIndex();
    }

    public void setAbortFetchEnabled(boolean isEnabled) {
        this.abortFetchButton.setEnabled(isEnabled);
    }

    public void connectButtonActionPerformed(ActionEvent e) {
        this.ui.getFrame().getJMenuBar().databaseConnectActionPerformed(null);
    }

    public void disConnectButtonActionPerformed(ActionEvent e) {
        this.ui.getFrame().getJMenuBar().databaseDisconnectActionPerformed(null);
    }

    public void abortCMDButtonActionPerformed(ActionEvent e) {
        this.ui.getFrame().getJMenuBar().cmdAbortCMDActionPerformed(null);
    }

    public void abortFetchButtonActionPerformed(ActionEvent e) {
        this.ui.getFrame().getJMenuBar().cmdAbortFetchActionPerformed(null);
    }

    public void historyButtonActionPerformed(ActionEvent e) {
        JsqlHistoryDialog dlg = new JsqlHistoryDialog(this.ui);
        GuiUt.setCenterLocation(this.ui.getFrame(), dlg);
        dlg.setVisible(true);
    }

    public void historyListButtonPerformed(MouseEvent e) {
        JMenuItem item = null;
        JPopupMenu pop = new JPopupMenu();
        this.cmds = this.ui.getCmdLists();
        int size = this.cmds.size();
        if (size < 2) {
            return;
        }
        if (size <= 10) {
            for (int i = size - 2; i >= 0; --i) {
                final String cmd = this.cmds.get(i);
                String cmd1 = cmd;
                if (cmd1.length() > 50) {
                    cmd1 = cmd1.substring(0, 50) + "...";
                }
                item = new JMenuItem(cmd1);
                item.setName(cmd1);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JsqlToolBar.this.ui.getFrame().getSimulator().inputCmd(cmd);
                    }
                });
                pop.add(item);
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                final String cmd = this.cmds.get(size - 2 - i);
                String cmd1 = cmd;
                if (cmd1.length() > 50) {
                    cmd1 = cmd1.substring(0, 50) + "...";
                }
                item = new JMenuItem(cmd1);
                item.setName(cmd1);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JsqlToolBar.this.ui.getFrame().getSimulator().inputCmd(cmd);
                    }
                });
                pop.add(item);
            }
        }
        pop.show(this.historyListButton, e.getX(), e.getY() + 10);
    }
}

