/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import dbaut.AboutBox;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.ShowIntegerInputDlg;
import dbaut.ShowSimpleInputDlg;
import dbaut.comp.DbaFileFilter;
import dbaut.comp.DbaJCheckBoxMenuItem;
import dbaut.comp.DbaJRadioButtonMenuItem;
import dbaut.comp.DbaMenu;
import dbaut.comp.DbaMenuItem;
import dbaut.comp.ReflectionAction;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenuBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.undo.UndoManager;
import ui.ConnectionStatus;
import ui.IsqlStatus;
import ui.Jsql2Preferences;
import ui.gui.JsqlBlobShowDialog;
import ui.gui.JsqlGUI;
import ui.gui.JsqlLoginDialog;
import ui.gui.JsqlPreferencesDialog;

public class JsqlMenuBar
extends JMenuBar {
    private static final int MAX_LEN = 20;
    private static final String[] DATE_FORMAT = ConnectionStatus.DATE_FORMAT;
    private static final String[] TIME_FORMAT = ConnectionStatus.TIME_FORMAT;
    private static final String[] LCODE = IsqlStatus.LCODE;
    private DbaMenu databaseMenu = new DbaMenu("Database", 'D');
    private DbaMenuItem databaseConnectMenuItem = new DbaMenuItem("Connect", 'C', new ReflectionAction(this, "databaseConnectActionPerformed"));
    private DbaMenuItem databaseDisconnectMenuItem = new DbaMenuItem("Disconnect", 'D', new ReflectionAction(this, "databaseDisconnectActionPerformed"));
    private DbaMenuItem databaseDisconnectAllMenuItem = new DbaMenuItem("Disconnect All", 'A', new ReflectionAction(this, "databaseDisconnectAllActionPerformed"));
    private DbaMenuItem databaseShowConsMenuItem = new DbaMenuItem("Show Connections", 'o', new ReflectionAction(this, "databaseShowConsActionPerformed"));
    private DbaMenuItem databaseRunScriptMenuItem = new DbaMenuItem("Run Script", 'S', new ReflectionAction(this, "databaseRunScriptActionPerformed"));
    private DbaMenuItem databaseCommitMenuItem = new DbaMenuItem("Commit", 'm', new ReflectionAction(this, "databaseCommitActionPerformed"));
    private DbaMenuItem databaseRollBackMenuItem = new DbaMenuItem("Roll Back", 'R', new ReflectionAction(this, "databaseRollBackActionPerformed"));
    private DbaMenuItem databaseExitMenuItem = new DbaMenuItem("Exit", 'X', new ReflectionAction(this, "databaseExitActionPerformed"), KeyStroke.getKeyStroke(115, 8));
    private DbaMenu editMenu = new DbaMenu("Edit", 'E');
    private DbaMenuItem editUndoMenuItem = new DbaMenuItem("Undo", 'U', new ReflectionAction(this, "editUndoActionPerformed"), KeyStroke.getKeyStroke(90, 2));
    private DbaMenuItem editCutMenuItem = new DbaMenuItem("Cut", 't', new ReflectionAction(this, "editCutActionPerformed"), KeyStroke.getKeyStroke(88, 2));
    private DbaMenuItem editCopyMenuItem = new DbaMenuItem("Copy", 'C', new ReflectionAction(this, "editCopyActionPerformed"), KeyStroke.getKeyStroke(67, 2));
    private DbaMenuItem editPasteMenuItem = new DbaMenuItem("Paste", 'P', new ReflectionAction(this, "editPasteActionPerformed"), KeyStroke.getKeyStroke(86, 2));
    private DbaMenuItem editDeleteMenuItem = new DbaMenuItem("Delete", 'D', new ReflectionAction(this, "editDeleteActionPerformed"));
    private DbaMenuItem editSelectAllMenuItem = new DbaMenuItem("Select All", 'S', new ReflectionAction(this, "editSelectAllActionPerformed"), KeyStroke.getKeyStroke(65, 2));
    private DbaMenuItem editClearAllMenuItem = new DbaMenuItem("Clear All", 'l', new ReflectionAction(this, "editClearAllActionPerformed"));
    private DbaMenu cmdMenu = new DbaMenu("Command", 'C');
    private DbaMenuItem cmdAbortCMDMenuItem = new DbaMenuItem("Abort Command", 'C', new ReflectionAction(this, "cmdAbortCMDActionPerformed"), KeyStroke.getKeyStroke(89, 2));
    private DbaMenuItem cmdAbortFetchMenuItem = new DbaMenuItem("Abort Fetch", 'F', new ReflectionAction(this, "cmdAbortFetchActionPerformed"), KeyStroke.getKeyStroke(92, 2));
    private DbaMenuItem cmdAbortScriptMenuItem = new DbaMenuItem("Abort Srcipt", 'S', new ReflectionAction(this, "cmdAbortScriptActionPerformed"), KeyStroke.getKeyStroke(92, 2));
    private DbaMenuItem cmdListTablesMenuItem = new DbaMenuItem("List Tables", 'L', new ReflectionAction(this, "cmdListTablesActionPerformed"));
    private DbaMenu displayMenu = new DbaMenu("Display", 'p');
    private DbaJCheckBoxMenuItem displayFastRetrieveMenuItem = new DbaJCheckBoxMenuItem("Fast Retrieve", 'F', new ReflectionAction(this, "displayFastRetrieveActionPerformed"), KeyStroke.getKeyStroke(84, 2));
    private DbaJCheckBoxMenuItem displayHSBMenuItem = new DbaJCheckBoxMenuItem("Horizontal Scroll Bar", 'H', new ReflectionAction(this, "displayHSBActionPerformed"));
    private DbaJCheckBoxMenuItem displayVSBMenuItem = new DbaJCheckBoxMenuItem("Vertical Scroll Bar", 'V', new ReflectionAction(this, "displayVSBActionPerformed"));
    private DbaJCheckBoxMenuItem displayToolBarMenuItem = new DbaJCheckBoxMenuItem("Tool Bar", 'T', new ReflectionAction(this, "displayToolBarActionPerformed"));
    private DbaJCheckBoxMenuItem displayStatusBarMenuItem = new DbaJCheckBoxMenuItem("Status Bar", 'S', new ReflectionAction(this, "displayStatusBarActionPerformed"));
    private DbaMenuItem displayPreferencesMenuItem = new DbaMenuItem("Preferences", 'P', new ReflectionAction(this, "displayPreferencesActionPerformed"));
    private DbaMenu setMenu = new DbaMenu("Set", 'S');
    private DbaMenuItem setShowSettingsMenuItem = new DbaMenuItem("Show Settings", 'S', new ReflectionAction(this, "setShowSettingsActionPerformed"));
    private DbaMenuItem setSaveSettingsMenuItem = new DbaMenuItem("Save Settings", 'v', new ReflectionAction(this, "setSaveSettingsActionPerformed"));
    private DbaMenuItem setBlobShowMenuItem = new DbaMenuItem("Blob Show", 'B', new ReflectionAction(this, "setBlobShowActionPerformed"));
    private DbaJCheckBoxMenuItem setGetENVMenuItem = new DbaJCheckBoxMenuItem("Get ENV", 'N', new ReflectionAction(this, "setGetENVActionPerformed"));
    private DbaMenu setLinewidthMenu = new DbaMenu("LineWidth", 'L');
    private boolean isLineWidthOffMenuSelected = false;
    private DbaJRadioButtonMenuItem setLineWidthOffMenuItem = new DbaJRadioButtonMenuItem("Off", 'f', new ReflectionAction(this, "setLineWidthOffActionPerformed"));
    private DbaJRadioButtonMenuItem setLineWidthMenuItem = new DbaJRadioButtonMenuItem("Other", 'O', new ReflectionAction(this, "setLineWidthActionPerformed"));
    private DbaMenu setPrinttoMenu = new DbaMenu("Print to", 'P');
    private boolean isPrinttoOffMenuSelected = true;
    private DbaJRadioButtonMenuItem setPrinttoOffMenuItem = new DbaJRadioButtonMenuItem("Off", 'f', new ReflectionAction(this, "setPrinttoOffActionPerformed"));
    private DbaJRadioButtonMenuItem setPrinttoMenuItem = new DbaJRadioButtonMenuItem("Other", 'O', new ReflectionAction(this, "setPrinttoActionPerformed"));
    private DbaJCheckBoxMenuItem setShowTimeMenuItem = new DbaJCheckBoxMenuItem("Show Time", 'o', new ReflectionAction(this, "setShowTimeActionPerformed"));
    private DbaMenuItem setWorkDIRMenuItem = new DbaMenuItem("Work DIR", 'W', new ReflectionAction(this, "setWorkDIRActionPerformed"));
    private DbaMenuItem setLoginTimeoutMenuItem = new DbaMenuItem("Login Timeout", 'G', new ReflectionAction(this, "setLoginTimeoutActionPerformed"));
    private DbaMenu setInputEncodingMenuItem = new DbaMenu("Input Encoding", 'I');
    private DbaJRadioButtonMenuItem setInputEncoding0MenuItem = new DbaJRadioButtonMenuItem(LCODE[0], new ReflectionAction(this, "setInputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setInputEncoding1MenuItem = new DbaJRadioButtonMenuItem(LCODE[1], new ReflectionAction(this, "setInputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setInputEncoding2MenuItem = new DbaJRadioButtonMenuItem(LCODE[2], new ReflectionAction(this, "setInputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setInputEncoding3MenuItem = new DbaJRadioButtonMenuItem(LCODE[3], new ReflectionAction(this, "setInputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setInputEncoding4MenuItem = new DbaJRadioButtonMenuItem(LCODE[4], new ReflectionAction(this, "setInputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setInputEncoding5MenuItem = new DbaJRadioButtonMenuItem(LCODE[5], new ReflectionAction(this, "setInputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setInputEncoding6MenuItem = new DbaJRadioButtonMenuItem(LCODE[6], new ReflectionAction(this, "setInputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setInputEncoding7MenuItem = new DbaJRadioButtonMenuItem(LCODE[7], new ReflectionAction(this, "setInputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setInputEncoding8MenuItem = new DbaJRadioButtonMenuItem(LCODE[8], new ReflectionAction(this, "setInputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setInputEncoding9MenuItem = new DbaJRadioButtonMenuItem(LCODE[9], new ReflectionAction(this, "setInputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setInputEncoding10MenuItem = new DbaJRadioButtonMenuItem(LCODE[10], new ReflectionAction(this, "setInputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setInputEncodingMoreMenuItem = new DbaJRadioButtonMenuItem("More", new ReflectionAction(this, "setInputEncodingMoreActionPerformed"));
    private DbaJRadioButtonMenuItem[] setInputEncodingMenuItems = new DbaJRadioButtonMenuItem[]{this.setInputEncoding0MenuItem, this.setInputEncoding1MenuItem, this.setInputEncoding2MenuItem, this.setInputEncoding3MenuItem, this.setInputEncoding4MenuItem, this.setInputEncoding5MenuItem, this.setInputEncoding6MenuItem, this.setInputEncoding7MenuItem, this.setInputEncoding8MenuItem, this.setInputEncoding9MenuItem, this.setInputEncoding10MenuItem};
    private DbaMenu setOutputEncodingMenuItem = new DbaMenu("Output Encoding", 'O');
    private DbaJRadioButtonMenuItem setOutputEncoding0MenuItem = new DbaJRadioButtonMenuItem(LCODE[0], new ReflectionAction(this, "setOutputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputEncoding1MenuItem = new DbaJRadioButtonMenuItem(LCODE[1], new ReflectionAction(this, "setOutputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputEncoding2MenuItem = new DbaJRadioButtonMenuItem(LCODE[2], new ReflectionAction(this, "setOutputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputEncoding3MenuItem = new DbaJRadioButtonMenuItem(LCODE[3], new ReflectionAction(this, "setOutputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputEncoding4MenuItem = new DbaJRadioButtonMenuItem(LCODE[4], new ReflectionAction(this, "setOutputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputEncoding5MenuItem = new DbaJRadioButtonMenuItem(LCODE[5], new ReflectionAction(this, "setOutputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputEncoding6MenuItem = new DbaJRadioButtonMenuItem(LCODE[6], new ReflectionAction(this, "setOutputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputEncoding7MenuItem = new DbaJRadioButtonMenuItem(LCODE[7], new ReflectionAction(this, "setOutputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputEncoding8MenuItem = new DbaJRadioButtonMenuItem(LCODE[8], new ReflectionAction(this, "setOutputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputEncoding9MenuItem = new DbaJRadioButtonMenuItem(LCODE[9], new ReflectionAction(this, "setOutputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputEncoding10MenuItem = new DbaJRadioButtonMenuItem(LCODE[10], new ReflectionAction(this, "setOutputEncodingActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputEncodingMoreMenuItem = new DbaJRadioButtonMenuItem("More", new ReflectionAction(this, "setOutputEncodingMoreActionPerformed"));
    private DbaJRadioButtonMenuItem[] setOutputEncodingMenuItems = new DbaJRadioButtonMenuItem[]{this.setOutputEncoding0MenuItem, this.setOutputEncoding1MenuItem, this.setOutputEncoding2MenuItem, this.setOutputEncoding3MenuItem, this.setOutputEncoding4MenuItem, this.setOutputEncoding5MenuItem, this.setOutputEncoding6MenuItem, this.setOutputEncoding7MenuItem, this.setOutputEncoding8MenuItem, this.setOutputEncoding9MenuItem, this.setOutputEncoding10MenuItem};
    private DbaMenuItem setExtNameMenuItem = new DbaMenuItem("Extension Name", 'E', new ReflectionAction(this, "setExtNameActionPerformed"));
    private DbaMenu setDateFormatMenuItem = new DbaMenu("Date", 'D');
    private DbaMenu setInputDateFormatMenu = new DbaMenu("Input Format", 'I');
    private DbaMenu setOutputDateFormatMenu = new DbaMenu("Output Format", 'O');
    private DbaJRadioButtonMenuItem setInputDateFormat0MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[0], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputDateFormat1MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[1], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputDateFormat2MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[2], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputDateFormat3MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[3], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputDateFormat4MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[4], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputDateFormat5MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[5], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputDateFormat6MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[6], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputDateFormat7MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[7], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputDateFormat8MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[8], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputDateFormat9MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[9], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputDateFormat10MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[10], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputDateFormat11MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[11], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputDateFormatAllMenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[12], new ReflectionAction(this, "setDateInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem[] setInputDateFormatMenuItems = new DbaJRadioButtonMenuItem[]{this.setInputDateFormat0MenuItem, this.setInputDateFormat1MenuItem, this.setInputDateFormat2MenuItem, this.setInputDateFormat3MenuItem, this.setInputDateFormat4MenuItem, this.setInputDateFormat5MenuItem, this.setInputDateFormat6MenuItem, this.setInputDateFormat7MenuItem, this.setInputDateFormat8MenuItem, this.setInputDateFormat9MenuItem, this.setInputDateFormat10MenuItem, this.setInputDateFormat11MenuItem, this.setInputDateFormatAllMenuItem};
    private DbaJRadioButtonMenuItem setOutputDateFormat0MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[0], new ReflectionAction(this, "setDateOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputDateFormat1MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[1], new ReflectionAction(this, "setDateOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputDateFormat2MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[2], new ReflectionAction(this, "setDateOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputDateFormat3MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[3], new ReflectionAction(this, "setDateOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputDateFormat4MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[4], new ReflectionAction(this, "setDateOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputDateFormat5MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[5], new ReflectionAction(this, "setDateOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputDateFormat6MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[6], new ReflectionAction(this, "setDateOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputDateFormat7MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[7], new ReflectionAction(this, "setDateOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputDateFormat8MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[8], new ReflectionAction(this, "setDateOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputDateFormat9MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[9], new ReflectionAction(this, "setDateOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputDateFormat10MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[10], new ReflectionAction(this, "setDateOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputDateFormat11MenuItem = new DbaJRadioButtonMenuItem(DATE_FORMAT[11], new ReflectionAction(this, "setDateOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem[] setOutputDateFormatMenuItems = new DbaJRadioButtonMenuItem[]{this.setOutputDateFormat0MenuItem, this.setOutputDateFormat1MenuItem, this.setOutputDateFormat2MenuItem, this.setOutputDateFormat3MenuItem, this.setOutputDateFormat4MenuItem, this.setOutputDateFormat5MenuItem, this.setOutputDateFormat6MenuItem, this.setOutputDateFormat7MenuItem, this.setOutputDateFormat8MenuItem, this.setOutputDateFormat9MenuItem, this.setOutputDateFormat10MenuItem, this.setOutputDateFormat11MenuItem};
    private DbaMenu setTimeFormatMenuItem = new DbaMenu("Time", 'T');
    private DbaMenu setInputTimeFormatMenu = new DbaMenu("Input Format", 'I');
    private DbaMenu setOutputTimeFormatMenu = new DbaMenu("Output Format", 'O');
    private DbaJRadioButtonMenuItem setInputTimeFormat0MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[0], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputTimeFormat1MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[1], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputTimeFormat2MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[2], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputTimeFormat3MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[3], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputTimeFormat4MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[4], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputTimeFormat5MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[5], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputTimeFormat6MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[6], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputTimeFormat7MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[7], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputTimeFormat8MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[8], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputTimeFormat9MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[9], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputTimeFormat10MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[10], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputTimeFormat11MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[11], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setInputTimeFormatAllMenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[12], new ReflectionAction(this, "setTimeInputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem[] setInputTimeFormatMenuItems = new DbaJRadioButtonMenuItem[]{this.setInputTimeFormat0MenuItem, this.setInputTimeFormat1MenuItem, this.setInputTimeFormat2MenuItem, this.setInputTimeFormat3MenuItem, this.setInputTimeFormat4MenuItem, this.setInputTimeFormat5MenuItem, this.setInputTimeFormat6MenuItem, this.setInputTimeFormat7MenuItem, this.setInputTimeFormat8MenuItem, this.setInputTimeFormat9MenuItem, this.setInputTimeFormat10MenuItem, this.setInputTimeFormat11MenuItem, this.setInputTimeFormatAllMenuItem};
    private DbaJRadioButtonMenuItem setOutputTimeFormat0MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[0], new ReflectionAction(this, "setTimeOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputTimeFormat1MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[1], new ReflectionAction(this, "setTimeOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputTimeFormat2MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[2], new ReflectionAction(this, "setTimeOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputTimeFormat3MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[3], new ReflectionAction(this, "setTimeOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputTimeFormat4MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[4], new ReflectionAction(this, "setTimeOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputTimeFormat5MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[5], new ReflectionAction(this, "setTimeOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputTimeFormat6MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[6], new ReflectionAction(this, "setTimeOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputTimeFormat7MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[7], new ReflectionAction(this, "setTimeOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputTimeFormat8MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[8], new ReflectionAction(this, "setTimeOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputTimeFormat9MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[9], new ReflectionAction(this, "setTimeOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputTimeFormat10MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[10], new ReflectionAction(this, "setTimeOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem setOutputTimeFormat11MenuItem = new DbaJRadioButtonMenuItem(TIME_FORMAT[11], new ReflectionAction(this, "setTimeOutputFormatActionPerformed"));
    private DbaJRadioButtonMenuItem[] setOutputTimeFormatMenuItems = new DbaJRadioButtonMenuItem[]{this.setOutputTimeFormat0MenuItem, this.setOutputTimeFormat1MenuItem, this.setOutputTimeFormat2MenuItem, this.setOutputTimeFormat3MenuItem, this.setOutputTimeFormat4MenuItem, this.setOutputTimeFormat5MenuItem, this.setOutputTimeFormat6MenuItem, this.setOutputTimeFormat7MenuItem, this.setOutputTimeFormat8MenuItem, this.setOutputTimeFormat9MenuItem, this.setOutputTimeFormat10MenuItem, this.setOutputTimeFormat11MenuItem};
    private Jsql2Preferences jsql2Pref = Jsql2Preferences.getPreferencesXml(this.ui);
    private DbaMenu helpMenu = new DbaMenu("Help", 'H');
    private DbaMenuItem helpOnlineMenuItem = new DbaMenuItem("Online Help", 'O', new ReflectionAction(this, "helpOnlineActionPerformed"));
    private DbaMenuItem helpSQLPreferenceMenuItem = new DbaMenuItem("SQL Reference", 'S', new ReflectionAction(this, "helpSQLPreferenceActionPerformed"));
    private DbaMenuItem helpAboutMenuItem = new DbaMenuItem("About", 'A', new ReflectionAction(this, "helpAboutActionPerformed"));
    private JsqlGUI ui = null;

    public JsqlMenuBar(JsqlGUI ui) {
        this.ui = ui;
        this.init();
    }

    private void init() {
        this.initGUI();
        this.initMenuNames();
        this.setConPropCompsEnabled(false);
        this.setAbortFetchEnabled(false);
        this.setFocusable(false);
        this.initIsqlValue();
    }

    private void initGUI() {
        this.databaseMenu.add(this.databaseConnectMenuItem);
        this.databaseMenu.add(this.databaseDisconnectMenuItem);
        this.databaseMenu.addSeparator();
        this.databaseMenu.add(this.databaseRunScriptMenuItem);
        this.databaseMenu.addSeparator();
        this.databaseMenu.add(this.databaseExitMenuItem);
        this.editMenu.add(this.editUndoMenuItem);
        this.editMenu.addSeparator();
        this.editMenu.add(this.editCutMenuItem);
        this.editMenu.add(this.editCopyMenuItem);
        this.editMenu.add(this.editPasteMenuItem);
        this.editMenu.add(this.editDeleteMenuItem);
        this.editMenu.addSeparator();
        this.editMenu.add(this.editSelectAllMenuItem);
        this.editMenu.add(this.editClearAllMenuItem);
        this.cmdMenu.add(this.cmdAbortCMDMenuItem);
        this.cmdMenu.add(this.cmdAbortFetchMenuItem);
        this.cmdMenu.add(this.cmdAbortScriptMenuItem);
        this.cmdMenu.addSeparator();
        this.cmdMenu.add(this.cmdListTablesMenuItem);
        this.displayMenu.add(this.displayHSBMenuItem);
        this.displayMenu.add(this.displayVSBMenuItem);
        this.displayMenu.add(this.displayToolBarMenuItem);
        this.displayMenu.add(this.displayStatusBarMenuItem);
        this.displayMenu.addSeparator();
        this.displayMenu.add(this.displayPreferencesMenuItem);
        this.setMenu.add(this.setBlobShowMenuItem);
        this.setMenu.add(this.setGetENVMenuItem);
        this.setLinewidthMenu.add(this.setLineWidthOffMenuItem);
        this.setLinewidthMenu.add(this.setLineWidthMenuItem);
        ButtonGroup bgLinewidth = new ButtonGroup();
        bgLinewidth.add(this.setLineWidthOffMenuItem);
        bgLinewidth.add(this.setLineWidthMenuItem);
        this.setMenu.add(this.setLinewidthMenu);
        this.setPrinttoMenu.add(this.setPrinttoOffMenuItem);
        this.setPrinttoMenu.add(this.setPrinttoMenuItem);
        ButtonGroup bgPrintto = new ButtonGroup();
        bgPrintto.add(this.setPrinttoOffMenuItem);
        bgPrintto.add(this.setPrinttoMenuItem);
        this.setMenu.add(this.setPrinttoMenu);
        this.setMenu.add(this.setShowTimeMenuItem);
        this.setMenu.add(this.setWorkDIRMenuItem);
        this.setMenu.add(this.setLoginTimeoutMenuItem);
        ButtonGroup bgInputEncoding = new ButtonGroup();
        for (int i = 0; i < this.setInputEncodingMenuItems.length; ++i) {
            bgInputEncoding.add(this.setInputEncodingMenuItems[i]);
            this.setInputEncodingMenuItem.add(this.setInputEncodingMenuItems[i]);
        }
        bgInputEncoding.add(this.setInputEncodingMoreMenuItem);
        this.setInputEncodingMenuItem.addSeparator();
        this.setInputEncodingMenuItem.add(this.setInputEncodingMoreMenuItem);
        this.setMenu.add(this.setInputEncodingMenuItem);
        ButtonGroup bgOnputEncoding = new ButtonGroup();
        for (int i = 0; i < this.setOutputEncodingMenuItems.length; ++i) {
            bgOnputEncoding.add(this.setOutputEncodingMenuItems[i]);
            this.setOutputEncodingMenuItem.add(this.setOutputEncodingMenuItems[i]);
        }
        bgOnputEncoding.add(this.setOutputEncodingMoreMenuItem);
        this.setOutputEncodingMenuItem.addSeparator();
        this.setOutputEncodingMenuItem.add(this.setOutputEncodingMoreMenuItem);
        this.setMenu.add(this.setOutputEncodingMenuItem);
        this.setMenu.addSeparator();
        this.setDateFormatMenuItem.add(this.setInputDateFormatMenu);
        ButtonGroup bgInDateFormat = new ButtonGroup();
        for (int i = 0; i < this.setInputDateFormatMenuItems.length; ++i) {
            bgInDateFormat.add(this.setInputDateFormatMenuItems[i]);
            if (i == this.setInputDateFormatMenuItems.length - 1) {
                this.setInputDateFormatMenu.addSeparator();
            }
            this.setInputDateFormatMenu.add(this.setInputDateFormatMenuItems[i]);
        }
        this.setDateFormatMenuItem.add(this.setOutputDateFormatMenu);
        ButtonGroup bgOutDateFormat = new ButtonGroup();
        for (int i = 0; i < this.setOutputDateFormatMenuItems.length; ++i) {
            bgOutDateFormat.add(this.setOutputDateFormatMenuItems[i]);
            this.setOutputDateFormatMenu.add(this.setOutputDateFormatMenuItems[i]);
        }
        this.setMenu.add(this.setDateFormatMenuItem);
        this.setTimeFormatMenuItem.add(this.setInputTimeFormatMenu);
        ButtonGroup bgInTimeFormat = new ButtonGroup();
        for (int i = 0; i < this.setInputTimeFormatMenuItems.length; ++i) {
            bgInTimeFormat.add(this.setInputTimeFormatMenuItems[i]);
            if (i == this.setInputTimeFormatMenuItems.length - 1) {
                this.setInputTimeFormatMenu.addSeparator();
            }
            this.setInputTimeFormatMenu.add(this.setInputTimeFormatMenuItems[i]);
        }
        this.setTimeFormatMenuItem.add(this.setOutputTimeFormatMenu);
        ButtonGroup bgOutTimeFormat = new ButtonGroup();
        for (int i = 0; i < this.setOutputTimeFormatMenuItems.length; ++i) {
            bgOutTimeFormat.add(this.setOutputTimeFormatMenuItems[i]);
            this.setOutputTimeFormatMenu.add(this.setOutputTimeFormatMenuItems[i]);
        }
        this.setMenu.add(this.setTimeFormatMenuItem);
        this.setMenu.addSeparator();
        this.setMenu.add(this.setShowSettingsMenuItem);
        this.setMenu.add(this.setSaveSettingsMenuItem);
        this.helpMenu.add(this.helpOnlineMenuItem);
        this.helpMenu.add(this.helpSQLPreferenceMenuItem);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.helpAboutMenuItem);
        this.add(this.databaseMenu);
        this.add(this.editMenu);
        this.add(this.cmdMenu);
        this.add(this.displayMenu);
        this.add(this.setMenu);
        this.add(this.helpMenu);
    }

    private void initIsqlValue() {
        try {
            Jsql2Preferences.getPreferencesXml(this.ui).setPreferences();
        }
        catch (Exception e) {
            System.out.println("Set prefereces value failed!");
            e.printStackTrace();
        }
        this.displayHSBMenuItem.setSelected(true);
        this.displayVSBMenuItem.setSelected(true);
        this.displayToolBarMenuItem.setSelected(true);
        this.displayStatusBarMenuItem.setSelected(true);
        if (this.ui.getIsqlStatus(1).equalsIgnoreCase("on")) {
            this.setGetENVMenuItem.setSelected(true);
        } else {
            this.setGetENVMenuItem.setSelected(false);
        }
        if (this.ui.getIsqlStatus(3).equalsIgnoreCase("off")) {
            this.setPrinttoOffMenuItem.setSelected(true);
            this.setPrinttoMenuItem.setText("Other");
        } else {
            this.setPrinttoMenuItem.setSelected(true);
            this.setPrinttoMenuItem.setText("Other(" + this.ui.getIsqlStatus(3) + ")");
        }
        if (this.ui.getIsqlStatus(8).equalsIgnoreCase("off")) {
            this.setLineWidthOffMenuItem.setSelected(true);
            this.setLineWidthMenuItem.setText("Other");
        } else {
            this.setLineWidthMenuItem.setSelected(true);
            this.setLineWidthMenuItem.setText("Other(" + this.ui.getIsqlStatus(8) + ")");
        }
        this.setLoginTimeoutMenuItem.setText(this.getFormatText("Login Timeout", this.ui.getIsqlStatus(7)));
        this.setWorkDIRMenuItem.setText(this.getFormatText("Work Dir", this.ui.getIsqlStatus(6)));
        this.setInputEncodingMoreMenuItem.setEnabled(false);
        String ienc = this.ui.getIsqlStatus(2);
        if (ienc.equalsIgnoreCase(LCODE[0])) {
            this.setInputEncoding0MenuItem.setSelected(true);
        } else if (ienc.equalsIgnoreCase(LCODE[1])) {
            this.setInputEncoding1MenuItem.setSelected(true);
        } else if (ienc.equalsIgnoreCase(LCODE[2])) {
            this.setInputEncoding2MenuItem.setSelected(true);
        } else if (ienc.equalsIgnoreCase(LCODE[3])) {
            this.setInputEncoding3MenuItem.setSelected(true);
        } else if (ienc.equalsIgnoreCase(LCODE[4])) {
            this.setInputEncoding4MenuItem.setSelected(true);
        } else if (ienc.equalsIgnoreCase(LCODE[5])) {
            this.setInputEncoding5MenuItem.setSelected(true);
        } else if (ienc.equalsIgnoreCase(LCODE[6])) {
            this.setInputEncoding6MenuItem.setSelected(true);
        } else if (ienc.equalsIgnoreCase(LCODE[7])) {
            this.setInputEncoding7MenuItem.setSelected(true);
        } else if (ienc.equalsIgnoreCase(LCODE[8])) {
            this.setInputEncoding8MenuItem.setSelected(true);
        } else if (ienc.equalsIgnoreCase(LCODE[9])) {
            this.setInputEncoding9MenuItem.setSelected(true);
        } else if (ienc.equalsIgnoreCase(LCODE[10])) {
            this.setInputEncoding10MenuItem.setSelected(true);
        } else {
            this.setInputEncodingMoreMenuItem.setSelected(true);
        }
        this.setOutputEncodingMoreMenuItem.setEnabled(false);
        String oenc = this.ui.getIsqlStatus(4);
        if (oenc.equalsIgnoreCase(LCODE[0])) {
            this.setOutputEncoding0MenuItem.setSelected(true);
        } else if (oenc.equalsIgnoreCase(LCODE[1])) {
            this.setOutputEncoding1MenuItem.setSelected(true);
        } else if (oenc.equalsIgnoreCase(LCODE[2])) {
            this.setOutputEncoding2MenuItem.setSelected(true);
        } else if (oenc.equalsIgnoreCase(LCODE[3])) {
            this.setOutputEncoding3MenuItem.setSelected(true);
        } else if (oenc.equalsIgnoreCase(LCODE[4])) {
            this.setOutputEncoding4MenuItem.setSelected(true);
        } else if (oenc.equalsIgnoreCase(LCODE[5])) {
            this.setOutputEncoding5MenuItem.setSelected(true);
        } else if (oenc.equalsIgnoreCase(LCODE[6])) {
            this.setOutputEncoding6MenuItem.setSelected(true);
        } else if (oenc.equalsIgnoreCase(LCODE[7])) {
            this.setOutputEncoding7MenuItem.setSelected(true);
        } else if (oenc.equalsIgnoreCase(LCODE[8])) {
            this.setOutputEncoding8MenuItem.setSelected(true);
        } else if (oenc.equalsIgnoreCase(LCODE[9])) {
            this.setOutputEncoding9MenuItem.setSelected(true);
        } else if (oenc.equalsIgnoreCase(LCODE[10])) {
            this.setOutputEncoding10MenuItem.setSelected(true);
        } else {
            this.setOutputEncodingMoreMenuItem.setSelected(true);
        }
    }

    public void initConPropComps() {
        try {
            String dateInputFormat = this.ui.getCurrentConnectionStatus(2);
            if (dateInputFormat == null) {
                return;
            }
            for (int i = 0; i < this.setInputDateFormatMenuItems.length; ++i) {
                if (!dateInputFormat.equals(this.setInputDateFormatMenuItems[i].getText())) continue;
                this.setInputDateFormatMenuItems[i].setSelected(true);
            }
            String dateOutputFormat = this.ui.getCurrentConnectionStatus(3);
            if (dateOutputFormat == null) {
                return;
            }
            for (int i = 0; i < this.setOutputDateFormatMenuItems.length; ++i) {
                if (!dateOutputFormat.equals(this.setOutputDateFormatMenuItems[i].getText())) continue;
                this.setOutputDateFormatMenuItems[i].setSelected(true);
            }
            String timeInputFormat = this.ui.getCurrentConnectionStatus(4);
            if (timeInputFormat == null) {
                return;
            }
            for (int i = 0; i < this.setInputTimeFormatMenuItems.length; ++i) {
                if (!timeInputFormat.equals(this.setInputTimeFormatMenuItems[i].getText())) continue;
                this.setInputTimeFormatMenuItems[i].setSelected(true);
            }
            String timeOutputFormat = this.ui.getCurrentConnectionStatus(5);
            if (timeOutputFormat == null) {
                return;
            }
            for (int i = 0; i < this.setOutputTimeFormatMenuItems.length; ++i) {
                if (!timeOutputFormat.equals(this.setOutputTimeFormatMenuItems[i].getText())) continue;
                this.setOutputTimeFormatMenuItems[i].setSelected(true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setConPropCompsEnabled(boolean isEnabled) {
        this.databaseDisconnectMenuItem.setEnabled(isEnabled);
        this.databaseDisconnectAllMenuItem.setEnabled(isEnabled);
        this.databaseCommitMenuItem.setEnabled(isEnabled);
        this.databaseRollBackMenuItem.setEnabled(isEnabled);
        this.cmdListTablesMenuItem.setEnabled(isEnabled);
        this.setExtNameMenuItem.setEnabled(isEnabled);
        this.setDateFormatMenuItem.setEnabled(isEnabled);
        this.setTimeFormatMenuItem.setEnabled(isEnabled);
    }

    public void setAbortFetchEnabled(boolean isEnabled) {
        this.cmdAbortFetchMenuItem.setEnabled(isEnabled);
        this.cmdAbortScriptMenuItem.setEnabled(isEnabled);
    }

    @Override
    public void setFocusable(boolean isFocusAble) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setFocusable(isFocusAble);
        }
    }

    private void initMenuNames() {
        this.databaseConnectMenuItem.setName("DatabaseConnectMenuItem");
        this.databaseDisconnectMenuItem.setName("DatabaseDisconnectMenuItem");
        this.databaseDisconnectAllMenuItem.setName("DatabaseDisconectAllMenuItem");
        this.databaseShowConsMenuItem.setName("DatabaseShowConsMenuItem");
        this.databaseRunScriptMenuItem.setName("DatabaseRunScriptMenuItem");
        this.databaseCommitMenuItem.setName("DatabaseCommitMenuItem");
        this.databaseRollBackMenuItem.setName("DatabaseRollBackMenuItem");
        this.databaseExitMenuItem.setName("DatabaseExitMenuItem");
        this.editUndoMenuItem.setName("EditUndoMenuItem");
        this.editCutMenuItem.setName("EditCutMenuItem");
        this.editCopyMenuItem.setName("EditCopyMenuItem");
        this.editPasteMenuItem.setName("EditPasteMenuItem");
        this.editDeleteMenuItem.setName("EditDeleteMenuItem");
        this.editSelectAllMenuItem.setName("EditSelectAllMenuItem");
        this.editClearAllMenuItem.setName("EditClearAllMenuItem");
        this.cmdAbortCMDMenuItem.setName("CMDAbortCMDMenuItem");
        this.cmdAbortFetchMenuItem.setName("CMDAbortFetchMenuItem");
        this.cmdAbortScriptMenuItem.setName("CMDAbortScriptMenuItem");
        this.cmdListTablesMenuItem.setName("CMDListTablesMenuItem");
        this.displayFastRetrieveMenuItem.setName("DisplayFastRetrieveMenuItem");
        this.displayHSBMenuItem.setName("DisplayHSBMenuItem");
        this.displayVSBMenuItem.setName("DisplayVSBMenuItem");
        this.displayToolBarMenuItem.setName("DisplayToolBarMenuItem");
        this.displayStatusBarMenuItem.setName("DisplayStatusBarMenuItem");
        this.displayPreferencesMenuItem.setName("DisplayPreferencesMenuItem");
        this.setShowSettingsMenuItem.setName("SetShowSettingsMenuItem");
        this.setSaveSettingsMenuItem.setName("SetSaveSettingsMenuItem");
        this.setBlobShowMenuItem.setName("SetBlobShowMenuItem");
        this.setGetENVMenuItem.setName("SetGetENVMeuItem");
        this.setLineWidthOffMenuItem.setName("SetLineWidthOffMenuItem");
        this.setLineWidthMenuItem.setName("SetLineWidthMenuItem");
        this.setPrinttoOffMenuItem.setName("SetPrinttoOffMenuItem");
        this.setPrinttoMenuItem.setName("SetPrinttoMenuItem");
        this.setShowTimeMenuItem.setName("SetShowTimeMenuItem");
        this.setWorkDIRMenuItem.setName("SetWorkDIRMenuItem");
        this.setLoginTimeoutMenuItem.setName("SetLoginTimeoutMenuItem");
        this.setInputEncodingMenuItem.setName("SetInputEncodingMenuItem");
        this.setInputEncoding0MenuItem.setName("SetInputEncoding0MenuItem");
        this.setInputEncoding1MenuItem.setName("SetInputEncoding1MenuItem");
        this.setInputEncoding2MenuItem.setName("SetInputEncoding2MenuItem");
        this.setInputEncoding3MenuItem.setName("SetInputEncoding3MenuItem");
        this.setInputEncoding4MenuItem.setName("SetInputEncoding4MenuItem");
        this.setInputEncoding5MenuItem.setName("SetInputEncoding5MenuItem");
        this.setInputEncoding6MenuItem.setName("SetInputEncoding6MenuItem");
        this.setInputEncoding7MenuItem.setName("SetInputEncoding7MenuItem");
        this.setInputEncoding8MenuItem.setName("SetInputEncoding8MenuItem");
        this.setInputEncoding9MenuItem.setName("SetInputEncoding9MenuItem");
        this.setInputEncoding10MenuItem.setName("SetInputEncoding10MenuItem");
        this.setInputEncodingMoreMenuItem.setName("SetInputEncodingMoreMenuItem");
        this.setOutputEncodingMenuItem.setName("SetOutputEncodingMenuItem");
        this.setOutputEncoding0MenuItem.setName("SetOutputEncoding0MenuItem");
        this.setOutputEncoding1MenuItem.setName("SetOutputEncoding1MenuItem");
        this.setOutputEncoding2MenuItem.setName("SetOutputEncoding2MenuItem");
        this.setOutputEncoding3MenuItem.setName("SetOutputEncoding3MenuItem");
        this.setOutputEncoding4MenuItem.setName("SetOutputEncoding4MenuItem");
        this.setOutputEncoding5MenuItem.setName("SetOutputEncoding5MenuItem");
        this.setOutputEncoding6MenuItem.setName("SetOutputEncoding6MenuItem");
        this.setOutputEncoding7MenuItem.setName("SetOutputEncoding7MenuItem");
        this.setOutputEncoding8MenuItem.setName("SetOutputEncoding8MenuItem");
        this.setOutputEncoding9MenuItem.setName("SetOutputEncoding9MenuItem");
        this.setOutputEncoding10MenuItem.setName("SetOutputEncoding10MenuItem");
        this.setOutputEncodingMoreMenuItem.setName("SetOutputEncodingMoreMenuItem");
        this.setExtNameMenuItem.setName("SetExtNameMenuItem");
        this.setDateFormatMenuItem.setName("SetDateFormatMenuItem");
        this.setInputDateFormat0MenuItem.setName("SetInputDateFormat0MenuItem");
        this.setInputDateFormat1MenuItem.setName("SetInputDateFormat1MenuItem");
        this.setInputDateFormat2MenuItem.setName("SetInputDateFormat2MenuItem");
        this.setInputDateFormat3MenuItem.setName("SetInputDateFormat3MenuItem");
        this.setInputDateFormat4MenuItem.setName("SetInputDateFormat4MenuItem");
        this.setInputDateFormat5MenuItem.setName("SetInputDateFormat5MenuItem");
        this.setInputDateFormat6MenuItem.setName("SetInputDateFormat6MenuItem");
        this.setInputDateFormat7MenuItem.setName("SetInputDateFormat7MenuItem");
        this.setInputDateFormat8MenuItem.setName("SetInputDateFormat8MenuItem");
        this.setInputDateFormat9MenuItem.setName("SetInputDateFormat9MenuItem");
        this.setInputDateFormat10MenuItem.setName("SetInputDateFormat10MenuItem");
        this.setInputDateFormat11MenuItem.setName("SetInputDateFormat11MenuItem");
        this.setInputDateFormatAllMenuItem.setName("SetInputDateFormatAllMenuItem");
        this.setOutputDateFormat0MenuItem.setName("SetOutputDateFormat0MenuItem");
        this.setOutputDateFormat1MenuItem.setName("SetOutputDateFormat1MenuItem");
        this.setOutputDateFormat2MenuItem.setName("SetOutputDateFormat2MenuItem");
        this.setOutputDateFormat3MenuItem.setName("SetOutputDateFormat3MenuItem");
        this.setOutputDateFormat4MenuItem.setName("SetOutputDateFormat4MenuItem");
        this.setOutputDateFormat5MenuItem.setName("SetOutputDateFormat5MenuItem");
        this.setOutputDateFormat6MenuItem.setName("SetOutputDateFormat6MenuItem");
        this.setOutputDateFormat7MenuItem.setName("SetOutputDateFormat7MenuItem");
        this.setOutputDateFormat8MenuItem.setName("SetOutputDateFormat8MenuItem");
        this.setOutputDateFormat9MenuItem.setName("SetOutputDateFormat9MenuItem");
        this.setOutputDateFormat10MenuItem.setName("SetOutputDateFormat10MenuItem");
        this.setOutputDateFormat11MenuItem.setName("SetOutputDateFormat11MenuItem");
        this.setTimeFormatMenuItem.setName("SetTimeFormatMenuItem");
        this.setInputTimeFormat0MenuItem.setName("SetInputTimeFormat0MenuItem");
        this.setInputTimeFormat1MenuItem.setName("SetInputTimeFormat1MenuItem");
        this.setInputTimeFormat2MenuItem.setName("SetInputTimeFormat2MenuItem");
        this.setInputTimeFormat3MenuItem.setName("SetInputTimeFormat3MenuItem");
        this.setInputTimeFormat4MenuItem.setName("SetInputTimeFormat4MenuItem");
        this.setInputTimeFormat5MenuItem.setName("SetInputTimeFormat5MenuItem");
        this.setInputTimeFormat6MenuItem.setName("SetInputTimeFormat6MenuItem");
        this.setInputTimeFormat7MenuItem.setName("SetInputTimeFormat7MenuItem");
        this.setInputTimeFormat8MenuItem.setName("SetInputTimeFormat8MenuItem");
        this.setInputTimeFormat9MenuItem.setName("SetInputTimeFormat9MenuItem");
        this.setInputTimeFormat10MenuItem.setName("SetInputTimeFormat10MenuItem");
        this.setInputTimeFormat11MenuItem.setName("SetInputTimeFormat11MenuItem");
        this.setInputTimeFormatAllMenuItem.setName("SetInputTimeFormatAllMenuItem");
        this.setOutputTimeFormat0MenuItem.setName("SetOutputTimeFormat0MenuItem");
        this.setOutputTimeFormat1MenuItem.setName("SetOutputTimeFormat1MenuItem");
        this.setOutputTimeFormat2MenuItem.setName("SetOutputTimeFormat2MenuItem");
        this.setOutputTimeFormat3MenuItem.setName("SetOutputTimeFormat3MenuItem");
        this.setOutputTimeFormat4MenuItem.setName("SetOutputTimeFormat4MenuItem");
        this.setOutputTimeFormat5MenuItem.setName("SetOutputTimeFormat5MenuItem");
        this.setOutputTimeFormat6MenuItem.setName("SetOutputTimeFormat6MenuItem");
        this.setOutputTimeFormat7MenuItem.setName("SetOutputTimeFormat7MenuItem");
        this.setOutputTimeFormat8MenuItem.setName("SetOutputTimeFormat8MenuItem");
        this.setOutputTimeFormat9MenuItem.setName("SetOutputTimeFormat9MenuItem");
        this.setOutputTimeFormat10MenuItem.setName("SetOutputTimeFormat10MenuItem");
        this.setOutputTimeFormat11MenuItem.setName("SetOutputTimeFormat11MenuItem");
        this.helpOnlineMenuItem.setName("HelpOnlineMenuItem");
        this.helpSQLPreferenceMenuItem.setName("HelpSQLPreferenceMenuItem");
        this.helpAboutMenuItem.setName("HelpAboutMenuItem");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void databaseConnectActionPerformed(ActionEvent e) {
        JsqlLoginDialog loginDlg = new JsqlLoginDialog(this.ui.getFrame());
        loginDlg.setName("LoginDialog");
        GuiUt.setCenterLocation(this.ui.getFrame(), loginDlg);
        loginDlg.setVisible(true);
        if (!loginDlg.isLoginButtonPushed()) {
            return;
        }
        String dbName = loginDlg.getDBName();
        String userName = loginDlg.getUserName();
        String password = loginDlg.getPassword();
        boolean isConnected = this.ui.isCurrentConnectionConnected();
        String cmd = "connect to '" + dbName + "' '" + userName + "' '********';";
        if (isConnected) {
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.getUIManager().getReporter().error("Connection handle in use");
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        } else {
            Connection connection = null;
            try {
                Class.forName("dbmaker.sql.JdbcOdbcDriver");
                this.ui.getFrame().getSimulator().inputCmd(cmd);
                this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
                DriverManager.setLoginTimeout(new Integer(this.ui.getIsqlStatus(7)));
                connection = DriverManager.getConnection("jdbc:dbmaker:" + dbName, userName, password);
                this.ui.setCurrentConnection(connection, dbName, userName, password);
                int id = this.ui.getCurrentConnectionID();
                this.ui.getFrame().getToolBar().setConnectionsListItem(id, id + 1 + ": " + dbName + "(" + userName + ")");
                this.ui.getUIManager().getReporter().report("USE db #" + (id + 1) + " connected to db:<" + dbName + "> by user:<" + userName + ">\n");
                this.ui.addCmdToHisLists(cmd);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
                this.ui.getUIManager().getReporter().error("Can not connect to server");
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                this.ui.getUIManager().getReporter().error("Can not connect to server");
            }
            finally {
                this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
            }
        }
    }

    public void databaseDisconnectActionPerformed(ActionEvent e) {
        Connection connection = null;
        String cmd = "disconnect;";
        try {
            connection = this.ui.getCurrentConnection();
            int id = this.ui.getCurrentConnectionID();
            String dbName = this.ui.getCurrentDBName();
            String userName = this.ui.getCurrentUserName();
            connection.close();
            this.ui.setCurrentConnection(null, null, null, null);
            this.ui.getFrame().getToolBar().setConnectionsListItem(id, id + 1 + ": not connected yet");
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.getUIManager().getReporter().report("USE db #" + (id + 1) + " disconnected from db:<" + dbName + "> by user:<" + userName + ">\n");
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        }
        catch (SQLException e2) {
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.getUIManager().getReporter().error("Can not disconnect from server");
        }
    }

    public void databaseDisConnectAllActionPerformed(ActionEvent e) {
        System.out.println("database->disconnect all");
    }

    public void databaseShowConsActionPerformed(ActionEvent e) {
        System.out.println("database->showcons");
    }

    public void databaseRunScriptActionPerformed(ActionEvent e) {
        System.out.println("database->runscript");
        JFileChooser chooser = new JFileChooser();
        chooser.setName("OpenScriptDialog");
        chooser.setMultiSelectionEnabled(false);
        DbaFileFilter dff = new DbaFileFilter("sql");
        chooser.setFileFilter(dff);
        chooser.setCurrentDirectory(new File(this.ui.getIsqlStatus(6)));
        int ret = chooser.showOpenDialog(this.ui.getFrame());
        String filePath = null;
        if (ret == 0) {
            File file = chooser.getSelectedFile();
            if (!file.exists()) {
                System.out.println(file.getAbsolutePath() + " file does not exist.");
                return;
            }
            filePath = file.getAbsolutePath();
            String cmd = "run '" + filePath + "';";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().needCmdLineKeyPressed();
        }
    }

    public void databaseCommitActionPerformed(ActionEvent e) {
        System.out.println("database->commit");
    }

    public void databaseRollBackActionPerformed(ActionEvent e) {
        System.out.println("database->rollback");
    }

    public void databaseExitActionPerformed(ActionEvent e) {
        Object connection = null;
        String cmd = "disconnect all;";
        try {
            ArrayList<ConnectionStatus> cs = this.ui.getConnectionStatus();
            ConnectionStatus c = null;
            for (int i = 0; i < cs.size(); ++i) {
                c = cs.get(i);
                if (!c.isConnected()) continue;
                c.getConnection().close();
                c.setConnection(null, null, null, null);
                this.ui.getFrame().getToolBar().setConnectionsListItem(i, i + 1 + ": not connected yet");
                this.ui.getUIManager().getReporter().report("USE db #" + (i + 1) + " disconnected from db:<" + c.getDBName() + "> by user:<" + c.getUserName() + ">\n");
            }
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
            this.ui.getFrame().setVisible(false);
            this.ui.getFrame().dispose();
        }
        catch (SQLException e2) {
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.getUIManager().getReporter().error("Can not disconnect all from server");
            this.ui.getFrame().setVisible(false);
            this.ui.getFrame().dispose();
        }
    }

    public void editUndoActionPerformed(ActionEvent e) {
        UndoManager undo = this.ui.getFrame().getSimulator().getUndoManager();
        if (undo.canUndo()) {
            undo.undo();
        }
    }

    public void editCutActionPerformed(ActionEvent e) {
        JTextField cmdLine = this.ui.getFrame().getSimulator().getSimulatorCmdLine();
        cmdLine.cut();
    }

    public void editCopyActionPerformed(ActionEvent e) {
        this.ui.getFrame().getSimulator().copyAction(null);
    }

    public void editPasteActionPerformed(ActionEvent e) {
        JTextField cmdLine = this.ui.getFrame().getSimulator().getSimulatorCmdLine();
        cmdLine.paste();
    }

    public void editDeleteActionPerformed(ActionEvent e) {
        JTextField cmdLine = this.ui.getFrame().getSimulator().getSimulatorCmdLine();
        cmdLine.replaceSelection("");
    }

    public void editSelectAllActionPerformed(ActionEvent e) {
        JTextField cmdLine = this.ui.getFrame().getSimulator().getSimulatorCmdLine();
        cmdLine.selectAll();
    }

    public void editClearAllActionPerformed(ActionEvent e) {
        this.ui.getFrame().getSimulator().clearSimulatorMsgBoard();
    }

    public void cmdAbortCMDActionPerformed(ActionEvent e) {
        String cmd = this.ui.getFrame().getSimulator().getInputCmd();
        this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
        this.ui.getFrame().getSimulator().clearCmd();
    }

    public void cmdAbortFetchActionPerformed(ActionEvent e) {
        System.out.println("cmd->fetch");
    }

    public void cmdAbortScriptActionPerformed(ActionEvent e) {
        System.out.println("cmd->Script");
    }

    public void cmdListTablesActionPerformed(ActionEvent e) {
        System.out.println("cmd->list tables");
    }

    public void displayFastRetrieveActionPerformed(ActionEvent e) {
        System.out.println("display->fast retrieve");
    }

    public void displayHSBActionPerformed(ActionEvent e) {
        if (this.displayHSBMenuItem.isSelected()) {
            this.ui.getFrame().getSimulator().showHorizontalScrollBar();
        } else {
            this.ui.getFrame().getSimulator().hideHorizontalScrollBar();
        }
    }

    public void displayVSBActionPerformed(ActionEvent e) {
        if (this.displayVSBMenuItem.isSelected()) {
            this.ui.getFrame().getSimulator().showVerticalScrollBar();
        } else {
            this.ui.getFrame().getSimulator().hideVerticalScrollBar();
        }
    }

    public void displayToolBarActionPerformed(ActionEvent e) {
        if (this.displayToolBarMenuItem.isSelected()) {
            this.ui.getFrame().showToolBar();
        } else {
            this.ui.getFrame().hideToolBar();
        }
    }

    public void displayStatusBarActionPerformed(ActionEvent e) {
        if (this.displayStatusBarMenuItem.isSelected()) {
            this.ui.getFrame().showStatusBar();
        } else {
            this.ui.getFrame().hideStatusBar();
        }
    }

    public void displayPreferencesActionPerformed(ActionEvent e) {
        JsqlPreferencesDialog dlg = new JsqlPreferencesDialog(this.ui.getFrame());
        GuiUt.setCenterLocation(this.ui.getFrame(), dlg);
        dlg.setVisible(true);
    }

    public void setBlobShowActionPerformed(ActionEvent e) {
        JsqlBlobShowDialog.showDialog(this.ui);
    }

    public void setGetENVActionPerformed(ActionEvent e) {
        if (this.setGetENVMenuItem.isSelected()) {
            String cmd = "set getenv on;";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.setIsqlStatus(1, "on");
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        } else {
            String cmd = "set getenv off;";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.setIsqlStatus(1, "off");
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        }
    }

    private boolean isValidInteger(String str) {
        try {
            int value = Integer.parseInt(str);
            return 0 < value && value < Integer.MAX_VALUE;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void setLineWidthOffActionPerformed(ActionEvent e) {
        String cmd = "set linewidth off;";
        this.ui.getFrame().getSimulator().inputCmd(cmd);
        this.ui.setIsqlStatus(8, "off");
        this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
        this.ui.addCmdToHisLists(cmd);
        this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        this.setLineWidthMenuItem.setText("Other");
        this.isLineWidthOffMenuSelected = true;
    }

    public void setLineWidthActionPerformed(ActionEvent e) {
        ShowIntegerInputDlg dlg = GuiUt.showIntegerInputDlg(this.ui.getFrame(), "Line width", "Please input line width number:");
        if (dlg.isOKPushed() && dlg.getInputValue() != null && dlg.getInputValue().trim().length() > 0) {
            String number = dlg.getInputValue();
            if (this.isValidInteger(number)) {
                int num = Integer.parseInt(number);
                String cmd = "set linewidth " + num + ";";
                this.ui.getFrame().getSimulator().inputCmd(cmd);
                this.ui.setIsqlStatus(8, num + "");
                this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
                this.ui.addCmdToHisLists(cmd);
                this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
                this.setLineWidthMenuItem.setText("Other(" + num + ")");
                this.isLineWidthOffMenuSelected = false;
            } else {
                String cmd = "set linewidth " + number + ";";
                this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
                this.ui.getUIManager().getReporter().error("Invalid number or out of range");
                if (this.isLineWidthOffMenuSelected) {
                    this.setLineWidthOffMenuItem.setSelected(true);
                } else {
                    this.setLineWidthMenuItem.setSelected(true);
                }
            }
        } else if (this.isLineWidthOffMenuSelected) {
            this.setLineWidthOffMenuItem.setSelected(true);
        } else {
            this.setLineWidthMenuItem.setSelected(true);
        }
    }

    public void setPrinttoOffActionPerformed(ActionEvent e) {
        String cmd = "set printto off;";
        this.ui.getFrame().getSimulator().inputCmd(cmd);
        this.ui.setIsqlStatus(3, "off");
        this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
        this.ui.getUIManager().getReporter().report(">>>>Command results redirected into stdout<<<<\n");
        this.ui.addCmdToHisLists(cmd);
        this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        this.setPrinttoMenuItem.setText("Other");
        this.ui.getUIManager().closeWriter();
        this.ui.getUIManager().openWriter();
        this.isPrinttoOffMenuSelected = true;
    }

    public void setPrinttoActionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setName("SetPrinttoFileChooserDialog");
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        chooser.setMultiSelectionEnabled(false);
        int ret = chooser.showSaveDialog(this.ui.getFrame());
        String filePath = null;
        if (ret == 0) {
            File file = chooser.getSelectedFile();
            filePath = file.getAbsolutePath();
            String cmd = "set printto '" + filePath + "';";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.setIsqlStatus(3, filePath);
            this.ui.getFrame().getSimulator().appendMessage("\njsql> " + cmd + "\n");
            this.ui.getFrame().getSimulator().appendMessage(">>>>Command results redirected into file: " + filePath + " <<<<\n");
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
            this.setPrinttoMenuItem.setText(this.getFormatText(this.setPrinttoMenuItem.getText(), filePath));
            this.ui.getUIManager().closeWriter();
            this.ui.getUIManager().openWriter();
            this.isPrinttoOffMenuSelected = false;
        } else if (this.isPrinttoOffMenuSelected) {
            this.setPrinttoOffMenuItem.setSelected(true);
        } else {
            this.setPrinttoMenuItem.setSelected(true);
        }
    }

    public void setShowTimeActionPerformed(ActionEvent e) {
        if (this.setShowTimeMenuItem.isSelected()) {
            String cmd = "set showtime on;";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.setIsqlStatus(5, "on");
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        } else {
            String cmd = "set showtime off;";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.setIsqlStatus(5, "off");
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        }
    }

    public void setWorkDIRActionPerformed(ActionEvent e) {
        ShowSimpleInputDlg dlg = GuiUt.showSimpleInputDlg(this.ui.getFrame(), "Input working directory", "Please input working directory:");
        if (dlg.isOKPushed() && dlg.getInputValue() != null && dlg.getInputValue().trim().length() > 0) {
            String workDir = dlg.getInputValue();
            File file = new File(workDir);
            if (!file.exists()) {
                String cmd = "set workdir '" + file.getAbsolutePath() + "';";
                this.ui.getFrame().getSimulator().inputCmd(cmd);
                this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
                this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
                this.ui.getUIManager().getReporter().error("Path does not exist!\n");
                return;
            }
            String cmd = "set workdir '" + file.getAbsolutePath() + "';";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.setIsqlStatus(6, workDir);
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
            this.setWorkDIRMenuItem.setText(this.getFormatText("Work Dir", workDir));
        }
    }

    private String getFormatText(String main, String info) {
        if (main == null) {
            return null;
        }
        if (info == null) {
            return main;
        }
        String tmp = null;
        tmp = info.length() < 20 ? info : info.substring(0, 20) + "...";
        tmp = main + "(" + tmp + ")";
        return tmp;
    }

    public void setLoginTimeoutActionPerformed(ActionEvent e) {
        String number;
        ShowIntegerInputDlg dlg = GuiUt.showIntegerInputDlg(this.ui.getFrame(), "Login timeout", "Please input login timeout value:");
        if (dlg.isOKPushed() && dlg.getInputValue() != null && dlg.getInputValue().trim().length() > 0 && this.isValidInteger(number = dlg.getInputValue())) {
            int num = Integer.parseInt(number);
            String cmd = "set login timeout " + num + ";";
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.setIsqlStatus(7, num + "");
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
            this.setLoginTimeoutMenuItem.setText(this.getFormatText("Login Timeout", num + ""));
        }
    }

    public void setInputEncodingActionPerformed(ActionEvent e) {
        String cmd = "set input encoding ";
        int i = 0;
        if (this.setInputEncoding0MenuItem.isSelected()) {
            cmd = cmd + LCODE[0] + ";";
            i = 0;
        } else if (this.setInputEncoding1MenuItem.isSelected()) {
            cmd = cmd + LCODE[1] + ";";
            i = 1;
        } else if (this.setInputEncoding2MenuItem.isSelected()) {
            cmd = cmd + LCODE[2] + ";";
            i = 2;
        } else if (this.setInputEncoding3MenuItem.isSelected()) {
            cmd = cmd + LCODE[3] + ";";
            i = 3;
        } else if (this.setInputEncoding4MenuItem.isSelected()) {
            cmd = cmd + LCODE[4] + ";";
            i = 4;
        } else if (this.setInputEncoding5MenuItem.isSelected()) {
            cmd = cmd + LCODE[5] + ";";
            i = 5;
        } else if (this.setInputEncoding6MenuItem.isSelected()) {
            cmd = cmd + LCODE[6] + ";";
            i = 6;
        } else if (this.setInputEncoding7MenuItem.isSelected()) {
            cmd = cmd + LCODE[7] + ";";
            i = 7;
        } else if (this.setInputEncoding8MenuItem.isSelected()) {
            cmd = cmd + LCODE[8] + ";";
            i = 8;
        } else if (this.setInputEncoding9MenuItem.isSelected()) {
            cmd = cmd + LCODE[9] + ";";
            i = 9;
        } else if (this.setInputEncoding10MenuItem.isSelected()) {
            cmd = cmd + LCODE[10] + ";";
            i = 10;
        }
        this.ui.getFrame().getSimulator().inputCmd(cmd);
        this.ui.setIsqlStatus(2, LCODE[i]);
        this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
        this.ui.addCmdToHisLists(cmd);
        this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
    }

    public void setOutputEncodingActionPerformed(ActionEvent e) {
        String cmd = "set output encoding ";
        int i = 0;
        if (this.setOutputEncoding0MenuItem.isSelected()) {
            cmd = cmd + LCODE[0] + ";";
            i = 0;
        } else if (this.setOutputEncoding1MenuItem.isSelected()) {
            cmd = cmd + LCODE[1] + ";";
            i = 1;
        } else if (this.setOutputEncoding2MenuItem.isSelected()) {
            cmd = cmd + LCODE[2] + ";";
            i = 2;
        } else if (this.setOutputEncoding3MenuItem.isSelected()) {
            cmd = cmd + LCODE[3] + ";";
            i = 3;
        } else if (this.setOutputEncoding4MenuItem.isSelected()) {
            cmd = cmd + LCODE[4] + ";";
            i = 4;
        } else if (this.setOutputEncoding5MenuItem.isSelected()) {
            cmd = cmd + LCODE[5] + ";";
            i = 5;
        } else if (this.setOutputEncoding6MenuItem.isSelected()) {
            cmd = cmd + LCODE[6] + ";";
            i = 6;
        } else if (this.setOutputEncoding7MenuItem.isSelected()) {
            cmd = cmd + LCODE[7] + ";";
            i = 7;
        } else if (this.setOutputEncoding8MenuItem.isSelected()) {
            cmd = cmd + LCODE[8] + ";";
            i = 8;
        } else if (this.setOutputEncoding9MenuItem.isSelected()) {
            cmd = cmd + LCODE[9] + ";";
            i = 9;
        } else if (this.setOutputEncoding10MenuItem.isSelected()) {
            cmd = cmd + LCODE[10] + ";";
            i = 10;
        }
        this.ui.getFrame().getSimulator().inputCmd(cmd);
        this.ui.setIsqlStatus(4, LCODE[i]);
        this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
        this.ui.addCmdToHisLists(cmd);
        this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
    }

    public void setInputEncodingMoreActionPerformed(ActionEvent e) {
        System.out.println("set->input encoding more format");
    }

    public void setOutputEncodingMoreActionPerformed(ActionEvent e) {
        System.out.println("set->output encoding more format");
    }

    public void setExtNameActionPerformed(ActionEvent e) {
        System.out.println("set->ext name ");
    }

    public void setDateInputFormatActionPerformed(ActionEvent e) {
        String cmd = "set date input format '";
        String format = "";
        for (int i = 0; i < this.setInputDateFormatMenuItems.length; ++i) {
            if (!this.setInputDateFormatMenuItems[i].isSelected()) continue;
            format = ConnectionStatus.DATE_FORMAT[i];
            break;
        }
        cmd = cmd + format + "';";
        try {
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.setCurrentConnectionStatus(2, format);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        }
        catch (SQLException e1) {
            this.ui.getUIManager().getReporter().error("Date format illegal.");
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        }
    }

    public void setDateOutputFormatActionPerformed(ActionEvent e) {
        String cmd = "set date output format '";
        String format = "";
        for (int i = 0; i < this.setOutputDateFormatMenuItems.length; ++i) {
            if (!this.setOutputDateFormatMenuItems[i].isSelected()) continue;
            format = ConnectionStatus.DATE_FORMAT[i];
            break;
        }
        cmd = cmd + format + "';";
        try {
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.setCurrentConnectionStatus(3, format);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        }
        catch (SQLException e1) {
            this.ui.getUIManager().getReporter().error("Date format illegal.");
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        }
    }

    public void setTimeInputFormatActionPerformed(ActionEvent e) {
        String cmd = "set time input format '";
        String format = "";
        for (int i = 0; i < this.setInputTimeFormatMenuItems.length; ++i) {
            if (!this.setInputTimeFormatMenuItems[i].isSelected()) continue;
            format = ConnectionStatus.TIME_FORMAT[i];
            break;
        }
        cmd = cmd + format + "';";
        try {
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.setCurrentConnectionStatus(4, format);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        }
        catch (SQLException e1) {
            this.ui.getUIManager().getReporter().error("Time format illegal.");
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        }
    }

    public void setTimeOutputFormatActionPerformed(ActionEvent e) {
        String cmd = "set time output format '";
        String format = "";
        for (int i = 0; i < this.setOutputTimeFormatMenuItems.length; ++i) {
            if (!this.setOutputTimeFormatMenuItems[i].isSelected()) continue;
            format = ConnectionStatus.TIME_FORMAT[i];
            break;
        }
        cmd = cmd + format + "';";
        try {
            this.ui.getFrame().getSimulator().inputCmd(cmd);
            this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
            this.ui.setCurrentConnectionStatus(5, format);
            this.ui.addCmdToHisLists(cmd);
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        }
        catch (SQLException e1) {
            this.ui.getUIManager().getReporter().error("Time format illegal.");
            this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
        }
    }

    public void setShowSettingsActionPerformed(ActionEvent e) {
        String isqlStatus = this.ui.getIsqlStatus().toString();
        String cmd = "set;";
        this.ui.getFrame().getSimulator().inputCmd(cmd);
        this.ui.getUIManager().getReporter().reportln("jsql> " + cmd);
        this.ui.getUIManager().getReporter().reportln(isqlStatus);
        if (this.ui.getCurrentConnectionStatus().isConnected()) {
            String conStatus = this.ui.getCurrentConnectionStatus().toString();
            this.ui.getUIManager().getReporter().reportln(conStatus);
        }
        this.ui.addCmdToHisLists(cmd);
        this.ui.getFrame().getSimulator().cmdLineKeyPressed(null);
    }

    public void setSaveSettingsActionPerformed(ActionEvent e) {
        this.jsql2Pref.save();
        if (this.ui.getCurrentConnectionStatus().isConnected()) {
            try {
                String dbName = this.ui.getCurrentDBName();
                String dateInput = this.ui.getCurrentConnectionStatus(2);
                String dateOutput = this.ui.getCurrentConnectionStatus(3);
                String timeInput = this.ui.getCurrentConnectionStatus(4);
                String timeOutput = this.ui.getCurrentConnectionStatus(5);
                JdmConfig config = new JdmConfig();
                int rc = config.fileOpen("dmconfig.ini", dbName, "r+");
                if (rc != 0) {
                    System.out.println("Error open dmconfig.ini via JdmConfig");
                } else {
                    config.insertPara("DB_DAIFM", dateInput, 4096);
                    config.insertPara("DB_DAOFM", dateOutput, 4096);
                    config.insertPara("DB_TMIFM", timeInput, 4096);
                    config.insertPara("DB_TMOFM", timeOutput, 4096);
                    config.fileClose();
                }
            }
            catch (SQLException e1) {
                System.out.println("save connection status failed!");
            }
        }
    }

    public void helpOnlineActionPerformed(ActionEvent e) {
        System.out.println("help->online");
    }

    public void helpSQLPreferenceActionPerformed(ActionEvent e) {
        System.out.println("help->sql preference");
    }

    public void helpAboutActionPerformed(ActionEvent e) {
        AboutBox dlg = new AboutBox((Frame)this.ui.getFrame(), 5);
        GuiUt.setCenterLocation(this.ui.getFrame(), dlg);
        dlg.setModal(true);
        dlg.setVisible(true);
    }
}

