/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import controller.UIManager;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import ui.JsqlUI;
import ui.gui.JsqlFrame;

public class JsqlGUI
extends JsqlUI {
    private BufferedWriter bWrite = null;
    private UIManager uiManager = null;
    private JsqlFrame frame = null;

    public JsqlGUI(HashMap<String, String> paras) {
        System.out.println("gui with paras.");
        String ienc = paras.get("-ienc");
        String outputFile = paras.get("-o");
        String oenc = paras.get("-oenc");
        if (ienc != null) {
            System.out.println("ienc=" + ienc);
            this.setIsqlStatus(2, ienc);
        }
        if (outputFile != null) {
            System.out.println("output=" + outputFile);
            this.setIsqlStatus(3, outputFile);
        }
        if (oenc != null) {
            System.out.println("oenc=" + oenc);
            this.setIsqlStatus(4, oenc);
        }
        this.uiManager = new UIManager(this);
        this.frame = new JsqlFrame(this);
        this.showGUI();
        this.openWriter();
    }

    public JsqlGUI() {
        System.out.println("gui default.");
        this.uiManager = new UIManager(this);
        this.frame = new JsqlFrame(this);
        this.showGUI();
        this.openWriter();
    }

    @Override
    public void openWriter() {
        try {
            BufferedWriter writer = null;
            String output = this.getIsqlStatus(3);
            String oenc = this.getIsqlStatus(4);
            if (output.equalsIgnoreCase("off")) {
                return;
            }
            FileOutputStream fops = new FileOutputStream(output);
            this.bWrite = writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fops, oenc));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void closeWriter() {
        if (this.bWrite != null) {
            try {
                this.bWrite.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void output(String message) {
        try {
            if (this.getIsqlStatus(3).equals("off")) {
                this.frame.getSimulator().appendMessage(message);
            } else {
                this.bWrite.write(message);
                this.bWrite.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public UIManager getUIManager() {
        return this.uiManager;
    }

    @Override
    public void callUIManagerToProcess() {
    }

    public void callUIManagerToProcess(String cmd) {
        this.uiManager.process(cmd);
    }

    public void showGUI() {
        this.frame.setVisible(true);
    }

    public JsqlFrame getFrame() {
        return this.frame;
    }
}

