/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import dbaut.GuiUt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import parser.jsqlparser.PreParser;
import reporter.Reporter;
import ui.gui.JsqlGUI;

public class JsqlCmdSimulator
extends JScrollPane {
    private JsqlGUI ui = null;
    private Font simulatorFont = new Font("Monospaced", 1, 14);
    private Color simulatorForeground = Color.GREEN;
    private Color simulatorBackground = Color.BLACK;
    private JTextArea msgBoard = new JTextArea();
    private JLabel cmdPrompt = new JLabel("jsql> ");
    private JTextField cmdLine = new JTextField();
    private final JPanel localJPanel1 = new JPanel(new BorderLayout(0, 0));
    private JPanel localJPanel2 = new JPanel(new BorderLayout(0, 0));
    private JPanel localJPanel3 = new JPanel();
    private boolean isVAdding = false;
    private ArrayList<String> cmdLists = null;
    private int cmdListsindex = -1;
    private UndoManager undoManager = new UndoManager();
    private boolean isHorizontalBarShow = true;
    private boolean isVerticalBarShow = true;
    private StringBuffer sb = new StringBuffer();
    private int i = 1;
    private Reporter reporter = null;
    private boolean needMore = false;

    public JsqlCmdSimulator(JsqlGUI ui) {
        this.ui = ui;
        this.reporter = ui.getUIManager().getReporter();
        this.cmdLists = ui.getCmdLists();
        this.init();
    }

    public void cmdLineKeyPressed(KeyEvent event) {
        this.scrollToVisible();
        if (event == null) {
            this.cmdListsindex = this.cmdLists.size() - 1;
            this.cmdLine.setText("");
            this.cmdLine.requestFocus();
            return;
        }
        if (event.getKeyCode() == 10) {
            String cmd = this.cmdLine.getText();
            String pro = this.getCmdPromptText();
            if (cmd != null && cmd.trim().length() > 0) {
                this.reporter.reportln(pro + cmd);
                this.sb.append(cmd + "\n");
                this.cmdLine.setText("");
                if (!PreParser.isOneCMDFinished(this.sb.toString())) {
                    this.needMore = true;
                    int b = pro.indexOf("> ");
                    String str = pro.substring(0, b);
                    String newPro = String.format("%" + str.length() + "s", ++this.i);
                    this.setCmdPromptText(newPro + "> ");
                    return;
                }
                this.needMore = false;
                this.i = 1;
                String oneCmd = this.sb.toString();
                this.sb = new StringBuffer();
                this.ui.callUIManagerToProcess(oneCmd);
                this.reporter.reportln();
                this.setCmdPromptText("jsql> ");
                this.cmdListsindex = this.cmdLists.size() - 1;
                this.cmdLine.requestFocus();
                this.isVAdding = true;
            } else if (this.needMore) {
                int b = pro.indexOf("> ");
                String str = pro.substring(0, b);
                String newPro = String.format("%" + str.length() + "s", ++this.i);
                this.setCmdPromptText(newPro + "> ");
                this.reporter.reportln(pro + cmd);
                this.cmdLine.setText("");
            } else {
                this.reporter.reportln("jsql> " + cmd);
                this.reporter.reportln();
                this.cmdLine.setText("");
            }
        }
    }

    public void needCmdLineKeyPressed() {
        this.scrollToVisible();
        String cmd = this.cmdLine.getText();
        if (cmd != null && cmd.trim().length() > 0) {
            this.isVAdding = true;
            this.ui.callUIManagerToProcess(this.cmdLine.getText());
            this.cmdLine.setText("");
            this.cmdListsindex = this.cmdLists.size() - 1;
            this.cmdLine.requestFocus();
        } else {
            this.ui.getUIManager().getReporter().reportln("jsql> ");
            this.ui.getUIManager().getReporter().reportln();
        }
    }

    private void mouseRightClick(MouseEvent e) {
        if (e.getButton() == 3) {
            Toolkit tk;
            Clipboard cb;
            Transferable tf;
            Clipboard cp;
            StringSelection ss;
            String str = this.msgBoard.getSelectedText();
            if (str != null && str.length() > 0) {
                ss = new StringSelection(str);
                cp = Toolkit.getDefaultToolkit().getSystemClipboard();
                cp.setContents(ss, null);
                this.msgBoard.select(this.msgBoard.getText().length(), this.msgBoard.getText().length());
            }
            if ((str = this.cmdLine.getSelectedText()) != null && str.length() > 0) {
                ss = new StringSelection(str);
                cp = Toolkit.getDefaultToolkit().getSystemClipboard();
                cp.setContents(ss, null);
                this.cmdLine.select(0, 0);
            }
            if ((tf = (cb = (tk = Toolkit.getDefaultToolkit()).getSystemClipboard()).getContents(null)) != null && tf.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String txt = (String)tf.getTransferData(DataFlavor.stringFlavor);
                    if (txt != null && txt.length() > 0) {
                        String cmd = "";
                        String temp = this.cmdLine.getText();
                        if (temp != null && temp.length() > 0) {
                            cmd = temp;
                        }
                        this.cmdLine.setText(cmd + txt);
                    }
                }
                catch (UnsupportedFlavorException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public void copyAction(KeyEvent e) {
        String txt = this.cmdLine.getSelectedText();
        if (txt != null && txt.length() > 0) {
            this.cmdLine.copy();
            this.cmdLine.select(this.cmdLine.getText().length(), this.cmdLine.getText().length());
        } else {
            txt = this.msgBoard.getSelectedText();
            if (txt != null && txt.length() > 0) {
                Clipboard cp = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection ss = new StringSelection(txt);
                cp.setContents(ss, null);
                this.msgBoard.select(this.msgBoard.getText().length(), this.msgBoard.getText().length());
            }
        }
    }

    private void init() {
        this.msgBoard.setEditable(false);
        this.msgBoard.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JsqlCmdSimulator.this.msgBoard.requestFocus();
                JsqlCmdSimulator.this.cmdLine.select(JsqlCmdSimulator.this.cmdLine.getText().length(), JsqlCmdSimulator.this.cmdLine.getText().length());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.msgBoard.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                JsqlCmdSimulator.this.dispatchEvent(e);
            }
        });
        this.msgBoard.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JsqlCmdSimulator.this.mouseRightClick(e);
            }
        });
        Document doc = this.cmdLine.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                JsqlCmdSimulator.this.undoManager.addEdit(e.getEdit());
            }
        });
        this.localJPanel2.add((Component)this.cmdPrompt, "West");
        this.localJPanel2.add((Component)this.cmdLine, "Center");
        this.localJPanel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JsqlCmdSimulator.this.mouseRightClick(e);
            }
        });
        this.cmdLine.setCursor(Cursor.getDefaultCursor());
        this.cmdLine.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JsqlCmdSimulator.this.mouseRightClick(e);
            }
        });
        this.cmdLine.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent paramKeyEvent) {
                JsqlCmdSimulator.this.cmdLineKeyPressed(paramKeyEvent);
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                JsqlCmdSimulator.this.cmdLine.requestFocus();
                JsqlCmdSimulator.this.msgBoard.select(JsqlCmdSimulator.this.msgBoard.getText().length(), JsqlCmdSimulator.this.msgBoard.getText().length());
                if (JsqlCmdSimulator.this.cmdLine.getText().length() > 1000) {
                    GuiUt.showErrorDlg(JsqlCmdSimulator.this.ui.getFrame(), "Your command is too long, please modify it!", "");
                }
            }
        });
        this.cmdLine.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                String tmpString;
                if (e.getKeyCode() == 38 || e.isControlDown() && e.getKeyCode() == 80) {
                    if (JsqlCmdSimulator.this.cmdListsindex > 0) {
                        tmpString = (String)JsqlCmdSimulator.this.cmdLists.get(--JsqlCmdSimulator.this.cmdListsindex);
                        JsqlCmdSimulator.this.cmdLine.setText(tmpString);
                        JsqlCmdSimulator.this.cmdLine.setText(tmpString);
                    } else if (JsqlCmdSimulator.this.cmdListsindex == 0) {
                        tmpString = (String)JsqlCmdSimulator.this.cmdLists.get(JsqlCmdSimulator.this.cmdListsindex);
                        JsqlCmdSimulator.this.cmdLine.setText(tmpString);
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                if (e.getKeyCode() == 40 || e.isControlDown() && e.getKeyCode() == 78) {
                    if (JsqlCmdSimulator.this.cmdListsindex < 0) {
                        JsqlCmdSimulator.this.cmdLine.setText("");
                        Toolkit.getDefaultToolkit().beep();
                    } else if (JsqlCmdSimulator.this.cmdListsindex < JsqlCmdSimulator.this.cmdLists.size() - 1) {
                        tmpString = (String)JsqlCmdSimulator.this.cmdLists.get(++JsqlCmdSimulator.this.cmdListsindex);
                        JsqlCmdSimulator.this.cmdLine.setText(tmpString);
                    } else if (JsqlCmdSimulator.this.cmdListsindex == JsqlCmdSimulator.this.cmdLists.size() - 1) {
                        tmpString = (String)JsqlCmdSimulator.this.cmdLists.get(JsqlCmdSimulator.this.cmdListsindex);
                        JsqlCmdSimulator.this.cmdLine.setText(tmpString);
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                if (e.isControlDown() && e.getKeyCode() == 67) {
                    JsqlCmdSimulator.this.copyAction(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.localJPanel1.add((Component)this.localJPanel2, "North");
        this.localJPanel1.add((Component)this.localJPanel3, "Center");
        this.msgBoard.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JsqlCmdSimulator.this.cmdLine.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.cmdLine.setBorder(null);
        this.cmdLine.requestFocus();
        JPanel contentPanel = new JPanel(new BorderLayout(0, 0));
        contentPanel.add((Component)this.msgBoard, "North");
        contentPanel.add((Component)this.localJPanel1, "Center");
        this.setAutoscrolls(true);
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(22);
        this.getViewport().add((Component)contentPanel, null);
        this.getVerticalScrollBar().setUnitIncrement(20);
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent paramAdjustmentEvent) {
                if (JsqlCmdSimulator.this.isVAdding) {
                    paramAdjustmentEvent.getAdjustable().setValue(paramAdjustmentEvent.getAdjustable().getMaximum());
                    JsqlCmdSimulator.this.isVAdding = false;
                }
            }
        });
        this.setSimulatorFont(this.simulatorFont);
        this.setSimulatorForeColor(this.simulatorForeground);
        this.setSimulatorBackColor(this.simulatorBackground);
    }

    private void scrollToVisible() {
        Point point = this.localJPanel1.getLocation();
        JScrollBar vBar = this.getVerticalScrollBar();
        vBar.setValue(point.y + this.cmdLine.getHeight());
    }

    public JTextArea getSimulatorMsgBoard() {
        return this.msgBoard;
    }

    public void clearSimulatorMsgBoard() {
        this.msgBoard.setText("");
        this.validate();
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public JTextField getSimulatorCmdLine() {
        return this.cmdLine;
    }

    public void inputCmd(String cmd) {
        this.cmdLine.setText(cmd);
        this.scrollToVisible();
    }

    public String getInputCmd() {
        return this.cmdLine.getText();
    }

    public void clearCmd() {
        this.cmdLine.setText("");
        this.scrollToVisible();
    }

    public void appendMessage(String message) {
        this.msgBoard.append(message);
        this.scrollToVisible();
        this.isVAdding = true;
    }

    public void setSimulatorFont(Font font) {
        this.simulatorFont = font;
        this.msgBoard.setFont(font);
        this.cmdLine.setFont(font);
        this.cmdPrompt.setFont(font);
    }

    public Font getSimulatorFont() {
        return this.simulatorFont;
    }

    public void setCmdPromptText(String str) {
        this.cmdPrompt.setText(str);
        this.validate();
    }

    public String getCmdPromptText() {
        return this.cmdPrompt.getText();
    }

    public void setSimulatorForeColor(Color c) {
        this.simulatorForeground = c;
        this.msgBoard.setForeground(c);
        this.cmdLine.setForeground(c);
        this.cmdLine.setCaretColor(c);
        this.cmdPrompt.setForeground(c);
    }

    public Color getSimulatorForeColor() {
        return this.simulatorForeground;
    }

    public void setSimulatorBackColor(Color c) {
        this.simulatorBackground = c;
        this.localJPanel1.setBackground(c);
        this.localJPanel2.setBackground(c);
        this.localJPanel3.setBackground(c);
        this.msgBoard.setBackground(c);
        this.cmdPrompt.setBackground(c);
        this.cmdLine.setBackground(c);
    }

    public Color getSimulatorBackColor() {
        return this.simulatorBackground;
    }

    public void simulatorRequireFocus() {
        this.cmdLine.grabFocus();
        this.validate();
    }

    public boolean isVerticalBarShow() {
        return this.isVerticalBarShow;
    }

    public boolean isHorizontalBarShow() {
        return this.isHorizontalBarShow;
    }

    public void hideVerticalScrollBar() {
        this.setVerticalScrollBarPolicy(21);
        this.isVerticalBarShow = false;
        this.validate();
    }

    public void showVerticalScrollBar() {
        this.setVerticalScrollBarPolicy(22);
        this.isVerticalBarShow = true;
        this.validate();
    }

    public void hideHorizontalScrollBar() {
        this.setHorizontalScrollBarPolicy(31);
        this.isHorizontalBarShow = false;
        this.validate();
    }

    public void showHorizontalScrollBar() {
        this.setHorizontalScrollBarPolicy(32);
        this.isHorizontalBarShow = true;
        this.validate();
    }
}

