/*
 * Decompiled with CFR 0.152.
 */
package ui.cmdui;

import controller.UIManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import ui.Jsql2Preferences;
import ui.JsqlUI;

public class JsqlCMDUI
extends JsqlUI {
    private BufferedWriter bWrite = null;
    private UIManager uiManager = null;
    private InputStreamReader ipsr = null;

    public JsqlCMDUI(File f, HashMap<String, String> paras) {
        System.out.println("cmdui with file and paras.");
        try {
            Jsql2Preferences pref = Jsql2Preferences.getPreferencesXml(this);
            pref.setPreferences();
            this.ips = new FileInputStream(f);
            String ienc = paras.get("-ienc");
            String outputFile = paras.get("-o");
            String oenc = paras.get("-oenc");
            if (ienc != null) {
                System.out.println("ienc=" + ienc);
                this.setIsqlStatus(2, ienc);
            }
            if (outputFile != null) {
                System.out.println("output=" + outputFile);
                this.setIsqlStatus(3, outputFile);
            }
            if (oenc != null) {
                System.out.println("oenc=" + oenc);
                this.setIsqlStatus(4, oenc);
            }
            this.uiManager = new UIManager(this);
            this.ipsr = new InputStreamReader(this.ips, this.getIsqlStatus(2));
            this.openWriter();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JsqlCMDUI(InputStream in, HashMap<String, String> paras) {
        System.out.println("cmdui with input stream and paras.");
        try {
            Jsql2Preferences pref = Jsql2Preferences.getPreferencesXml(this);
            pref.setPreferences();
            this.ips = in;
            String ienc = paras.get("-ienc");
            String outputFile = paras.get("-o");
            String oenc = paras.get("-oenc");
            if (ienc != null) {
                System.out.println("ienc=" + ienc);
                this.setIsqlStatus(2, ienc);
            }
            if (outputFile != null) {
                System.out.println("output=" + outputFile);
                this.setIsqlStatus(3, outputFile);
            }
            if (oenc != null) {
                System.out.println("oenc=" + oenc);
                this.setIsqlStatus(4, oenc);
            }
            this.uiManager = new UIManager(this);
            this.ipsr = new InputStreamReader(this.ips, this.getIsqlStatus(2));
            this.openWriter();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JsqlCMDUI(InputStream in) {
        System.out.println("cmdui with input stream.");
        try {
            Jsql2Preferences pref = Jsql2Preferences.getPreferencesXml(this);
            pref.setPreferences();
            this.ips = in;
            this.uiManager = new UIManager(this);
            this.ipsr = new InputStreamReader(this.ips, this.getIsqlStatus(2));
            this.openWriter();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void callUIManagerToProcess() {
        this.uiManager.process(this.ipsr);
    }

    @Override
    public UIManager getUIManager() {
        return this.uiManager;
    }

    @Override
    public void openWriter() {
        try {
            BufferedWriter writer = null;
            String output = this.getIsqlStatus(3);
            String oenc = this.getIsqlStatus(4);
            if (output.equalsIgnoreCase("off")) {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, oenc));
            } else {
                FileOutputStream fops = new FileOutputStream(output);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fops, oenc));
            }
            this.bWrite = writer;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void output(String message) {
        try {
            if (this.bWrite != null) {
                this.bWrite.write(message);
                this.bWrite.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void closeWriter() {
        if (this.bWrite != null) {
            try {
                this.bWrite.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

