/*
 * Decompiled with CFR 0.152.
 */
package ui;

import controller.UIManager;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import ui.ConnectionStatus;
import ui.IsqlStatus;

public abstract class JsqlUI {
    public static final String STAND_PROMPT = "jsql> ";
    public static final String PROMPT1 = "> ";
    protected InputStream ips = null;
    protected IsqlStatus isqlStatus = new IsqlStatus();
    protected ArrayList<String> cmdLists = new ArrayList();
    protected ArrayList<ConnectionStatus> connectionsStatus = new ArrayList();
    protected int currentConnectionID = 0;

    public JsqlUI() {
        for (int i = 0; i <= 7; ++i) {
            this.connectionsStatus.add(i, new ConnectionStatus());
        }
        this.cmdLists.add("");
        this.currentConnectionID = 0;
    }

    public ArrayList<String> getCmdLists() {
        return this.cmdLists;
    }

    public void addCmdToHisLists(String cmd) {
        this.cmdLists.add(this.cmdLists.size() - 1, cmd);
    }

    public IsqlStatus getIsqlStatus() {
        return this.isqlStatus;
    }

    public void setIsqlStatus(int isqlKey, String value) {
        this.isqlStatus.setIsqlStatus(isqlKey, value);
    }

    public String getIsqlStatus(int isqlKey) {
        return this.isqlStatus.getIsqlStatus(isqlKey);
    }

    public int getCurrentConnectionID() {
        return this.currentConnectionID;
    }

    public void setCurrentConnectionID(int conID) {
        this.currentConnectionID = conID;
    }

    public ConnectionStatus getCurrentConnectionStatus() {
        return this.connectionsStatus.get(this.currentConnectionID);
    }

    public Connection getCurrentConnection() {
        return this.connectionsStatus.get(this.currentConnectionID).getConnection();
    }

    public void setCurrentConnection(Connection connection, String dbName, String userName, String password) {
        this.connectionsStatus.get(this.currentConnectionID).setConnection(connection, dbName, userName, password);
    }

    public String getCurrentDBName() {
        return this.connectionsStatus.get(this.currentConnectionID).getDBName();
    }

    public String getCurrentUserName() {
        return this.connectionsStatus.get(this.currentConnectionID).getUserName();
    }

    public void setCurrentConnectionStatus(int conKey, String conAttr) throws SQLException {
        this.connectionsStatus.get(this.currentConnectionID).setConnectionAttr(conKey, conAttr);
    }

    public String getCurrentConnectionStatus(int conKey) throws SQLException {
        return this.connectionsStatus.get(this.currentConnectionID).getConnectionAttr(conKey);
    }

    public boolean isCurrentConnectionConnected() {
        return this.connectionsStatus.get(this.currentConnectionID).isConnected();
    }

    public ArrayList<ConnectionStatus> getConnectionStatus() {
        return this.connectionsStatus;
    }

    public abstract void openWriter();

    public abstract void output(String var1);

    public abstract void closeWriter();

    public abstract void callUIManagerToProcess();

    public abstract UIManager getUIManager();
}

