/*
 * Decompiled with CFR 0.152.
 */
package ui;

public class IsqlStatus {
    public static final String[] LCODE = new String[]{"ASCII", "BIG5", "SHIFT-JIS", "GBK", "ISO-8859-1", "ISO-8859-2", "ISO-8859-5", "ISO-8859-7", "EUC-JP", "GB18030", "UTF-8"};
    public static final int ENV = 1;
    public static final int IENC = 2;
    public static final int PRINTTO = 3;
    public static final int OENC = 4;
    public static final int SHOW_TIME = 5;
    public static final int WORK_DIR = 6;
    public static final int LOGIN_TIMEOUT = 7;
    public static final int LINE_WIDTH = 8;
    public static final int BLOB_SHOW = 9;
    public static final int BLOB_PREF = 10;
    public static final int BLOB_WIDTH = 11;
    private String env = "on";
    private String ienc = System.getProperty("file.encoding");
    private String printto = "off";
    private String oenc = System.getProperty("file.encoding");
    private String showTime = "off";
    private String workDir = System.getProperty("user.dir");
    private String loginTimeout = "5";
    private String lineWidth = "80";
    private String blobShow = "print";
    private String blobPref = "bb_";
    private String blobWidth = "16";

    public void setIsqlStatus(int key, String value) {
        if (value == null) {
            return;
        }
        String msg = "Invalid value";
        switch (key) {
            case 1: {
                if (!this.checkEnv(value)) break;
                this.env = value;
                break;
            }
            case 2: {
                this.ienc = value;
                break;
            }
            case 3: {
                this.printto = value;
                break;
            }
            case 4: {
                this.oenc = value;
                break;
            }
            case 5: {
                this.showTime = value;
                break;
            }
            case 6: {
                this.workDir = value;
                break;
            }
            case 7: {
                this.loginTimeout = value;
                break;
            }
            case 8: {
                this.lineWidth = value;
                break;
            }
            case 9: {
                this.blobShow = value;
                break;
            }
            case 10: {
                this.blobPref = value;
                break;
            }
            case 11: {
                this.blobWidth = value;
            }
        }
    }

    public String getIsqlStatus(int isqlKey) {
        switch (isqlKey) {
            case 1: {
                return this.env;
            }
            case 2: {
                return this.ienc;
            }
            case 3: {
                return this.printto;
            }
            case 4: {
                return this.oenc;
            }
            case 5: {
                return this.showTime;
            }
            case 6: {
                return this.workDir;
            }
            case 7: {
                return this.loginTimeout;
            }
            case 8: {
                return this.lineWidth;
            }
            case 9: {
                return this.blobShow;
            }
            case 10: {
                return this.blobPref;
            }
            case 11: {
                return this.blobWidth;
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.blobShow.equalsIgnoreCase("size")) {
            buf.append(String.format("%20s", "Blob show").toUpperCase() + " : " + this.blobShow + "\n");
        } else if (this.blobShow.equalsIgnoreCase("file")) {
            buf.append(String.format("%20s", "Blob show").toUpperCase() + " : " + this.blobShow + "(pref=" + this.blobPref + ")\n");
        } else if (this.blobShow.equalsIgnoreCase("print")) {
            buf.append(String.format("%20s", "Blob show").toUpperCase() + " : " + this.blobShow + " (width=" + this.blobWidth + ")\n");
        }
        buf.append(String.format("%20s", "Get env").toUpperCase() + " : " + this.env + "\n");
        buf.append(String.format("%20s", "Line width").toUpperCase() + " : " + this.lineWidth + "\n");
        buf.append(String.format("%20s", "Print to").toUpperCase() + " : " + this.printto + "\n");
        buf.append(String.format("%20s", "Show time").toUpperCase() + " : " + this.showTime + "\n");
        buf.append(String.format("%20s", "Work dir").toUpperCase() + " : " + this.workDir + "\n");
        buf.append(String.format("%20s", "Login timeout").toUpperCase() + " : " + this.loginTimeout + "\n");
        buf.append(String.format("%20s", "Input encoding").toUpperCase() + " : " + this.ienc + "\n");
        buf.append(String.format("%20s", "Output encoding").toUpperCase() + " : " + this.oenc);
        return buf.toString();
    }

    private boolean checkEnv(String value) {
        if (value == null) {
            return false;
        }
        String tmp = value.toLowerCase();
        return tmp.equals("on") || tmp.equals("off");
    }
}

