/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.createDB;

import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.ColumnTableModel;
import dbaut.CommonUt.EmptyPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.String_array;
import dbaut.VersionManager;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.dbalib;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.winlib;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import svrmgrwizard.createDB.CreateDBDialog;

public class CreateDB_Finish
extends AbstractWizardPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.CreateDBRes", LocaleManager.getLocale());
    private String title = this.res.getString("Create_Database_finish");
    private CreateDBDialog dlg = null;
    private String DB_Idcap = null;
    private String DB_Usrfo = null;
    private String DB_TDEMD = null;
    private AbstractWizardPanel previous = null;
    private AbstractWizardPanel next = null;

    public CreateDB_Finish(CreateDBDialog dlg, AbstractWizardPanel previous) {
        try {
            this.dlg = dlg;
            this.previous = previous;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        int i;
        this.setName("FinishPanel");
        DbaButton back_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancel_Button_actionPerformed"));
        DbaButton finish_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Finish"), 'F', DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"), new ReflectionAction(this, "finish_Button_actionPerformed"));
        finish_Button.setName("FinishButton");
        SmHelpButton help_Button = new SmHelpButton();
        ColumnTableModel model = new ColumnTableModel(new String[]{this.res.getString("key"), this.res.getString("value")});
        JTable jtable = new JTable(model);
        JScrollPane jscroll = new JScrollPane(jtable);
        JPanel panel2 = new JPanel(new FlowLayout(2));
        JPanel panel8 = new JPanel(new BorderLayout());
        WizardTextArea textArea = new WizardTextArea(this.title, this.res.getString("Press_previous_button"));
        jtable.setEnabled(false);
        finish_Button.setHorizontalTextPosition(2);
        panel2.add(back_Button);
        panel2.add(finish_Button);
        panel2.add(new EmptyPanel());
        panel2.add(cancel_Button);
        panel2.add(help_Button);
        panel8.add((Component)jscroll, "Center");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/svrmgrimages/CreateDB.jpg"));
        this.setButtonBar(panel2);
        this.setTextArea(textArea);
        this.setContent(panel8);
        this.DB_Idcap = this.dlg.DB_Idcap == "1" ? this.res.getString("Enable") : this.res.getString("Disable");
        this.DB_Usrfo = this.dlg.DB_Usrfo == "1" ? this.res.getString("Enable") : this.res.getString("Disable");
        this.DB_TDEMD = this.dlg.DB_TDEMD == "1" ? this.res.getString("Enable") : this.res.getString("Disable");
        SmFrame.frame.enableDialogHelp(this, help_Button, "wizard_CreateDB_Finish", null);
        TableColumnModel tcmodel = jtable.getColumnModel();
        TableColumn col = tcmodel.getColumn(0);
        col.setPreferredWidth(120);
        col = tcmodel.getColumn(1);
        col.setPreferredWidth(280);
        model.addValue(new Object[]{this.res.getString("Database_name_in"), this.dlg.DBName});
        model.addValue(new Object[]{this.res.getString("Database_directory_"), this.dlg.DB_DBDir});
        if (this.dlg.multiuser) {
            model.addValue(new Object[]{this.res.getString("IP_address_Server"), this.dlg.DB_Svadr});
            model.addValue(new Object[]{this.res.getString("Server_port_number"), this.dlg.DB_PtNum});
        }
        if (this.dlg.DB_DBFil != null && this.dlg.DB_DBFil.length() > 0) {
            model.addValue(new Object[]{this.res.getString("System_data_file_name"), this.dlg.DB_DBFil});
        }
        if (this.dlg.DB_BBFil != null && this.dlg.DB_BBFil.length() > 0) {
            model.addValue(new Object[]{this.res.getString("System_BLOB_file_name"), this.dlg.DB_BBFil});
        }
        if (this.dlg.DB_usrDB != null) {
            model.addValue(new Object[]{this.res.getString("User_data_file_name"), this.dlg.DB_usrDB.getFilename()});
            model.addValue(new Object[]{this.res.getString("User_data_file_pages"), this.dlg.DB_usrDB.getPagenum()});
        }
        if (this.dlg.DB_usrBB != null) {
            model.addValue(new Object[]{this.res.getString("User_BLOB_file_name"), this.dlg.DB_usrBB.getFilename()});
            model.addValue(new Object[]{this.res.getString("User_BLOB_file_frames"), this.dlg.DB_usrBB.getPagenum()});
        }
        if (this.dlg.DB_ITTDIR != null) {
            for (i = 0; i < this.dlg.DB_ITTDIR.length; ++i) {
                if (this.dlg.DB_ITTDIR[i].length() <= 0) continue;
                model.addValue(new Object[]{this.res.getString("Temporary_file_name"), this.dlg.DB_ITTDIR[i]});
                break;
            }
            ++i;
            while (i < this.dlg.DB_ITTDIR.length) {
                if (this.dlg.DB_ITTDIR[i].length() > 0) {
                    model.addValue(new Object[]{"", this.dlg.DB_ITTDIR[i]});
                }
                ++i;
            }
        }
        if (this.dlg.DB_JNFil != null) {
            for (i = 0; i < this.dlg.DB_JNFil.length; ++i) {
                if (this.dlg.DB_JNFil[i].length() <= 0) continue;
                model.addValue(new Object[]{this.res.getString("System_journal_file_sysjnl"), this.dlg.DB_JNFil[i]});
                break;
            }
            ++i;
            while (i < this.dlg.DB_JNFil.length) {
                if (this.dlg.DB_JNFil[i].length() > 0) {
                    model.addValue(new Object[]{"", this.dlg.DB_JNFil[i]});
                }
                ++i;
            }
        }
        if (this.dlg.DB_JNLsz != null) {
            model.addValue(new Object[]{this.res.getString("Journal_file_size"), this.dlg.DB_JNLsz});
        }
        String[] langs = new String[]{"English_ASCII_", "Traditional_Chinese", "Japanese_Shift_JiS", "Simplified_Chinese_GB", "Latin_ISO_8859_1", "Latin_ISO_8859_2", "Cyrillic_ISO_8859_5", "Greek_ISO_8859_7", "EUC_JP", "GB18030", "UTF-8"};
        String langStr = this.res.getString(langs[this.dlg.DB_Lcode]);
        model.addValue(new Object[]{this.res.getString("Language_code_"), langStr});
        if (this.dlg.DB_Order != null && this.dlg.DB_Order.length() > 0) {
            model.addValue(new Object[]{this.res.getString("Order_definition_file"), this.dlg.DB_Order});
        } else {
            model.addValue(new Object[]{this.res.getString("Order_definition_file"), this.res.getString("None")});
        }
        model.addValue(new Object[]{this.res.getString("Convert_identifier_to"), this.DB_Idcap});
        if (this.dlg.DB_PGSIZ != null) {
            model.addValue(new Object[]{this.res.getString("page_size_KB"), this.dlg.DB_PGSIZ});
        }
        if (this.dlg.DB_Bfrsz != null) {
            model.addValue(new Object[]{this.res.getString("BLOB_frame_size_KB_"), this.dlg.DB_Bfrsz});
        }
        if (this.dlg.DB_Fodir != null && this.dlg.DB_Fodir.length() > 0) {
            model.addValue(new Object[]{this.res.getString("System_file_object"), this.dlg.DB_Fodir});
        }
        model.addValue(new Object[]{this.res.getString("Enable_user_file"), this.DB_Usrfo});
        model.addValue(new Object[]{this.res.getString("Encrypt_database"), this.DB_TDEMD});
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.dlg.Next(this.previous);
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.dlg.dispose();
    }

    private void writeConfig(JdmConfig config) {
        if (this.dlg.multiuser) {
            config.insertPara("DB_SVADR", this.dlg.DB_Svadr, 4096);
            config.insertPara("DB_PTNUM", this.dlg.DB_PtNum, 4096);
        }
        config.insertPara("DB_USRID", "SYSADM", 4096);
        this.dlg.DB_USRID = "SYSADM";
        if (this.dlg.DB_DBDir != null && this.dlg.DB_DBDir.length() > 0) {
            String dbdir = this.dlg.DB_DBDir;
            if (dbdir.indexOf(32) >= 0 && !dbdir.startsWith("\"") && !dbdir.endsWith("\"")) {
                dbdir = "\"" + dbdir + "\"";
            }
            this.dlg.DB_DBDir = dbdir;
            config.insertPara("DB_DBDIR", this.dlg.DB_DBDir, 4096);
        }
        if (this.dlg.DB_DBFil != null && this.dlg.DB_DBFil.length() > 0) {
            config.insertPara("DB_DBFIL", this.dlg.DB_DBFil, 4096);
        }
        if (this.dlg.DB_BBFil != null && this.dlg.DB_BBFil.length() > 0) {
            config.insertPara("DB_BBFIL", this.dlg.DB_BBFil, 4096);
        }
        if (this.dlg.DB_usrDB != null) {
            config.insertPara("DB_USRDB", this.dlg.DB_usrDB, 53760);
        }
        if (this.dlg.DB_usrBB != null) {
            config.insertPara("DB_USRBB", this.dlg.DB_usrBB, 53760);
        }
        if (this.dlg.DB_ITTDIR != null) {
            config.insertPara("DB_ITTDIR", new String_array(this.dlg.DB_ITTDIR), 53504);
        }
        if (this.dlg.DB_JNFil != null) {
            config.insertPara("DB_JNFIL", new String_array(this.dlg.DB_JNFil), 53504);
        }
        if (this.dlg.DB_JNLsz != null) {
            config.insertPara("DB_JNLSZ", this.dlg.DB_JNLsz, 4096);
        }
        if (this.dlg.DB_Lcode != null) {
            config.insertPara("DB_LCODE", this.dlg.DB_Lcode, 8192);
        }
        if (this.dlg.DB_Idcap != null) {
            config.insertPara("DB_IDCAP", this.dlg.DB_Idcap, 4096);
        }
        if (this.dlg.DB_Order != null && this.dlg.DB_Order.length() > 0) {
            config.insertPara("DB_ORDER", this.dlg.DB_Order, 4096);
        }
        if (this.dlg.DB_PGSIZ != null) {
            config.insertPara("DB_PGSIZ", this.dlg.DB_PGSIZ, 4096);
        }
        if (this.dlg.DB_Bfrsz != null) {
            config.insertPara("DB_BFRSZ", this.dlg.DB_Bfrsz, 4096);
        }
        if (this.dlg.DB_Fodir != null && this.dlg.DB_Fodir.length() > 0 && !this.dlg.DB_Fodir.equals(this.dlg.DB_DBDir + System.getProperty("file.separator") + "fo")) {
            String fodir = this.dlg.DB_Fodir;
            if (fodir.indexOf(32) >= 0 && !fodir.startsWith("\"") && !fodir.endsWith("\"")) {
                fodir = "\"" + fodir + "\"";
            }
            this.dlg.DB_Fodir = fodir;
            config.insertPara("DB_FODIR", this.dlg.DB_Fodir, 4096);
        }
        if (this.dlg.DB_Usrfo != null) {
            config.insertPara("DB_USRFO", this.dlg.DB_Usrfo, 4096);
        }
        if (this.dlg.DB_TMPDIR != null && this.dlg.DB_TMPDIR.length() > 0) {
            String tmpdir = this.dlg.DB_TMPDIR;
            if (tmpdir.indexOf(32) >= 0 && !tmpdir.startsWith("\"") && !tmpdir.endsWith("\"")) {
                tmpdir = "\"" + tmpdir + "\"";
            }
            this.dlg.DB_TMPDIR = tmpdir;
            config.insertPara("DB_TMPDIR", this.dlg.DB_TMPDIR, 4096);
        }
        config.insertPara("DB_TDEMD", this.dlg.DB_TDEMD, 4096);
        if (SmFrame.frame.isWindows()) {
            dbalib dlib = new dbalib();
            String driverPath = this.getDriverPath(dlib);
            winlib lib = new winlib();
            lib.setRegistryKeys(this.dlg.DBName, this.dlg.DB_DBDir, this.dlg.DB_Svadr, this.dlg.DB_PtNum, driverPath);
        }
    }

    private String getDriverPath(dbalib lib) {
        String result = "";
        int LEN_FNAME = 256;
        byte[] b = new byte[256];
        int rc2 = lib.utInstDir(b);
        if (rc2 == 0) {
            String instdir = new String(b).trim();
            String fileseparator = System.getProperty("file.separator");
            String version = VersionManager.getVersion().trim().replace(".", "");
            result = instdir + "bin" + fileseparator + "DMAPI" + version + ".DLL";
        }
        return result;
    }

    public void finish_Button_actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dlg.finish = true;
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", this.dlg.DBName, "r+");
        if (rc == 0) {
            int reply = GuiUt.showOption3Dlg(this.dlg, this.res.getString("Create_db_error_title"), this.res.getString("Database") + " " + this.dlg.DBName + " " + this.res.getString("Create_new_section_in_dmconfig_file") + " " + this.res.getString("is_already_in_dmconfig"));
            if (reply == 0) {
                rc = config.procDelete("", 0);
                if (rc != 0) {
                    System.out.println("procDelete return error " + rc);
                }
                if ((rc = config.fileClose()) != 0) {
                    System.out.println("fail to close dmconfig " + rc);
                }
                if ((rc = config.create("dmconfig.ini", this.dlg.DBName)) != 0) {
                    System.out.println("failt to create section " + this.dlg.DBName);
                }
                if ((rc = config.fileOpen("dmconfig.ini", this.dlg.DBName, "r+")) != 0) {
                    System.out.println("fail to open dmconfig file for " + this.dlg.DBName);
                }
                this.writeConfig(config);
                config.fileClose();
            } else if (reply == 1) {
                config.fileClose();
                this.setCursor(Cursor.getPredefinedCursor(3));
            } else if (reply == 2) {
                config.fileClose();
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
        } else {
            config.create("dmconfig.ini", this.dlg.DBName);
            rc = config.fileOpen("dmconfig.ini", this.dlg.DBName, "r+");
            this.writeConfig(config);
            config.fileClose();
        }
        DatabaseConnection connection = new DatabaseConnection(this.dlg.DBName, this.dlg.DB_USRID, "", this.dlg, true);
        if (connection == null || !connection.result) {
            rc = config.fileOpen("dmconfig.ini", this.dlg.DBName, "r+");
            config.procDelete("", 0);
            config.fileClose();
            GuiUt.showErrorDlg(this.dlg, this.res.getString("can't_create_or_connect_database") + " " + this.dlg.DBName, null);
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        connection.disconnect();
        connection = null;
        this.setCursor(Cursor.getDefaultCursor());
        GuiUt.showInformationDlg(this.dlg, this.res.getString("Create_Database1"));
        this.dlg.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

