/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.backup;

import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.DbaObject;
import dbaut.DbaUtDef;
import dbaut.FullBackupFile;
import dbaut.GuiUt;
import dbaut.JBackupHistory;
import dbaut.JdmConfig;
import dbaut.String_array;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaTable;
import dbaut.comp.ProgressDialog;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.svrmgrlib;
import dbaut.system.BackupFile;
import dbaut.textField.FilePathField;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import svrmgrwizard.backup.BackupConstants;
import svrmgrwizard.backup.BackupDlg;
import svrmgrwizard.backup.DiffBackupTableModel;
import svrmgrwizard.backup.exception.CopyFileErrorException;
import svrmgrwizard.backup.exception.DeleteFileFailedException;
import svrmgrwizard.backup.exception.DiffFileErrorException;
import svrmgrwizard.backup.exception.UserCancelException;

public class OnlineDifferentialBackupPanel
extends AbstractWizardPanel {
    private static final long serialVersionUID = 5656557991829689903L;
    public static final short LOGICAL_NAME = 0;
    public static final short PHYSICAL_NAME = 1;
    public static final short BASE_NAME = 2;
    public static final short DESTINATION = 3;
    public static final short FILE_TYPE = 4;
    public static final short DATA_FILE = 0;
    public static final short JOURNAL_FILE = 1;
    private BackupDlg parentDialog = null;
    private AbstractWizardPanel previousPanel = null;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.BackupRes", LocaleManager.getLocale());
    private String title = null;
    private SmHelpButton helpButton = new SmHelpButton();
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton finishButton = new DbaButton(new Dimension(100, 24), this.res.getString("Finish"), 'F', DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"), new ReflectionAction(this, "finishButtonActionPerformed"));
    private DbaButton previousButton = new DbaButton(new Dimension(100, 24), this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "previousButtonActionPerformed"));
    private JLabel backupDestinationLabel = new JLabel(this.res.getString("Backup_Directory_Colon"));
    private FilePathField backupDestinationField = new FilePathField(this, "", this.res.getString("Select_Path"), true);
    private JRadioButton nonBackup = new JRadioButton(this.res.getString("Turn_Off_Backup_Mode"));
    private JRadioButton backupData = new JRadioButton(this.res.getString("Backup_Data"));
    private JRadioButton backupDataBlob = new JRadioButton(this.res.getString("Backup_Data_And_Blob"));
    private JCheckBox isWriteToConfig = new JCheckBox(this.res.getString("Write_To_Dmconfig"));
    private DiffBackupTableModel model = new DiffBackupTableModel();
    private DbaTable table = new DbaTable(this.model);
    private DatabaseConnection connection = null;
    private ArrayList connectionInfo = null;
    private String dbName = null;
    private String db_bkdir = null;
    private Integer db_bkzip = null;
    private int option = -1;
    private int bmode = -1;
    private ArrayList fullBackupItems = new ArrayList();
    private svrmgrlib lib = new svrmgrlib();

    public OnlineDifferentialBackupPanel(BackupDlg parentDialog, AbstractWizardPanel previousPanel, DatabaseConnection connection, ArrayList connectionInfo) {
        this.parentDialog = parentDialog;
        this.previousPanel = previousPanel;
        this.connection = connection;
        this.connectionInfo = connectionInfo;
        if (this.connectionInfo.size() <= 0) {
            System.out.println("No connection information." + this.getClass().getName());
            return;
        }
        this.dbName = (String)this.connectionInfo.get(0);
        this.db_bkzip = (Integer)this.connectionInfo.get(3);
        try {
            this.init();
        }
        catch (SQLException e) {
            GuiUt.showErrorDlg(this.parentDialog, e.getMessage(), "");
        }
    }

    private void init() throws SQLException {
        JPanel jPanel1 = new JPanel();
        jPanel1.setPreferredSize(new Dimension(640, 440));
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        jPanel1.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        JPanel destinationPanel = new JPanel(new FlowLayout(0));
        destinationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Destination"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.backupDestinationField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.backupDestinationField.setPreferredSize(new Dimension(440, 24));
        this.backupDestinationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OnlineDifferentialBackupPanel.this.backupDestinationFieldKeyReleased();
            }
        });
        destinationPanel.add(this.backupDestinationLabel);
        destinationPanel.add(this.backupDestinationField);
        JPanel backupModePanel = new JPanel(new BorderLayout());
        backupModePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Backup_Mode"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JPanel tmpPanel = new JPanel(new FlowLayout(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.nonBackup);
        bg.add(this.backupData);
        bg.add(this.backupDataBlob);
        tmpPanel.add(this.nonBackup);
        tmpPanel.add(this.backupData);
        tmpPanel.add(this.backupDataBlob);
        backupModePanel.add((Component)tmpPanel, "Center");
        this.isWriteToConfig.setSelected(true);
        backupModePanel.add((Component)this.isWriteToConfig, "East");
        topPanel.add(destinationPanel);
        topPanel.add(backupModePanel);
        JPanel tableContentsPanel = new JPanel(new BorderLayout());
        tableContentsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Backup_Contents"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JScrollPane tableContentsScrollPane = new JScrollPane();
        tableContentsScrollPane.setBorder(BorderFactory.createEtchedBorder());
        tableContentsScrollPane.getViewport().add(this.table);
        tableContentsPanel.add(tableContentsScrollPane);
        jPanel1.add((Component)topPanel, "North");
        jPanel1.add((Component)tableContentsPanel, "Center");
        this.add((Component)jPanel1, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.finishButton.setHorizontalTextPosition(2);
        this.cancelButton.setHorizontalTextPosition(2);
        SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Help_Backup_OnlineDifferentialBackupPanel", null);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(this.finishButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        this.setButtonBar(buttonPanel);
        this.initBackupDir();
        this.initBackupMode();
        this.initColumnSizes(this.table);
        this.initTableContents();
    }

    private void backupDestinationFieldKeyReleased() {
        this.table.editingStopped(null);
        String current_bkdir = this.backupDestinationField.getText();
        if (!current_bkdir.equals(this.db_bkdir)) {
            String bk_file = null;
            for (int j = 0; j < this.model.getRowCount(); ++j) {
                bk_file = (String)this.model.getValueAt(j, 3);
                bk_file = this.replacePath(bk_file, this.db_bkdir, current_bkdir);
                this.model.setValueAt(bk_file, j, 3);
            }
            this.model.fireTableChanged(new TableModelEvent(this.model));
            this.db_bkdir = current_bkdir;
        }
    }

    private String replacePath(String filename, String origPath, String replacePath) {
        int i = filename.lastIndexOf(BackupConstants.FILE_SEPARATOR);
        String temp = filename.substring(0, i);
        if (temp.equals(origPath)) {
            return replacePath + filename.substring(i);
        }
        return filename;
    }

    private void initBackupDir() throws SQLException {
        this.db_bkdir = JdmConfig.getOnlineBackupDir(this.dbName, this.connection.dbconn);
        this.backupDestinationField.setText(this.db_bkdir);
    }

    private void initBackupMode() {
        try {
            this.bmode = ((JdbcOdbcConnection)this.connection.dbconn).getOptionInt(1120);
            if (this.bmode == 0) {
                this.nonBackup.setSelected(true);
            } else if (this.bmode == 1) {
                this.backupData.setSelected(true);
            } else {
                this.backupDataBlob.setSelected(true);
                this.backupData.setEnabled(false);
            }
        }
        catch (SQLException e) {
            GuiUt.showErrorDlg(this.parentDialog, e.getMessage(), "");
        }
    }

    public int getBackupMode() {
        int backupMode = -1;
        backupMode = this.nonBackup.isSelected() ? 0 : (this.backupData.isSelected() ? 1 : 2);
        return backupMode;
    }

    private void initTableContents() {
        this.parseOffBackupHisFile();
        this.getDmConfigBackupInfo("dmconfig.ini");
        this.getDataFileBackupInfo(this.db_bkzip);
        this.getJournalFileBackupInfo(this.dbName, this.db_bkzip);
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    private void getDmConfigBackupInfo(String fileName) {
        Object[] one_row = new Object[5];
        one_row[0] = "CONFIG";
        JdmConfig dmConfig = new JdmConfig();
        String dmConfigFilePath = dmConfig.filePath(fileName);
        one_row[1] = dmConfigFilePath;
        one_row[2] = "";
        String tmpFileName = this.getDiffBackupFileName(fileName);
        one_row[3] = this.db_bkdir + BackupConstants.FILE_SEPARATOR + tmpFileName;
        one_row[4] = new Short(0);
        this.model.addValue(one_row);
    }

    private String getDiffBackupFileName(String fileName) {
        long nowMillis = System.currentTimeMillis();
        fileName = "D" + nowMillis + "_" + fileName;
        return fileName;
    }

    private void getDataFileBackupInfo(int db_bkzip) {
        Statement stmt = null;
        try {
            stmt = this.connection.dbconn.createStatement();
            String query = "select FILE_NAME, GETFILENAME(FILE_NAME) from SYSTEM.SYSFILE where FILE_NAME != 'SYSJNL'";
            ResultSet rs = stmt.executeQuery(query);
            String logicalFile = null;
            String physicalFile = null;
            while (rs.next()) {
                Object[] one_row = new Object[5];
                logicalFile = rs.getString(1).trim();
                one_row[0] = rs.wasNull() ? "" : logicalFile;
                physicalFile = rs.getString(2).trim();
                String physical_name = rs.wasNull() ? "" : physicalFile;
                one_row[1] = physical_name;
                String baseFile = this.getBaseFile(logicalFile);
                one_row[2] = baseFile;
                int index = physical_name.lastIndexOf(BackupConstants.FILE_SEPARATOR);
                String physicalFileName = null;
                physicalFileName = index >= 0 ? physical_name.substring(index + 1) : physical_name;
                String tmpDes = this.db_bkdir + BackupConstants.FILE_SEPARATOR + this.getDiffBackupFileName(physicalFileName);
                String finalDes = null;
                finalDes = baseFile.length() == 0 ? tmpDes + ".dif2" : tmpDes + ".dif";
                one_row[3] = finalDes;
                one_row[4] = new Short(0);
                this.model.addValue(one_row);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this, null, sqle);
            DbaObject.close(stmt);
        }
    }

    private void parseOffBackupHisFile() {
        JBackupHistory his = new JBackupHistory(SmFrame.frame);
        String offBackupHisPath = this.db_bkdir + BackupConstants.FILE_SEPARATOR + "dmBackup.his";
        int rc = his.FileOpen(this.dbName, offBackupHisPath, "0");
        if (rc != 0) {
            System.out.println("Open backup history file " + offBackupHisPath + " failed: rc=" + rc + ".");
            return;
        }
        Vector fullBackupList = his.getFullBackupList();
        Vector fullBackupInfo = his.getFullBackupInfo(fullBackupList.size());
        for (int j = 0; j < fullBackupInfo.size(); ++j) {
            FullBackupFile fullBackupFile = (FullBackupFile)fullBackupInfo.get(j);
            this.fullBackupItems.add(fullBackupFile);
        }
        his.FileClose();
    }

    private String getBaseFile(String logicalFile) {
        String baseFile = "";
        for (int i = 0; i < this.fullBackupItems.size(); ++i) {
            FullBackupFile tmp = (FullBackupFile)this.fullBackupItems.get(i);
            String logicalName = tmp.getLogicalFile();
            if (!logicalName.equalsIgnoreCase(logicalFile)) continue;
            baseFile = tmp.getBackupFile();
            break;
        }
        return baseFile;
    }

    private void getJournalFileBackupInfo(String dbName, int db_bkzip) {
        String dbDir = JdmConfig.getDBDir(dbName);
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", dbName, "r");
        if (rc != 0) {
            return;
        }
        String_array files = (String_array)config.getPara("DB_JNFIL", 53504);
        config.fileClose();
        for (int i = 0; i < files.size(); ++i) {
            String str = files.content[i];
            if (str.length() == 0) continue;
            int g = str.lastIndexOf(BackupConstants.FILE_SEPARATOR);
            String filename = g >= 0 ? new String(str.substring(g + 1)) : str;
            Object[] one_row = new Object[5];
            one_row[0] = "SYSJNL";
            one_row[1] = g >= 0 ? str : dbDir + BackupConstants.FILE_SEPARATOR + filename;
            one_row[2] = "";
            String tmpDes = null;
            tmpDes = this.db_bkdir + BackupConstants.FILE_SEPARATOR + this.getDiffBackupFileName(filename);
            if (db_bkzip == 1) {
                tmpDes = tmpDes + ".gz";
            }
            one_row[3] = tmpDes;
            one_row[4] = new Short(1);
            this.model.addValue(one_row);
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(200);
        column = table.getColumnModel().getColumn(3);
        column.setPreferredWidth(300);
    }

    public void previousButtonActionPerformed(ActionEvent e) {
        this.parentDialog.next(this.previousPanel);
    }

    public void finishButtonActionPerformed(ActionEvent e) {
        try {
            if (!this.isFullBackupIntegrity()) {
                GuiUt.showErrorDlg(this.parentDialog, this.res.getString("You_Must_Do_Full_Backup_Before_Differential_Backup_FullStop"), "");
                return;
            }
        }
        catch (SQLException e1) {
            GuiUt.showErrorDlg(this.parentDialog, e1.getMessage(), "");
            return;
        }
        int rowCount = this.model.getRowCount();
        String fileFullPath = null;
        File tmpFile = null;
        long len = 0L;
        for (int i = 0; i < rowCount; ++i) {
            fileFullPath = (String)this.model.getValueAt(i, 1);
            tmpFile = new File(fileFullPath);
            len += tmpFile.length();
        }
        final long totalLen = len;
        Thread t1 = new Thread(){

            @Override
            public void run() {
                OnlineDifferentialBackupPanel.this.runBackupTask(totalLen);
            }
        };
        t1.start();
    }

    private boolean isFullBackupIntegrity() throws SQLException {
        File backupLogFile;
        String backupDir = JdmConfig.getOnlineBackupDir(this.dbName, this.connection.dbconn);
        File file = new File(backupDir);
        if (!file.exists()) {
            return false;
        }
        String absolutePath = file.getAbsolutePath();
        if (!absolutePath.endsWith(BackupConstants.FILE_SEPARATOR)) {
            absolutePath = absolutePath + BackupConstants.FILE_SEPARATOR;
        }
        if (!(backupLogFile = new File(absolutePath + "dmBackup.his")).exists()) {
            return false;
        }
        JBackupHistory hist = new JBackupHistory(SmFrame.frame);
        int rc = hist.FileOpen(this.dbName, backupLogFile.getAbsolutePath(), "0");
        if (rc != DbaUtDef.RTN_OK) {
            System.out.println("Error open backup history file " + backupLogFile.getAbsolutePath() + ". And err no = " + rc);
            return false;
        }
        Vector fullBackupList = hist.getFullBackupList();
        if (fullBackupList.size() < 1) {
            return false;
        }
        Vector fullBackupInfo = hist.getFullBackupInfo(fullBackupList.size());
        hist.FileClose();
        FullBackupFile bf = null;
        String s = null;
        File f = null;
        for (int i = 0; i < fullBackupInfo.size(); ++i) {
            bf = (FullBackupFile)fullBackupInfo.get(i);
            s = bf.getBackupFile();
            f = new File(s);
            if (f.exists()) continue;
            System.out.println(f.getAbsolutePath() + " is not exist.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBackupTask(long len) {
        String message;
        final ProgressDialog progressDialog = new ProgressDialog(this.parentDialog, this.res.getString("Online_Differential_Backup"));
        JBackupHistory hist = null;
        BackupFile bf = null;
        Statement stmt = null;
        try {
            this.table.editingStopped(null);
            String backupDir = this.backupDestinationField.getText().trim();
            File file = new File(backupDir);
            if (!file.exists()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        OnlineDifferentialBackupPanel.this.option = GuiUt.showOptionDlg(OnlineDifferentialBackupPanel.this.parentDialog, OnlineDifferentialBackupPanel.this.res.getString("Create_Directory"), OnlineDifferentialBackupPanel.this.res.getString("Do_You_Want_Create_Backup_Directory_QuestionMark"));
                    }
                });
                if (this.option == 0) {
                    boolean isMkDirsSuccessful = file.mkdirs();
                    if (!isMkDirsSuccessful) {
                        System.out.println("Create backup dir failed!");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GuiUt.showErrorDlg(OnlineDifferentialBackupPanel.this.parentDialog, OnlineDifferentialBackupPanel.this.res.getString("Create_Backup_Directory_Failed_FullStop"), "");
                            }
                        });
                        return;
                    }
                } else {
                    return;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressDialog.show();
                }
            });
            stmt = this.connection.dbconn.createStatement();
            stmt.execute("begin backup");
            int newBMode = this.getBackupMode();
            if (newBMode != this.bmode) {
                ((JdbcOdbcConnection)this.connection.dbconn).setOption(1120, newBMode);
            }
            bf = new BackupFile();
            String logical_name = null;
            String db_file = null;
            String baseFile = null;
            String dest_file = null;
            File tmpFile = null;
            long fileLen = -1L;
            long workLen = -1L;
            int rowCount = this.model.getRowCount();
            byte[] outMessageBytes = new byte[1024];
            boolean flag = false;
            for (int i = 0; i < rowCount; ++i) {
                logical_name = (String)this.model.getValueAt(i, 0);
                db_file = (String)this.model.getValueAt(i, 1);
                tmpFile = new File(db_file);
                fileLen = tmpFile.length();
                workLen += fileLen;
                baseFile = (String)this.model.getValueAt(i, 2);
                dest_file = (String)this.model.getValueAt(i, 3);
                if (logical_name.equalsIgnoreCase("SYSJNL") && !flag) {
                    stmt.execute("end backup datafile");
                    flag = true;
                }
                if (baseFile.length() == 0) {
                    boolean isSuccessful = bf.copyFile(db_file, dest_file);
                    if (!isSuccessful) {
                        throw new CopyFileErrorException();
                    }
                } else {
                    int rc1 = this.lib.utXdeltaEncode(baseFile, db_file, dest_file, outMessageBytes);
                    if (rc1 != 0) {
                        String mgs = new String(outMessageBytes).trim();
                        throw new DiffFileErrorException(mgs);
                    }
                }
                int percent = (int)((double)workLen / (double)len * 100.0);
                progressDialog.setProgressBarValue(percent);
                if (!progressDialog.isCanceling()) continue;
                ProgressDialog.sem.semaphoreWait();
                progressDialog.setIsCanceling(false);
                if (!progressDialog.isUserCanceled()) continue;
                throw new UserCancelException();
            }
            stmt.execute("end backup journal");
            hist = new JBackupHistory(SmFrame.frame);
            String offBackupHisFileFullPath = null;
            offBackupHisFileFullPath = backupDir.endsWith(BackupConstants.FILE_SEPARATOR) ? backupDir + "dmBackup.his" : backupDir + BackupConstants.FILE_SEPARATOR + "dmBackup.his";
            int rc = hist.FileOpen(this.dbName, offBackupHisFileFullPath, "1");
            if (rc != DbaUtDef.RTN_OK) {
                System.out.println("Error open backup history file " + offBackupHisFileFullPath + ". And err no = " + rc);
                throw new UserCancelException();
            }
            int isSetBackupDataSuccessful = -1;
            for (int i = 0; i < rowCount; ++i) {
                logical_name = (String)this.model.getValueAt(i, 0);
                db_file = (String)this.model.getValueAt(i, 1);
                dest_file = (String)this.model.getValueAt(i, 3);
                isSetBackupDataSuccessful = i == 0 ? hist.setBackupData(0, 4, db_file, logical_name, dest_file, 1) : (i == rowCount - 1 ? hist.setBackupData(0, 4, db_file, logical_name, dest_file, 2) : hist.setBackupData(0, 4, db_file, logical_name, dest_file, 0));
                if (isSetBackupDataSuccessful == 0) continue;
                throw new UserCancelException();
            }
            this.writeToDmConfig(newBMode);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressDialog.setVisible(false);
                    progressDialog.dispose();
                    GuiUt.showInformationDlg(OnlineDifferentialBackupPanel.this.parentDialog, OnlineDifferentialBackupPanel.this.res.getString("Backup_Successfully_FullStop"));
                    OnlineDifferentialBackupPanel.this.cancelButtonActionPerformed(null);
                }
            });
        }
        catch (UserCancelException ex1) {
            System.out.println("User canceled.");
            this.abortBackup(stmt);
            this.clean(progressDialog);
        }
        catch (CopyFileErrorException e) {
            System.out.println("Copy file error.");
            String copyFileErrorMessage = "";
            if (bf != null) {
                copyFileErrorMessage = bf.copyFileErrorMessage;
            }
            this.abortBackup(stmt);
            this.clean(progressDialog, copyFileErrorMessage);
        }
        catch (DiffFileErrorException e) {
            message = e.getMessage();
            System.out.println(message);
            this.abortBackup(stmt);
            this.clean(progressDialog, message);
        }
        catch (InterruptedException e) {
            System.out.println("Interrupted exception.");
            this.abortBackup(stmt);
            this.clean(progressDialog);
        }
        catch (InvocationTargetException e) {
            System.out.println("Invocation target exception.");
            this.abortBackup(stmt);
            this.clean(progressDialog);
        }
        catch (SQLException e) {
            message = e.getMessage();
            System.out.println(message);
            this.abortBackup(stmt);
            this.clean(progressDialog, message);
        }
        finally {
            if (hist != null) {
                hist.FileClose();
            }
        }
    }

    private void clean(final ProgressDialog progressDialog) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
                OnlineDifferentialBackupPanel.this.cancelButtonActionPerformed(null);
            }
        });
        try {
            this.cleanBackupFile();
        }
        catch (DeleteFileFailedException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void clean(final ProgressDialog progressDialog, final String str) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
                GuiUt.showErrorDlg(OnlineDifferentialBackupPanel.this.parentDialog, str, "");
            }
        });
        try {
            this.cleanBackupFile();
        }
        catch (DeleteFileFailedException e1) {
            System.out.println(e1.getMessage());
            e1.printStackTrace();
        }
    }

    private void abortBackup(Statement stmt) {
        try {
            stmt.execute("abort backup");
        }
        catch (SQLException e2) {
            System.out.println("About Backup execute exception.");
            e2.printStackTrace();
        }
    }

    private void writeToDmConfig(int newBMode) throws UserCancelException {
        int rcDmConfig = -1;
        if (this.isWriteToConfig.isSelected()) {
            JdmConfig dmconfig = new JdmConfig();
            rcDmConfig = dmconfig.fileOpen("dmconfig.ini", this.dbName, "r+");
            if (rcDmConfig != 0) {
                throw new UserCancelException();
            }
            rcDmConfig = dmconfig.insertPara("DB_BMODE", new Integer(newBMode), 8192);
            if (rcDmConfig != 0) {
                throw new UserCancelException();
            }
            rcDmConfig = dmconfig.fileClose();
            if (rcDmConfig != 0) {
                throw new UserCancelException();
            }
        }
    }

    private void cleanBackupFile() throws DeleteFileFailedException {
        String dest_file = null;
        File desFile = null;
        int rowCount = this.model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            dest_file = (String)this.model.getValueAt(i, 3);
            desFile = new File(dest_file);
            if (!desFile.exists() || desFile.delete()) continue;
            throw new DeleteFileFailedException(desFile.getAbsolutePath());
        }
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.parentDialog.setVisible(false);
        this.parentDialog.dispose();
    }

    @Override
    public void windowClosing() {
        this.cancelButtonActionPerformed(null);
    }

    @Override
    public String getTitle() {
        this.title = "Online_Differential_Backup";
        return this.title;
    }
}

