/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.backup;

import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import com.syscom.dm.svrmgr.sca.DefaultSvrmgrAuthority;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.textField.CharPasswordField;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import svrmgrwizard.backup.BackupDlg;
import svrmgrwizard.backup.SelectOfflineBackupTypePanel;
import svrmgrwizard.backup.SelectOnlineBackupTypePanel;

public class LoginDatabasePanel
extends AbstractWizardPanel {
    private static final long serialVersionUID = -6652062511895120837L;
    private BackupDlg parentDialog = null;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.BackupRes", LocaleManager.getLocale());
    private String title = null;
    private AbstractWizardPanel next = null;
    private SmHelpButton helpButton = new SmHelpButton();
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton nextButton = new DbaButton(new Dimension(100, 24), this.res.getString("Next"), 'N', DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"), new ReflectionAction(this, "nextButtonActionPerformed"));
    private DbaButton previousButton = new DbaButton(new Dimension(100, 24), this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "previousButtonActionPerformed"));
    private SteppedComboBox databaseNameComboBox = new SteppedComboBox();
    private CharField userNameField = new CharField(128, true);
    private CharPasswordField passwordField = new CharPasswordField(16, true);
    private JRadioButton onlineRadioButton = new JRadioButton(this.res.getString("Online_Backup"));
    private JRadioButton offlineRadioButton = new JRadioButton(this.res.getString("Offline_Backup"));
    public static final int DB_NAME = 0;
    public static final int USER_NAME = 1;
    public static final int PASSWORD = 2;
    public static final int IS_TERMINAL_SERVER = 3;
    public static final int IS_SERVER_ON = 4;
    public static final int SERVER_ADDRESS = 5;
    public static final int SERVER_PROTNUM = 6;
    public static final int DB_BKZIP = 7;

    public LoginDatabasePanel(BackupDlg parentDialog) {
        this.parentDialog = parentDialog;
        this.init();
    }

    private void init() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel jLabel1 = new JLabel();
        jLabel1.setBorder(BorderFactory.createLoweredBevelBorder());
        ImageIcon imgIcon = DBAImageResource.getResource(this.getClass(), "/svrmgrimages/BackupDBleft.gif");
        jLabel1.setIcon(imgIcon);
        JPanel jPanel1 = new JPanel();
        jPanel1.setPreferredSize(new Dimension(470, 440));
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        jPanel1.setLayout(new GridLayout(2, 1, 5, 5));
        JPanel databasePanel = new JPanel();
        databasePanel.setLayout((LayoutManager)new XYLayout());
        databasePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Database"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JLabel databaseNameLabel = new JLabel(this.res.getString("Database_Name_Colon"));
        JLabel userNameLabel = new JLabel(this.res.getString("User_Name_Colon"));
        JLabel passWdLabel = new JLabel(this.res.getString("Password_Colon"));
        databasePanel.add((Component)databaseNameLabel, new XYConstraints(10, 10, 150, 25));
        Vector<String> dataSource = JdmConfig.getDatabaseNames("dmconfig.ini", false, true);
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>(dataSource);
        comboModel.insertElementAt("", 0);
        this.databaseNameComboBox.setModel((ComboBoxModel)comboModel);
        this.databaseNameComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDatabasePanel.this.databaseNameComboBoxActionPerformed(e);
            }
        });
        this.databaseNameComboBox.setSelectedIndex(0);
        databasePanel.add((Component)this.databaseNameComboBox, new XYConstraints(150, 10, 200, 25));
        databasePanel.add((Component)userNameLabel, new XYConstraints(10, 45, 150, 25));
        databasePanel.add((Component)this.userNameField, new XYConstraints(150, 45, 200, 25));
        databasePanel.add((Component)passWdLabel, new XYConstraints(10, 80, 150, 25));
        databasePanel.add((Component)this.passwordField, new XYConstraints(150, 80, 200, 25));
        JPanel backupTypePanel = new JPanel();
        backupTypePanel.setLayout((LayoutManager)new XYLayout());
        backupTypePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Backup_Type"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        ButtonGroup backupTypeButtonGroup = new ButtonGroup();
        this.setName("LoginDatabasePanel");
        this.databaseNameComboBox.setName("DatabaseNameComboBox");
        this.userNameField.setName("UserNameField");
        this.passwordField.setName("PasswordField");
        this.onlineRadioButton.setName("OnlineRadioButton");
        this.offlineRadioButton.setName("OfflineRadioButton");
        this.nextButton.setName("NextButton");
        this.onlineRadioButton.setSelected(true);
        backupTypeButtonGroup.add(this.onlineRadioButton);
        backupTypeButtonGroup.add(this.offlineRadioButton);
        backupTypePanel.add((Component)this.onlineRadioButton, new XYConstraints(10, 10, 200, 25));
        backupTypePanel.add((Component)this.offlineRadioButton, new XYConstraints(10, 45, 200, 25));
        jPanel1.add(databasePanel);
        jPanel1.add(backupTypePanel);
        panel.add((Component)jLabel1, "West");
        panel.add((Component)jPanel1, "East");
        this.add((Component)panel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.nextButton.setHorizontalTextPosition(2);
        this.cancelButton.setHorizontalTextPosition(2);
        SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Help_Backup_LoginDatabasePanel", null);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        this.setButtonBar(buttonPanel);
        this.userNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    this.userNameFieldKeyReleased();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.userNameFieldKeyReleased();
            }

            private void userNameFieldKeyReleased() {
                if (LoginDatabasePanel.this.userNameField.getText() == null || LoginDatabasePanel.this.userNameField.getText().trim().length() == 0) {
                    LoginDatabasePanel.this.nextButton.setEnabled(false);
                } else {
                    String dbName = (String)LoginDatabasePanel.this.databaseNameComboBox.getSelectedItem();
                    if (dbName.trim() != null) {
                        LoginDatabasePanel.this.nextButton.setEnabled(true);
                    }
                }
            }
        });
    }

    public void nextButtonActionPerformed(ActionEvent e) {
        int backupType = this.getBackupType();
        if (backupType == 1) {
            String dbName = (String)this.databaseNameComboBox.getSelectedItem();
            String userName = this.userNameField.getText().trim();
            String passWord = new String(this.passwordField.getPassword());
            ArrayList<String> connectionInfo = new ArrayList<String>();
            connectionInfo.add(dbName);
            connectionInfo.add(userName);
            connectionInfo.add(passWord);
            DatabaseConnection connection = new DatabaseConnection(dbName, userName, passWord, this.parentDialog);
            if (connection == null || !connection.isConnected()) {
                System.out.println("Connection is not available.");
                return;
            }
            DefaultSvrmgrAuthority authority = new DefaultSvrmgrAuthority(connection);
            if (!authority.isAboveDba()) {
                authority.errorIsNotDBA(this.parentDialog);
                connection.disconnect();
                return;
            }
            this.next = new SelectOnlineBackupTypePanel(this.parentDialog, this, connection, connectionInfo);
        } else if (backupType == 2) {
            DatabaseConnection connection = null;
            String dbName = (String)this.databaseNameComboBox.getSelectedItem();
            String userName = this.userNameField.getText().trim();
            String passWord = new String(this.passwordField.getPassword());
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(dbName);
            info.add(userName);
            info.add(passWord);
            JdmConfig config = new JdmConfig();
            boolean isTerminalServer = config.isTerminalServer(dbName);
            boolean isServerOn = false;
            int rc = config.fileOpen("dmconfig.ini", dbName, "r");
            if (rc != 0) {
                System.out.println("can't open file dmconfig.ini");
                return;
            }
            String svr_address = (String)config.getPara("DB_SVADR", 4096);
            Integer svr_portnum = (Integer)config.getPara("DB_PTNUM", 8192);
            Integer db_bkzip = (Integer)config.getPara("DB_BKZIP", 8192);
            config.fileClose();
            if (!isTerminalServer) {
                try {
                    isServerOn = DatabaseConnection.isServerOn(dbName, userName, passWord);
                }
                catch (SQLException ex) {
                    GuiUt.showSQLException(this.parentDialog, null, ex);
                    return;
                }
                if (isServerOn) {
                    GuiUt.showErrorDlg(this.parentDialog, this.res.getString("Can_Not_Do_Offline_Backup_While_Server_Is_On_FullStop"), "");
                    return;
                }
                JdmConfig.setTerminalServer(true, dbName, null, null);
            }
            if ((connection = new DatabaseConnection(dbName, userName, passWord, this.parentDialog)) == null || !connection.result) {
                if (!isTerminalServer && !isServerOn) {
                    JdmConfig.setTerminalServer(false, dbName, svr_address, svr_portnum);
                }
                return;
            }
            DefaultSvrmgrAuthority authority = new DefaultSvrmgrAuthority(connection);
            if (!authority.isAboveDba()) {
                authority.errorIsNotDBA(this.parentDialog);
                connection.disconnect();
                connection = null;
                if (!isTerminalServer && !isServerOn) {
                    JdmConfig.setTerminalServer(false, dbName, svr_address, svr_portnum);
                }
                return;
            }
            if (connection.getFileVersion() < 3.6f) {
                GuiUt.showErrorDlg(this.parentDialog, this.res.getString("Database_File_Version_Is_Too_Old"), "");
                connection.disconnect();
                connection = null;
                if (!isTerminalServer && !isServerOn) {
                    JdmConfig.setTerminalServer(false, dbName, svr_address, svr_portnum);
                }
                return;
            }
            info.add(new Boolean(isTerminalServer));
            info.add(new Boolean(isServerOn));
            info.add(svr_address);
            info.add(svr_portnum);
            info.add(db_bkzip);
            this.next = new SelectOfflineBackupTypePanel(this.parentDialog, this, connection, info);
        } else {
            System.out.println("Unsupport backup type.");
            return;
        }
        this.parentDialog.next(this.next);
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        if (this.next instanceof SelectOfflineBackupTypePanel) {
            SelectOfflineBackupTypePanel p = (SelectOfflineBackupTypePanel)this.next;
            p.cancelButtonActionPerformed(null);
        } else if (this.next instanceof SelectOnlineBackupTypePanel) {
            SelectOnlineBackupTypePanel p = (SelectOnlineBackupTypePanel)this.next;
            p.cancelButtonActionPerformed(null);
        }
        this.next = null;
        this.parentDialog.dispose();
    }

    @Override
    public void windowClosing() {
        this.cancelButtonActionPerformed(null);
    }

    @Override
    public String getTitle() {
        this.title = "Login_Database";
        return this.title;
    }

    private int getBackupType() {
        int tmpBackupType = -1;
        if (this.onlineRadioButton.isSelected()) {
            tmpBackupType = 1;
        }
        if (this.offlineRadioButton.isSelected()) {
            tmpBackupType = 2;
        }
        return tmpBackupType;
    }

    private void databaseNameComboBoxActionPerformed(ActionEvent e) {
        if (this.databaseNameComboBox.getSelectedIndex() == 0) {
            this.setButtonStatus(false);
        } else {
            JdmConfig dmconfig;
            String defaultUserName = JdmConfig.getDefaultUser((String)this.databaseNameComboBox.getSelectedItem());
            if (defaultUserName == null) {
                this.userNameField.setText("");
            } else {
                this.userNameField.setText(defaultUserName);
            }
            this.setButtonStatus(true);
            String dbName = (String)this.databaseNameComboBox.getSelectedItem();
            if (dbName.trim() != null && !(dmconfig = new JdmConfig()).isLocalHost("dmconfig.ini", dbName)) {
                this.offlineRadioButton.setEnabled(false);
            }
        }
    }

    private void setButtonStatus(boolean b) {
        this.onlineRadioButton.setEnabled(b);
        this.offlineRadioButton.setEnabled(b);
        this.nextButton.setEnabled(b);
    }
}

