/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbatool.DbFrame;
import dbaut.editorPanel.SQLTextPane;
import dbaut.resource.DBAImageResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class SQLAutoCompletionTextPane
extends SQLTextPane {
    private static final long serialVersionUID = -3493121544217745611L;
    private String loginUser = null;
    private Connection connection = null;
    private JPopupMenu suggestions;
    private JList<IconTextItem> list;
    private DefaultListModel<IconTextItem> listModel;
    private DefaultListModel<IconTextItem> origListModel = null;
    private boolean isProgrammaticChange = false;
    private ArrayList<Owner> owners = new ArrayList();
    private ArrayList<Table> tables = new ArrayList();
    private ArrayList<Function> functions = new ArrayList();

    public SQLAutoCompletionTextPane() {
        this.connection = DbFrame.conn_DatabaseConnection.getDbConnection();
        this.loginUser = DbFrame.conn_DatabaseConnection.username;
        this.suggestions = new JPopupMenu();
        this.setupDatabaseConnection();
        this.setupEditor();
        this.setupPopup();
    }

    public void setupDatabaseConnection() {
        try {
            this.owners.clear();
            this.tables.clear();
            this.functions.clear();
            DatabaseMetaData dbmd = this.connection.getMetaData();
            ResultSet rs = dbmd.getColumns(null, null, null, null);
            Table lastTable = null;
            Owner lastOwner = null;
            while (rs.next()) {
                String owner = rs.getString(2).trim();
                String table = rs.getString(3).trim();
                String column = rs.getString(4).trim();
                if (lastTable == null || lastTable.name.compareToIgnoreCase(table) != 0) {
                    if (lastOwner == null || lastOwner.name.compareToIgnoreCase(owner) != 0) {
                        lastOwner = new Owner(owner);
                        this.owners.add(lastOwner);
                    }
                    lastTable = new Table(table);
                    lastOwner.add(lastTable);
                    if (owner.compareToIgnoreCase(this.loginUser) == 0) {
                        this.tables.add(lastTable);
                    }
                } else if (lastOwner == null || lastOwner.name.compareToIgnoreCase(owner) != 0) {
                    lastOwner = new Owner(owner);
                    this.owners.add(lastOwner);
                    lastTable = new Table(table);
                    lastOwner.add(lastTable);
                    this.tables.add(lastTable);
                }
                lastTable.add(new Column(column));
            }
            rs.close();
            Statement stmt = this.connection.createStatement();
            rs = stmt.executeQuery("select FUNC_NAME from SYSTEM.SYSUSERFUNC");
            String funcName = null;
            while (rs.next()) {
                funcName = rs.getString(1).trim();
                this.functions.add(new Function(funcName));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void performInsertion() {
        if (!this.list.isSelectionEmpty()) {
            IconTextItem selectedItem = this.list.getSelectedValue();
            String selectedValue = selectedItem.getText();
            int caretPos = this.getCaretPosition();
            String textUpToCaret = this.getText().replace("\r\n", "\n").substring(0, caretPos);
            char lastChar = textUpToCaret.charAt(textUpToCaret.length() - 1);
            if (lastChar == ',' || lastChar == '.' || lastChar == ' ' || lastChar == '\n' || lastChar == '\t') {
                this.replaceSelection(selectedValue);
            } else {
                String[] tokens = textUpToCaret.split("[,.\\n\\t\\s]+");
                String lastToken = tokens[tokens.length - 1];
                int lastTokenStart = textUpToCaret.lastIndexOf(lastToken);
                int lastTokenEnd = lastTokenStart + lastToken.length();
                try {
                    this.getDocument().remove(lastTokenStart, lastTokenEnd - lastTokenStart);
                    this.getDocument().insertString(lastTokenStart, selectedValue, null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            this.suggestions.setVisible(false);
            this.listModel.removeAllElements();
            this.requestFocus();
        }
    }

    private void setupEditor() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!SQLAutoCompletionTextPane.this.hasFocus()) {
                    return;
                }
                if (e.getKeyCode() == 10 && SQLAutoCompletionTextPane.this.suggestions.isShowing() && !SQLAutoCompletionTextPane.this.list.isSelectionEmpty()) {
                    SQLAutoCompletionTextPane.this.performInsertion();
                    e.consume();
                    return;
                }
                if (e.getKeyCode() == 40 && SQLAutoCompletionTextPane.this.suggestions.isShowing()) {
                    SQLAutoCompletionTextPane.this.list.requestFocus();
                    e.consume();
                    KeyEvent newEvent = new KeyEvent(SQLAutoCompletionTextPane.this.list, e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
                    SQLAutoCompletionTextPane.this.list.dispatchEvent(newEvent);
                    return;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!SQLAutoCompletionTextPane.this.hasFocus()) {
                    return;
                }
                int caretPos = SQLAutoCompletionTextPane.this.getCaretPosition();
                String text = SQLAutoCompletionTextPane.this.getText().replace("\r\n", "\n").substring(0, caretPos);
                List<String> tokens = SQLAutoCompletionTextPane.tokenize(text);
                if (tokens == null || tokens.size() == 0) {
                    return;
                }
                if (text.endsWith(".") || text.endsWith(" ") || text.endsWith(",")) {
                    SQLAutoCompletionTextPane.this.listModel.removeAllElements();
                }
                if (!SQLAutoCompletionTextPane.this.listModel.isEmpty()) {
                    if (text.endsWith(" ") || text.endsWith(",")) {
                        return;
                    }
                    if (!tokens.isEmpty()) {
                        String lastToken = tokens.get(tokens.size() - 1);
                        SQLAutoCompletionTextPane.this.filterSuggestions(lastToken);
                    }
                    if (!SQLAutoCompletionTextPane.this.listModel.isEmpty()) {
                        SQLAutoCompletionTextPane.this.displayPopup();
                        SQLAutoCompletionTextPane.this.grabFocus();
                    } else {
                        SQLAutoCompletionTextPane.this.suggestions.setVisible(false);
                    }
                    return;
                }
                SQLAutoCompletionTextPane.this.suggestions.setVisible(false);
                SQLAutoCompletionTextPane.this.listModel.removeAllElements();
                if (text.endsWith(" ") || text.endsWith(",")) {
                    String t = null;
                    for (int i = tokens.size() - 1; i >= 0; --i) {
                        t = tokens.get(i).toUpperCase();
                        if (t.equals("TABLE")) {
                            String beforeLastToken;
                            String string = beforeLastToken = tokens.size() > 1 ? tokens.get(tokens.size() - 2) : null;
                            if (beforeLastToken != null && beforeLastToken.compareToIgnoreCase("DROP") == 0) {
                                SQLAutoCompletionTextPane.this.showOwnerSuggestions();
                                SQLAutoCompletionTextPane.this.showTableSuggestions(SQLAutoCompletionTextPane.this.loginUser);
                            }
                        } else if (t.equals("BY")) {
                            String beforeLastToken;
                            String string = beforeLastToken = tokens.size() > 1 ? tokens.get(tokens.size() - 2) : null;
                            if (beforeLastToken != null && (beforeLastToken.compareToIgnoreCase("ORDER") == 0 || beforeLastToken.compareToIgnoreCase("GROUP") == 0)) {
                                SQLAutoCompletionTextPane.this.showOwnerSuggestions();
                                SQLAutoCompletionTextPane.this.showTableSuggestions(SQLAutoCompletionTextPane.this.loginUser);
                            }
                        } else if (t.equals("WHERE") || t.equals("AND") || t.equals("OR")) {
                            SQLAutoCompletionTextPane.this.showOwnerSuggestions();
                            SQLAutoCompletionTextPane.this.showTableSuggestions(SQLAutoCompletionTextPane.this.loginUser);
                            SQLAutoCompletionTextPane.this.showFunctionSuggestions();
                        } else if (t.equals("FROM")) {
                            SQLAutoCompletionTextPane.this.showOwnerSuggestions();
                            SQLAutoCompletionTextPane.this.showTableSuggestions(SQLAutoCompletionTextPane.this.loginUser);
                        } else {
                            if (!t.equals("SELECT")) continue;
                            SQLAutoCompletionTextPane.this.showOwnerSuggestions();
                            SQLAutoCompletionTextPane.this.showTableSuggestions(SQLAutoCompletionTextPane.this.loginUser);
                            SQLAutoCompletionTextPane.this.showFunctionSuggestions();
                        }
                        break;
                    }
                } else if (text.endsWith(".")) {
                    SQLAutoCompletionTextPane.this.handleDotCompletion(text, SQLAutoCompletionTextPane.this.showTableOnly(tokens));
                }
                SQLAutoCompletionTextPane.this.origListModel = null;
                if (!SQLAutoCompletionTextPane.this.suggestions.isVisible() && !SQLAutoCompletionTextPane.this.listModel.isEmpty()) {
                    SQLAutoCompletionTextPane.this.origListModel = SQLAutoCompletionTextPane.this.listModel;
                    if (!text.endsWith(" ") && !text.endsWith(",")) {
                        SQLAutoCompletionTextPane.this.displayPopup();
                    }
                    SQLAutoCompletionTextPane.this.grabFocus();
                }
            }

            private boolean isSelectContext(List<String> tokens) {
                for (int i = tokens.size() - 1; i >= 0; --i) {
                    if (tokens.get(i).compareToIgnoreCase("FROM") == 0) {
                        return false;
                    }
                    if (tokens.get(i).compareToIgnoreCase("WHERE") == 0) {
                        return false;
                    }
                    if (tokens.get(i).compareToIgnoreCase("SELECT") != 0) continue;
                    return true;
                }
                return false;
            }

            private boolean isFromContext(List<String> tokens) {
                for (int i = tokens.size() - 1; i >= 0; --i) {
                    if (tokens.get(i).compareToIgnoreCase("FROM") != 0) continue;
                    return true;
                }
                return false;
            }

            private boolean isOrderOrGroupBy(List<String> tokens) {
                Object t = null;
                for (int i = tokens.size() - 1; i >= 0; --i) {
                }
                return false;
            }

            private boolean isWhereContext(List<String> tokens) {
                String t = null;
                for (int i = tokens.size() - 1; i >= 0; --i) {
                    t = tokens.get(i);
                    if (t.compareToIgnoreCase("WHERE") != 0 && t.compareToIgnoreCase("AND") != 0 && t.compareToIgnoreCase("OR") != 0) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public boolean showTableOnly(List<String> tokens) {
        for (int i = tokens.size() - 1; i >= 0; --i) {
            String t = tokens.get(i).toUpperCase();
            if (t.equals("TABLE")) {
                return true;
            }
            if (t.equals("BY")) {
                return false;
            }
            if (t.equals("WHERE") || t.equals("AND") || t.equals("OR")) {
                return false;
            }
            if (t.equals("FROM")) {
                return true;
            }
            if (!t.equals("SELECT")) continue;
            return false;
        }
        return false;
    }

    public static List<String> tokenize(String text) {
        String[] lines;
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        boolean inDoubleQuotes = false;
        for (String line : lines = text.split("\n")) {
            if (line.trim().startsWith("--") && !inDoubleQuotes) continue;
            if (inDoubleQuotes) {
                currentLine.append("\n").append(line);
            } else {
                currentLine.setLength(0);
                currentLine.append(line);
            }
            String regex = "\"([^\"]*)\"|'((?:''|[^'])*)'|([^\\s.]+)|\\.";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(currentLine.toString());
            while (matcher.find()) {
                if (matcher.group(1) != null) {
                    tokens.add("\"" + matcher.group(1) + "\"");
                    inDoubleQuotes = false;
                    continue;
                }
                if (matcher.group(2) != null) {
                    tokens.add("'" + matcher.group(2).replace("''", "'") + "'");
                    continue;
                }
                if (matcher.group().startsWith("\"") && !matcher.group().endsWith("\"")) {
                    tokens.add(matcher.group());
                    inDoubleQuotes = true;
                    continue;
                }
                tokens.add(matcher.group());
            }
            if (inDoubleQuotes) continue;
            currentLine.setLength(0);
        }
        return tokens;
    }

    private void setupPopup() {
        this.listModel = new DefaultListModel();
        this.list = new JList<IconTextItem>(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IconListRenderer());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e)) {
                    SQLAutoCompletionTextPane.this.performInsertion();
                }
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SQLAutoCompletionTextPane.this.performInsertion();
                    e.consume();
                } else if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                    int selectedIndex = SQLAutoCompletionTextPane.this.list.getSelectedIndex();
                    if (e.getKeyCode() == 40) {
                        if (selectedIndex < SQLAutoCompletionTextPane.this.listModel.getSize() - 1) {
                            SQLAutoCompletionTextPane.this.list.setSelectedIndex(selectedIndex + 1);
                        }
                    } else if (e.getKeyCode() == 38 && selectedIndex > 0) {
                        SQLAutoCompletionTextPane.this.list.setSelectedIndex(selectedIndex - 1);
                    }
                    SQLAutoCompletionTextPane.this.list.ensureIndexIsVisible(SQLAutoCompletionTextPane.this.list.getSelectedIndex());
                    e.consume();
                }
            }
        });
        this.suggestions.add(new JScrollPane(this.list));
    }

    private void filterSuggestions(String str) {
        str = str.toUpperCase();
        DefaultListModel<IconTextItem> newModel = new DefaultListModel<IconTextItem>();
        if (this.origListModel != null) {
            this.listModel = this.origListModel;
        }
        for (int i = 0; i < this.listModel.size(); ++i) {
            IconTextItem item = this.listModel.get(i);
            if (!item.getText().toUpperCase().startsWith(str)) continue;
            newModel.addElement(item);
        }
        this.list.setModel(newModel);
        this.listModel = newModel;
    }

    private void showTableSuggestions(String name) {
        Owner owner = this.findOwnerByName(name);
        if (owner != null) {
            for (Table table : owner.tables) {
                this.listModel.addElement(table);
            }
        }
    }

    private void showOwnerSuggestions() {
        for (Owner owner : this.owners) {
            this.listModel.addElement(owner);
        }
    }

    private void showFunctionSuggestions() {
        for (Function function : this.functions) {
            this.listModel.addElement(function);
        }
    }

    private void handleDotCompletion(String text, boolean showTableOnly) {
        int lastDotIndex = text.lastIndexOf(".");
        String[] tokens = text.split("[,\\n\\t\\s]+");
        String context = tokens[tokens.length - 1];
        if (context.endsWith("..")) {
            return;
        }
        String[] parts = context.split("\\.");
        switch (parts.length) {
            case 1: {
                this.showTableSuggestions(parts[0]);
                if (showTableOnly) break;
                this.showColumnSuggestions(this.loginUser, parts[0]);
                break;
            }
            case 2: {
                if (showTableOnly) break;
                this.showColumnSuggestions(parts[0], parts[1]);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void showColumnSuggestions(String ownerName, String tableName) {
        Owner owner = this.findOwnerByName(ownerName);
        if (owner == null) {
            return;
        }
        Table table = owner.findTableByName(tableName);
        if (table == null) {
            return;
        }
        for (Column column : table.columns) {
            this.listModel.addElement(column);
        }
    }

    private Owner findOwnerByName(String name) {
        for (Owner owner : this.owners) {
            if (!owner.name.equalsIgnoreCase(name)) continue;
            return owner;
        }
        return null;
    }

    private void displayPopup() {
        try {
            FontMetrics metrics = this.list.getFontMetrics(this.list.getFont());
            int maxWidth = 0;
            for (int i = 0; i < this.listModel.size(); ++i) {
                IconTextItem item = this.listModel.get(i);
                int itemWidth = metrics.stringWidth(item.getText());
                if (itemWidth <= maxWidth) continue;
                maxWidth = itemWidth;
            }
            this.isProgrammaticChange = true;
            int caretPos = this.getCaretPosition();
            Rectangle caretCoords = this.modelToView(caretPos);
            this.suggestions.show(this, caretCoords.x, caretCoords.y + caretCoords.height);
            this.suggestions.setVisible(true);
            this.suggestions.validate();
            this.list.setSelectedIndex(0);
            this.isProgrammaticChange = false;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    class Owner
    extends IconTextItem {
        ArrayList<Table> tables;

        Owner(String name) {
            super(name);
            this.tables = new ArrayList();
        }

        void add(Table table) {
            this.tables.add(table);
        }

        Table findTableByName(String name) {
            for (Table table : this.tables) {
                if (!table.name.equalsIgnoreCase(name)) continue;
                return table;
            }
            return null;
        }

        @Override
        public Icon getIcon() {
            return DBAImageResource.getResource(this.getClass(), "/jdbaimages/user.gif");
        }
    }

    class Table
    extends IconTextItem {
        ArrayList<Column> columns;

        Table(String name) {
            super(name);
            this.columns = new ArrayList();
        }

        void add(Column column) {
            this.columns.add(column);
        }

        Column findColumnByName(String name) {
            for (Column column : this.columns) {
                if (!column.name.equalsIgnoreCase(name)) continue;
                return column;
            }
            return null;
        }

        @Override
        public Icon getIcon() {
            return DBAImageResource.getResource(this.getClass(), "/jdbaimages/table.gif");
        }
    }

    class Column
    extends IconTextItem {
        Column(String name) {
            super(name);
        }

        @Override
        public Icon getIcon() {
            return null;
        }
    }

    class Function
    extends IconTextItem {
        Function(String name) {
            super(name);
        }

        @Override
        public Icon getIcon() {
            return DBAImageResource.getResource(this.getClass(), "/jdbaimages/function.gif");
        }

        @Override
        public void setDisplayText(String text) {
            if (text.length() + 2 < 10) {
                StringBuilder paddedText = new StringBuilder(text + "()");
                while (paddedText.length() < 10) {
                    paddedText.append(" ");
                }
                this.displayText = paddedText.toString();
            } else {
                this.displayText = text.length() + 2 <= 40 ? text + "() " : text.substring(0, 38) + "()... ";
            }
        }

        @Override
        public String getText() {
            return this.name + "()";
        }
    }

    public class IconListRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof IconTextItem) {
                IconTextItem item = (IconTextItem)value;
                this.setIcon(item.getIcon());
                this.setText(item.getDisplayText());
            } else {
                this.setText(value.toString());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            } else {
                this.setBackground(Color.WHITE);
                this.setForeground(list.getForeground());
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    public abstract class IconTextItem {
        String name;
        String displayText;

        public IconTextItem(String name) {
            this.name = name;
            this.setDisplayText(name);
        }

        public abstract Icon getIcon();

        public String getText() {
            return this.name;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public void setDisplayText(String text) {
            if (text.length() < 10) {
                StringBuilder paddedText = new StringBuilder(text);
                while (paddedText.length() < 10) {
                    paddedText.append(" ");
                }
                this.displayText = paddedText.toString();
            } else {
                this.displayText = text.length() <= 40 ? text + " " : text.substring(0, 40) + "... ";
            }
        }
    }
}

