/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbatool.DbFrame;
import dbatool.Preferences.PreferencesXml;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaTable;
import dbaut.comp.DbaToggleButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.editorPanel.SQLTextPane;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.resource.HelpResourceBundle;
import dbaut.text.TextArea;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import queryAnalyzer.AsJsql;
import queryAnalyzer.AsOutputStream;
import queryAnalyzer.AsQueryPane;
import queryAnalyzer.AsSQLResultPane;
import queryAnalyzer.AsShowPlanPane;
import queryAnalyzer.AsTableModel;
import queryAnalyzer.QueryToolBar;
import queryAnalyzer.SQLAutoCompletionTextPane;
import queryAnalyzer.TabbedPanePopupMenu;
import tableCell.BlobEditor;
import tableCell.BlobEditorButton;
import tableCell.BlobEditorButtonInterface;
import tableCell.BlobEditorNoJAIButton;

public class QueryFrame
extends JPanel {
    private boolean isSQLAutoCompletion;
    private static final long serialVersionUID = -6893123559927482741L;
    public static QueryFrame frame = null;
    private JSplitPane containPane;
    private TabbedPanePopupMenu popupMenu;
    public PreferencesXml px;
    private String dbname;
    private String user;
    public DBAResourceBundle res;
    public boolean isWindows;
    public JTabbedPane tabbedPane;
    public SQLTextPane sqlTextArea;
    JScrollPane sqlScrollPane;
    DbaToggleButton showPlan;
    public DbaToggleButton useAutoCompletion;
    public SteppedComboBox historyComboBox;
    public JCheckBox asOneSqlCheckbox;
    public static HelpResourceBundle helpres = null;
    private JLabel messageLabel;
    private JLabel dbLabel;
    private JLabel queryTimeLabel;
    private JLabel rowPositionLabel;
    private JLabel systemTimeLabel;
    private JTextArea nonQueryTextArea;
    private String helpsetName;
    public QueryToolBar queryToolbar;
    static AsJsql asJSql = null;
    private Cursor wait_cursor;
    private Cursor defCursor;
    public HelpSet mainHS;
    public DefaultHelpBroker mainHB;
    public Point centerLocation;
    public Connection conn;
    public boolean isConnect;
    public boolean isLocalHost;
    public boolean isDBA;
    public boolean isResource;
    public String file_separator;
    public static String db_lcode = "ASCII";

    public QueryFrame() {
        this.isSQLAutoCompletion = DbFrame.frame.px.getAutoCompletion();
        this.containPane = new JSplitPane(0);
        this.popupMenu = null;
        this.px = DbFrame.frame.px;
        this.dbname = DbFrame.conn_DatabaseConnection.dbname;
        this.user = DbFrame.conn_DatabaseConnection.username;
        this.res = DBAResourceBundle.getDBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
        this.isWindows = true;
        this.tabbedPane = null;
        this.sqlTextArea = null;
        this.sqlScrollPane = null;
        this.showPlan = new DbaToggleButton(this.res.getString("Show_plan"), DBAImageResource.getResource(this.getClass(), "/images/dumpplan.png"), false);
        this.useAutoCompletion = new DbaToggleButton(this.res.getString("Auto completion"), DBAImageResource.getResource(this.getClass(), "/images/autocomp.png"), false);
        this.historyComboBox = new SteppedComboBox((ComboBoxModel)new LimitedComboBoxModel(this.px.getNumHistoryCmd(), this.px.getHistory(this.dbname, this.user)));
        this.asOneSqlCheckbox = new JCheckBox(this.res.getString("Execute_as_one_SQL"));
        this.messageLabel = new JLabel();
        this.dbLabel = new JLabel();
        this.queryTimeLabel = new JLabel();
        this.rowPositionLabel = new JLabel();
        this.systemTimeLabel = new JLabel();
        this.nonQueryTextArea = new TextArea();
        this.helpsetName = "JSQL.hs";
        this.queryToolbar = new QueryToolBar();
        this.wait_cursor = new Cursor(3);
        this.defCursor = new Cursor(0);
        this.mainHS = null;
        this.mainHB = null;
        this.centerLocation = null;
        this.conn = null;
        this.isConnect = false;
        this.isLocalHost = true;
        this.isDBA = true;
        this.isResource = true;
        this.file_separator = System.getProperty("file.separator");
        this.conn = DbFrame.conn_DatabaseConnection.getDbConnection();
        frame = this;
        JPanel upPane = new JPanel(new BorderLayout());
        JPanel downPane = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane(3);
        this.useAutoCompletion.setSelected(this.isSQLAutoCompletion);
        this.sqlTextArea = this.useAutoCompletion.isSelected() ? new SQLAutoCompletionTextPane() : new SQLTextPane();
        this.sqlScrollPane = new JScrollPane(this.sqlTextArea);
        this.nonQueryTextArea.setEditable(false);
        AsSQLResultPane nonQueryScrollPane = new AsSQLResultPane(this.nonQueryTextArea);
        this.sqlScrollPane.setPreferredSize(new Dimension(200, 100));
        this.tabbedPane.setTabLayoutPolicy(1);
        this.initHelpSet(true);
        this.queryToolbar.setOrientation(0);
        this.historyComboBox.setBackground(Color.white);
        this.historyComboBox.setPreferredSize(new Dimension(440, 23));
        this.asOneSqlCheckbox.setToolTipText(this.res.getString("Execute_as_one_SQL_tooltip"));
        JPanel toolbarPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.showPlan.addActionListener(new ReflectionAction(this, "executionPlan_checkBox_action"));
        this.useAutoCompletion.addActionListener(new ReflectionAction(this, "autoCompletion_action"));
        this.queryToolbar.add(this.showPlan);
        toolbarPanel.add(this.queryToolbar);
        toolbarPanel.add(new JLabel("        "));
        toolbarPanel.add(this.historyComboBox);
        toolbarPanel.add(this.asOneSqlCheckbox);
        toolbarPanel.add(new JLabel("        "));
        this.showPlan.setSelected(false);
        this.tabbedPane.add(this.res.getString("SQL_Result"), nonQueryScrollPane);
        ImageIcon icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/session.gif");
        this.tabbedPane.setIconAt(this.tabbedPane.getTabCount() - 1, icon);
        upPane.add((Component)toolbarPanel, "North");
        upPane.add((Component)this.sqlScrollPane, "Center");
        downPane.add((Component)this.tabbedPane, "Center");
        this.containPane.add((Component)upPane, "top");
        this.containPane.add((Component)downPane, "bottom");
        if (this.px.getDividerLocation() != 0) {
            this.containPane.setDividerLocation(this.px.getDividerLocation());
        }
        this.containPane.setDividerSize(5);
        this.setLayout(new BorderLayout());
        this.add((Component)this.containPane, "Center");
        this.isWindows = this.isWindows();
        this.historyComboBox.addActionListener(new ReflectionAction(this, "historyComboBox_actionPerformed"));
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                QueryFrame.this.tabbedPane.getSelectedComponent().requestFocus();
                Component focusComp = QueryFrame.this.tabbedPane.getSelectedComponent();
                if (me.getModifiers() == 4) {
                    Point p = me.getPoint();
                    int count = QueryFrame.this.tabbedPane.getTabCount();
                    QueryFrame.this.popupMenu = new TabbedPanePopupMenu(p, count, focusComp);
                }
                if (me.getModifiers() == 16 && QueryFrame.this.popupMenu != null) {
                    QueryFrame.this.popupMenu.setVisible(false);
                    QueryFrame.this.popupMenu = null;
                }
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                QueryFrame.this.tabbed_actionPerformed(e);
            }
        });
        this.nonQueryTextArea.setFont(new Font("MonoSpaced", 0, 12));
        this.queryToolbar.undoButton.setEnabled(this.sqlTextArea.canUndo());
        this.queryToolbar.redoButton.setEnabled(this.sqlTextArea.canRedo());
        this.initSqlTextArea();
    }

    private void initSqlTextArea() {
        this.sqlTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    QueryFrame.this.sqlTextPane_keyRelease(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                QueryFrame.this.sqlTextPane_keyRelease(e);
            }
        });
        this.sqlTextArea.getDocument().addDocumentListener(new DocumentListener(){

            private void updateUndoRedoButtonStatue() {
                QueryFrame.this.queryToolbar.undoButton.setEnabled(QueryFrame.this.sqlTextArea.canUndo());
                QueryFrame.this.queryToolbar.redoButton.setEnabled(QueryFrame.this.sqlTextArea.canRedo());
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                this.updateUndoRedoButtonStatue();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                this.updateUndoRedoButtonStatue();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                this.updateUndoRedoButtonStatue();
            }
        });
        this.sqlTextArea.setFont(new Font("SansSerif", 0, 14));
        final JPopupMenu pop = new JPopupMenu();
        JMenuItem execute = new JMenuItem("Execute");
        execute.addActionListener(new ReflectionAction(this, "runCommandButton_actionPerformed"));
        execute.setAccelerator(KeyStroke.getKeyStroke(123, 0));
        pop.add(execute);
        this.sqlTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                if (QueryFrame.this.isPopupTrigger(ev)) {
                    pop.show(ev.getComponent(), ev.getX(), ev.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (QueryFrame.this.isPopupTrigger(ev)) {
                    pop.show(ev.getComponent(), ev.getX(), ev.getY());
                }
            }
        });
    }

    private boolean isPopupTrigger(MouseEvent ev) {
        if (!ev.isPopupTrigger()) {
            return false;
        }
        SQLTextPane textComp = this.sqlTextArea;
        int textAreaMouseXLocation = ev.getX();
        int textAreaMouseYLocation = ev.getY();
        boolean isSelected = false;
        if (((JTextComponent)textComp).getText().isEmpty()) {
            return false;
        }
        if (textComp.getSelectedText() == null) {
            return false;
        }
        Point pt = new Point(textAreaMouseXLocation, textAreaMouseYLocation);
        int pos = textComp.viewToModel(pt);
        int start = textComp.getSelectionStart();
        int end = textComp.getSelectionEnd();
        if (pos >= start && pos < end) {
            isSelected = true;
        }
        return isSelected;
    }

    public void runCommandButton_actionPerformed(ActionEvent e) {
        if (this.sqlTextArea.getSelectedText() == null) {
            return;
        }
        this.ExecuteCommand();
    }

    public void enableHelpKey(Component comp, String id) {
        if (this.mainHB == null) {
            return;
        }
        this.mainHB.enableHelpKey(comp, id, null);
    }

    public void setHelpID(Component comp, String id) {
        if (this.mainHB == null || helpres == null) {
            return;
        }
        String mapped = helpres.getString(id);
        CSH.setHelpIDString((Component)comp, (String)mapped);
    }

    public void enableDialogHelp(Component comp, JButton button, String id, HelpSet hs) {
        if (this.mainHB == null) {
            return;
        }
        String helpid2 = helpres.getString(id);
        if (comp != null) {
            this.mainHB.enableHelpKey(comp, helpid2, hs);
        }
        if (button != null) {
            this.mainHB.enableHelpOnButton((Component)button, helpid2, hs);
        }
    }

    private static String getHelpSetName() {
        String s = "JSQL.hs";
        switch (LocaleManager.getHelpFileLanguage()) {
            default: 
        }
        s = "JSQL.hs";
        return s;
    }

    private void initHelpSet(boolean first) {
        try {
            this.mainHS = null;
            this.mainHB = null;
            helpres = DbFrame.helpres;
            ClassLoader cl = QueryFrame.class.getClassLoader();
            this.helpsetName = QueryFrame.getHelpSetName();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)this.helpsetName);
            this.mainHS = new HelpSet(cl, url);
            this.mainHB = (DefaultHelpBroker)this.mainHS.createHelpBroker();
            this.mainHB.enableHelpKey((Component)this.getRootPane(), helpres.getString("home"), null);
        }
        catch (Exception ex) {
            System.out.println("Help Set " + this.helpsetName + this.res.getString("not_found"));
        }
        catch (ExceptionInInitializerError ex) {
            System.err.println(this.res.getString("initialization_error_"));
        }
    }

    public int getDividerLocation() {
        return this.containPane.getDividerLocation();
    }

    private String getDBLCode(Connection dbconn) throws SQLException {
        Statement stmt2 = dbconn.createStatement();
        ResultSet rs2 = stmt2.executeQuery("select value from sysconfig where keyword = 'DB_LCODE'");
        if (rs2.next()) {
            String tmp = rs2.getString(1);
            if (rs2.wasNull()) {
                return db_lcode;
            }
            tmp = tmp.trim();
            int value = Integer.valueOf(tmp);
            String[] languages = new String[]{"ASCII", "BIG5", "Shift_JiS", "GB2312", "ISO-8859-1", "ISO-8859-2", "ISO-8859-5", "ISO-8859-7", "EUC_JP", "GB18030", "UTF-8"};
            db_lcode = languages[value];
        }
        rs2.close();
        stmt2.close();
        return db_lcode;
    }

    public void ExecuteCommand() {
        this.mySetCursor(true);
        try {
            this.getDBLCode(this.conn);
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        String s = this.sqlTextArea.getText().trim();
        if (s.length() == 0) {
            GuiUt.showErrorDlg(DbFrame.frame, this.res.getString("No_SQL_command_"), "");
            this.mySetCursor(false);
            return;
        }
        this.clearResultPane();
        this.messageLabel.setText(this.res.getString("In_Process"));
        String sqlStatement = this.sqlTextArea.getSelectedText();
        if (sqlStatement == null) {
            sqlStatement = this.sqlTextArea.getText();
        }
        if (sqlStatement.equalsIgnoreCase("")) {
            return;
        }
        try {
            this.nonQueryTextArea.setText("");
            if (this.asOneSqlCheckbox.isSelected()) {
                asJSql = new AsJsql(this.nonQueryTextArea.getFontMetrics(this.nonQueryTextArea.getFont()), sqlStatement, (Writer)new AsOutputStream(this.nonQueryTextArea), "UTF8", this.conn);
            } else {
                ByteArrayInputStream in = new ByteArrayInputStream(sqlStatement.getBytes("UTF8"));
                asJSql = new AsJsql(this.nonQueryTextArea.getFontMetrics(this.nonQueryTextArea.getFont()), new InputStreamReader((InputStream)in, "UTF8"), (Writer)new AsOutputStream(this.nonQueryTextArea), "UTF8", this.conn);
            }
            asJSql.displayTime(QueryFrame.asJSql.totalTime);
            this.convertHistory(QueryFrame.asJSql.validStatement.keySet());
            try {
                if (this.conn != null) {
                    if (!this.conn.isClosed()) {
                        this.queryToolbar.runCommandButton.setEnabled(true);
                        this.queryToolbar.loadCommandButton.setEnabled(true);
                        this.queryToolbar.saveCommandButton.setEnabled(true);
                        this.queryToolbar.clearCommandButton.setEnabled(true);
                        QueryFrame.frame.sqlTextArea.setEnabled(true);
                    } else {
                        this.queryToolbar.runCommandButton.setEnabled(false);
                        this.queryToolbar.loadCommandButton.setEnabled(false);
                        this.queryToolbar.saveCommandButton.setEnabled(false);
                        this.queryToolbar.clearCommandButton.setEnabled(false);
                        QueryFrame.frame.sqlTextArea.setEnabled(false);
                        this.rowPositionLabel.setText("");
                        this.sqlTextArea.setText("");
                        this.nonQueryTextArea.setText("");
                        this.historyComboBox.removeAllItems();
                        this.queryTimeLabel.setText("");
                    }
                    this.messageLabel.setText(this.res.getString("Process_done"));
                } else {
                    this.messageLabel.setText(this.res.getString("No_connection"));
                    this.queryToolbar.runCommandButton.setEnabled(false);
                    this.queryToolbar.loadCommandButton.setEnabled(false);
                    this.queryToolbar.saveCommandButton.setEnabled(false);
                    this.queryToolbar.clearCommandButton.setEnabled(false);
                    QueryFrame.frame.sqlTextArea.setEnabled(false);
                    this.sqlTextArea.setText("");
                    this.nonQueryTextArea.setText("");
                    this.historyComboBox.removeAllItems();
                    this.rowPositionLabel.setText("");
                    this.queryTimeLabel.setText("");
                }
                if ((this.showPlan.isSelected() || QueryFrame.frame.px.getDisplayTableModel()) && this.conn != null) {
                    Map<String, AsJsql.Command> map = QueryFrame.asJSql.validStatement;
                    int i = 0;
                    for (Map.Entry<String, AsJsql.Command> entry : map.entrySet()) {
                        ++i;
                        AsJsql.Command cmd = entry.getValue();
                        if (cmd.type != AsJsql.SQLTYPE.OTHER && this.showPlan.isSelected()) {
                            this.ExecuteSqlForExecutionPlan(cmd.sql, cmd.json, i);
                            continue;
                        }
                        if (cmd.type != AsJsql.SQLTYPE.SELECT) continue;
                        this.ExecuteSql(cmd.sql, cmd.tbname);
                    }
                }
            }
            catch (Exception e1) {
                this.mySetCursor(false);
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            this.mySetCursor(false);
            e.printStackTrace();
            this.messageLabel.setText(this.res.getString("Process_fail"));
        }
        this.mySetCursor(false);
        this.setSelectedComponent();
    }

    private void setSelectedComponent() {
        if (asJSql.getErrorFound()) {
            this.tabbedPane.setSelectedComponent(this.tabbedPane.getComponentAt(0));
        } else {
            AsQueryPane theOne = null;
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                Component component = this.tabbedPane.getComponentAt(i);
                if (!(component instanceof AsQueryPane)) continue;
                theOne = (AsQueryPane)component;
                break;
            }
            if (theOne != null) {
                this.tabbedPane.setSelectedComponent(theOne);
            }
        }
    }

    private void ExecuteSqlForExecutionPlan(String sqlStatement, String json, int index) {
        this.tabbedPane.add(this.res.getString("plan") + index, new AsShowPlanPane(sqlStatement, json));
        ImageIcon icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/single_table.gif");
        this.tabbedPane.setIconAt(this.tabbedPane.getTabCount() - 1, icon);
    }

    private void ExecuteSql(String sqlStatement, String tableName) throws SQLException {
        int dataSum = 0;
        int jump = 0;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement(1004, 1007);
            if (stmt == null) {
                System.out.println("error, this is happened in jsql QueryFrame.java->ExecuteSal..");
                return;
            }
            rs = stmt.executeQuery(sqlStatement);
            if (rs == null) {
                System.out.println("error,rs is null,this is happend in jsql QueryFrame.java->ExecuteSql.");
                return;
            }
            while (rs.next()) {
                ++dataSum;
            }
            rs.first();
            ResultSetMetaData meta = rs.getMetaData();
            ArrayList<String> nameRecord = new ArrayList<String>();
            ArrayList<String> dataTypeRecord = new ArrayList<String>();
            int numOfColumn = meta.getColumnCount();
            for (int i = 0; i < numOfColumn; ++i) {
                nameRecord.add(meta.getColumnName(i + 1));
                dataTypeRecord.add(meta.getColumnTypeName(i + 1));
            }
            AsTableModel tableModel = new AsTableModel(nameRecord, dataTypeRecord);
            DbaTable resultTable = new DbaTable(tableModel);
            resultTable.setAutoResizeMode(0);
            String ToolTipText = sqlStatement;
            jump = QueryFrame.frame.px.getNumRecord();
            int[] info = new int[]{jump, dataSum, 0};
            boolean[] enable = new boolean[]{false, false, dataSum >= jump, dataSum >= jump, true};
            AsQueryPane resultScrollPane = new AsQueryPane(stmt, rs, this.conn, info, enable, sqlStatement, tableModel, resultTable, nameRecord, dataTypeRecord);
            if (tableName.length() > 32) {
                tableName = tableName.substring(0, 31) + "...";
            }
            if (tableName.equals("")) {
                tableName = this.res.getString("Result");
            }
            this.tabbedPane.add(tableName, resultScrollPane);
            ImageIcon icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/single_table.gif");
            this.tabbedPane.setIconAt(this.tabbedPane.getTabCount() - 1, icon);
            this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, ToolTipText);
            for (int col = 0; col < numOfColumn; ++col) {
                if (!this.isBlobType(dataTypeRecord.get(col).toString())) continue;
                this.setUpBlobEditor(resultTable, tableModel, col);
            }
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (SQLException e) {
            this.mySetCursor(false);
            DbaObject.close(rs);
            DbaObject.close(stmt);
            throw e;
        }
    }

    public void executeBatch(File batchFile, File resultFile, String encode) {
        this.mySetCursor(true);
        this.messageLabel.setText(this.res.getString("Running_batch_file"));
        try {
            FileInputStream in = new FileInputStream(batchFile);
            InputStreamReader reader = null;
            reader = encode != null ? new InputStreamReader((InputStream)in, encode) : new InputStreamReader(in);
            OutputStreamWriter writer = null;
            if (resultFile != null) {
                writer = encode != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(resultFile), encode) : new OutputStreamWriter(new FileOutputStream(resultFile));
            }
            this.nonQueryTextArea.setText("");
            asJSql = new AsJsql(this.nonQueryTextArea.getFontMetrics(this.nonQueryTextArea.getFont()), reader, (Writer)new AsOutputStream(this.nonQueryTextArea, writer), encode, this.conn);
            if (this.conn != null) {
                if (!this.conn.isClosed()) {
                    this.queryToolbar.runCommandButton.setEnabled(true);
                    this.queryToolbar.loadCommandButton.setEnabled(true);
                    this.queryToolbar.saveCommandButton.setEnabled(true);
                    this.queryToolbar.clearCommandButton.setEnabled(true);
                    QueryFrame.frame.sqlTextArea.setEnabled(true);
                } else {
                    this.queryToolbar.runCommandButton.setEnabled(false);
                    this.queryToolbar.loadCommandButton.setEnabled(false);
                    this.queryToolbar.saveCommandButton.setEnabled(false);
                    this.queryToolbar.clearCommandButton.setEnabled(false);
                    QueryFrame.frame.sqlTextArea.setEnabled(false);
                }
            } else {
                this.queryToolbar.runCommandButton.setEnabled(false);
                this.queryToolbar.loadCommandButton.setEnabled(false);
                this.queryToolbar.saveCommandButton.setEnabled(false);
                this.queryToolbar.clearCommandButton.setEnabled(false);
                QueryFrame.frame.sqlTextArea.setEnabled(false);
            }
        }
        catch (SQLException e1) {
            this.mySetCursor(false);
            e1.printStackTrace();
        }
        catch (IOException e2) {
            this.mySetCursor(false);
            e2.printStackTrace();
        }
        this.mySetCursor(false);
    }

    public void historyComboBox_actionPerformed(ActionEvent e) {
        Object obj = this.historyComboBox.getSelectedItem();
        if (obj != null) {
            this.sqlTextArea.setText(obj.toString());
            if (obj.toString().trim().length() > 0) {
                this.historyComboBox.setToolTipText(this.historyComboBox.getSelectedItem().toString());
            } else {
                this.historyComboBox.setToolTipText(null);
            }
        }
    }

    public void executionPlan_checkBox_action(ActionEvent e) {
        this.tabbedPane.setSelectedIndex(0);
        this.clearResultPane();
    }

    public void resetAutoComplementContent() {
        if (this.sqlTextArea instanceof SQLAutoCompletionTextPane) {
            ((SQLAutoCompletionTextPane)this.sqlTextArea).setupDatabaseConnection();
        }
    }

    public void autoCompletion_action(ActionEvent e) {
        String text = this.sqlTextArea.getText();
        this.sqlScrollPane.remove(this.sqlTextArea);
        if (this.useAutoCompletion.isSelected()) {
            this.sqlTextArea = new SQLAutoCompletionTextPane();
            this.isSQLAutoCompletion = true;
        } else {
            this.sqlTextArea = new SQLTextPane();
            this.isSQLAutoCompletion = false;
        }
        this.sqlTextArea.setText(text);
        this.sqlScrollPane.setViewportView(this.sqlTextArea);
        this.initSqlTextArea();
        this.sqlScrollPane.revalidate();
        this.sqlScrollPane.repaint();
    }

    public boolean isWindows() {
        String fileseparator = System.getProperty("file.separator");
        return fileseparator.equals("\\");
    }

    public void setUpBlobEditor(JTable table, AsTableModel tableModel, int index) {
        Class<?> jaicls = null;
        try {
            jaicls = Class.forName("javax.media.jai.widget.ScrollingImagePanel");
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe.getMessage());
        }
        JButton field = jaicls == null ? new BlobEditorNoJAIButton() : new BlobEditorButton();
        BlobEditor editor = new BlobEditor((BlobEditorButtonInterface)((Object)field), table, tableModel);
        TableColumn column = table.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
    }

    public boolean isBlobType(String type) {
        return type.equalsIgnoreCase("LONGVARBINARY") || type.equalsIgnoreCase("LONGVARCHAR") || type.equalsIgnoreCase("FILE") || type.equalsIgnoreCase("BLOB") || type.equalsIgnoreCase("CLOB") || type.equalsIgnoreCase("NCLOB") || type.equalsIgnoreCase("LONG VARBINARY") || type.equalsIgnoreCase("LONG VARCHAR");
    }

    private void convertHistory(Set<String> v) {
        LimitedComboBoxModel cbm = (LimitedComboBoxModel)this.historyComboBox.getModel();
        String[] s = new String[v.size()];
        cbm.add(v.toArray(s));
    }

    public void sqlTextPane_keyRelease(KeyEvent e) {
        if (this.sqlTextArea.getText().equalsIgnoreCase("")) {
            this.queryToolbar.clearCommandButton.setEnabled(false);
        } else if (e.getKeyCode() == 123) {
            this.ExecuteCommand();
        } else if (e.getKeyCode() == 115) {
            this.sqlTextArea.setText("");
            this.queryToolbar.clearCommandButton.setEnabled(false);
        } else {
            this.queryToolbar.clearCommandButton.setEnabled(true);
        }
        this.queryToolbar.undoButton.setEnabled(this.sqlTextArea.canUndo());
        this.queryToolbar.redoButton.setEnabled(this.sqlTextArea.canRedo());
    }

    public void tabbed_actionPerformed(ChangeEvent e) {
        Component comp = this.tabbedPane.getSelectedComponent();
        if (comp instanceof AsQueryPane) {
            ((AsQueryPane)comp).buttonAction(null);
        }
    }

    public void setMessageField(String info) {
        this.messageLabel.setText(info);
        this.messageLabel.setToolTipText(info);
    }

    public void setDBField(String dbInfo) {
        this.dbLabel.setText(dbInfo);
        this.dbLabel.setToolTipText(dbInfo);
    }

    public void setQueryTimeField(long time) {
        if (time >= 0L) {
            this.queryTimeLabel.setText(this.res.getString("Total_") + time + "ms");
            this.queryTimeLabel.setToolTipText(this.res.getString("Total_") + time + "ms");
        } else {
            this.queryTimeLabel.setText("");
            this.queryTimeLabel.setToolTipText("");
        }
    }

    public void setRowField(String row, int start, int end, int max) {
        if (max > 0) {
            this.rowPositionLabel.setToolTipText(this.res.getString("MAX_Row_") + max);
        } else {
            this.rowPositionLabel.setToolTipText("");
        }
        if (start != 0) {
            this.rowPositionLabel.setText("Row# :" + row + "(" + start + " - " + end + ")");
        } else {
            this.rowPositionLabel.setText("");
        }
    }

    public void clearQueryPane() {
        this.sqlTextArea.setText("");
    }

    public void clearNonQueryPane() {
        this.nonQueryTextArea.setText("");
    }

    public void clearButtonStatus(boolean enable) {
        this.queryToolbar.clearCommandButton.setEnabled(enable);
    }

    private void mySetCursor(boolean b) {
        if (b) {
            frame.setCursor(this.wait_cursor);
            this.sqlTextArea.setCursor(this.wait_cursor);
            this.nonQueryTextArea.setCursor(this.wait_cursor);
        } else {
            frame.setCursor(this.defCursor);
            this.sqlTextArea.setCursor(this.defCursor);
            this.nonQueryTextArea.setCursor(this.defCursor);
        }
    }

    public void clearResultPane() {
        Component comp = null;
        for (int i = this.tabbedPane.getTabCount(); i > 1; --i) {
            comp = this.tabbedPane.getComponentAt(i - 1);
            if (comp instanceof AsQueryPane) {
                ((AsQueryPane)comp).closeResultSet();
            }
            this.tabbedPane.remove(i - 1);
        }
    }

    public void clearATab() {
        ((AsQueryPane)this.tabbedPane.getSelectedComponent()).closeResultSet();
        this.tabbedPane.remove(this.tabbedPane.getSelectedIndex());
    }

    public void killHistory() {
        this.historyComboBox.removeAllItems();
    }

    public void askFocus() {
        this.sqlTextArea.requestFocus();
    }

    public String getSqlText() {
        return this.sqlTextArea.getText();
    }

    public Point getDefaultCenterLocation() {
        return this.centerLocation;
    }

    public void setDefaultCenterLocation(Point p) {
        this.centerLocation = p;
    }

    public void copyFile(File sFile, File dFile) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            dFile.createNewFile();
            in = new FileInputStream(sFile.getAbsolutePath());
            out = new FileOutputStream(dFile.getAbsolutePath());
            byte[] buff = new byte[1024];
            int read = in.read(buff);
            while (read >= 0) {
                out.write(buff, 0, read);
                read = in.read(buff);
            }
            in.close();
            out.close();
            sFile.delete();
            sFile.createNewFile();
        }
        catch (IOException ioe) {
            GuiUt.showErrorDlg(this, ioe.getMessage(), null);
        }
    }

    public void localeChanged(LocaleChangeEvent e) {
        this.res = e == null ? DBAResourceBundle.getDBAResourceBundle("resource.jsqltool", LocaleManager.getLocale()) : DBAResourceBundle.getDBAResourceBundle("resource.jsqltool", e.getLocale());
        this.queryToolbar.localeChanged(e);
        this.tabbedPane.setTitleAt(0, this.res.getString("SQL_Result"));
        if (!this.isConnect) {
            this.setMessageField(this.res.getString("No_connection"));
        } else {
            this.setMessageField(this.res.getString("Database_connected"));
        }
        this.validate();
    }

    public String getHelpIDString() {
        return helpres.getString("jsql_introduction");
    }

    class LimitedComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 1L;
        int limit = Integer.MAX_VALUE;

        LimitedComboBoxModel(int limit, ArrayList<String> history) {
            this.limit = limit;
            if (history != null && history.size() > 0) {
                this.add(history);
            }
        }

        void add(ArrayList<String> strs) {
            for (String s : strs) {
                this.addElement(s);
            }
        }

        void add(String[] strs) {
            int cur = this.getSize();
            for (int i = 0; i < strs.length; ++i) {
                this.insertElementAt(strs[i], 0);
            }
            int size = this.getSize();
            if (size > this.limit) {
                for (int i = size - 1; i >= this.limit; --i) {
                    this.removeElementAt(i);
                }
            }
        }
    }
}

