/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import queryAnalyzer.QueryFrame;
import tableCell.BlobCellObject;

public class AsTableModel
extends AbstractTableModel {
    ArrayList columnNames;
    ArrayList colTypeNames;
    public Vector dataRecord = new Vector();
    public boolean isEditable = false;

    public AsTableModel(ArrayList columnNames, ArrayList colTypeNames) {
        this.columnNames = columnNames;
        this.colTypeNames = colTypeNames;
    }

    @Override
    public int getRowCount() {
        return this.dataRecord.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames.get(col).toString();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object[] rowData = (Object[])this.dataRecord.get(row);
        return rowData[col];
    }

    public void addValue(Object[] newData) {
        this.dataRecord.addElement(newData);
    }

    public void switchOrder(int godown, int goup) {
        Object downRow = this.dataRecord.elementAt(godown);
        Object upRow = this.dataRecord.elementAt(goup);
        this.dataRecord.setElementAt(downRow, goup);
        this.dataRecord.setElementAt(upRow, godown);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            return;
        }
        String dataType = this.colTypeNames.get(col - 1).toString();
        if (QueryFrame.frame.isBlobType(dataType)) {
            if (!(value instanceof BlobCellObject)) {
                return;
            }
            BlobCellObject obj = (BlobCellObject)value;
            if (obj.size < 0L || obj.isNull) {
                return;
            }
        }
    }

    public void removeRow(int row) {
        this.dataRecord.removeElementAt(row);
    }

    public void removeAll() {
        this.dataRecord.removeAllElements();
    }

    public void addAll(Vector v) {
        this.dataRecord.addAll(v);
    }

    public Object getRowValue(int row) {
        return this.dataRecord.elementAt(row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col < 0) {
            return false;
        }
        if (col >= 0 && QueryFrame.frame.isBlobType(this.colTypeNames.get(col).toString())) {
            return true;
        }
        return this.isEditable;
    }
}

