/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import dbaut.preference.CorePreferences;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import monitor.MonitorFrame;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PreferencesXml
extends CorePreferences {
    private Point position = new Point(0, 0);
    private boolean view_format = false;
    private short repaint_caption_every_row = (short)25;
    private short repaint_caption_every_day = (short)2;
    private boolean export_monitor_item_to_external_file = true;
    private boolean repaint_caption_by_row = true;
    private short file_size = 1;
    private short file_count = (short)10;
    private String selected_directory = null;
    private Element syscom = null;
    public String orString = null;
    public boolean isWindows = true;
    public String user_dir = null;
    public String file_separator = null;
    public int max_seconds = 172800;
    public int first_item_time = 0;
    public short outputFileCount = 0;
    public short dataRowCount = 0;
    public int max_caption_size = 0;
    public static final int VIEW_FORMAT = 0;
    public static final int REPAINT_CAPTION_EVERY_ROW = 1;
    public static final int REPAINT_CAPTION_EVERY_DAY = 2;
    public static final int SELECTED_DIRECTORY = 3;
    public static final int EXPORT_MONITOR_ITEM_TO_EXTERNAL_FILE = 4;
    public static final int REPAINT_CAPTION_BY_ROW = 5;
    public static final int FILE_SIZE = 6;
    public static final int FILE_COUNT = 7;
    public static final int FILE_SIZE_LIMITATION = 524288;
    public static final int MAX_FILE_SIZE_GAP = 10;

    public static PreferencesXml getPreferencesXml() {
        return new PreferencesXml();
    }

    public PreferencesXml() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.file_separator = System.getProperty("file.separator");
        this.user_dir = System.getProperty("user.dir");
        this.isWindows = this.file_separator.equals("\\");
        this.init(CorePreferences.getConfigName());
    }

    private void init(String fileName) throws Exception {
        File f = new File(fileName);
        if (!f.exists()) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(fileName);
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        String temp = null;
        Node node = null;
        this.resetDOM(doc);
        node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jmonitor");
        if (node != null && node.getNodeType() == 1 && (temp = ((Element)node).getAttribute("selected_directory")) != null && temp.length() > 0) {
            this.selected_directory = temp;
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jmonitor/frame")) != null && node.getNodeType() == 1) {
            Element elm = (Element)node;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int xpos = 0;
            int ypos = 0;
            temp = elm.getAttribute("xpos");
            if (temp != null && temp.length() > 0 && ((xpos = Integer.parseInt(temp)) < 0 || (double)xpos > screenSize.getWidth())) {
                xpos = 0;
            }
            if ((temp = elm.getAttribute("ypos")) != null && temp.length() > 0 && ((ypos = Integer.parseInt(temp)) < 0 || (double)ypos > screenSize.getHeight())) {
                ypos = 0;
            }
            this.position = new Point(xpos, ypos);
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jmonitor/options")) != null && node.getNodeType() == 1) {
            temp = ((Element)node).getAttribute("view_format");
            if (temp != null && temp.length() > 0) {
                this.view_format = new Boolean(temp);
            }
            if ((temp = ((Element)node).getAttribute("repaint_caption_by_row")) != null && temp.length() > 0) {
                this.repaint_caption_by_row = new Boolean(temp);
            }
            if ((temp = ((Element)node).getAttribute("repaint_caption_every_row")) != null && temp.length() > 0) {
                this.repaint_caption_every_row = Short.parseShort(temp);
            }
            if ((temp = ((Element)node).getAttribute("repaint_caption_every_day")) != null && temp.length() > 0) {
                this.repaint_caption_every_day = Short.parseShort(temp);
            }
            if ((temp = ((Element)node).getAttribute("export_monitor_item_to_external_file")) != null && temp.length() > 0) {
                this.export_monitor_item_to_external_file = new Boolean(temp);
            }
            if ((temp = ((Element)node).getAttribute("file_count")) != null && temp.length() > 0) {
                this.file_count = Short.parseShort(temp);
            }
            if ((temp = ((Element)node).getAttribute("file_size")) != null && temp.length() > 0) {
                this.file_size = Short.parseShort(temp);
            }
        }
    }

    public void updateVariables(int options, String value) {
        switch (options) {
            case 0: {
                this.view_format = new Boolean(value);
                break;
            }
            case 1: {
                this.repaint_caption_every_row = Short.parseShort(value);
                break;
            }
            case 2: {
                this.repaint_caption_every_day = Short.parseShort(value);
                break;
            }
            case 3: {
                this.selected_directory = value;
                break;
            }
            case 4: {
                this.export_monitor_item_to_external_file = new Boolean(value);
                break;
            }
            case 5: {
                this.repaint_caption_by_row = new Boolean(value);
                break;
            }
            case 6: {
                this.file_size = Short.parseShort(value);
                break;
            }
            case 7: {
                this.file_count = Short.parseShort(value);
            }
        }
    }

    public Point getLocation() {
        return this.position;
    }

    public boolean getViewFormat() {
        return this.view_format;
    }

    public short getRepaintCaptionEveryRow() {
        return this.repaint_caption_every_row;
    }

    public short getRepaintCaptionEveryDay() {
        return this.repaint_caption_every_day;
    }

    public String getSelectedDirectory() {
        return this.selected_directory;
    }

    public boolean getExportMonitorItem2ExternalFile() {
        return this.export_monitor_item_to_external_file;
    }

    public short getFileCount() {
        return this.file_count;
    }

    public short getFileSize() {
        return this.file_size;
    }

    public boolean getRepaintCaptionByRow() {
        return this.repaint_caption_by_row;
    }

    @Override
    public void save() {
        this.save(CorePreferences.getConfigName());
    }

    private void save(String fileName) {
        this.position = MonitorFrame.frame.getLocationOnScreen();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Document doc = null;
        Element jmonitor2 = null;
        File file = new File(fileName);
        if (file.exists()) {
            try {
                doc = builder.parse(fileName);
            }
            catch (Exception pe) {
                doc = builder.newDocument();
            }
        } else {
            doc = builder.newDocument();
        }
        this.setDOM(doc);
        this.syscom = doc.getDocumentElement();
        if (this.syscom == null) {
            System.out.println("CorePreferences fails to save <syscom>");
        }
        jmonitor2 = doc.createElement("jmonitor");
        if (this.selected_directory != null && this.selected_directory.length() > 0) {
            jmonitor2.setAttribute("selected_directory", this.selected_directory);
        }
        Element frame = doc.createElement("frame");
        frame.setAttribute("xpos", Integer.toString((int)this.position.getX()));
        frame.setAttribute("ypos", Integer.toString((int)this.position.getY()));
        Element options = doc.createElement("options");
        options.setAttribute("export_monitor_item_to_external_file", this.export_monitor_item_to_external_file ? "true" : "false");
        options.setAttribute("view_format", this.view_format ? "true" : "false");
        options.setAttribute("repaint_caption_every_row", Short.toString(this.repaint_caption_every_row));
        options.setAttribute("repaint_caption_every_day", Short.toString(this.repaint_caption_every_day));
        options.setAttribute("repaint_caption_by_row", this.repaint_caption_by_row ? "true" : "false");
        options.setAttribute("file_count", Integer.toString(this.file_count));
        options.setAttribute("file_size", Integer.toString(this.file_size));
        jmonitor2.appendChild(frame);
        jmonitor2.appendChild(options);
        Node orig = null;
        try {
            orig = XPathAPI.selectSingleNode((Node)this.syscom, (String)"jmonitor");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (orig != null && orig.getNodeType() == 1) {
            this.syscom.replaceChild(jmonitor2, orig);
        } else {
            this.syscom.appendChild(jmonitor2);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            StreamResult result = new StreamResult(out);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            out.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

