/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaToggleButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.resource.HelpResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.TableModelEvent;
import monitor.DataObject;
import monitor.DataSet;
import monitor.DatabaseConnection;
import monitor.LoginDlg;
import monitor.MonitorMenuBar;
import monitor.OuterPanel;
import monitor.PreferencesXml;
import monitor.PropertiesDialog;
import monitor.TablePanel;

public class MonitorFrame
extends JFrame
implements LocaleChangeListener {
    DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("Monitorproperties.Monitor.MonitorRes", LocaleManager.getLocale());
    HelpResourceBundle helpres = new HelpResourceBundle("jdbaproperties.help");
    static MonitorFrame frame = null;
    private DefaultComboBoxModel dcm = null;
    private DbaToggleButton Stop_Button = new DbaToggleButton(this.res.getString("Pause"), 'U', new ReflectionAction(this, "Stop_Button_actionPerformed"), DBAImageResource.getResource(this.getClass(), "/monitorimages/stop.gif"));
    private DbaButton Properties_Button = new DbaButton(new Dimension(120, 24), false, this.res.getString("Properties"), 'P', DBAImageResource.getResource(this.getClass(), "/monitorimages/porperties.gif"), new ReflectionAction(this, "Properties_Button_actionPerformed"));
    private JComboBox RangeComboBox = new JComboBox();
    private JLabel everyLabel = new JLabel();
    private Vector colorVector = new Vector();
    boolean isHigh = false;
    DatabaseConnection conn_DatabaseConnection = null;
    boolean isWindows = true;
    boolean isConnect = false;
    String firstArgument = "ynnn";
    int io_daemon_fgRun = 0;
    int szStructHeader = 0;
    MonitorMenuBar menubar = null;
    static byte[] UDF_HIS_MARK = new String("UHUH").getBytes();
    HelpSet mainHS = null;
    DefaultHelpBroker mainHB = null;
    PreferencesXml px = PreferencesXml.getPreferencesXml();
    DataSet dataset = new DataSet();
    private OuterPanel chartpanel = new OuterPanel(this.dataset);
    private TablePanel tablepanel = new TablePanel(this.dataset);
    String[] itemDataArray = null;
    String[] itemCaptionArray = null;
    String[] itemProportionArray = null;
    boolean isDataRefresh = false;

    public MonitorFrame(String dbName, String userID, String password) {
        frame = this;
        this.setCursor(Cursor.getPredefinedCursor(3));
        DatabaseConnection conn = new DatabaseConnection(dbName, userID, password, this);
        this.setCursor(Cursor.getDefaultCursor());
        MonitorFrame.frame.conn_DatabaseConnection = conn;
        if (!this.isConnect) {
            MonitorFrame.frame.tablepanel.Add_Button.setEnabled(false);
            MonitorFrame.frame.Stop_Button.setEnabled(false);
            return;
        }
        frame.initRangeCombo(MonitorFrame.frame.conn_DatabaseConnection);
        MonitorFrame.frame.tablepanel.Add_Button.setEnabled(true);
        MonitorFrame.frame.Stop_Button.setEnabled(true);
        System.gc();
        this.enableEvents(64L);
        try {
            this.jbInit();
            if (MonitorFrame.frame.conn_DatabaseConnection != null) {
                this.setTitle(MonitorFrame.frame.conn_DatabaseConnection.dbname + " : " + MonitorFrame.frame.conn_DatabaseConnection.username);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MonitorFrame() {
        frame = this;
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void inihelp() {
        String hs = null;
        try {
            this.helpres = new HelpResourceBundle("jdbaproperties.help");
            hs = this.getHelpSetFile();
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)hs);
            this.mainHS = new HelpSet(cl, url);
            this.mainHB = (DefaultHelpBroker)this.mainHS.createHelpBroker();
            this.mainHB.enableHelpKey((Component)this.getRootPane(), this.helpres.getString("home_Monitor"), null);
        }
        catch (Exception ex) {
            System.out.println("Help Set " + hs + " not found");
            ex.printStackTrace();
        }
        catch (ExceptionInInitializerError ex) {
            System.err.println("initialization error:");
            ex.getException().printStackTrace();
        }
    }

    public static String getHelpSetFile() {
        String hs = "JDBA.hs";
        switch (LocaleManager.getHelpFileLanguage()) {
            default: 
        }
        hs = "JDBA.hs";
        return hs;
    }

    public void enableHelpAction(Component com, JButton helpButton, String helpId, HelpSet hs) {
        if (this.mainHB == null) {
            return;
        }
        String locale = this.helpres.getString(helpId);
        if (com != null) {
            this.mainHB.enableHelpKey(com, locale, hs);
        }
        if (helpButton != null) {
            this.mainHB.enableHelpOnButton((Component)helpButton, locale, hs);
        }
    }

    private void jbInit() throws Exception {
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel panel3 = new JPanel(new BorderLayout());
        JSplitPane jSplitPane1 = new JSplitPane();
        JToolBar jToolBar = new JToolBar();
        Container contentPane = this.getContentPane();
        this.setSize(new Dimension(640, 520));
        this.setResizable(false);
        this.setTitle(this.res.getString("Database_monitor"));
        this.inihelp();
        URL url = this.getClass().getResource("/monitorimages/monitor.gif");
        if (url != null) {
            this.setIconImage(this.getToolkit().getImage(url));
        }
        this.isWindows = MonitorFrame.isWindows();
        frame = this;
        this.menubar = new MonitorMenuBar();
        this.setJMenuBar(this.menubar);
        jToolBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.RangeComboBox.addActionListener(new ReflectionAction(this, "RangeComboBox_actionPerformed"));
        panel3.setPreferredSize(new Dimension(160, 34));
        this.everyLabel.setText(this.res.getString("Every"));
        jToolBar.add(this.Properties_Button);
        JPanel tmpPanel = new JPanel();
        tmpPanel.setMinimumSize(new Dimension(160, 24));
        jToolBar.add(tmpPanel);
        jToolBar.add(this.Stop_Button);
        jSplitPane1.setBorder(null);
        jSplitPane1.setOrientation(0);
        jSplitPane1.setDividerLocation(300);
        jSplitPane1.setBottomComponent(this.tablepanel);
        jSplitPane1.setTopComponent(this.chartpanel);
        panel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.RangeComboBox.setPreferredSize(new Dimension(80, 24));
        panel3.add((Component)this.RangeComboBox, "Center");
        panel3.add((Component)this.everyLabel, "West");
        panel2.add((Component)jToolBar, "West");
        panel2.add((Component)panel3, "East");
        contentPane.add((Component)jSplitPane1, "Center");
        contentPane.add((Component)panel2, "North");
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        this.exitApplication();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            try {
                this.px.save();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            this.Disconnect_MenuItem_actionPerformed(null);
            System.exit(0);
        }
        super.processWindowEvent(e);
    }

    public void setControllersStatus(boolean flag) {
        this.tablepanel.Add_Button.setEnabled(flag);
        this.tablepanel.Object_Button.setEnabled(flag);
        this.tablepanel.Delete_Button.setEnabled(flag);
        TablePanel.table.setEnabled(flag);
        this.everyLabel.setEnabled(flag);
        this.RangeComboBox.setEnabled(flag);
        this.Properties_Button.setEnabled(flag);
        this.tablepanel.jScrollPane1.setEnabled(flag);
    }

    public void Stop_Button_actionPerformed(ActionEvent e) {
        if (this.Stop_Button.isSelected()) {
            this.dataset.cancelTimer();
            this.setControllersStatus(false);
        } else {
            this.dataset.setTimer();
            this.setControllersStatus(true);
        }
    }

    public void Properties_Button_actionPerformed(ActionEvent e) {
        PropertiesDialog dlg = null;
        dlg = GuiUt.isWindows() ? new PropertiesDialog((Frame)frame, this.dataset) : new PropertiesDialog((Frame)frame, "", true, this.dataset);
        GuiUt.setCenterLocation(this, dlg);
        dlg.show();
        frame.repaint();
    }

    public void RangeComboBox_actionPerformed(ActionEvent e) {
        if (this.RangeComboBox.isEnabled()) {
            this.dataset.range = (short)this.RangeComboBox.getSelectedIndex();
            switch (this.dataset.range) {
                case 0: {
                    this.firstArgument = "ynnn";
                    break;
                }
                case 1: {
                    this.firstArgument = "nynn";
                    break;
                }
                case 2: {
                    this.firstArgument = "nnyn";
                    break;
                }
                case 3: {
                    this.firstArgument = "nnny";
                }
            }
            for (int i = 0; i < this.dataset.getItemCount(); ++i) {
                if (MonitorFrame.frame.px.getExportMonitorItem2ExternalFile()) {
                    this.dataset.getItem(i).update();
                    continue;
                }
                this.dataset.getItem(i).update();
            }
            this.dataset.setTimer();
            frame.repaint();
        }
    }

    public void connect_DB() {
        try {
            this.Disconnect_MenuItem_actionPerformed(null);
            LoginDlg dlg = this.isWindows ? new LoginDlg(this) : new LoginDlg(this, "", true);
            GuiUt.setCenterLocation(this, dlg);
            dlg.show();
            dlg = null;
            if (!this.isConnect) {
                MonitorFrame.frame.tablepanel.Add_Button.setEnabled(false);
                MonitorFrame.frame.Stop_Button.setEnabled(false);
                this.menubar.Disconnect_DB_Menuitem.setEnabled(false);
                this.menubar.Connect_DB_Menuitem.setEnabled(true);
                return;
            }
            frame.initRangeCombo(MonitorFrame.frame.conn_DatabaseConnection);
            MonitorFrame.frame.tablepanel.Add_Button.setEnabled(true);
            MonitorFrame.frame.Stop_Button.setEnabled(true);
            this.menubar.Disconnect_DB_Menuitem.setEnabled(true);
            this.menubar.Connect_DB_Menuitem.setEnabled(true);
            if (this.conn_DatabaseConnection != null) {
                this.setTitle(this.conn_DatabaseConnection.dbname + " : " + this.conn_DatabaseConnection.username);
            }
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void Disconnect_MenuItem_actionPerformed(ActionEvent e) {
        if (this.conn_DatabaseConnection != null) {
            this.dataset.cancelTimer();
            this.conn_DatabaseConnection.disconnect();
            this.conn_DatabaseConnection = null;
        }
        this.isConnect = false;
        this.setTitle(this.res.getString("No_database_connected"));
        int objectCount = MonitorFrame.frame.dataset.getItemCount();
        if (objectCount > 0) {
            for (int i = objectCount; i > 0; --i) {
                MonitorFrame.frame.dataset.removeItem(i - 1);
                MonitorFrame.frame.tablepanel.model.fireTableChanged(new TableModelEvent(MonitorFrame.frame.tablepanel.model));
            }
        }
        MonitorFrame.frame.RangeComboBox.removeAllItems();
        MonitorFrame.frame.tablepanel.Add_Button.setEnabled(false);
        MonitorFrame.frame.Stop_Button.setEnabled(false);
        this.menubar.Disconnect_DB_Menuitem.setEnabled(false);
        this.menubar.Connect_DB_Menuitem.setEnabled(true);
        MonitorFrame.frame.tablepanel.serverTimeLabel.setText("");
        System.gc();
        this.repaint();
    }

    public static boolean isWindows() {
        String fileseparator = System.getProperty("file.separator");
        return fileseparator.equals("\\");
    }

    public void setServerTime(int time) {
        MonitorFrame.frame.tablepanel.serverTimeLabel.setText(GuiUt.utTimeToStr(time));
    }

    public String getServerTime() {
        return MonitorFrame.frame.tablepanel.serverTimeLabel.getText();
    }

    public void initRangeCombo(DatabaseConnection conn) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.getConnection().createStatement();
            rs = stmt.executeQuery("select SysInfoHistory('n', 'n')");
            rs.next();
            byte[] ba = rs.getBytes(1);
            this.isHigh = ba[0] != UDF_HIS_MARK[0] || ba[1] != UDF_HIS_MARK[1] || ba[2] != UDF_HIS_MARK[2] || ba[3] != UDF_HIS_MARK[3];
            int itemCount = MonitorFrame.byteArrayToInteger(ba, 16, 4, this.isHigh);
            this.szStructHeader = MonitorFrame.byteArrayToInteger(ba, 4, 4, this.isHigh);
            this.io_daemon_fgRun = MonitorFrame.byteArrayToInteger(ba, 8, 4, this.isHigh);
            int time = MonitorFrame.byteArrayToInteger(ba, 12, 4, this.isHigh);
            this.setServerTime(time);
            Vector<String> v = new Vector<String>();
            block8: for (int i = 20; i < 20 + itemCount * 4; i += 4) {
                int rangeValue = MonitorFrame.byteArrayToInteger(ba, i, 4, this.isHigh);
                switch (rangeValue) {
                    case 5: {
                        v.addElement(this.res.getString("5_seconds"));
                        continue block8;
                    }
                    case 120: {
                        v.addElement(this.res.getString("2_minutes"));
                        continue block8;
                    }
                    case 3600: {
                        v.addElement(this.res.getString("a_hour"));
                        continue block8;
                    }
                    case 86400: {
                        v.addElement(this.res.getString("a_day"));
                    }
                }
            }
            this.dcm = new DefaultComboBoxModel(v);
            MonitorFrame.frame.RangeComboBox.setModel(this.dcm);
            DbaObject.close(rs);
            DbaObject.close(stmt);
            if (this.io_daemon_fgRun == 0) {
                GuiUt.showWarningDlg(this, this.res.getString("Warning"), this.res.getString("History_daemon_does_not"));
            }
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this, sqle.getMessage(), sqle);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
    }

    public static int byteArrayToInteger(byte[] ba, int offset, int length, boolean isHigh) {
        int i2 = 0;
        if (isHigh) {
            for (int i = offset; i < offset + length; ++i) {
                int i1 = ba[i];
                if (i1 < 0) {
                    i1 = 256 + i1;
                }
                i2 += (int)(Math.pow(256.0, (double)i - (double)offset) * (double)Math.abs(i1));
            }
        } else {
            for (int i = offset + length - 1; i >= offset; --i) {
                int i1 = ba[i];
                if (i1 < 0) {
                    i1 = 256 + i1;
                }
                i2 += (int)(Math.pow(256.0, (double)(offset + length - 1) - (double)i) * (double)Math.abs(i1));
            }
        }
        return i2;
    }

    public static long byteArrayToLong(byte[] ba, int offset, int length, boolean isHigh) {
        int i;
        int len = 8;
        byte[] tmp = new byte[len];
        int j = len;
        int g = 0;
        if (!isHigh) {
            for (i = offset; i < offset + len; ++i) {
                tmp[--j] = ba[i];
            }
        } else {
            for (i = offset; i < offset + len; ++i) {
                tmp[g++] = ba[i];
            }
        }
        long value = 0L;
        int i2 = 0;
        for (int x = 0; x < 64; x += 8) {
            value |= ((long)tmp[i2] & 0xFFL) << x;
            ++i2;
        }
        return value;
    }

    public void exitApplication() {
        try {
            Toolkit.getDefaultToolkit().beep();
            int reply = GuiUt.showOptionDlg(this, this.res.getString("Monitor_Exit"), this.res.getString("Do_you_really"));
            if (reply == 0) {
                this.px.save();
                this.dataset.cancelTimer();
                this.Disconnect_MenuItem_actionPerformed(null);
                this.setVisible(false);
                this.dispose();
                System.exit(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = e == null ? DBAResourceBundle.getDBAResourceBundle("Monitorproperties.Monitor.MonitorRes", LocaleManager.getLocale()) : DBAResourceBundle.getDBAResourceBundle("Monitorproperties.Monitor.MonitorRes", e.getLocale());
        this.setTitle(this.res.getString("Database_monitor"));
        this.Stop_Button.setText(this.res.getString("Pause"));
        this.Properties_Button.setText(this.res.getString("Properties"));
        this.everyLabel.setText(this.res.getString("Every"));
        int i = this.RangeComboBox.getSelectedIndex();
        Vector<String> vv = new Vector<String>();
        vv.addElement(this.res.getString("5_seconds"));
        vv.addElement(this.res.getString("2_minutes"));
        vv.addElement(this.res.getString("a_hour"));
        vv.addElement(this.res.getString("a_day"));
        this.dcm = new DefaultComboBoxModel(vv);
        MonitorFrame.frame.RangeComboBox.setModel(this.dcm);
        this.RangeComboBox.setSelectedIndex(i);
        if (MonitorFrame.frame.conn_DatabaseConnection != null) {
            this.setTitle(MonitorFrame.frame.conn_DatabaseConnection.dbname + " : " + MonitorFrame.frame.conn_DatabaseConnection.username);
        } else {
            this.setTitle(this.res.getString("No_database_connected"));
        }
    }

    public void calculateCaptoinSize() {
        int size = MonitorFrame.frame.dataset.getItemCount();
        DataObject obj = null;
        int curLen = 0;
        for (int i = 0; i < size; ++i) {
            obj = MonitorFrame.frame.dataset.getItem(i);
            curLen = MonitorFrame.frame.res.getString(obj.key).getBytes().length + 2;
            if (curLen <= MonitorFrame.frame.px.max_caption_size) continue;
            MonitorFrame.frame.px.max_caption_size = curLen;
        }
    }

    public void copyFile(File sFile, File dFile) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            dFile.createNewFile();
            in = new FileInputStream(sFile.getAbsolutePath());
            out = new FileOutputStream(dFile.getAbsolutePath());
            byte[] buff = new byte[1024];
            int read = in.read(buff);
            while (read >= 0) {
                out.write(buff, 0, read);
                read = in.read(buff);
            }
            in.close();
            out.close();
            sFile.delete();
            sFile.createNewFile();
        }
        catch (IOException ioe) {
            GuiUt.showErrorDlg(this, ioe.getMessage(), null);
        }
    }

    private void moveFile(String path) {
        int size;
        File f1 = new File(path + "Message.log");
        long fileSize = f1.length();
        int itemCount = MonitorFrame.frame.dataset.getItemCount();
        int mergeSize = MonitorFrame.frame.px.max_caption_size + 10;
        int reduceSize = mergeSize * 3;
        int cReduceSize = reduceSize * itemCount;
        if (MonitorFrame.frame.px.getViewFormat()) {
            if (MonitorFrame.frame.px.getRepaintCaptionByRow()) {
                short everyRow = MonitorFrame.frame.px.getRepaintCaptionEveryRow();
                if (MonitorFrame.frame.px.dataRowCount / everyRow == 1 && MonitorFrame.frame.px.dataRowCount % everyRow == 0) {
                    fileSize = fileSize - (long)(reduceSize * 2) - 4L;
                }
                if (!MonitorFrame.frame.px.getViewFormat()) {
                    int itemLen = this.itemCaptionArray.length;
                    int ii = MonitorFrame.frame.px.dataRowCount / itemLen;
                    fileSize -= (long)(reduceSize * 2 * ii);
                }
            } else {
                int currentTime = GuiUt.convertStrToTime(frame.getServerTime());
                if (currentTime - MonitorFrame.frame.px.first_item_time < MonitorFrame.frame.px.getRepaintCaptionEveryDay() * 86400) {
                    fileSize = fileSize - (long)(reduceSize * 2) - 4L;
                }
                if (!MonitorFrame.frame.px.getViewFormat()) {
                    int itemLen = this.itemCaptionArray.length;
                    int ii = MonitorFrame.frame.px.dataRowCount / itemLen;
                    fileSize -= (long)(reduceSize * 2 * ii);
                }
            }
        }
        if (fileSize >= (long)((size = this.px.getFileSize() * 1024 * 1024) - cReduceSize)) {
            this.isDataRefresh = true;
            this.moveLogFiles(path);
            if (MonitorFrame.frame.px.outputFileCount < MonitorFrame.frame.px.getFileCount()) {
                MonitorFrame.frame.px.outputFileCount = (short)(MonitorFrame.frame.px.outputFileCount + 1);
            }
        }
    }

    private void moveLogFiles(String path) {
        File sFile = null;
        File dFile = null;
        if (MonitorFrame.frame.px.outputFileCount > 0) {
            int fileCount;
            for (int i = fileCount = MonitorFrame.frame.px.outputFileCount; i >= 0; --i) {
                if (i > 0) {
                    sFile = new File(path + "Message" + (i - 1) + ".log");
                    dFile = new File(path + "Message" + i + ".log");
                    continue;
                }
                sFile = new File(path + "Message.log");
                dFile = new File(path + "Message" + i + ".log");
            }
        } else {
            sFile = new File(path + "Message.log");
            dFile = new File(path + "Message0.log");
        }
        this.copyFile(sFile, dFile);
        sFile = null;
        dFile = null;
    }

    public void writeDataIntoFile() {
        String s;
        if (MonitorFrame.frame.px.getSelectedDirectory() == null) {
            s = System.getProperty("user.dir");
            PreferencesXml cfr_ignored_0 = MonitorFrame.frame.px;
            MonitorFrame.frame.px.updateVariables(3, System.getProperty("user.dir"));
            MonitorFrame.frame.px.save();
        }
        if (!(s = MonitorFrame.frame.px.getSelectedDirectory()).endsWith(MonitorFrame.frame.px.file_separator)) {
            s = s + MonitorFrame.frame.px.file_separator;
        }
        File f = new File(s + "Message.log");
        this.getEveryItem();
        FileWriter fw = null;
        if (f.exists()) {
            try {
                this.moveFile(s);
                fw = new FileWriter(s + "Message.log", true);
                this.writing(fw);
                fw.close();
            }
            catch (IOException ioe) {
                GuiUt.showErrorDlg(this, ioe.getMessage(), null);
                ioe.printStackTrace();
            }
        } else {
            MonitorFrame.frame.px.dataRowCount = 0;
            MonitorFrame.frame.px.first_item_time = 0;
            try {
                f.createNewFile();
                fw = new FileWriter(f.getAbsolutePath(), true);
                this.moveFile(s);
                this.writing(fw);
                fw.close();
            }
            catch (IOException ioe) {
                GuiUt.showErrorDlg(this, ioe.getMessage(), null);
                ioe.printStackTrace();
            }
        }
    }

    private String paddingString(String inStr, char c) {
        int restLen = MonitorFrame.frame.px.max_caption_size - inStr.trim().getBytes().length + 10;
        String retStr = inStr;
        for (int i = 0; i < restLen; ++i) {
            retStr = retStr + c;
        }
        return retStr;
    }

    public void getEveryItem() {
        int size = MonitorFrame.frame.dataset.getItemCount();
        this.itemCaptionArray = new String[size];
        this.itemDataArray = new String[size];
        this.itemProportionArray = new String[size];
        DataObject obj = null;
        int last = 60 - MonitorFrame.frame.dataset.linepos - 1;
        long[] lastvalue = null;
        for (int i = 0; i < size; ++i) {
            obj = MonitorFrame.frame.dataset.getItem(i);
            lastvalue = obj.getData();
            this.itemCaptionArray[i] = "[" + MonitorFrame.frame.res.getString(obj.key) + "]";
            this.itemProportionArray[i] = obj.proportion.toString();
            this.itemDataArray[i] = last < 0 ? "" : (obj.keyindex == 31 || obj.keyindex == 32 || obj.keyindex == 33 ? new Long(lastvalue[last]).toString() : (lastvalue[last] < 0L ? "N/A" : new Long(lastvalue[last]).toString()));
        }
    }

    private void writeData(FileWriter fw, boolean byRow, boolean overRow, boolean overDay, int currentTime, boolean fileFormat) {
        String time = GuiUt.convertTimeToStr(currentTime);
        int arraySize = this.itemCaptionArray.length;
        try {
            if (fileFormat) {
                int i;
                if (overRow || overDay || MonitorFrame.frame.isDataRefresh) {
                    MonitorFrame.frame.px.dataRowCount = 0;
                    fw.write(this.paddingString("", ' '));
                    for (i = 0; i < arraySize; ++i) {
                        fw.write(this.paddingString(this.itemCaptionArray[i], ' '));
                    }
                    fw.write("\r\n");
                    fw.write(this.paddingString("=", '='));
                    for (i = 0; i < arraySize; ++i) {
                        fw.write(this.paddingString("=", '='));
                    }
                    fw.write("\r\n");
                }
                fw.write(this.paddingString(time, ' '));
                for (i = 0; i < arraySize; ++i) {
                    fw.write(this.paddingString(this.itemDataArray[i], ' '));
                }
                if (byRow) {
                    MonitorFrame.frame.px.dataRowCount = (short)(MonitorFrame.frame.px.dataRowCount + 1);
                }
                fw.write("\r\n");
            } else {
                if (overRow || overDay || MonitorFrame.frame.isDataRefresh) {
                    MonitorFrame.frame.px.dataRowCount = 0;
                    fw.write(this.paddingString(this.res.getString("Item_Name"), ' '));
                    fw.write(this.paddingString(this.res.getString("Data"), ' '));
                    fw.write(this.paddingString(this.res.getString("Time"), ' '));
                    fw.write("\r\n");
                    fw.write(this.paddingString("=", '='));
                    fw.write(this.paddingString("=", '='));
                    fw.write(this.paddingString("=", '='));
                    fw.write("\r\n");
                }
                for (int i = 0; i < arraySize; ++i) {
                    fw.write(this.paddingString(this.itemCaptionArray[i], ' '));
                    fw.write(this.paddingString(this.itemDataArray[i], ' '));
                    fw.write(this.paddingString(time, ' '));
                    if (byRow) {
                        MonitorFrame.frame.px.dataRowCount = (short)(MonitorFrame.frame.px.dataRowCount + 1);
                        if (MonitorFrame.frame.px.dataRowCount / MonitorFrame.frame.px.getRepaintCaptionEveryRow() == 1 && MonitorFrame.frame.px.dataRowCount % MonitorFrame.frame.px.getRepaintCaptionEveryRow() == 0 && MonitorFrame.frame.px.dataRowCount % arraySize != 0) {
                            MonitorFrame.frame.px.dataRowCount = 0;
                            fw.write("\r\n");
                            fw.write(this.paddingString(this.res.getString("Item_Name"), ' '));
                            fw.write(this.paddingString(this.res.getString("Data"), ' '));
                            fw.write(this.paddingString(this.res.getString("Time"), ' '));
                            fw.write("\r\n");
                            fw.write(this.paddingString("=", '='));
                            fw.write(this.paddingString("=", '='));
                            fw.write(this.paddingString("=", '='));
                        }
                    }
                    fw.write("\r\n");
                }
            }
            if (!byRow) {
                MonitorFrame.frame.px.first_item_time = currentTime;
            }
            if (MonitorFrame.frame.isDataRefresh) {
                MonitorFrame.frame.isDataRefresh = false;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void writing(FileWriter fw) {
        int size = MonitorFrame.frame.dataset.getItemCount();
        Object obj = null;
        String time = frame.getServerTime();
        int currentTime = GuiUt.convertStrToTime(time);
        if (MonitorFrame.frame.px.getViewFormat()) {
            if (MonitorFrame.frame.px.getRepaintCaptionByRow()) {
                short everyRow = MonitorFrame.frame.px.getRepaintCaptionEveryRow();
                if (MonitorFrame.frame.px.dataRowCount / everyRow == 1 && MonitorFrame.frame.px.dataRowCount % everyRow == 0) {
                    this.writeData(fw, true, true, false, currentTime, true);
                } else {
                    this.writeData(fw, true, false, false, currentTime, true);
                }
            } else if (currentTime - MonitorFrame.frame.px.first_item_time < MonitorFrame.frame.px.getRepaintCaptionEveryDay() * 86400) {
                this.writeData(fw, false, false, false, currentTime, true);
            } else {
                this.writeData(fw, false, false, true, currentTime, true);
            }
        } else if (MonitorFrame.frame.px.getRepaintCaptionByRow()) {
            short everyRow = MonitorFrame.frame.px.getRepaintCaptionEveryRow();
            if (MonitorFrame.frame.px.dataRowCount / everyRow == 1 && MonitorFrame.frame.px.dataRowCount % everyRow == 0) {
                this.writeData(fw, true, true, false, currentTime, false);
            } else {
                this.writeData(fw, true, false, false, currentTime, false);
            }
        } else if (currentTime - MonitorFrame.frame.px.first_item_time < MonitorFrame.frame.px.getRepaintCaptionEveryDay() * 86400) {
            this.writeData(fw, false, false, false, currentTime, false);
        } else {
            this.writeData(fw, false, false, true, currentTime, false);
        }
    }
}

