/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import dbaut.GuiUt;
import dbaut.alarm.Alarm;
import dbaut.alarm.Sleeper;
import java.awt.Color;
import java.util.Vector;
import monitor.DataObject;
import monitor.DbmainDef;
import monitor.KeyObject;
import monitor.MonitorFrame;

public class DataSet
implements Sleeper {
    private Vector v = new Vector(5);
    Color background = Color.black;
    Color gridline = new Color(54, 133, 54);
    int gridwidth = 10;
    int rangehi = 100;
    int rangelow = 0;
    int linepos = 0;
    short range = 0;
    private Alarm clock = new Alarm();

    public void cancelTimer() {
        this.clock.cancelAlarm(this);
    }

    public void setTimer() {
        this.clock.cancelAlarm(this);
        if (this.range == 0) {
            this.clock.setAlarm(this, 5L);
        } else if (this.range == 1) {
            this.clock.setAlarm(this, 120L);
        } else if (this.range == 2) {
            this.clock.setAlarm(this, 3600L);
        } else if (this.range == 3) {
            this.clock.setAlarm(this, 86400L);
        }
    }

    public int getItemCount() {
        return this.v.size();
    }

    public Vector getItemVector() {
        return this.v;
    }

    public DataObject getItem(int index) {
        return (DataObject)this.v.elementAt(index);
    }

    public void removeItem(int index) {
        DataObject obj = (DataObject)this.v.elementAt(index);
        KeyObject kobj = DbmainDef.keys[obj.keyindex];
        kobj.isEnable = true;
        this.v.removeElementAt(index);
    }

    public void addItem(DataObject obj) {
        KeyObject kobj = DbmainDef.keys[obj.keyindex];
        kobj.isEnable = false;
        this.v.addElement(obj);
    }

    public void clearData() {
        DataObject obj = null;
        int size = this.v.size();
        for (int i = 0; i < size; ++i) {
            obj = (DataObject)this.v.elementAt(i);
            obj.clear();
        }
    }

    public int getAscNumber() {
        switch (this.range) {
            case 0: {
                return 5;
            }
            case 1: {
                return 2;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return 1;
    }

    @Override
    public synchronized void wakeUp() {
        int size = this.v.size();
        DataObject obj = null;
        for (int i = 0; i < size; ++i) {
            obj = (DataObject)this.v.elementAt(i);
            if (obj.update()) continue;
            return;
        }
        if (MonitorFrame.frame != null) {
            if (MonitorFrame.frame.px.getExportMonitorItem2ExternalFile() && MonitorFrame.frame.px.first_item_time == 0) {
                MonitorFrame.frame.px.first_item_time = GuiUt.convertStrToTime(MonitorFrame.frame.getServerTime());
            }
            if (MonitorFrame.frame.px.getExportMonitorItem2ExternalFile() && size > 0) {
                MonitorFrame.frame.writeDataIntoFile();
            }
            MonitorFrame.frame.repaint();
        }
    }
}

