/*
 * Decompiled with CFR 0.152.
 */
package framework.jconfig;

import DmEditor.Preferences.Preferences;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.locale.LocaleManager;
import dbaut.preference.CorePreferences;
import framework.SystemUt;
import org.fest.swing.fixture.DialogFixture;
import org.fest.swing.fixture.FrameFixture;
import org.fest.swing.fixture.JButtonFixture;
import org.fest.swing.fixture.JPanelFixture;
import org.fest.swing.fixture.JTabbedPaneFixture;

public class DmconfigUt {
    public static final String dbdir = "." + SystemUt.getFileSeparator() + "db";
    public static final String dbName = "DMCONFIGDB";
    public static final String userName = "SYSADM";
    public static final String password = "";
    public static final String config = "dmconfig.ini";
    public static final String rootPath = "dmconfig.ini";
    public static final String defaultPath = "dmconfig.ini/DMCONFIGDB";
    public static final int CONNECTION = 0;
    public static final int DMSERVER = 1;
    public static final int DATA_MANIPULATION = 2;
    public static final int SQL_ATTRIBUTES = 3;
    public static final int DDB_ENVIRONMENT = 4;
    public static final int GROUP_COMMITTED = 5;
    public static final int STORAGE1 = 6;
    public static final int STORAGE2 = 7;
    public static final int CACHE_CONTROL = 8;
    public static final int BACKUP = 9;
    public static final int REPLICATION = 10;
    public static final int START_DB = 11;
    public static final int CREATE_DB = 12;
    public static final int USER_FILES = 13;
    public static final int LOG_SYSTEM = 14;
    public static final int CHARSET_ENCODING = 15;
    public static final int STATISTICS = 16;

    public static synchronized void insertNewSection(String dbName) {
        String testHome = SystemUt.getTestDBHome();
        JdmConfig config = new JdmConfig();
        String str = config.filePath("dmconfig.ini");
        System.out.println(str);
        int rc = config.create("dmconfig.ini", dbName);
        if (rc != 0) {
            System.out.println("create new section " + dbName + " failed in file " + str + " !");
            return;
        }
        rc = config.fileOpen("dmconfig.ini", dbName, "r+");
        config.insertPara("DB_DBDIR", testHome, 4096);
        config.fileClose();
    }

    public static synchronized void init() {
        CorePreferences cp = CorePreferences.getCorePreferences();
        LocaleManager.getLocaleManager(cp.getLanguageChoice());
        GuiUt.initFont();
        Preferences.initialPrefereces();
    }

    public static synchronized void activeRootPanel(FrameFixture frame) {
        frame.tree("DmConfigTree").selectPath("dmconfig.ini");
    }

    public static synchronized void activePanel(FrameFixture frame, int index) {
        frame.tree("DmConfigTree").selectPath(defaultPath);
        JTabbedPaneFixture tabbedPane = frame.tabbedPane("DetailInfoTabbedPane");
        tabbedPane.requireVisible();
        tabbedPane.requireEnabled();
        tabbedPane.selectTab(index);
    }

    public static synchronized void save(FrameFixture frame) {
        JPanelFixture dpp = frame.panel("DetailParentPanel");
        JButtonFixture b = dpp.button("SaveButton");
        b.requireEnabled();
        b.click();
        DialogFixture df = frame.dialog("ShowInformationDialog");
        df.requireVisible();
        df.button("OKButton").requireEnabled();
        df.button("OKButton").click();
    }

    public static synchronized void reset(FrameFixture frame) {
        JPanelFixture dpp = frame.panel("DetailParentPanel");
        JButtonFixture b = dpp.button("ResetButton");
        b.requireEnabled();
        b.click();
        DialogFixture df = frame.dialog("ShowInformationDialog");
        df.requireVisible();
        df.button("OKButton").requireEnabled();
        df.button("OKButton").click();
    }
}

