/*
 * Decompiled with CFR 0.152.
 */
package executionPlan;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class SaveAsJpg {
    private static final int[] RGB_MASKS = new int[]{0xFF0000, 65280, 255};
    private static final ColorModel colorMD = new DirectColorModel(32, RGB_MASKS[0], RGB_MASKS[1], RGB_MASKS[2]);

    public static void componentToImage(JPanel panel, String path) {
        BufferedImage img = null;
        img = new BufferedImage(panel.getWidth(), panel.getHeight(), 4);
        Graphics2D g2d = (Graphics2D)img.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        panel.paintAll(g2d);
        SaveAsJpg.saveAs(img, path);
    }

    public static void saveAs(Image img, String path) {
        PixelGrabber pg = new PixelGrabber(img, 0, 0, -1, -1, true);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int width = pg.getWidth();
        int height = pg.getHeight();
        DataBufferInt buffer = new DataBufferInt((int[])pg.getPixels(), width * height);
        WritableRaster raster = Raster.createPackedRaster(buffer, width, height, width, RGB_MASKS, null);
        BufferedImage bi = new BufferedImage(colorMD, raster, false, null);
        try {
            ImageIO.write((RenderedImage)bi, "png", new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

