/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importODBC;

import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.CheckingStatusRenderer;
import dbaut.CommonUt.EmptyPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.alarm.Alarm2;
import dbaut.alarm.Sleeper;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importODBC.ForeignKeyInfo;
import dttwizard.importODBC.odbcDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ForeignKeyProcess
extends AbstractWizardPanel
implements Sleeper {
    private static final long serialVersionUID = 4647430821231493167L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportOdbcRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_foreignkeyprocess");
    private odbcDialog odbcdlg = null;
    private AbstractWizardPanel previous = null;
    private DbaButton next_Button = new DbaButton(this.res.getString("Done"), 'D', new ReflectionAction(this, "next_Button_actionPerformed"));
    private ForeignKeyTableModel tableModel = new ForeignKeyTableModel();
    JTable viewTable = new JTable(this.tableModel);
    ArrayList<ForeignKeyInfo> list = null;
    private Alarm2 clock = null;

    public ForeignKeyProcess(odbcDialog odbcdlg, AbstractWizardPanel previous, ArrayList<ForeignKeyInfo> list) {
        try {
            this.odbcdlg = odbcdlg;
            this.previous = previous;
            this.list = list;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton back_Button = new DbaButton(this.res.getString("Previous"), 'P', new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString(""));
        JScrollPane jscroll2 = new JScrollPane(this.viewTable);
        back_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"));
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        jscroll2.setVerticalScrollBarPolicy(20);
        this.viewTable.setBorder(BorderFactory.createLoweredBevelBorder());
        this.viewTable.setRowHeight(24);
        JPanel panel4 = new JPanel(new FlowLayout(2));
        panel4.add(back_Button);
        panel4.add(this.next_Button);
        panel4.add(new EmptyPanel());
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        JPanel panel10 = new JPanel(new FlowLayout(0));
        panel10.add(new EmptyPanel(new Dimension(160, 0)));
        JPanel panel6 = new JPanel(new BorderLayout());
        panel6.add((Component)jscroll2, "Center");
        panel6.add((Component)panel10, "South");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportODBC.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportODBC_from_tables", null);
        TableColumnModel tcsourceTableModel = this.viewTable.getColumnModel();
        TableColumn col = tcsourceTableModel.getColumn(0);
        col.setPreferredWidth(50);
        col.setCellRenderer(new CheckingStatusRenderer());
        col = tcsourceTableModel.getColumn(1);
        col.setPreferredWidth(200);
        col = tcsourceTableModel.getColumn(2);
        col.setPreferredWidth(100);
        col = tcsourceTableModel.getColumn(3);
        col.setPreferredWidth(200);
        this.clock = new Alarm2();
        this.setTimer();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.next_Button.setEnabled(false);
    }

    public void setTimer() {
        this.clock.cancelAlarm(this);
        this.clock.setAlarm(this, 1L);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.dispose();
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.dispose();
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.Next(this.previous);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private void doJob() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Connection conn = this.odbcdlg.destinationConnection.getDbConnection();
        try {
            Statement stmt = conn.createStatement();
            for (ForeignKeyInfo info : this.list) {
                String sql = "alter table ";
                if (info.fkTable_Schema != null) {
                    sql = sql + GuiUt.getIDString(info.fkTable_Schema) + ".";
                }
                sql = sql + GuiUt.getIDString(info.fkTable_Name);
                sql = sql + " foreign key ";
                sql = sql + GuiUt.getIDString(info.fkName);
                sql = sql + "(";
                boolean first = true;
                for (String column : info.fkTable_Columns) {
                    if (first) {
                        sql = sql + column;
                        first = false;
                        continue;
                    }
                    sql = sql + "," + column;
                }
                sql = sql + ")";
                sql = sql + " references ";
                if (info.pkTable_Schema != null) {
                    sql = sql + GuiUt.getIDString(info.pkTable_Schema) + ".";
                }
                sql = sql + GuiUt.getIDString(info.pkTable_Name);
                sql = sql + "(";
                first = true;
                for (String column : info.pkTable_Columns) {
                    if (first) {
                        sql = sql + column;
                        first = false;
                        continue;
                    }
                    sql = sql + "," + column;
                }
                sql = sql + ")";
                switch (info.updateRule) {
                    default: {
                        sql = sql + " on update NO ACTION ";
                        break;
                    }
                    case 0: {
                        sql = sql + " on update CASCADE ";
                        break;
                    }
                    case 2: {
                        sql = sql + " on update SET NULL ";
                        break;
                    }
                    case 4: {
                        sql = sql + " on update SET DEFAULT ";
                    }
                }
                switch (info.deleteRule) {
                    default: {
                        sql = sql + " on delete NO ACTION ";
                        break;
                    }
                    case 0: {
                        sql = sql + " on delete CASCADE ";
                        break;
                    }
                    case 2: {
                        sql = sql + " on delete SET NULL ";
                        break;
                    }
                    case 4: {
                        sql = sql + " on delete SET DEFAULT ";
                    }
                }
                try {
                    stmt.executeUpdate(sql);
                    info.result.value = 2;
                }
                catch (SQLException e) {
                    info.result.value = 4;
                    info.result.message = sql + e.getMessage();
                    System.out.println(info.result.message);
                }
                this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel));
            }
            stmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.next_Button.setEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public synchronized void wakeUp() {
        this.clock.cancelAlarm(this);
        this.doJob();
        if (this.list.size() <= 0) {
            if (this.odbcdlg.sourceConnection != null && this.odbcdlg.sourceConnection.isConnected()) {
                this.odbcdlg.sourceConnection.disconnect();
            }
            if (this.odbcdlg.destinationConnection != null && this.odbcdlg.destinationConnection.isConnected()) {
                this.odbcdlg.destinationConnection.disconnect();
            }
            this.odbcdlg.sourceConnection = null;
            this.odbcdlg.destinationConnection = null;
        }
    }

    class ForeignKeyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4663280698331513717L;
        private String[] header;

        public ForeignKeyTableModel() {
            this.header = new String[]{"", ForeignKeyProcess.this.res.getString("Table_Name"), ForeignKeyProcess.this.res.getString("FK_Name"), ForeignKeyProcess.this.res.getString("Referenced_Table"), ForeignKeyProcess.this.res.getString("Referenced_Column"), ForeignKeyProcess.this.res.getString("Update_Rule"), ForeignKeyProcess.this.res.getString("Delete_Rule")};
        }

        @Override
        public String getColumnName(int col) {
            return this.header[col];
        }

        @Override
        public int getColumnCount() {
            return this.header.length;
        }

        @Override
        public int getRowCount() {
            return ForeignKeyProcess.this.list.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ForeignKeyInfo info = ForeignKeyProcess.this.list.get(row);
            return info.get2(col);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }
    }
}

