/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importODBC;

import com.borland.jbcl.layout.VerticalFlowLayout;
import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import datatransfer.dttlib;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.CheckingStatusRenderer;
import dbaut.CommonUt.ColumnTableModel;
import dbaut.CommonUt.DetailDialog;
import dbaut.CommonUt.WizardTextArea;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.SunCommonDatabaseConnection;
import dbaut.SyscomCommonDatabaseConnection;
import dbaut.alarm.Alarm2;
import dbaut.alarm.Sleeper;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.infoObject.TableInfoObject;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importODBC.ColumnMapTransfer;
import dttwizard.importODBC.ForeignKeyInfo;
import dttwizard.importODBC.ForeignKeyView;
import dttwizard.importODBC.IndexInfo;
import dttwizard.importODBC.LogDialog;
import dttwizard.importODBC.PrimaryKeyInfo;
import dttwizard.importODBC.PrimaryKeyView;
import dttwizard.importODBC.QueryObject;
import dttwizard.importODBC.SourceTableView;
import dttwizard.importODBC.SqlQueryStatement;
import dttwizard.importODBC.odbcDialog;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DetailInfo
extends AbstractWizardPanel
implements Sleeper {
    private static final long serialVersionUID = -2858044034514777494L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportOdbcRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_ImportStatus");
    private odbcDialog odbcdlg = null;
    private AbstractWizardPanel previous = null;
    private SourceTableView stv = null;
    private SqlQueryStatement sqs = null;
    private DbaButton viewLogButton = new DbaButton(this.res.getString("View_log"), 'V', new ReflectionAction(this, "viewLogButton_actionPerformed"));
    private DbaButton next_Button = new DbaButton(this.res.getString("Done"), 'D', new ReflectionAction(this, "next_Button_actionPerformed"));
    private String[] header = new String[]{this.res.getString("Status"), this.res.getString("Source_table_view"), this.res.getString("Destination_Table")};
    private ColumnTableModel columnTableModel = new ColumnTableModel(this.header);
    private JTable runStatusTable = new JTable(this.columnTableModel);
    private Alarm2 clock = null;
    private ArrayList<PrimaryKeyInfo> pkList = new ArrayList();
    private ArrayList<ForeignKeyInfo> fkList = new ArrayList();
    private ArrayList<IndexInfo> indexList = new ArrayList();

    public DetailInfo(odbcDialog odbcdlg, AbstractWizardPanel previous) {
        try {
            this.odbcdlg = odbcdlg;
            this.previous = previous;
            switch (odbcdlg.flowType) {
                case 0: {
                    this.stv = (SourceTableView)previous;
                    break;
                }
                case 1: {
                    this.sqs = (SqlQueryStatement)previous;
                    break;
                }
                case 2: {
                    if (previous instanceof SourceTableView) {
                        this.stv = (SourceTableView)previous;
                        break;
                    }
                    this.sqs = (SqlQueryStatement)previous;
                }
            }
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton back_Button = new DbaButton(this.res.getString("Previous"), 'P', new ReflectionAction(this, "back_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel panel7 = new JPanel();
        JPanel panel10 = new JPanel(new FlowLayout(0));
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Please_check_dtterror"));
        JScrollPane jscroll2 = new JScrollPane(this.runStatusTable);
        this.next_Button.setHorizontalTextPosition(2);
        this.viewLogButton.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/view_log.gif"));
        this.next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/done.gif"));
        back_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"));
        panel7.setPreferredSize(new Dimension(80, 0));
        panel7.setBorder(null);
        jscroll2.setBorder(null);
        jscroll2.setPreferredSize(new Dimension(480, 250));
        jscroll2.setVerticalScrollBarPolicy(20);
        this.runStatusTable.setRowHeight(24);
        panel4.add(back_Button);
        panel4.add(this.next_Button);
        panel4.add(panel7);
        panel4.add(help_Button);
        panel10.add(this.viewLogButton);
        panel6.add(jscroll2);
        panel6.add(panel10);
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportODBC.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportODBC_DetailInfo", null);
        TableColumnModel tcmodel = this.runStatusTable.getColumnModel();
        TableColumn col = tcmodel.getColumn(0);
        col.setPreferredWidth(50);
        col.setCellRenderer(new CheckingStatusRenderer());
        col = tcmodel.getColumn(1);
        col.setPreferredWidth(200);
        col = tcmodel.getColumn(2);
        col.setPreferredWidth(200);
        this.columnTableModel.fireTableChanged(new TableModelEvent(this.columnTableModel));
        this.setCursor(Cursor.getPredefinedCursor(3));
        switch (this.odbcdlg.flowType) {
            case 0: {
                this.assignTableFromSourceTableView();
                break;
            }
            case 1: {
                this.assignTableFromSqlQueryStatement();
                break;
            }
            case 2: {
                if (this.stv != null && this.sqs == null) {
                    this.assignTableFromSourceTableView();
                    break;
                }
                if (this.stv != null || this.sqs == null) break;
                this.assignTableFromSqlQueryStatement();
            }
        }
        this.clock = new Alarm2();
        this.setTimer();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.next_Button.setEnabled(false);
    }

    private void doJob() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        switch (this.odbcdlg.flowType) {
            case 0: {
                this.runImportResultForSourceTableView();
                break;
            }
            case 1: {
                this.runImportResultForSqlQueryStatement();
                break;
            }
            case 2: {
                if (this.stv != null && this.sqs == null) {
                    this.runImportResultForSourceTableView();
                    break;
                }
                if (this.stv != null || this.sqs == null) break;
                this.runImportResultForSqlQueryStatement();
            }
        }
        this.viewLogButton.setEnabled(this.setViewLogButtonStatus());
        this.next_Button.setEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    boolean setViewLogButtonStatus() {
        int rowCount = this.runStatusTable.getRowCount();
        boolean b = false;
        for (int i = 0; i < rowCount; ++i) {
            int status = (Integer)this.runStatusTable.getValueAt(i, 0);
            if (status == 2) {
                b = false;
                continue;
            }
            if (status != 4) continue;
            b = true;
            break;
        }
        return b;
    }

    public void assignTableFromSourceTableView() {
        int rowCount = this.stv.sourceTableViewTable.getRowCount();
        Boolean objB = null;
        TableInfoObject stio = null;
        TableInfoObject dtio = null;
        for (int i = 0; i < rowCount; ++i) {
            objB = (Boolean)this.stv.sourceTableViewTable.getValueAt(i, 0);
            if (!objB.booleanValue()) continue;
            stio = (TableInfoObject)this.stv.sourceTableViewTable.getValueAt(i, 1);
            dtio = (TableInfoObject)this.stv.sourceTableViewTable.getValueAt(i, 2);
            Object[] objA = new Object[]{new Integer(0), stio.toString(), dtio.toString()};
            this.columnTableModel.addValue(objA);
        }
    }

    public void assignTableFromSqlQueryStatement() {
        int rowCount = this.sqs.sqlQueryModel.getRowCount();
        QueryObject sqo = null;
        TableInfoObject dtio = null;
        for (int i = 0; i < rowCount; ++i) {
            sqo = (QueryObject)this.sqs.sqlQueryModel.getValueAt(i, 0);
            dtio = (TableInfoObject)this.sqs.sqlQueryModel.getValueAt(i, 1);
            Object[] objA = new Object[]{new Integer(0), sqo.toString(), dtio.toString()};
            this.columnTableModel.addValue(objA);
        }
    }

    public void runImportResultForSqlQueryStatement() {
        int rowCount = this.sqs.sqlQueryModel.getRowCount();
        ColumnMapTransfer cmt = null;
        QueryObject sqo = null;
        TableInfoObject dtio = null;
        dttlib lib = new dttlib();
        String sqlStr = "";
        int statusCount = 0;
        File dtterrfile = new File("DTTERROR.LOG");
        System.out.println("DTTERROR.LOG exists() = " + dtterrfile.exists());
        if (dtterrfile.delete()) {
            System.out.println(dtterrfile.getAbsolutePath() + " is deleted!");
        }
        for (int i = 0; i < rowCount; ++i) {
            sqo = (QueryObject)this.sqs.sqlQueryModel.getValueAt(i, 0);
            dtio = (TableInfoObject)this.sqs.sqlQueryModel.getValueAt(i, 1);
            cmt = (ColumnMapTransfer)this.sqs.sqlQueryModel.getValueAt(i, 2);
            if (cmt == null) {
                DetailDialog ddlg = new DetailDialog(this.odbcdlg, true);
                if (dtio.owner.length() == 0 && dtio.name.length() != 0) {
                    cmt = new ColumnMapTransfer(ddlg, this.odbcdlg, sqo, dtio, true, true);
                    this.sqs.sqlQueryModel.setValueAt(cmt, i, 2);
                } else {
                    cmt = new ColumnMapTransfer(ddlg, this.odbcdlg, sqo, dtio, false, true);
                    this.sqs.sqlQueryModel.setValueAt(cmt, i, 2);
                }
            }
            Statement stmt = null;
            if (cmt.create_RadioButton.isSelected()) {
                try {
                    stmt = this.odbcdlg.destinationConnection.getDbConnection().createStatement();
                    sqlStr = cmt.getCreateStr();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    stmt.execute(sqlStr);
                    DbaObject.close(stmt);
                    stmt = null;
                }
                catch (SQLException sqle) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    DbaObject.close(stmt);
                    GuiUt.showSQLException(this.odbcdlg, null, sqle);
                }
            } else if (cmt.delete_RadioButton.isSelected()) {
                try {
                    sqlStr = "delete from " + cmt.destinationTableInfo_TextField.getText();
                    stmt = this.odbcdlg.destinationConnection.getDbConnection().createStatement();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    stmt.execute(sqlStr);
                    DbaObject.close(stmt);
                    stmt = null;
                }
                catch (SQLException sqle) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    DbaObject.close(stmt);
                    GuiUt.showSQLException(this.odbcdlg, null, sqle);
                }
            } else if (!cmt.append_RadioButton.isSelected()) {
                try {
                    sqlStr = "drop table " + cmt.destinationTableInfo_TextField.getText();
                    stmt = this.odbcdlg.destinationConnection.getDbConnection().createStatement();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    stmt.execute(sqlStr);
                    DbaObject.close(stmt);
                    stmt = null;
                    sqlStr = cmt.getCreateStr();
                    stmt = this.odbcdlg.destinationConnection.getDbConnection().createStatement();
                    stmt.execute(sqlStr);
                    DbaObject.close(stmt);
                    stmt = null;
                }
                catch (SQLException sqle) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    DbaObject.close(stmt);
                    GuiUt.showSQLException(this.odbcdlg, null, sqle);
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            int result = 0;
            if (this.odbcdlg.sourceConnection != null && this.odbcdlg.sourceConnection.isConnected()) {
                this.odbcdlg.sourceConnection.disconnect();
                this.odbcdlg.sourceConnection = null;
            }
            if (this.odbcdlg.destinationConnection != null && this.odbcdlg.destinationConnection.isConnected()) {
                this.odbcdlg.destinationConnection.disconnect();
                this.odbcdlg.destinationConnection = null;
            }
            if ((result = lib.importODBC(this.odbcdlg.sourceDbName.getBytes(), this.odbcdlg.sourceUserID.getBytes(), this.odbcdlg.sourcePasswd.getBytes(), cmt.getSelectStr().getBytes(), this.odbcdlg.destinationDbName.getBytes(), this.odbcdlg.destinationUserID.getBytes(), this.odbcdlg.destinationPasswd.getBytes(), cmt.getInsertStr().getBytes(), new String("DTTERROR.LOG").getBytes(), 0L)) == 0) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.columnTableModel.setValueAt(new Integer(2), statusCount++, 0);
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.columnTableModel.setValueAt(new Integer(4), statusCount++, 0);
            }
            this.runStatusTable.editingStopped(null);
            this.columnTableModel.fireTableChanged(new TableModelEvent(this.columnTableModel));
            this.odbcdlg.destinationConnection = new SyscomCommonDatabaseConnection(this.odbcdlg.destinationDbName, this.odbcdlg.destinationUserID, this.odbcdlg.destinationPasswd, this.odbcdlg);
            this.odbcdlg.sourceConnection = new SunCommonDatabaseConnection(this.odbcdlg.sourceDbName, this.odbcdlg.sourceUserID, this.odbcdlg.sourcePasswd, this.odbcdlg);
        }
    }

    public void runImportResultForSourceTableView() {
        int rowCount = this.stv.sourceTableViewTable.getRowCount();
        ColumnMapTransfer cmt = null;
        Boolean objB = null;
        TableInfoObject stio = null;
        TableInfoObject dtio = null;
        dttlib lib = new dttlib();
        String sqlStr = "";
        File dtterrfile = new File("DTTERROR.LOG");
        System.out.println("DTTERROR.LOG exists() = " + dtterrfile.exists());
        if (dtterrfile.delete()) {
            System.out.println(dtterrfile.getAbsolutePath() + " is deleted!");
        }
        int statusCount = 0;
        for (int i = 0; i < rowCount; ++i) {
            objB = (Boolean)this.stv.sourceTableViewTable.getValueAt(i, 0);
            if (!objB.booleanValue()) continue;
            stio = (TableInfoObject)this.stv.sourceTableViewTable.getValueAt(i, 1);
            dtio = (TableInfoObject)this.stv.sourceTableViewTable.getValueAt(i, 2);
            cmt = (ColumnMapTransfer)this.stv.sourceTableViewTable.getValueAt(i, 3);
            if (cmt == null) {
                DetailDialog ddlg = new DetailDialog(this.odbcdlg, true);
                cmt = dtio.owner.length() == 0 && dtio.name.length() != 0 ? new ColumnMapTransfer(ddlg, this.odbcdlg, stio, dtio, true, false) : new ColumnMapTransfer(ddlg, this.odbcdlg, stio, dtio, false, false);
            }
            Statement stmt = null;
            if (cmt.create_RadioButton.isSelected()) {
                try {
                    ArrayList<ForeignKeyInfo> fkinfo;
                    ArrayList<IndexInfo> idxInfo;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    stmt = this.odbcdlg.destinationConnection.getDbConnection().createStatement();
                    sqlStr = cmt.getCreateStr();
                    stmt.execute(sqlStr);
                    DbaObject.close(stmt);
                    stmt = null;
                    PrimaryKeyInfo info = cmt.getPrimaryKeyInfo();
                    if (info != null) {
                        this.pkList.add(info);
                    }
                    if ((idxInfo = cmt.getIndexInfo()) != null && idxInfo.size() > 0) {
                        this.indexList.addAll(idxInfo);
                    }
                    if ((fkinfo = cmt.getForeignKeyInfo()) != null) {
                        this.fkList.addAll(fkinfo);
                    }
                }
                catch (SQLException sqle) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    DbaObject.close(stmt);
                    GuiUt.showSQLException(this.odbcdlg, null, sqle);
                }
            } else if (cmt.delete_RadioButton.isSelected()) {
                try {
                    sqlStr = "delete from " + cmt.destinationTableInfo_TextField.getText();
                    stmt = this.odbcdlg.destinationConnection.getDbConnection().createStatement();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    stmt.execute(sqlStr);
                    DbaObject.close(stmt);
                    stmt = null;
                }
                catch (SQLException sqle) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    DbaObject.close(stmt);
                    GuiUt.showSQLException(this.odbcdlg, null, sqle);
                }
            } else if (!cmt.append_RadioButton.isSelected()) {
                try {
                    sqlStr = "drop table " + cmt.destinationTableInfo_TextField.getText();
                    stmt = this.odbcdlg.destinationConnection.getDbConnection().createStatement();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    stmt.execute(sqlStr);
                    DbaObject.close(stmt);
                    stmt = null;
                    sqlStr = cmt.getCreateStr();
                    stmt = this.odbcdlg.destinationConnection.getDbConnection().createStatement();
                    stmt.execute(sqlStr);
                    DbaObject.close(stmt);
                    stmt = null;
                }
                catch (SQLException sqle) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    DbaObject.close(stmt);
                    GuiUt.showSQLException(this.odbcdlg, null, sqle);
                }
            }
            int result = 0;
            String ss = cmt.getInsertStr();
            if (this.odbcdlg.sourceConnection != null && this.odbcdlg.sourceConnection.isConnected()) {
                this.odbcdlg.sourceConnection.disconnect();
                this.odbcdlg.sourceConnection = null;
            }
            if (this.odbcdlg.destinationConnection != null && this.odbcdlg.destinationConnection.isConnected()) {
                this.odbcdlg.destinationConnection.disconnect();
                this.odbcdlg.destinationConnection = null;
            }
            System.out.println(" cmt.getSelectStr() = " + cmt.getSelectStr());
            this.setCursor(Cursor.getPredefinedCursor(3));
            result = lib.importODBC(this.odbcdlg.sourceDbName.getBytes(), this.odbcdlg.sourceUserID.getBytes(), this.odbcdlg.sourcePasswd.getBytes(), cmt.getSelectStr().getBytes(), this.odbcdlg.destinationDbName.getBytes(), this.odbcdlg.destinationUserID.getBytes(), this.odbcdlg.destinationPasswd.getBytes(), ss.getBytes(), new String("DTTERROR.LOG").getBytes(), 0L);
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (result == 0) {
                this.columnTableModel.setValueAt(new Integer(2), statusCount++, 0);
            } else {
                this.columnTableModel.setValueAt(new Integer(4), statusCount++, 0);
            }
            this.runStatusTable.editingStopped(null);
            this.columnTableModel.fireTableChanged(new TableModelEvent(this.columnTableModel));
            this.odbcdlg.destinationConnection = new SyscomCommonDatabaseConnection(this.odbcdlg.destinationDbName, this.odbcdlg.destinationUserID, this.odbcdlg.destinationPasswd, this.odbcdlg);
            this.odbcdlg.sourceConnection = new SunCommonDatabaseConnection(this.odbcdlg.sourceDbName, this.odbcdlg.sourceUserID, this.odbcdlg.sourcePasswd, this.odbcdlg);
            if (!this.odbcdlg.sourceConnection.isConnected()) break;
        }
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        if (this.pkList.size() > 0 || this.indexList.size() > 0) {
            this.odbcdlg.Next(new PrimaryKeyView(this.odbcdlg, this.pkList, this.indexList, this.fkList));
        } else if (this.fkList.size() > 0) {
            this.odbcdlg.Next(new ForeignKeyView(this.odbcdlg, this.fkList));
        } else {
            this.odbcdlg.dispose();
        }
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        if (this.odbcdlg.sourceConnection != null && this.odbcdlg.sourceConnection.isConnected()) {
            this.odbcdlg.sourceConnection.disconnect();
        }
        if (this.odbcdlg.destinationConnection != null && this.odbcdlg.destinationConnection.isConnected()) {
            this.odbcdlg.destinationConnection.disconnect();
        }
        this.odbcdlg.destinationConnection = new SyscomCommonDatabaseConnection(this.odbcdlg.destinationDbName, this.odbcdlg.destinationUserID, this.odbcdlg.destinationPasswd, this.odbcdlg);
        this.odbcdlg.sourceConnection = new SunCommonDatabaseConnection(this.odbcdlg.sourceDbName, this.odbcdlg.sourceUserID, this.odbcdlg.sourcePasswd, this.odbcdlg);
        this.odbcdlg.Next(this.previous);
    }

    public void viewLogButton_actionPerformed(ActionEvent e) {
        LogDialog logdlg = new LogDialog(this.odbcdlg, true);
        logdlg.setVisible(true);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTimer() {
        this.clock.cancelAlarm(this);
        this.clock.setAlarm(this, 1L);
    }

    @Override
    public synchronized void wakeUp() {
        this.clock.cancelAlarm(this);
        this.doJob();
        if (this.pkList.size() > 0 || this.fkList.size() > 0) {
            this.next_Button.setText(this.res.getString("Next"));
            this.next_Button.setMnemonic('N');
            this.next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"));
        } else {
            if (this.odbcdlg.sourceConnection != null && this.odbcdlg.sourceConnection.isConnected()) {
                this.odbcdlg.sourceConnection.disconnect();
            }
            if (this.odbcdlg.destinationConnection != null && this.odbcdlg.destinationConnection.isConnected()) {
                this.odbcdlg.destinationConnection.disconnect();
            }
            this.odbcdlg.sourceConnection = null;
            this.odbcdlg.destinationConnection = null;
        }
    }
}

