/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importJson;

import dbaut.DbaObject;
import dbaut.GuiUt;
import dttwizard.importJson.ImJsonDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;

public class CustomComboBoxEditor
extends DefaultCellEditor
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private DefaultComboBoxModel model = (DefaultComboBoxModel)((JComboBox)this.getComponent()).getModel();
    private ImJsonDialog imt = null;
    private JComboBox combo = null;
    ArrayList<String> typeList = null;
    private String selectedType = "";
    private JTable table;
    private int row;

    public CustomComboBoxEditor(ImJsonDialog imt) {
        super(new JComboBox());
        this.imt = imt;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.typeList = this.generateDataType();
        Iterator<String> it = this.typeList.iterator();
        while (it.hasNext()) {
            this.model.addElement(it.next());
        }
        this.table = table;
        this.row = row;
        this.combo = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        this.combo.addActionListener(this);
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    private ArrayList<String> generateDataType() {
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<String> bx = new ArrayList<String>();
        try {
            stmt = this.imt.connection.getDbConnection().createStatement();
            String query = "select TYPE_NAME from SYSTEM.SYSTYPEINFO";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                bx.add(rs.getString(1).trim());
            }
            DbaObject.close(rs);
            String queryDomain = "select DOMAIN_NAME from SYSTEM.SYSDOMAIN ORDER BY DOMAIN_NAME";
            rs = stmt.executeQuery(queryDomain);
            while (rs.next()) {
                bx.add(rs.getString(1).trim());
            }
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.imt, null, sqle);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        return bx;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.selectedType = this.combo.getSelectedItem().toString().trim().toLowerCase();
        if (this.table.getModel().getValueAt(this.row, 2).toString().trim().equalsIgnoreCase(this.selectedType)) {
            return;
        }
        if (this.selectedType.equals("smallint") || this.selectedType.equals("integer") || this.selectedType.equals("bigint") || this.selectedType.equals("real") || this.selectedType.equals("double") || this.selectedType.equals("date") || this.selectedType.equals("time") || this.selectedType.equals("oid") || this.selectedType.equals("timestamp") || this.selectedType.equals("file") || this.selectedType.equals("long varbinary") || this.selectedType.equals("long varchar") || this.selectedType.equals("serial") || this.selectedType.equals("bigserial") || this.selectedType.equals("nclob") || this.selectedType.equals("clob") || this.selectedType.equalsIgnoreCase("blob")) {
            this.table.getModel().setValueAt("", this.row, 3);
            this.table.getModel().setValueAt("", this.row, 4);
        } else if (this.selectedType.equals("decimal")) {
            this.table.getModel().setValueAt("17", this.row, 3);
            this.table.getModel().setValueAt("6", this.row, 4);
        } else if (this.selectedType.equals("char") || this.selectedType.equals("binary") || this.selectedType.equals("varchar") || this.selectedType.equals("nchar") || this.selectedType.equals("nvarchar")) {
            this.table.getModel().setValueAt("255", this.row, 3);
            this.table.getModel().setValueAt("", this.row, 4);
        } else {
            this.table.getModel().setValueAt("", this.row, 3);
            this.table.getModel().setValueAt("", this.row, 4);
        }
    }
}

