/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.exportXML;

import com.borland.jbcl.layout.VerticalFlowLayout;
import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import datatransfer.dttlib;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.JdmConfig;
import dbaut.SyscomCommonDatabaseConnection;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.textField.CharPasswordField;
import dbaut.util.PlatformUtil;
import dttwizard.exportXML.CopyOrQuery;
import dttwizard.exportXML.ExXmlDialog;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChooseDataSource
extends AbstractWizardPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Export.dtt_ExportXmlRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_ChooseDataSource");
    private ExXmlDialog exx = null;
    private AbstractWizardPanel next1 = null;
    private AbstractWizardPanel previous = null;
    private CharField userName_TextField = new CharField(128, true);
    private CharPasswordField password_TextField = new CharPasswordField(16, true);
    private SteppedComboBox databaseName_ComboBox = new SteppedComboBox();
    private DbaButton next_Button = new DbaButton(this.res.getString("Next"), 'N', new ReflectionAction(this, "next_Button_actionPerformed"));

    public ChooseDataSource(ExXmlDialog exx, AbstractWizardPanel previous) {
        try {
            this.exx = exx;
            this.previous = previous;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton back_Button = new DbaButton(this.res.getString("Previous"), 'P', new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel panel7 = new JPanel();
        JPanel panel8 = new JPanel(new FlowLayout(0));
        JPanel panel9 = new JPanel(new FlowLayout(0));
        JPanel panel10 = new JPanel(new FlowLayout(0));
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Data_source_is_one"));
        JLabel jlabel3 = new JLabel(this.res.getString("Database"));
        JLabel jlabel4 = new JLabel(this.res.getString("User_name"));
        JLabel jlabel5 = new JLabel(this.res.getString("Password"));
        this.next_Button.setHorizontalTextPosition(2);
        back_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"));
        this.next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"));
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        panel7.setPreferredSize(new Dimension(80, 0));
        panel7.setBorder(null);
        jlabel3.setPreferredSize(new Dimension(80, 24));
        jlabel4.setPreferredSize(new Dimension(80, 24));
        jlabel5.setPreferredSize(new Dimension(80, 24));
        this.userName_TextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.password_TextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.userName_TextField.setPreferredSize(new Dimension(253, 24));
        this.password_TextField.setPreferredSize(new Dimension(253, 24));
        this.databaseName_ComboBox.setPreferredSize(new Dimension(253, 24));
        Vector<String> dataSource = JdmConfig.getDatabaseNames("dmconfig.ini", false);
        dataSource.insertElementAt(new String("  "), 0);
        DefaultComboBoxModel<String> databaseName_ComboBoxModel = new DefaultComboBoxModel<String>(dataSource);
        this.databaseName_ComboBox.setModel((ComboBoxModel)databaseName_ComboBoxModel);
        this.databaseName_ComboBox.setMaximumRowCount(6);
        this.databaseName_ComboBox.addActionListener(new ReflectionAction(this, "databaseName_ComboBox_actionPerformed"));
        this.userName_TextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    ChooseDataSource.this.userName_TextField_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ChooseDataSource.this.userName_TextField_keyReleased(e);
            }
        });
        this.password_TextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    ChooseDataSource.this.password_TextField_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ChooseDataSource.this.password_TextField_keyReleased(e);
            }
        });
        panel4.add(back_Button);
        panel4.add(this.next_Button);
        panel4.add(panel7);
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        panel8.add(jlabel3);
        panel8.add(this.databaseName_ComboBox);
        panel9.add(jlabel4);
        panel9.add(this.userName_TextField);
        panel10.add(jlabel5);
        panel10.add(this.password_TextField);
        panel6.add(panel8);
        panel6.add(panel9);
        panel6.add(panel10);
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ExportXML.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ExportXml_ChooseDataSource", null);
        this.next_Button.setEnabled(false);
    }

    void userName_TextField_keyReleased(KeyEvent e) {
        if (this.userName_TextField.getText().length() > 0) {
            this.next_Button.setEnabled(true);
            if (e.getKeyCode() == 10) {
                this.next_Button_actionPerformed(null);
            }
        } else {
            this.next_Button.setEnabled(false);
        }
    }

    void password_TextField_keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.userName_TextField.getText().length() > 0) {
            this.next_Button_actionPerformed(null);
        }
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        if (!(this.exx.dbName.equals(this.databaseName_ComboBox.getSelectedItem().toString()) && this.exx.userID.equals(this.userName_TextField.getText()) && this.exx.passwd.equals(new String(this.password_TextField.getPassword())))) {
            this.next1 = null;
            if (this.exx.connection != null && this.exx.connection.isConnected) {
                this.exx.connection.disconnect();
                this.exx.connection = null;
            }
        }
        if (this.next1 == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.exx.connection = new SyscomCommonDatabaseConnection(this.databaseName_ComboBox.getSelectedItem().toString(), this.userName_TextField.getText(), new String(this.password_TextField.getPassword()), this.exx);
            dttlib lib = new dttlib();
            this.exx.setClilcodeName(lib.getCliLcodeName(this.exx.connection.getHDBC()));
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (!this.exx.connection.isConnected) {
                this.exx.connection = null;
                return;
            }
            this.exx.dbName = this.databaseName_ComboBox.getSelectedItem().toString();
            String userName = this.userName_TextField.getText().trim();
            this.exx.userID = this.exx.connection.isIDCAP() ? userName.toUpperCase() : userName;
            this.exx.passwd = new String(this.password_TextField.getPassword());
            this.next1 = new CopyOrQuery(this.exx, this);
        }
        this.exx.Next(this.next1);
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.exx.dispose();
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.exx.Next(this.previous);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void databaseName_ComboBox_actionPerformed(ActionEvent e) {
        String name = (String)this.databaseName_ComboBox.getSelectedItem();
        if (name.equals("  ")) {
            this.next_Button.setEnabled(false);
            this.userName_TextField.setText("");
            this.password_TextField.setText("");
        } else {
            String username = JdmConfig.getUserId(name);
            if (username != null && username.length() > 0) {
                this.userName_TextField.setText(username);
                this.next_Button.setEnabled(true);
            }
            this.password_TextField.setText("");
        }
    }
}

