/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.exportText;

import com.borland.jbcl.layout.VerticalFlowLayout;
import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import datatransfer.TextFormat;
import datatransfer.dttlib;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.EmptyPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.SyscomCommonDatabaseConnection;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dttwizard.exportText.ExTextDialog;
import dttwizard.importODBC.LogDialog;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class AdvancedSetting
extends AbstractWizardPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Export.dtt_ExportTextRes", LocaleManager.getLocale());
    private String title = this.res.getString("File_Format_setting");
    private ExTextDialog ext = null;
    private AbstractWizardPanel next1 = null;
    private AbstractWizardPanel previous = null;
    private JCheckBox printColumnName_CheckBox = new JCheckBox(this.res.getString("Print_column_name"));
    private JCheckBox printTableSchema_CheckBox = new JCheckBox(this.res.getString("Print_table_schema"));
    private JCheckBox printNullData_CheckBox = new JCheckBox(this.res.getString("Print_null_data"), true);
    private JCheckBox exportFileLink_CheckBox = new JCheckBox(this.res.getString("Export_file_link"));
    private JCheckBox buildTempFile_CheckBox = new JCheckBox(this.res.getString("Build_temp_file"), true);
    private JCheckBox escape_CheckBox = new JCheckBox(this.res.getString("All_column_content"), true);

    public AdvancedSetting(ExTextDialog ext, AbstractWizardPanel previous) {
        try {
            this.ext = ext;
            this.previous = previous;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton back_Button = new DbaButton(this.res.getString("Previous"), 'P', new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        DbaButton next_Button = new DbaButton(this.res.getString("Execute"), 'E', new ReflectionAction(this, "next_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Checking_pring-column-name"));
        next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/execute.gif"));
        back_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"));
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        panel4.add(back_Button);
        panel4.add(next_Button);
        panel4.add(new EmptyPanel());
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        panel6.add(this.printColumnName_CheckBox);
        panel6.add(this.printTableSchema_CheckBox);
        panel6.add(this.printNullData_CheckBox);
        panel6.add(this.exportFileLink_CheckBox);
        panel6.add(this.buildTempFile_CheckBox);
        panel6.add(this.escape_CheckBox);
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ExportText.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ExportText_AdvancedSetting", null);
        if (!this.ext.isColumnDelimiter) {
            this.escape_CheckBox.setSelected(false);
            this.escape_CheckBox.setEnabled(false);
        }
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.ext.Next(this.previous);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        this.ext.printColumnName = this.printColumnName_CheckBox.isSelected();
        this.ext.printTableSchema = this.printTableSchema_CheckBox.isSelected();
        this.ext.displayNULL = this.printNullData_CheckBox.isSelected();
        this.ext.linkFileNameToFileType = this.exportFileLink_CheckBox.isSelected();
        this.ext.createTempFile = this.buildTempFile_CheckBox.isSelected();
        this.ext.mapEscape = this.escape_CheckBox.isSelected();
        if (this.ext.connection != null && (this.ext.tbowner == null || this.ext.tbname == null) && this.ext.connection.isConnected) {
            this.ext.connection.disconnect();
        }
        dttlib lib = new dttlib();
        TextFormat format = new TextFormat();
        if (!this.ext.isColumnDelimiter) {
            format.style = dttlib.DT_FIXED_COLUMN_LEN;
            format.nspace = (short)this.ext.separateGapNumber;
        } else {
            format.coldelim = (byte)this.ext.columnDelimiter.charAt(0);
            if (this.ext.textQualifier != null) {
                format.textq = (byte)this.ext.textQualifier.charAt(0);
            }
            if (this.ext.binaryQualifier != null) {
                format.binaryq = (byte)this.ext.binaryQualifier.charAt(0);
                if (this.ext.binaryPadding != null && this.ext.binaryPadding.length() > 0) {
                    format.binaryp = (byte)this.ext.binaryPadding.charAt(0);
                }
            }
        }
        format.rowdelim = this.ext.rowDelimiter.getBytes();
        if (this.ext.printColumnName) {
            format.flags |= dttlib.DT_INCLUDE_COL_NAME;
        }
        if (this.ext.printTableSchema) {
            format.flags |= dttlib.DT_INCLUDE_SCHEMA;
        }
        if (this.ext.displayNULL) {
            format.flags |= dttlib.DT_PRINT_NULL;
        }
        if (this.ext.linkFileNameToFileType) {
            format.flags |= dttlib.DT_EXPORT_FILENAME;
        }
        if (this.ext.createTempFile) {
            format.flags |= dttlib.DT_INCLUDE_BLOB;
        }
        if (!this.ext.mapEscape) {
            format.flags |= dttlib.DT_NO_ESCAPE_CHARACTER;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        SyscomCommonDatabaseConnection conn = this.ext.connection;
        int rc = lib.exportText(conn.dbname.getBytes(), conn.username.getBytes(), conn.password.getBytes(), this.ext.fileName.getBytes(), this.ext.queryStr.getBytes(), new String("ErrExportText.Log").getBytes(), format);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (rc == 0) {
            if (this.ext.tbowner == null || this.ext.tbname == null) {
                GuiUt.showInformationDlg(this.ext, this.res.getString("Export_text_file") + " " + this.ext.fileName + " " + this.res.getString("From_database_name") + " " + this.ext.dbName + " " + this.res.getString("successfully"));
            } else {
                GuiUt.showInformationDlg(this.ext, this.res.getString("Export_text_file") + " " + this.ext.fileName + " " + this.res.getString("successfully"));
            }
            this.ext.dispose();
        } else {
            LogDialog logdlg = new LogDialog(this.ext, true);
            logdlg.show();
            if (this.ext.connection == null || !this.ext.connection.isConnected) {
                this.ext.connection = new SyscomCommonDatabaseConnection(this.ext.dbName, this.ext.userID, this.ext.passwd, this.ext);
            }
        }
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.ext.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

