/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.exportJson;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.google.gson.stream.JsonWriter;
import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.FilePathField;
import dbmaker.sql.JdbcOdbcConnection;
import dttwizard.exportJson.ExtDialog;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JsonName
extends AbstractWizardPanel {
    private static final long serialVersionUID = 3703958547874221293L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Export.dtt_ExportTextRes", LocaleManager.getLocale());
    private String title = this.res.getString("Json_Name_the_textfile");
    private ExtDialog ext = null;
    private AbstractWizardPanel previous = null;
    private DbaButton next_Button = new DbaButton(this.res.getString("Execute"), 'E', new ReflectionAction(this, "next_Button_actionPerformed"));
    private FilePathField filePath_TextField = null;
    private JRadioButton textBtn = new JRadioButton("Text");
    private JRadioButton jsonBtn = new JRadioButton("JSON", true);
    private String filename = null;
    private static final String identSpaces = "  ";

    public JsonName(ExtDialog ext, AbstractWizardPanel previous, String filename) {
        try {
            this.ext = ext;
            this.previous = previous;
            this.filename = filename;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton back_Button = new DbaButton(this.res.getString("Previous"), 'P', new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel panel7 = new JPanel(new FlowLayout(0));
        JPanel panel8 = new JPanel();
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Json_specify_a_name"));
        JLabel jlabel3 = new JLabel(this.res.getString("Json_file"));
        this.filePath_TextField = new FilePathField(this.ext, false);
        back_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"));
        this.next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/execute.gif"));
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        this.next_Button.setHorizontalTextPosition(2);
        panel8.setPreferredSize(new Dimension(80, 0));
        panel8.setBorder(null);
        this.filePath_TextField.setPreferredSize(new Dimension(250, 24));
        this.filePath_TextField.setBorder(BorderFactory.createLoweredBevelBorder());
        panel7.add(jlabel3);
        panel7.add(this.filePath_TextField);
        ButtonGroup group = new ButtonGroup();
        group.add(this.textBtn);
        group.add(this.jsonBtn);
        JPanel panelRadioBtnItems = new JPanel(new FlowLayout(0));
        panelRadioBtnItems.add(this.textBtn);
        panelRadioBtnItems.add(this.jsonBtn);
        panel4.add(back_Button);
        panel4.add(this.next_Button);
        panel4.add(panel8);
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        panel6.add(panel7);
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ExportJson.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ExportText_TextName", null);
        this.filePath_TextField.setText(this.filename);
        if (this.filename == null || this.filename.length() == 0) {
            this.next_Button.setEnabled(false);
        } else {
            this.next_Button.setEnabled(true);
        }
        this.filePath_TextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JsonName.this.filePath_TextField_keyReleased(e);
            }
        });
        this.filePath_TextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JsonName.this.filePath_TextField_keyReleased(null);
            }
        });
    }

    void filePath_TextField_keyReleased(KeyEvent e) {
        if (this.filePath_TextField.getText().length() > 0) {
            this.next_Button.setEnabled(true);
        } else {
            this.next_Button.setEnabled(false);
        }
        if (e != null && e.getKeyCode() == 10) {
            this.next_Button_actionPerformed(null);
        }
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.ext.Next(this.previous);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        this.getJsonFile();
        int rc = -1;
        String errmsg = null;
        try {
            rc = this.process();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            errmsg = e1.getMessage();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (rc == 0) {
            if (this.ext.tbowner == null || this.ext.tbname == null) {
                GuiUt.showInformationDlg(this.ext, this.res.getString("Export_text_file") + " " + this.ext.fileName + " " + this.res.getString("From_database_name") + " " + this.ext.dbName + " " + this.res.getString("successfully"));
            } else {
                GuiUt.showInformationDlg(this.ext, this.res.getString("Export_json_file") + " " + this.ext.fileName + " " + this.res.getString("successfully"));
            }
            this.cancel_Button_actionPerformed(null);
        } else {
            GuiUt.showErrorDlg(this.ext, errmsg, null);
        }
    }

    private void getJsonFile() {
        File file;
        String s;
        if (this.ext.fileName == null || (GuiUt.isWindows() ? !this.ext.fileName.equalsIgnoreCase(this.filePath_TextField.getText().trim()) : !this.ext.fileName.equals(this.filePath_TextField.getText().trim()))) {
            // empty if block
        }
        if ((s = this.filePath_TextField.getText().trim()).length() == 0) {
            GuiUt.showErrorDlg(this.ext, this.res.getString("Text_file_name_or_file_path_cannot_be_all_spaces"), null);
            return;
        }
        String ss = null;
        if (s.length() <= 5) {
            s = s + ".json";
        } else {
            ss = s.substring(s.length() - 5, s.length());
            if (s.length() >= 252) {
                if (!ss.equalsIgnoreCase(".json")) {
                    GuiUt.showErrorDlg(this.ext, this.res.getString("The_file_extension_is_not_txt_and_file_path_length_is_over_251"), null);
                    return;
                }
            } else if (!ss.equalsIgnoreCase(".json")) {
                s = s + ".json";
            }
        }
        this.ext.fileName = s;
        this.filePath_TextField.setText(s);
        File f = new File(this.ext.fileName);
        String path = f.getParent();
        if (path != null && !(file = new File(path)).exists()) {
            GuiUt.showErrorDlg(this.ext, this.res.getString("Directory") + " " + file.getPath() + " " + this.res.getString("Does_not_exist"), null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int process() throws Exception {
        int rc = 0;
        Connection conn = this.ext.connection.getDbConnection();
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        Column[] columns = null;
        FileOutputStream out = null;
        out = new FileOutputStream(this.ext.fileName);
        JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)out, "UTF-8"));
        try {
            int i;
            ((JdbcOdbcConnection)conn).setOption(1136, 1);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(this.ext.queryStr);
            rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            columns = new Column[columnCount];
            for (i = 0; i < columnCount; ++i) {
                columns[i] = new Column(rsmd.getColumnName(i + 1), rsmd.getColumnType(i + 1));
            }
            if (!rs.next()) {
                writer.close();
                i = rc;
                return i;
            }
            writer.setIndent(identSpaces);
            writer.beginArray();
            Object value = null;
            do {
                writer.beginObject();
                block15: for (int i2 = 0; i2 < columnCount; ++i2) {
                    writer.name(columns[i2].name);
                    switch (columns[i2].type) {
                        default: {
                            value = rs.getString(i2 + 1);
                            if (value != null && (columns[i2].type == 1 || columns[i2].type == -15)) {
                                value = ((String)value).trim();
                            }
                            if (rs.wasNull()) {
                                writer.nullValue();
                                continue block15;
                            }
                            writer.value((String)value);
                            continue block15;
                        }
                        case -16: 
                        case -4: 
                        case -1: 
                        case 301: {
                            value = rs.getString(i2 + 1);
                            if (rs.wasNull()) {
                                writer.nullValue();
                                continue block15;
                            }
                            writer.value((String)value);
                            continue block15;
                        }
                        case 3: {
                            value = rs.getBigDecimal(i2 + 1);
                            if (rs.wasNull()) {
                                writer.nullValue();
                                continue block15;
                            }
                            writer.value(value.toString());
                            continue block15;
                        }
                        case -5: 
                        case 2: {
                            value = rs.getLong(i2 + 1);
                            if (rs.wasNull()) {
                                writer.nullValue();
                                continue block15;
                            }
                            writer.value((Number)((Long)value));
                            continue block15;
                        }
                        case -7: 
                        case -6: 
                        case 4: 
                        case 5: {
                            value = rs.getInt(i2 + 1);
                            if (rs.wasNull()) {
                                writer.nullValue();
                                continue block15;
                            }
                            writer.value((Number)((Integer)value));
                            continue block15;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            value = rs.getDouble(i2 + 1);
                            if (rs.wasNull()) {
                                writer.nullValue();
                                continue block15;
                            }
                            writer.value((Number)((Double)value));
                        }
                    }
                }
                writer.endObject();
            } while (rs.next());
            writer.endArray();
            writer.close();
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            out.close();
        }
        return rc;
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.ext.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JComponent getFocusComponent() {
        return this.filePath_TextField;
    }

    class Column {
        String name = null;
        String quotedName = null;
        int type = 1;

        Column(String name, int type) {
            this.name = name.trim();
            this.quotedName = "\"" + this.name + "\"";
            this.type = type;
        }
    }
}

