/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.DataSource;
import dbaut.DbaUtDef;
import dbaut.VersionManager;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import java.util.Vector;

public class winlib {
    public static String DBMAKER_ODBC_DRIVER = "DBMaker " + VersionManager.getVersion().trim() + " Driver";

    public winlib() {
        try {
            if (!LocaleManager.getIsDBMaker()) {
                DBMAKER_ODBC_DRIVER = "DBMaster " + VersionManager.getVersion().trim() + " Driver";
            }
            System.loadLibrary("dmjdbaut");
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("error loadlibrary dmjdbaut");
        }
    }

    public int OpenKey(long hKey, String key, long[] phKey) {
        return this.RegOpenKeyEx(hKey, key.getBytes(), phKey);
    }

    public int CreateKey(long hKey, String key, long[] phKey) {
        return this.RegCreateKeyEx(hKey, key.getBytes(), phKey);
    }

    public int QueryValue(long[] phKey, String variable, int type, byte[] buffer, int[] size) {
        return this.RegQueryValueEx(phKey, variable.getBytes(), type, buffer, size);
    }

    public int SetValue(long[] phKey, String variable, int type, byte[] buffer, int size) {
        return this.RegSetValueEx(phKey, variable.getBytes(), type, buffer, size);
    }

    public int CloseKey(long[] phKey) {
        return this.RegCloseKey(phKey);
    }

    public int DeleteKey(long hKey, String key) {
        return this.RegDeleteKey(hKey, key.getBytes());
    }

    public int DeleteValue(long[] phKey, String variable) {
        return this.RegDeleteValue(phKey, variable.getBytes());
    }

    public String exec(String command, int option) {
        byte[] result = new byte[1024];
        this.winExec(command.getBytes(), option, result);
        return new String(result);
    }

    public String StartDatabase(String dbname, String user, String password, DBAResourceBundle res) {
        String s;
        byte[] result = new byte[1024];
        int rc = this.startDB(dbname.getBytes(), user.getBytes(), password.getBytes(), result);
        switch (rc) {
            case 0: {
                s = new String(res.getString("dmserver_out_of_memory") + " [ dmserver.exe ]");
                break;
            }
            case 11: {
                s = new String(res.getString("dmserver_file_is_invalid") + " [ dmserver.exe ]");
                break;
            }
            case 2: {
                s = new String(res.getString("dmserver_file_was_not_found") + " [ dmserver.exe ] ");
                break;
            }
            case 3: {
                s = new String(res.getString("dmserver_path_was_not_found") + " [ dmserver.exe ]");
                break;
            }
            default: {
                s = new String(result).trim();
                if (rc == 32) break;
                s = s + " (" + Integer.toString(rc - 32) + ")";
            }
        }
        return s;
    }

    public int getServiceNames(Vector v) {
        byte[] buff = new byte[12800];
        int[] size = new int[]{100};
        int rc = this.GetNTService(buff, size);
        if (rc != 0) {
            return rc;
        }
        for (int i = 0; i < size[0]; ++i) {
            String name = new String(buff, i * 128, 128);
            v.addElement(name.trim());
        }
        return rc;
    }

    public int removeService(String dbname) {
        return this.RemoveNTService(dbname.getBytes());
    }

    public int installService(String dbname, String password, int startmode) {
        return this.InstallNTService(dbname.getBytes(), password.getBytes(), startmode);
    }

    public int getDataSourceNames(Vector v) {
        DataSource ds;
        int index;
        long[] phKey = new long[1];
        int rc = this.OpenKey(-2147483647L, "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources", phKey);
        if (rc != 0) {
            System.out.println("can't RegOpenKeyEx SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources");
        } else {
            index = 0;
            while ((rc = this.getDataSource(phKey, index, ds = new DataSource())) == DbaUtDef.RTN_OK) {
                v.addElement(ds);
                ++index;
            }
            rc = this.CloseKey(phKey);
        }
        rc = this.OpenKey(-2147483646L, "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources", phKey);
        if (rc != 0) {
            System.out.println("can't RegOpenKeyEx SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources");
        } else {
            index = 0;
            while ((rc = this.getDataSource(phKey, index, ds = new DataSource())) == DbaUtDef.RTN_OK) {
                v.addElement(ds);
                ++index;
            }
            rc = this.CloseKey(phKey);
        }
        return rc;
    }

    public boolean setODBCRegistryKeys(long key, byte[] driver, String dbname, String dbdir, String svr_address, String svr_port) {
        winlib lib = this;
        long[] phKey = new long[1];
        int rc = lib.OpenKey(key, "Software\\ODBC\\ODBC.INI\\ODBC Data Sources", phKey);
        if (rc != 0) {
            System.out.println("can't RegOpenKeyEx Software\\ODBC\\ODBC.INI\\ODBC Data Sources");
            return false;
        }
        rc = lib.SetValue(phKey, dbname, 1, DBMAKER_ODBC_DRIVER.getBytes(), DBMAKER_ODBC_DRIVER.length());
        if (rc != 0) {
            System.out.println("error SetValue variable=" + dbname + " driver=" + DBMAKER_ODBC_DRIVER);
        }
        lib.CloseKey(phKey);
        rc = lib.CreateKey(key, "Software\\ODBC\\ODBC.INI\\" + dbname, phKey);
        rc = lib.SetValue(phKey, "DB_DbDir", 1, dbdir.getBytes(), dbdir.length());
        if (svr_address != null && svr_address.length() > 0) {
            String str = "Server";
            rc = lib.SetValue(phKey, "DB_DbRole", 1, str.getBytes(), str.length());
            str = "ClientServer";
            rc = lib.SetValue(phKey, "DB_DbType", 1, str.getBytes(), str.length());
            rc = lib.SetValue(phKey, "DB_SvAdr", 1, svr_address.getBytes(), svr_address.length());
            rc = lib.SetValue(phKey, "DB_PtNum", 1, svr_port.getBytes(), svr_port.length());
        } else {
            String str = "SingleUser";
            rc = lib.SetValue(phKey, "DB_DbType", 1, str.getBytes(), str.length());
        }
        rc = lib.SetValue(phKey, "DB_UsrID", 1, new byte[0], 0);
        rc = lib.SetValue(phKey, "Description", 1, new byte[0], 0);
        rc = lib.SetValue(phKey, "Driver", 1, driver, driver.length);
        rc = lib.CloseKey(phKey);
        return true;
    }

    public boolean setRegistryKeys(String dbname, String dbdir, String svr_address, String svr_port, String driverPath) {
        if (dbname == null) {
            System.out.println("dbname is required");
            return false;
        }
        winlib lib = this;
        long[] phKey = new long[1];
        int rc = lib.OpenKey(-2147483646L, "SOFTWARE\\ODBC\\ODBCINST.INI\\" + DBMAKER_ODBC_DRIVER, phKey);
        byte[] driver = new byte[1024];
        if (rc == 0) {
            int[] size = new int[]{1024};
            rc = lib.QueryValue(phKey, "Driver", 1, driver, size);
            String driverStr = new String(driver, 0, size[0]);
            driver = driverStr.getBytes();
            lib.CloseKey(phKey);
        } else if (driverPath != null && driverPath.length() > 0) {
            driver = driverPath.getBytes();
        } else {
            System.out.println("can't RegOpenKeyEx SOFTWARE\\ODBC\\ODBCINST.INI\\" + DBMAKER_ODBC_DRIVER);
            return false;
        }
        boolean result = this.setODBCRegistryKeys(-2147483646L, driver, dbname, dbdir == null ? "" : dbdir, svr_address == null ? "" : svr_address, svr_port == null ? "" : svr_port);
        if (!result) {
            result = this.setODBCRegistryKeys(-2147483647L, driver, dbname, dbdir == null ? "" : dbdir, svr_address == null ? "" : svr_address, svr_port == null ? "" : svr_port);
        }
        if (!result) {
            System.out.println("failed to add to either HKEY_LOCAL_MACHINE or  HKEY_CURRENT_USER");
        }
        return result;
    }

    public boolean removeRegistryKey(long key, String name) {
        winlib lib = new winlib();
        int rc = lib.DeleteKey(key, "Software\\ODBC\\ODBC.INI\\" + name);
        if (rc != 0) {
            System.out.println("Error remove registry key for " + name);
            return false;
        }
        long[] phKey = new long[1];
        rc = lib.OpenKey(key, "Software\\ODBC\\ODBC.INI\\ODBC Data Sources", phKey);
        if (rc != 0) {
            System.out.println("can't RegOpenKeyEx Software\\ODBC\\ODBC.INI\\ODBC Data Sources");
            return false;
        }
        rc = lib.DeleteValue(phKey, name);
        if (rc != 0) {
            System.out.println("Error delete value " + name + " in key Software\\ODBC\\ODBC.INI\\ODBC Data Sources");
        }
        lib.CloseKey(phKey);
        return true;
    }

    protected native int RegOpenKeyEx(long var1, byte[] var3, long[] var4);

    protected native int RegCreateKeyEx(long var1, byte[] var3, long[] var4);

    protected native int RegQueryValueEx(long[] var1, byte[] var2, int var3, byte[] var4, int[] var5);

    protected native int RegSetValueEx(long[] var1, byte[] var2, int var3, byte[] var4, int var5);

    protected native int RegCloseKey(long[] var1);

    protected native int RegDeleteKey(long var1, byte[] var3);

    protected native int RegDeleteValue(long[] var1, byte[] var2);

    protected native int GetNTService(byte[] var1, int[] var2);

    protected native int RemoveNTService(byte[] var1);

    protected native int InstallNTService(byte[] var1, byte[] var2, int var3);

    protected native int getDataSource(long[] var1, int var2, DataSource var3);

    protected native int winExec(byte[] var1, int var2, byte[] var3);

    protected native int startDB(byte[] var1, byte[] var2, byte[] var3, byte[] var4);
}

