/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.text.TextField;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IpAddressField
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Dimension fixedDimension = new Dimension(140, 22);
    JTextField digitalText1 = new TextField();
    JTextField digitalText2 = new TextField();
    JTextField digitalText3 = new TextField();
    JTextField digitalText4 = new TextField();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    Border border;
    Color colorJL;
    boolean lock = false;

    public IpAddressField() {
        try {
            this.jbinit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbinit() throws Exception {
        this.border = BorderFactory.createEmptyBorder();
        this.colorJL = this.getBackground();
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                IpAddressField.this.this_componentResized(e);
            }
        });
        this.setSize(140, 22);
        this.setMaximumSize(fixedDimension);
        this.setMinimumSize(fixedDimension);
        this.setPreferredSize(fixedDimension);
        this.digitalText1.setDocument(new DigitalTextDocument(this.digitalText1));
        this.digitalText1.setText("0");
        this.digitalText1.setBorder(this.border);
        this.digitalText1.setHorizontalAlignment(0);
        this.digitalText1.setBounds(new Rectangle(2, 2, 30, 22));
        this.digitalText1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                IpAddressField.this.digitalText1_keyPressed(e);
            }
        });
        this.digitalText1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                IpAddressField.this.digitalText1_keyReleased(e);
            }
        });
        this.digitalText2.setDocument(new DigitalTextDocument(this.digitalText2));
        this.digitalText2.setText("0");
        this.digitalText2.setBorder(this.border);
        this.digitalText2.setHorizontalAlignment(0);
        this.digitalText2.setBounds(new Rectangle(37, 2, 30, 22));
        this.digitalText2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                IpAddressField.this.digitalText2_keyPressed(e);
            }
        });
        this.digitalText2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                IpAddressField.this.digitalText2_keyReleased(e);
            }
        });
        this.digitalText3.setDocument(new DigitalTextDocument(this.digitalText3));
        this.digitalText3.setText("0");
        this.digitalText3.setBorder(this.border);
        this.digitalText3.setHorizontalAlignment(0);
        this.digitalText3.setBounds(new Rectangle(72, 2, 30, 22));
        this.digitalText3.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                IpAddressField.this.digitalText3_keyPressed(e);
            }
        });
        this.digitalText3.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                IpAddressField.this.digitalText3_keyReleased(e);
            }
        });
        this.digitalText4.setDocument(new DigitalTextDocument(this.digitalText4));
        this.digitalText4.setText("");
        this.digitalText4.setBorder(this.border);
        this.digitalText4.setHorizontalAlignment(0);
        this.digitalText4.setBounds(new Rectangle(107, 2, 30, 22));
        this.digitalText4.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                IpAddressField.this.digitalText4_keyPressed(e);
            }
        });
        this.jLabel1.setBounds(new Rectangle(30, 2, 8, 22));
        this.jLabel1.setBackground(Color.white);
        this.jLabel1.setFont(new Font("Dialog", 0, 13));
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setOpaque(true);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(".");
        this.jLabel2.setBounds(new Rectangle(65, 2, 8, 22));
        this.jLabel2.setText(".");
        this.jLabel2.setForeground(Color.black);
        this.jLabel2.setOpaque(true);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setHorizontalTextPosition(0);
        this.jLabel2.setFont(new Font("Dialog", 0, 13));
        this.jLabel2.setBackground(Color.white);
        this.jLabel3.setBounds(new Rectangle(100, 2, 8, 22));
        this.jLabel3.setText(".");
        this.jLabel3.setForeground(Color.black);
        this.jLabel3.setOpaque(true);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setFont(new Font("Dialog", 0, 13));
        this.jLabel3.setBackground(Color.white);
        this.add(this.digitalText1);
        this.add(this.jLabel1);
        this.add(this.digitalText2);
        this.add(this.jLabel2);
        this.add(this.digitalText3);
        this.add(this.jLabel3);
        this.add(this.digitalText4);
    }

    @Override
    public void setEnabled(boolean valueSel) {
        if (valueSel) {
            this.jLabel1.setBackground(Color.white);
            this.jLabel2.setBackground(Color.white);
            this.jLabel3.setBackground(Color.white);
            this.digitalText1.setEditable(true);
            this.digitalText2.setEditable(true);
            this.digitalText3.setEditable(true);
            this.digitalText4.setEditable(true);
            super.setEnabled(true);
        } else {
            this.jLabel1.setBackground(this.colorJL);
            this.jLabel2.setBackground(this.colorJL);
            this.jLabel3.setBackground(this.colorJL);
            this.digitalText1.setEditable(false);
            this.digitalText2.setEditable(false);
            this.digitalText3.setEditable(false);
            this.digitalText4.setEditable(false);
            super.setEnabled(false);
        }
    }

    public void setText(String newIpAddress) {
        if (newIpAddress.equals("")) {
            try {
                this.digitalText1.setText("");
                this.digitalText2.setText("");
                this.digitalText3.setText("");
                this.digitalText4.setText("");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        StringTokenizer strToken = new StringTokenizer(newIpAddress, ".");
        String[] strIPAddress = new String[strToken.countTokens()];
        if (strToken.countTokens() != 4) {
            return;
        }
        int k = 0;
        while (strToken.hasMoreTokens()) {
            strIPAddress[k] = strToken.nextToken();
            ++k;
        }
        try {
            this.digitalText1.setText(strIPAddress[0]);
            this.digitalText2.setText(strIPAddress[1]);
            this.digitalText3.setText(strIPAddress[2]);
            this.digitalText4.setText(strIPAddress[3]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getText() {
        if (this.digitalText1.getText().equals("")) {
            return "";
        }
        if (this.digitalText2.getText().equals("")) {
            return "";
        }
        if (this.digitalText3.getText().equals("")) {
            return "";
        }
        if (this.digitalText4.getText().equals("")) {
            return "";
        }
        String IpAdr = null;
        IpAdr = this.digitalText1.getText() + "." + this.digitalText2.getText() + "." + this.digitalText3.getText() + "." + this.digitalText4.getText();
        return IpAdr;
    }

    public void this_componentResized(ComponentEvent e) {
        this.setSize(140, 22);
        this.validate();
    }

    public void digitalText1_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 39 && this.digitalText1.getCaretPosition() == this.digitalText1.getText().length()) {
            this.digitalText2.requestFocus();
            this.digitalText2.setCaretPosition(0);
        }
        if (e.getKeyCode() == 110 && this.digitalText1.getCaretPosition() > 0) {
            this.digitalText2.requestFocus();
            this.digitalText2.selectAll();
        }
    }

    public void digitalText2_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 39 && this.digitalText2.getCaretPosition() == this.digitalText2.getText().length()) {
            this.digitalText3.requestFocus();
            this.digitalText3.setCaretPosition(0);
        }
        if (e.getKeyCode() == 37 && this.digitalText2.getCaretPosition() == 0) {
            this.digitalText1.requestFocus();
            this.digitalText1.setCaretPosition(this.digitalText1.getText().length());
        }
        if (e.getKeyCode() == 8) {
            if (this.digitalText2.getCaretPosition() == 0 && this.digitalText2.getSelectedText() != null) {
                this.digitalText2.requestFocus();
            }
            if (this.digitalText2.getCaretPosition() == 0 && this.digitalText2.getSelectedText() == null) {
                this.digitalText1.requestFocus();
                this.digitalText1.setCaretPosition(this.digitalText1.getText().length());
            }
        }
        if (e.getKeyCode() == 110) {
            if (this.lock) {
                return;
            }
            if (this.digitalText2.getCaretPosition() > 0) {
                this.digitalText3.requestFocus();
                this.digitalText3.selectAll();
            }
        }
    }

    public void digitalText3_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 39 && this.digitalText3.getCaretPosition() == this.digitalText3.getText().length()) {
            this.digitalText4.requestFocus();
            this.digitalText4.setCaretPosition(0);
        }
        if (e.getKeyCode() == 37 && this.digitalText3.getCaretPosition() == 0) {
            this.digitalText2.requestFocus();
            this.digitalText2.setCaretPosition(this.digitalText2.getText().length());
        }
        if (e.getKeyCode() == 8) {
            if (this.digitalText3.getCaretPosition() == 0 && this.digitalText3.getSelectedText() != null) {
                this.digitalText3.requestFocus();
            }
            if (this.digitalText3.getCaretPosition() == 0 && this.digitalText3.getSelectedText() == null) {
                this.digitalText2.requestFocus();
                this.digitalText2.setCaretPosition(this.digitalText2.getText().length());
            }
        }
        if (e.getKeyCode() == 110) {
            if (this.lock) {
                return;
            }
            if (this.digitalText3.getCaretPosition() > 0) {
                this.digitalText4.requestFocus();
                this.digitalText4.selectAll();
            }
        }
    }

    public void digitalText4_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 37 && this.digitalText4.getCaretPosition() == 0) {
            this.digitalText3.requestFocus();
            this.digitalText3.setCaretPosition(this.digitalText3.getText().length());
        }
        if (e.getKeyCode() == 8) {
            if (this.digitalText4.getCaretPosition() == 0 && this.digitalText4.getSelectedText() != null) {
                this.digitalText4.requestFocus();
            }
            if (this.digitalText4.getCaretPosition() == 0 && this.digitalText4.getSelectedText() == null) {
                this.digitalText3.requestFocus();
                this.digitalText3.setCaretPosition(this.digitalText3.getText().length());
            }
        }
    }

    public void digitalText1_keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 110 && e.getKeyCode() != 37 && e.getKeyCode() != 39 && e.getKeyCode() != 27 && e.getKeyCode() != 10 && e.getKeyCode() != 8 && e.getKeyCode() != 17 && e.getKeyCode() != 16 && e.getKeyCode() != 67 && e.getKeyCode() != 86 && this.digitalText1.getText().length() >= 3) {
            this.digitalText2.requestFocus();
            this.digitalText2.selectAll();
            this.lock = true;
        }
    }

    public void digitalText2_keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 110 && e.getKeyCode() != 37 && e.getKeyCode() != 39 && e.getKeyCode() != 27 && e.getKeyCode() != 10 && e.getKeyCode() != 8 && e.getKeyCode() != 17 && e.getKeyCode() != 16 && e.getKeyCode() != 67 && e.getKeyCode() != 86 && this.digitalText2.getText().length() >= 3) {
            this.digitalText3.requestFocus();
            this.digitalText3.selectAll();
            this.lock = true;
        }
    }

    public void digitalText3_keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 110 && e.getKeyCode() != 37 && e.getKeyCode() != 39 && e.getKeyCode() != 27 && e.getKeyCode() != 10 && e.getKeyCode() != 8 && e.getKeyCode() != 17 && e.getKeyCode() != 16 && e.getKeyCode() != 67 && e.getKeyCode() != 86 && this.digitalText3.getText().length() >= 3) {
            this.digitalText4.requestFocus();
            this.digitalText4.selectAll();
            this.lock = true;
        }
    }

    class DigitalTextDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private JTextField JTF;

        public DigitalTextDocument(JTextField tmpJTF) {
            this.JTF = tmpJTF;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            int valueAfterInsert = 0;
            String strBeforeInsert = this.getText(0, this.getLength());
            String strAfterInsert = strBeforeInsert.substring(0, offset) + str + strBeforeInsert.substring(offset);
            try {
                valueAfterInsert = Integer.parseInt(strAfterInsert);
            }
            catch (NumberFormatException e) {
                return;
            }
            if (strAfterInsert.length() > 3) {
                return;
            }
            if (valueAfterInsert <= 255) {
                IpAddressField.this.lock = false;
                super.insertString(offset, str, a);
                return;
            }
            this.JTF.setText("255");
            this.JTF.requestFocus();
            this.JTF.setCaretPosition(this.JTF.getText().length());
        }
    }
}

