/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import dbaut.textField.IntegerField;
import dbaut.util.JavaTypeUtil;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class IntegerRangeField
extends JPanel {
    private static final long serialVersionUID = 2918118184901005469L;
    private ActionListener listener = null;
    public IntegerField Value_Field = null;
    private JButton Up_Button = new JButton();
    private JButton Down_Button = new JButton();
    private int min = 0;
    private int max = Integer.MAX_VALUE;
    private int minFieldLen = 0;
    private boolean isDbbkful = false;
    private Integer objI = null;
    private boolean nullable = true;
    private boolean borderNormal = true;
    private int[] excludedRange = null;
    public JComboBox unitComboBox = null;
    private int dataType = -1;
    public static final int DATA_TYPE_NORMAL = -1;
    public static final int DATA_TYPE_PAGE = 0;
    public static final int DATA_TYPE_FRAME = 1;
    private int unitType = -1;
    public static final int UNIT_TYPE_NONE = -1;
    public static final int UNIT_TYPE_PAGE = 0;
    public static final int UNIT_TYPE_FRAME = 3;
    public static final int UNIT_TYPE_MEGABYTES = 1;
    public static final int UNIT_TYPE_GIGABYTES = 2;

    public IntegerRangeField() {
        this(Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public IntegerRangeField(int dataType) {
        this(true, Integer.MAX_VALUE, Integer.MIN_VALUE, null, dataType);
    }

    public IntegerRangeField(int max, int min) {
        this(true, max, min);
    }

    public IntegerRangeField(boolean borderNormal, int max, int min) {
        this(borderNormal, max, min, null, -1);
    }

    public IntegerRangeField(boolean borderNormal, int max, int min, int dataType) {
        this(borderNormal, max, min, null, dataType);
    }

    public IntegerRangeField(boolean borderNormal, int max, int min, int[] excludedRange, int dataType) {
        this(borderNormal, max, min, excludedRange, dataType, true);
    }

    public IntegerRangeField(boolean borderNormal, int max, int min, int[] excludedRange, int dataType, boolean positive) {
        try {
            this.setMax(max);
            this.setMin(min);
            this.excludedRange = excludedRange;
            this.borderNormal = borderNormal;
            this.dataType = dataType;
            this.Value_Field = new IntegerField(positive);
            this.objI = new Integer(this.getMin());
            this.minFieldLen = this.objI.toString().length();
            if (this.getMin() < 0 && this.minFieldLen > 1) {
                --this.minFieldLen;
            }
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IntegerRangeField(int max, int min, boolean nullable) {
        this(true, max, min);
        this.nullable = nullable;
    }

    public IntegerRangeField(int value, int max, int min) {
        this(max, min);
        this.setInitValue(value);
    }

    public IntegerRangeField(int max, int min, int[] excludedRange) {
        this(true, max, min, excludedRange, -1);
    }

    public IntegerRangeField(int value, int max, int min, boolean positive) {
        this(true, max, min, null, -1, positive);
        this.setInitValue(value);
    }

    public IntegerRangeField(String value, int max, int min, int dataType, boolean positive) {
        this(true, max, min, null, dataType, positive);
        this.setInitValue(value);
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.Value_Field.setName("IntegerValueField");
        if (this.borderNormal) {
            this.Value_Field.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            this.Value_Field.setBorder(BorderFactory.createEmptyBorder());
        }
        this.Value_Field.setPreferredSize(new Dimension(55, 24));
        this.Value_Field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    IntegerRangeField.this.Value_Field_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                IntegerRangeField.this.Value_Field_keyReleased(e);
            }
        });
        JPanel jPanel1 = new JPanel();
        jPanel1.setLayout(new GridLayout(2, 1));
        this.Value_Field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                IntegerRangeField.this.Value_Field_focusLost(e);
            }
        });
        this.Up_Button.addActionListener(new ReflectionAction(this, "Up_Button_actionPerformed"));
        this.Down_Button.addActionListener(new ReflectionAction(this, "Down_Button_actionPerformed"));
        this.Up_Button.setBorder(BorderFactory.createRaisedBevelBorder());
        this.Up_Button.setPreferredSize(new Dimension(22, 10));
        this.Up_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/up.gif"));
        this.Down_Button.setBorder(BorderFactory.createRaisedBevelBorder());
        this.Down_Button.setPreferredSize(new Dimension(22, 10));
        this.Down_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/down.gif"));
        jPanel1.add((Component)this.Up_Button, null);
        jPanel1.add((Component)this.Down_Button, null);
        if (this.dataType != -1) {
            JPanel p0 = new JPanel(new BorderLayout());
            p0.add((Component)this.Value_Field, "Center");
            if (this.borderNormal) {
                p0.add((Component)jPanel1, "East");
            }
            if (this.dataType == 0) {
                this.unitComboBox = new JComboBox<String>(new String[]{"page", "M", "G"});
            } else if (this.dataType == 1) {
                this.unitComboBox = new JComboBox<String>(new String[]{"frame", "M", "G"});
            }
            this.unitComboBox.setPreferredSize(new Dimension(80, 24));
            this.unitComboBox.setName("UnitComboBox");
            this.add((Component)p0, "Center");
            this.add((Component)this.unitComboBox, "East");
        } else {
            this.add((Component)this.Value_Field, "Center");
            if (this.borderNormal) {
                this.add((Component)jPanel1, "East");
            }
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        this.Value_Field.setEnabled(flag);
        this.Up_Button.setEnabled(flag);
        this.Down_Button.setEnabled(flag);
        if (this.unitComboBox != null) {
            this.unitComboBox.setEnabled(flag);
        }
    }

    public int getInt() {
        Integer v = (Integer)this.Value_Field.getValue();
        if (v == null) {
            return 0;
        }
        return v;
    }

    public String getStringValue() {
        Integer i = this.getValue();
        String str = null;
        int index = 0;
        if (i != null) {
            str = i.toString();
            if (this.unitComboBox != null) {
                index = this.unitComboBox.getSelectedIndex();
                if (index == 1) {
                    str = str + 'M';
                } else if (index == 2) {
                    str = str + 'G';
                }
            }
        }
        return str;
    }

    public boolean isEmpty() {
        String txt = this.Value_Field.getText();
        return txt == null || txt.trim().length() == 0;
    }

    public Integer getValue() {
        Integer v = (Integer)this.Value_Field.getValue();
        if (v == null) {
            return null;
        }
        return v;
    }

    public boolean isChanged() {
        if (this.unitComboBox != null && this.unitType != this.unitComboBox.getSelectedIndex()) {
            return true;
        }
        return this.Value_Field.isChanged();
    }

    public int getUnit() {
        if (this.unitComboBox == null) {
            return -1;
        }
        return this.unitComboBox.getSelectedIndex();
    }

    public void setUnit(int unitType) {
        if (this.unitComboBox != null) {
            this.unitType = unitType;
            this.changeUnit();
        }
    }

    private boolean isInExcludedRange(int value) {
        return this.excludedRange != null && Arrays.binarySearch(this.excludedRange, value) >= 0;
    }

    private int getOutsideExcludedValue(int value) {
        int result = 0;
        if (this.excludedRange != null) {
            int middle;
            int index = Arrays.binarySearch(this.excludedRange, value);
            result = index > (middle = (this.excludedRange.length - 1) / 2) ? this.getMaxExcludedValue() + 1 : this.getMinExcludedValue() - 1;
        }
        return result;
    }

    private int getMinExcludedValue() {
        return this.excludedRange[0];
    }

    private int getMaxExcludedValue() {
        return this.excludedRange[this.excludedRange.length - 1];
    }

    private void changeUnit() {
        if (this.unitType == 3) {
            this.unitComboBox.setSelectedIndex(0);
        } else {
            this.unitComboBox.setSelectedIndex(this.unitType);
        }
    }

    public void setDbbkful(boolean flag) {
        this.isDbbkful = flag;
    }

    public void setNullable(boolean flag) {
        this.nullable = flag;
    }

    void Value_Field_focusLost(FocusEvent e) {
        Integer v = (Integer)this.Value_Field.getValue();
        if (v == null) {
            if (!this.nullable) {
                this.Value_Field.setValue(this.getMin());
            }
            return;
        }
        if (this.isDbbkful && v == 0) {
            return;
        }
        if (v <= this.getMin()) {
            this.Value_Field.setValue(this.getMin());
        }
        if (v >= this.getMax()) {
            this.Value_Field.setValue(this.getMax());
        }
        if (this.isInExcludedRange(v)) {
            this.Value_Field.setValue(this.getOutsideExcludedValue(v));
        }
    }

    public void Up_Button_actionPerformed(ActionEvent e) {
        Integer v = (Integer)this.Value_Field.getValue();
        if (v == null) {
            this.Value_Field.setValue(this.getMin());
        } else if (this.isDbbkful && v == 0) {
            this.Value_Field.setValue(this.getMin());
        } else if (v < this.getMax()) {
            if (this.isInExcludedRange(v + 1)) {
                this.Value_Field.setValue(this.getMaxExcludedValue() + 1);
            } else {
                this.Value_Field.setValue(v + 1);
            }
        }
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public void Down_Button_actionPerformed(ActionEvent e) {
        Integer v = (Integer)this.Value_Field.getValue();
        if (v == null) {
            this.Value_Field.setValue(this.getMax());
        } else if (this.isDbbkful && v.intValue() == this.getMin()) {
            this.Value_Field.setValue(0);
        } else if (v > this.getMin()) {
            if (this.isInExcludedRange(v - 1)) {
                this.Value_Field.setValue(this.getMinExcludedValue() - 1);
            } else {
                this.Value_Field.setValue(v - 1);
            }
        }
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public void setInitValue(int value) {
        value = value < this.getMax() ? value : this.getMax();
        int n = value = value > this.getMin() ? value : this.getMin();
        if (this.isInExcludedRange(value)) {
            this.Value_Field.setInitValue(this.getOutsideExcludedValue(value));
        } else {
            this.Value_Field.setInitValue(value);
        }
    }

    public void setInitValue(String value) {
        if (value != null) {
            value = value.trim();
        }
        if (value != null && value.length() > 0) {
            if (this.unitComboBox != null) {
                char last = value.charAt(value.length() - 1);
                if (last == 'M' || last == 'm') {
                    this.unitType = 1;
                    value = value.substring(0, value.length() - 1);
                } else if (last == 'G' || last == 'g') {
                    this.unitType = 2;
                    value = value.substring(0, value.length() - 1);
                } else {
                    this.unitType = 0;
                }
                this.changeUnit();
            }
            this.setInitValue(JavaTypeUtil.parseInt(value));
        } else {
            this.Value_Field.setInitValue(value);
        }
    }

    public void setValue(int value) {
        this.Value_Field.setValue(value);
    }

    public void setValue(String value) {
        if (value != null) {
            value = value.trim();
        }
        if (value != null && value.length() > 0) {
            this.Value_Field.setValue(value);
        }
    }

    void Value_Field_keyReleased(KeyEvent e) {
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
        if (e.getKeyCode() != 39 && e.getKeyCode() != 37 && e.getKeyCode() != 36) {
            Integer v = (Integer)this.Value_Field.getValue();
            if (v == null) {
                return;
            }
            if (v.toString().length() > this.minFieldLen && (v >= this.getMax() || v <= this.getMin())) {
                this.Value_Field_focusLost(null);
            }
            if (e.getKeyCode() == 10) {
                this.Value_Field_focusLost(null);
            }
        }
    }

    @Override
    public void setToolTipText(String str) {
        super.setToolTipText(str);
        this.Value_Field.setToolTipText(str);
        if (this.unitComboBox != null) {
            this.unitComboBox.setToolTipText(str);
        }
    }
}

