/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.GuiUt;
import dbaut.text.TextField;
import dbaut.textField.DbaTextField;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class FloatField
extends TextField
implements DbaTextField {
    private static final long serialVersionUID = -7998640985461468631L;
    private NumberFormat numberFormatter;
    private int max_length = 0;
    private boolean length_limited = false;
    private FloatField field = this;

    public FloatField(float value, int columns) {
        this(columns);
        this.setValue(value);
    }

    public FloatField(int columns) {
        super(columns);
        this.numberFormatter = NumberFormat.getNumberInstance(Locale.US);
    }

    public FloatField() {
        this(5);
    }

    @Override
    public Object getValue() {
        float retVal = 0.0f;
        String t = this.getText().trim();
        try {
            retVal = Float.parseFloat(t);
        }
        catch (NumberFormatException e) {
            if (t.length() > 0) {
                Toolkit.getDefaultToolkit().beep();
                GuiUt.showErrorDlg(this, t + " can't be formatted as Float", null);
            }
            return null;
        }
        return new Float(retVal);
    }

    public void setValue(float value) {
        this.setText(this.numberFormatter.format(value));
    }

    @Override
    protected Document createDefaultModel() {
        return new DoubleDocument();
    }

    @Override
    public void setInitValue(String value) {
        throw new UnsupportedOperationException("Method setInitValue() not yet implemented.");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Method isEmpty() not yet implemented.");
    }

    @Override
    public boolean isChanged() {
        throw new UnsupportedOperationException("Method isChanged() not yet implemented.");
    }

    protected class DoubleDocument
    extends PlainDocument {
        private static final long serialVersionUID = -2519515822294586357L;

        protected DoubleDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String temp;
            if (FloatField.this.length_limited && (temp = FloatField.this.field.getText()).length() >= FloatField.this.max_length) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            int length = str.length();
            for (int i = 0; i < length; ++i) {
                if (Character.isDigit(str.charAt(i)) || str.charAt(i) == '.' || str.charAt(i) == '-' || str.charAt(i) == 'E' || str.charAt(i) == 'e') continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

