/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.DateDocument;
import dbaut.GuiUt;
import dbaut.TimeDocument;
import dbaut.text.TextField;
import dbaut.textField.DbaTextField;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DateTimeField
extends JPanel
implements DbaTextField {
    private static final long serialVersionUID = -6726441516112752208L;
    private JTextField Date_Field = new TextField();
    private JTextField Time_Field = new TextField();
    private DateDocument date_doc = null;
    private TimeDocument time_doc = null;

    public DateTimeField() {
        this.date_doc = new DateDocument(this.Date_Field);
        this.time_doc = new TimeDocument(this.Time_Field);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DateTimeField(String maxDate, String minDate, String defaultDate, String maxTime, String minTime, String defaultTime) {
        this.date_doc = new DateDocument(this.Date_Field, maxDate, minDate, defaultDate);
        this.time_doc = new TimeDocument(this.Time_Field, maxTime, minTime, defaultTime);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridLayout());
        this.add((Component)this.Date_Field, null);
        this.add((Component)this.Time_Field, null);
        this.Date_Field.setDocument(this.date_doc);
        this.Time_Field.setDocument(this.time_doc);
        this.Time_Field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (DateTimeField.this.Time_Field.getText().equals("  :  :  ") && !DateTimeField.this.Date_Field.getText().equals("    /  /  ")) {
                        DateTimeField.this.time_doc.insertString(0, "00:00:00", null);
                    } else {
                        DateTimeField.this.time_doc.insertString(8, "", null);
                    }
                }
                catch (Exception ble) {
                    System.out.println(ble.getMessage());
                }
            }
        });
        this.Date_Field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    DateTimeField.this.date_doc.insertString(10, "", null);
                    if (DateTimeField.this.Time_Field.getText().equals("  :  :  ") && !DateTimeField.this.Date_Field.getText().equals("    /  /  ")) {
                        DateTimeField.this.time_doc.insertString(0, "00:00:00", null);
                    }
                }
                catch (Exception ble) {
                    System.out.println(ble.getMessage());
                }
            }
        });
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Method isEmpty() not yet implemented.");
    }

    @Override
    public boolean isChanged() {
        throw new UnsupportedOperationException("Method isChanged() not yet implemented.");
    }

    @Override
    public void setInitValue(String dt) {
        int index = dt.indexOf(" ");
        DateDocument.initString = dt.substring(0, index);
        TimeDocument.initString = dt.substring(index + 1);
        this.Date_Field.setText(dt.substring(0, index));
        this.Time_Field.setText(dt.substring(index + 1));
    }

    public String getDateTime() {
        if (this.Date_Field.getText().equals("    /  /  ")) {
            return null;
        }
        if (this.Time_Field.getText().equals("  :  :  ")) {
            return this.Date_Field.getText() + " " + "00:00:00";
        }
        return this.Date_Field.getText() + " " + this.Time_Field.getText();
    }

    @Override
    public Object getValue() {
        return this.Date_Field.getText() + " " + this.Time_Field.getText();
    }

    @Override
    public void setEnabled(boolean enable) {
        this.Date_Field.setEnabled(enable);
        this.Time_Field.setEnabled(enable);
    }

    public static boolean isDate(String inStr) {
        boolean flag = true;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (inStr.indexOf("/") > 0) {
                inStr = inStr.replace("/", "-");
            }
            sdf.parse(inStr);
            String[] dateStr = inStr.split("-");
            int year = Integer.parseInt(dateStr[0]);
            if (year < 1970 || year > 2037) {
                flag = false;
            }
        }
        catch (ParseException e) {
            flag = false;
        }
        return flag;
    }

    public static String[] parseSpaceString(String inStr) {
        Date dateTime;
        if ((inStr = inStr.trim()).startsWith("\"")) {
            inStr = inStr.substring(1, inStr.length());
        }
        if (inStr.endsWith("\"")) {
            inStr = inStr.substring(0, inStr.length() - 1);
        }
        inStr = DateTimeField.removeSpaceBeforeSlashAndColon(inStr);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            int i1 = -1;
            if (DateTimeField.isDate(inStr)) {
                i1 = GuiUt.convertStrToTime(inStr);
            }
            String t1 = i1 < 0 ? GuiUt.convertTimeToStr(0) : GuiUt.convertTimeToStr(i1);
            dateTime = sdf.parse(t1);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
        SimpleDateFormat dsdf = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat tsdf = new SimpleDateFormat("HH:mm:ss");
        String[] sA = new String[]{dsdf.format(dateTime), tsdf.format(dateTime)};
        return sA;
    }

    private static String removeSpaceBeforeSlashAndColon(String inStr) {
        int slashPos = 0;
        while ((slashPos = inStr.indexOf(" /")) > 0) {
            inStr = inStr.substring(0, slashPos) + inStr.substring(slashPos + 1);
        }
        while ((slashPos = inStr.indexOf("/ ")) > 0) {
            inStr = inStr.substring(0, slashPos + 1) + inStr.substring(slashPos + 2);
        }
        return inStr;
    }
}

