/*
 * Decompiled with CFR 0.152.
 */
package dbaut.text;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class TextArea
extends JTextArea {
    private static final long serialVersionUID = 255746930842849239L;
    UndoManager undoManager = new UndoManager();
    UndoHandler undoHandler = new UndoHandler();
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    KeyStroke undoKeystroke = KeyStroke.getKeyStroke(90, 2);
    KeyStroke redoKeystroke = KeyStroke.getKeyStroke(89, 2);

    public TextArea() {
        this.setupUndoRedo();
    }

    public TextArea(String arg0) {
        super(arg0);
        this.setupUndoRedo();
    }

    public TextArea(Document arg0) {
        super(arg0);
        this.setupUndoRedo();
    }

    public TextArea(int arg0, int arg1) {
        super(arg0, arg1);
        this.setupUndoRedo();
    }

    public TextArea(String arg0, int arg1, int arg2) {
        super(arg0, arg1, arg2);
        this.setupUndoRedo();
    }

    public TextArea(Document arg0, String arg1, int arg2, int arg3) {
        super(arg0, arg1, arg2, arg3);
        this.setupUndoRedo();
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void undo() {
        this.undoManager.undo();
    }

    public void redo() {
        this.undoManager.redo();
    }

    public void setupUndoRedo() {
        this.getInputMap().put(this.undoKeystroke, "undoKeystroke");
        this.getActionMap().put("undoKeystroke", this.undoAction);
        this.getInputMap().put(this.redoKeystroke, "redoKeystroke");
        this.getActionMap().put("redoKeystroke", this.redoAction);
        this.getDocument().addUndoableEditListener(this.undoHandler);
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -731716311693118517L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TextArea.this.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                ex.printStackTrace();
            }
            this.update();
            TextArea.this.undoAction.update();
        }

        protected void update() {
            if (TextArea.this.undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", TextArea.this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 130221570602668519L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TextArea.this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.update();
            TextArea.this.redoAction.update();
        }

        protected void update() {
            if (TextArea.this.undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", TextArea.this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            TextArea.this.undoManager.addEdit(e.getEdit());
            TextArea.this.undoAction.update();
            TextArea.this.redoAction.update();
        }
    }
}

