/*
 * Decompiled with CFR 0.152.
 */
package dbaut.text;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class EditorPane
extends JEditorPane {
    private static final long serialVersionUID = 6919515877897651490L;
    UndoManager undoManager = new UndoManager();
    UndoHandler undoHandler = new UndoHandler();
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    KeyStroke undoKeystroke = KeyStroke.getKeyStroke(90, 2);
    KeyStroke redoKeystroke = KeyStroke.getKeyStroke(89, 2);

    public EditorPane() {
        this.setupUndoRedo();
    }

    public EditorPane(URL initialPage) throws IOException {
        super(initialPage);
        this.setupUndoRedo();
    }

    public EditorPane(String url) throws IOException {
        super(url);
        this.setupUndoRedo();
    }

    public EditorPane(String type, String text) {
        super(type, text);
        this.setupUndoRedo();
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void undo() {
        this.undoManager.undo();
    }

    public void redo() {
        this.undoManager.redo();
    }

    public void setupUndoRedo() {
        this.getInputMap().put(this.undoKeystroke, "undoKeystroke");
        this.getActionMap().put("undoKeystroke", this.undoAction);
        this.getInputMap().put(this.redoKeystroke, "redoKeystroke");
        this.getActionMap().put("redoKeystroke", this.redoAction);
        this.getDocument().addUndoableEditListener(this.undoHandler);
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -731716311693118517L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                EditorPane.this.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                ex.printStackTrace();
            }
            this.update();
            EditorPane.this.undoAction.update();
        }

        protected void update() {
            if (EditorPane.this.undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", EditorPane.this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 130221570602668519L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                EditorPane.this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.update();
            EditorPane.this.redoAction.update();
        }

        protected void update() {
            if (EditorPane.this.undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", EditorPane.this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            EditorPane.this.undoManager.addEdit(e.getEdit());
            EditorPane.this.undoAction.update();
            EditorPane.this.redoAction.update();
        }
    }
}

