/*
 * Decompiled with CFR 0.152.
 */
package dbaut.privilege;

import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UserPrivilege {
    private Connection con = null;
    private String userName = null;
    private boolean isSYSADM = false;
    private boolean isSYSDBA = false;
    private boolean isDBA = false;
    private boolean isResource = false;
    private boolean isConnect = false;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dbautproperties.dbaut.Res", LocaleManager.getLocale());
    private Component comp = null;

    public UserPrivilege(Connection con, String userName, Component comp) throws SQLException {
        this.comp = comp;
        if (con == null || con.isClosed()) {
            System.out.println("Connection is null or closed in " + this.getClass().getName());
            return;
        }
        if (userName == null || userName.length() < 1) {
            System.out.println("User name is invalid in " + this.getClass().getName());
            return;
        }
        this.con = con;
        this.setUserName(userName);
        this.checkUserPrivilege();
    }

    public boolean isOwner(String schemaName) {
        String sql = "SELECT * FROM SYSTEM.SYSSCHEMA WHERE SCHEMA_NAME='" + schemaName + "' AND SCHEMA_OWNER='" + this.getUserName() + "'";
        return this.hasResultSet(sql);
    }

    public boolean hasSelectAllPrivilege(String owner, String name) {
        String sql = "SELECT * FROM SYSTEM.SYSAUTHTABLE WHERE TABLE_OWNER='" + owner + "' AND TABLE_NAME='" + name + "' AND SEL_ALL<>0";
        return this.hasResultSet(sql);
    }

    public boolean hasDeleteAllPrivilege(String owner, String name) {
        String sql = "SELECT * FROM SYSTEM.SYSAUTHTABLE WHERE TABLE_OWNER='" + owner + "' AND TABLE_NAME='" + name + "' AND DEL_ALL<>0";
        return this.hasResultSet(sql);
    }

    public boolean hasInsertPrivilege(String owner, String name) {
        return true;
    }

    public boolean hasInsertAllPrivilege(String owner, String name) {
        String sql = "SELECT * FROM SYSTEM.SYSAUTHTABLE WHERE TABLE_OWNER='" + owner + "' AND TABLE_NAME='" + name + "' AND INS_ALL<>0";
        return this.hasResultSet(sql);
    }

    public boolean hasUpdatePrivilege(String owner, String name) {
        return true;
    }

    public boolean hasUpdateAllPrivilege(String owner, String name) {
        String sql = "SELECT * FROM SYSTEM.SYSAUTHTABLE WHERE TABLE_OWNER='" + owner + "' AND TABLE_NAME='" + name + "' AND UPD_ALL<>0";
        return this.hasResultSet(sql);
    }

    public boolean hasAlterAllPrivilege(String owner, String name) {
        String sql = "SELECT *  FROM SYSTEM.SYSAUTHTABLE WHERE TABLE_OWNER='" + owner + "' " + "AND TABLE_NAME='" + name + "' AND ALT_ALL!=0";
        return this.hasResultSet(sql);
    }

    public boolean hasIndexAllPrivilege() {
        return true;
    }

    public boolean hasReferencePrivilege() {
        return true;
    }

    public boolean hasReferenceAllPrivilege() {
        return true;
    }

    public boolean canModifyData(String owner, String name) {
        String sql = "SELECT *  FROM SYSTEM.SYSAUTHTABLE WHERE TABLE_OWNER='" + owner + "' " + "AND TABLE_NAME='" + name + "' AND SEL_ALL!=0 " + "AND (UPD_ALL!=0 OR DEL_ALL!=0 OR INS_ALL!=0 OR UPD!=0 OR INS !=0)";
        return this.hasResultSet(sql);
    }

    public boolean isSYSADM() {
        return this.isSYSADM;
    }

    public boolean isSYSDBA() {
        return this.isSYSDBA;
    }

    public boolean isDBA() {
        return this.isDBA;
    }

    public boolean isResource() {
        return this.isResource;
    }

    public boolean isConnect() {
        return this.isConnect;
    }

    private String getUserName() {
        return this.userName;
    }

    private void setUserName(String userName) {
        this.userName = userName;
    }

    public void errorIsNotDBA(Component comp) {
        GuiUt.showErrorDlg(comp, this.res.getString("User_Is_Not_DBA"), null);
    }

    private void checkUserPrivilege() throws SQLException {
        this.isSYSADM = this.getUserName().equalsIgnoreCase("SYSADM");
        Statement stmt = null;
        ResultSet rs = null;
        int dba = 0;
        short resource = 0;
        try {
            stmt = this.con.createStatement();
            rs = stmt.executeQuery("SELECT DBA, RESOURCE FROM SYSAUTHUSER WHERE USER_NAME = '" + this.getUserName() + "'");
            while (rs.next()) {
                dba = rs.getShort(1);
                resource = rs.getShort(2);
            }
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        catch (SQLException sqldbae) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this.comp, null, sqldbae);
            dba = 0;
            resource = 0;
            sqldbae.printStackTrace();
        }
        if (dba == 2) {
            this.isSYSDBA = true;
        }
        if (dba == 1) {
            this.isDBA = true;
        }
        if (dba == 0 && resource == 1) {
            this.isResource = true;
        }
        if (dba == 0 && resource == 0) {
            this.isConnect = true;
        }
    }

    private boolean hasResultSet(String sql) {
        boolean hasResult = false;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.createStatement();
            rs = stmt.executeQuery(sql);
            hasResult = rs.next();
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        catch (SQLException sqldbae) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this.comp, null, sqldbae);
            hasResult = false;
            sqldbae.printStackTrace();
        }
        return hasResult;
    }
}

