/*
 * Decompiled with CFR 0.152.
 */
package dbaut.preference;

import dbaut.JdmConfig;
import dbaut.locale.LocaleManager;
import java.io.File;
import java.io.FileWriter;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import startup.ToolInfo;

public class CorePreferences {
    private static CorePreferences self = null;
    private short language_choice = LocaleManager.getDefaultSystemLanguage();
    private String login_db_name = "";
    private String login_id_name = "";
    private String login_password = "";
    public static final String CONFIGNAME = ToolInfo.getToolConfigName();
    private HashMap<String, DB> dbs = new HashMap();

    public CorePreferences() {
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() throws Exception {
        String path = CorePreferences.getWinInstallPath();
        this.init(path + CONFIGNAME);
    }

    public static String getConfigName() {
        String path = CorePreferences.getWinInstallPath();
        return path + CONFIGNAME;
    }

    private void init(String fileName) {
        File f = new File(fileName);
        if (!f.exists()) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = factory.newDocumentBuilder();
            doc = builder.parse(fileName);
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (Exception e) {
            doc = this.createXmlDocument(builder);
            e.printStackTrace();
        }
        String tmp = null;
        Node node = null;
        try {
            node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom");
            if (node != null && node.getNodeType() == 1) {
                Element elm = (Element)node;
                tmp = elm.getAttribute("login_db_name");
                if (tmp != null && tmp.length() > 0) {
                    this.login_db_name = tmp;
                }
                if ((tmp = elm.getAttribute("login_id_name")) != null && tmp.length() > 0) {
                    this.login_id_name = tmp;
                }
                if ((tmp = elm.getAttribute("login_password")) != null && tmp.length() > 0) {
                    this.login_password = DBMakerDes.decrypt(tmp);
                }
                if ((tmp = elm.getAttribute("language_choice")) != null && tmp.length() > 0) {
                    this.language_choice = Short.parseShort(tmp);
                    if (this.language_choice < 0) {
                        this.language_choice = 0;
                    }
                }
                NodeList nl = XPathAPI.selectNodeList((Node)node, (String)"db");
                for (int i = 0; i < nl.getLength(); ++i) {
                    String db = null;
                    String id = null;
                    String pw = null;
                    node = nl.item(i);
                    elm = (Element)node;
                    db = elm.getAttribute("db_name");
                    id = elm.getAttribute("id_name");
                    tmp = elm.getAttribute("password");
                    if (tmp != null && tmp.length() > 0) {
                        pw = DBMakerDes.decrypt(tmp);
                    }
                    this.dbs.put(db, new DB(db, id, pw));
                }
            } else {
                doc = this.createXmlDocument(builder);
            }
        }
        catch (Exception ee) {
            doc = this.createXmlDocument(builder);
            ee.printStackTrace();
        }
    }

    public void createRootElement(Document doc) {
        Element syscom = doc.createElement("syscom");
        doc.appendChild(syscom);
    }

    public Document createXmlDocument(DocumentBuilder builder) {
        Document doc = builder.newDocument();
        this.createRootElement(doc);
        return doc;
    }

    public void resetDOM(Document doc) {
        String temp = null;
        Node node = null;
        try {
            node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom");
            if (node != null && node.getNodeType() == 1) {
                temp = ((Element)node).getAttribute("language_choice");
                if (temp != null && temp.length() > 0) {
                    this.language_choice = Short.parseShort(temp);
                }
                if ((temp = ((Element)node).getAttribute("login_db_name")) != null && temp.length() > 0) {
                    this.login_db_name = temp;
                }
                if ((temp = ((Element)node).getAttribute("login_id_name")) != null && temp.length() > 0) {
                    this.login_id_name = temp;
                }
                if ((temp = ((Element)node).getAttribute("login_password")) != null && temp.length() > 0) {
                    this.login_password = DBMakerDes.decrypt(temp);
                }
                Element elm = null;
                NodeList nl = XPathAPI.selectNodeList((Node)node, (String)"db");
                for (int i = 0; i < nl.getLength(); ++i) {
                    String db = null;
                    String id = null;
                    String pw = null;
                    node = nl.item(i);
                    elm = (Element)node;
                    db = elm.getAttribute("db_name");
                    id = elm.getAttribute("id_name");
                    temp = elm.getAttribute("password");
                    if (temp != null && temp.length() > 0) {
                        pw = DBMakerDes.decrypt(temp);
                    }
                    this.dbs.put(db, new DB(db, id, pw));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LocaleManager.getLocaleManager(this.getLanguageChoice());
    }

    public void removeLoginInfo(String db_name) {
        this.login_id_name = null;
        this.login_password = null;
        this.dbs.remove(this.login_db_name);
    }

    public void setDOM(Document doc) {
        Element syscom = null;
        Element root = doc.getDocumentElement();
        Element db = null;
        if (root == null) {
            syscom = doc.createElement("syscom");
            doc.appendChild(syscom);
        } else if (!root.getNodeName().equals("syscom")) {
            syscom = doc.createElement("syscom");
            doc.replaceChild(syscom, root);
        } else {
            syscom = root;
        }
        syscom.setAttribute("language_choice", Short.toString(this.language_choice));
        if (this.login_db_name != null && this.login_db_name.length() > 0) {
            syscom.setAttribute("login_db_name", this.login_db_name);
        }
        if (this.login_id_name != null && this.login_id_name.length() > 0) {
            syscom.setAttribute("login_id_name", this.login_id_name);
        } else {
            syscom.removeAttribute("login_id_name");
        }
        if (this.login_password != null && this.login_password.length() > 0) {
            syscom.setAttribute("login_password", DBMakerDes.encrypt(this.login_password));
        } else {
            syscom.removeAttribute("login_password");
        }
        try {
            String xpath = "db[@db_name=\"" + this.login_db_name + "\"]";
            Node node = XPathAPI.selectSingleNode((Node)syscom, (String)xpath);
            if (this.login_id_name == null && this.login_password == null) {
                if (node != null) {
                    syscom.removeChild(node);
                }
            } else if (node == null) {
                db = doc.createElement("db");
                db.setAttribute("db_name", this.login_db_name);
                db.setAttribute("id_name", this.login_id_name);
                if (this.login_password != null) {
                    db.setAttribute("password", DBMakerDes.encrypt(this.login_password));
                }
                node = db;
                syscom.appendChild(node);
            } else {
                db = (Element)node;
                db.setAttribute("id_name", this.login_id_name);
                db.setAttribute("password", DBMakerDes.encrypt(this.login_password));
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public short getLanguageChoice() {
        return this.language_choice;
    }

    public void setLanguageChoice(short language) {
        this.language_choice = language;
    }

    public String getLoginDbName() {
        return this.login_db_name;
    }

    public void setLoginDbName(String loginDbName) {
        this.login_db_name = loginDbName;
    }

    public String getLoginIdName() {
        return this.login_id_name;
    }

    public String getLoginIdName(String db_name) {
        String user = null;
        DB db = this.dbs.get(db_name);
        if (db != null) {
            user = db.id_name;
        }
        return user;
    }

    public void setLoginIdName(String idName) {
        this.login_id_name = idName;
    }

    public String getLoginPassword(String db_name) {
        String pw = null;
        DB db = this.dbs.get(db_name);
        if (db != null) {
            pw = db.password;
        }
        return pw;
    }

    public String getLoginPassword() {
        return this.login_password;
    }

    public void setLoginPassword(String str) {
        this.login_password = str;
    }

    public static String getWinInstallPath() {
        String fileSeparator = System.getProperty("file.separator");
        JdmConfig config = new JdmConfig();
        String path = config.filePath("dmconfig.ini");
        int index = path.lastIndexOf(fileSeparator);
        if (index > 0) {
            return path.substring(0, index + 1);
        }
        return "";
    }

    public static CorePreferences getCorePreferences() {
        if (self == null) {
            self = new CorePreferences();
        }
        return self;
    }

    private void save(String fileName) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = null;
        Element syscom_element = null;
        File file = new File(fileName);
        if (file.exists()) {
            doc = builder.parse(fileName);
            NodeList nl = doc.getElementsByTagName("syscom");
            if (nl.getLength() > 0) {
                syscom_element = (Element)nl.item(0);
            }
        } else {
            doc = builder.newDocument();
            syscom_element = doc.createElement("syscom");
            doc.appendChild(syscom_element);
        }
        syscom_element.setAttribute("language_choice", Short.toString(this.language_choice));
        if (this.login_db_name != null && this.login_db_name.length() > 0) {
            syscom_element.setAttribute("login_db_name", this.login_db_name);
        }
        if (this.login_id_name != null && this.login_id_name.length() > 0) {
            syscom_element.setAttribute("login_id_name", this.login_id_name);
        } else {
            syscom_element.removeAttribute("login_id_name");
        }
        if (this.login_password != null && this.login_password.length() > 0) {
            syscom_element.setAttribute("login_password", DBMakerDes.encrypt(this.login_password));
        } else {
            syscom_element.removeAttribute("login_password");
        }
        FileWriter out = null;
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            out = new FileWriter(file);
            tf.transform(new DOMSource(doc), new StreamResult(out));
            out.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void save() throws Exception {
        this.save(CorePreferences.getConfigName());
    }

    static class DBMakerDes {
        static String key = "DBMakerDes";
        private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

        DBMakerDes() {
        }

        static String encrypt(String content) {
            if (content == null) {
                return null;
            }
            try {
                SecureRandom random = new SecureRandom();
                DESKeySpec desKey = new DESKeySpec(key.getBytes());
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
                SecretKey securekey = keyFactory.generateSecret(desKey);
                Cipher cipher = Cipher.getInstance("DES");
                cipher.init(1, (Key)securekey, random);
                byte[] result = cipher.doFinal(content.getBytes());
                return DBMakerDes.toHexString(result);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        static String decrypt(String strContent) {
            if (strContent == null) {
                return null;
            }
            try {
                byte[] content = DBMakerDes.toByteArray(strContent);
                SecureRandom random = new SecureRandom();
                DESKeySpec desKey = new DESKeySpec(key.getBytes());
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
                SecretKey securekey = keyFactory.generateSecret(desKey);
                Cipher cipher = Cipher.getInstance("DES");
                cipher.init(2, (Key)securekey, random);
                byte[] result = cipher.doFinal(content);
                return new String(result);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        static String toHexString(byte[] bytes) {
            char[] hexChars = new char[bytes.length * 2];
            for (int j = 0; j < bytes.length; ++j) {
                int v = bytes[j] & 0xFF;
                hexChars[j * 2] = HEX_ARRAY[v >>> 4];
                hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            }
            return new String(hexChars);
        }

        static byte[] toByteArray(String s) throws Exception {
            int len = s.length();
            byte[] data = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            }
            return data;
        }
    }

    class DB {
        String db_name;
        String id_name;
        String password;

        DB(String db, String id, String pw) {
            this.db_name = db;
            this.id_name = id;
            this.password = pw;
        }
    }
}

