/*
 * Decompiled with CFR 0.152.
 */
package dbaut.infoObject;

import dbaut.infoObject.ComboBoxObject;

public class ColumnInfoObject
implements ComboBoxObject {
    public int precision = 10;
    public int scale;
    public int type;
    public boolean nullable = true;
    public boolean isEditable = true;
    public String colname = "";
    public String dataType;
    public String local_type = null;
    public boolean isEncrypted = false;

    public ColumnInfoObject(String colname, int type, int precision, int scale, boolean nullable, boolean isEditable, String local_type) {
        this(colname, type, precision, scale, nullable, isEditable, local_type, false);
    }

    public ColumnInfoObject(String colname, int type, int precision, int scale, boolean nullable, boolean isEditable, String local_type, boolean isEncrypted) {
        this.colname = colname;
        this.type = type;
        this.precision = precision;
        this.scale = scale;
        this.nullable = nullable;
        this.isEditable = isEditable;
        this.dataType = this.getDBMakerDataType();
        this.local_type = local_type != null ? local_type.toLowerCase() : null;
        this.isEncrypted = isEncrypted;
        if (this.dataType.equalsIgnoreCase("nclob")) {
            precision = Short.MAX_VALUE;
        }
        if (this.dataType.equalsIgnoreCase("char") && precision > Short.MAX_VALUE) {
            precision = Short.MAX_VALUE;
        }
    }

    public ColumnInfoObject() {
    }

    public ColumnInfoObject(String colname, String dataType, int precision, int scale, boolean nullable, boolean isEditable) {
        this(colname, dataType, precision, scale, nullable, isEditable, false);
    }

    public ColumnInfoObject(String colname, String dataType, int precision, int scale, boolean nullable, boolean isEditable, boolean isEncrypted) {
        this(colname, ColumnInfoObject.getDBMakerDataType(dataType), precision, scale, nullable, isEditable, dataType, isEncrypted);
    }

    public String getDataType() {
        return this.dataType.trim();
    }

    public String getColName() {
        return this.colname;
    }

    public int getType() {
        return this.type;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public Boolean getNullable() {
        if (this.nullable) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String toString() {
        return this.colname;
    }

    public String getDBMakerDataType() {
        String typeStr = "char";
        int i = this.getType();
        if (this.local_type != null && (this.local_type.equals("serial") || this.local_type.equals("bigserial"))) {
            return this.local_type;
        }
        switch (i) {
            case -5: {
                typeStr = "bigint";
                break;
            }
            case -2: {
                typeStr = "binary";
                break;
            }
            case -7: {
                typeStr = "smallint";
                break;
            }
            case 2004: {
                typeStr = "long varbinary";
                break;
            }
            case 1: {
                typeStr = "char";
                break;
            }
            case 2005: {
                typeStr = "long varchar";
                break;
            }
            case 91: {
                typeStr = "date";
                break;
            }
            case 3: {
                typeStr = "decimal";
                break;
            }
            case 8: {
                typeStr = "double";
                break;
            }
            case 6: 
            case 7: {
                typeStr = "real";
                break;
            }
            case 4: {
                typeStr = "integer";
                break;
            }
            case -4: {
                typeStr = "long varbinary";
                break;
            }
            case -1: {
                typeStr = "long varchar";
                break;
            }
            case 2: {
                typeStr = "decimal";
                break;
            }
            case 5: {
                typeStr = "smallint";
                break;
            }
            case 92: {
                typeStr = "time";
                break;
            }
            case 93: {
                typeStr = "timestamp";
                break;
            }
            case -6: {
                typeStr = "smallint";
                break;
            }
            case -3: {
                typeStr = "binary";
                break;
            }
            case 12: {
                typeStr = "varchar";
                break;
            }
            case -16: 
            case -10: {
                typeStr = "nclob";
                break;
            }
            case -15: 
            case -8: {
                typeStr = "nchar";
                break;
            }
            case -9: {
                typeStr = "nvarchar";
                break;
            }
            case 301: {
                typeStr = "file";
                break;
            }
            default: {
                typeStr = "char";
            }
        }
        return typeStr;
    }

    @Override
    public void setValue(String str) {
        this.colname = str;
    }

    public static int getDBMakerDataType(String inStr) {
        int type = 1;
        type = inStr.equalsIgnoreCase("integer") ? 4 : (inStr.equalsIgnoreCase("binary") ? -2 : (inStr.equalsIgnoreCase("smallint") ? -7 : (inStr.equalsIgnoreCase("long varbinary") ? -4 : (inStr.equalsIgnoreCase("char") ? 1 : (inStr.equalsIgnoreCase("long varchar") ? -1 : (inStr.equalsIgnoreCase("date") ? 91 : (inStr.equalsIgnoreCase("decimal") ? 3 : (inStr.equalsIgnoreCase("double") ? 8 : (inStr.equalsIgnoreCase("real") ? 7 : (inStr.equalsIgnoreCase("time") ? 92 : (inStr.equalsIgnoreCase("timestamp") ? 93 : (inStr.equalsIgnoreCase("varchar") ? 12 : (inStr.equalsIgnoreCase("nchar") ? -15 : (inStr.equalsIgnoreCase("nvarchar") ? 12 : (inStr.equalsIgnoreCase("clob") ? -1 : (inStr.equalsIgnoreCase("blob") ? -4 : (inStr.equalsIgnoreCase("nclob") ? -10 : 1)))))))))))))))));
        return type;
    }
}

