/*
 * Decompiled with CFR 0.152.
 */
package dbaut.comp;

import dbaut.comp.DbaRadioMenuItem;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.preference.CorePreferences;
import dbaut.resource.DBAResourceBundle;
import java.awt.event.ActionEvent;
import java.util.Locale;

public class LocaleRadioMenuItem
extends DbaRadioMenuItem
implements LocaleChangeListener {
    private static final long serialVersionUID = 8934672752487222134L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dbautproperties.dbaut.Res", LocaleManager.getLocale());
    private short language_choice;

    public LocaleRadioMenuItem(short language_choice) {
        this.language_choice = language_choice;
        switch (language_choice) {
            case 1: {
                this.setText(this.res.getString("Chinese"));
                this.setMnemonic('C');
                break;
            }
            case 2: {
                this.setText(this.res.getString("Japanese"));
                this.setMnemonic('J');
                break;
            }
            case 3: {
                this.setText(this.res.getString("China"));
                this.setMnemonic('H');
                break;
            }
            default: {
                this.setText(this.res.getString("English"));
                this.setMnemonic('E');
            }
        }
        this.addActionListener(new ReflectionAction(this, "language_actionPerformed"));
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    public void language_actionPerformed(ActionEvent e) {
        CorePreferences cp = CorePreferences.getCorePreferences();
        switch (this.language_choice) {
            case 1: {
                LocaleManager.getLocaleManager().localeChanged(new LocaleChangeEvent(this, Locale.TAIWAN));
                System.out.println("CHINESE = " + this.getLanguageChoice());
                break;
            }
            case 2: {
                LocaleManager.getLocaleManager().localeChanged(new LocaleChangeEvent(this, Locale.JAPAN));
                System.out.println("JAPANESE = " + this.getLanguageChoice());
                break;
            }
            case 3: {
                LocaleManager.getLocaleManager().localeChanged(new LocaleChangeEvent(this, Locale.CHINA));
                System.out.println("CHINA = " + this.getLanguageChoice());
                break;
            }
            default: {
                LocaleManager.getLocaleManager().localeChanged(new LocaleChangeEvent(this, Locale.US));
                System.out.println("ENGLISH = " + this.getLanguageChoice());
            }
        }
        cp.setLanguageChoice(this.getLanguageChoice());
        try {
            cp.save();
        }
        catch (Exception ec) {
            ec.printStackTrace();
        }
    }

    public short getLanguageChoice() {
        return this.language_choice;
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = e != null ? DBAResourceBundle.getDBAResourceBundle("dbautproperties.dbaut.Res", e.getLocale()) : DBAResourceBundle.getDBAResourceBundle("dbautproperties.dbaut.Res", LocaleManager.getLocale());
        switch (this.language_choice) {
            case 1: {
                this.setText(this.res.getString("Chinese"));
                break;
            }
            case 2: {
                this.setText(this.res.getString("Japanese"));
                break;
            }
            case 3: {
                this.setText(this.res.getString("China"));
                break;
            }
            default: {
                this.setText(this.res.getString("English"));
            }
        }
    }
}

