/*
 * Decompiled with CFR 0.152.
 */
package dbaut.comp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class JComboBoxShowPopup
extends PlainDocument {
    private JComboBox comboBox;
    private ComboBoxModel model;
    private JTextComponent editor;
    private boolean selecting = false;

    public JComboBoxShowPopup(final JComboBox comboBox) {
        this.comboBox = comboBox;
        this.model = comboBox.getModel();
        this.editor = (JTextComponent)comboBox.getEditor().getEditorComponent();
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!JComboBoxShowPopup.this.selecting) {
                    JComboBoxShowPopup.this.highLightCompletedText(0);
                }
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (comboBox.isDisplayable()) {
                    comboBox.setPopupVisible(true);
                }
            }
        });
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.remove(offs, len);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(offset, str, a);
        Object item = this.lookupItem(this.getText(0, this.getLength()));
        if (item != null) {
            this.setSelectItem(item);
        } else {
            item = this.comboBox.getSelectedItem();
            offset -= str.length();
        }
        this.setText(item.toString());
        this.highLightCompletedText(offset + str.length());
    }

    private void setSelectItem(Object item) {
        this.selecting = true;
        this.model.setSelectedItem(item);
        this.selecting = false;
    }

    private void highLightCompletedText(int i) {
        this.editor.setSelectionStart(i);
        this.editor.setSelectionEnd(this.getLength());
    }

    private void setText(String text) throws BadLocationException {
        super.remove(0, this.getLength());
        super.insertString(0, text, null);
    }

    private Object lookupItem(String text) {
        Object selectItem = this.model.getSelectedItem();
        if (selectItem != null && this.startWithMatch(selectItem.toString(), text)) {
            return selectItem;
        }
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object currentItem = this.model.getElementAt(i);
            if (currentItem == null || !this.startWithMatch(currentItem.toString(), text)) continue;
            return currentItem;
        }
        return this.model.getElementAt(0).toString();
    }

    private boolean startWithMatch(String item, String text) {
        return item.toUpperCase().startsWith(text.toUpperCase());
    }
}

