/*
 * Decompiled with CFR 0.152.
 */
package dbaut.comp;

import dbaut.comp.DNDComponentInterface;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class DragNDrogList
extends JList
implements DNDComponentInterface,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    private DropTarget dropTarget = new DropTarget(this, this);
    private DragSource dragSource = new DragSource();
    private boolean orderchange = false;
    private ActionListener listener = null;
    private boolean b = false;
    private DataFlavor dataFlavor = null;

    public void setDataFlavor(DataFlavor df) {
        this.dataFlavor = df;
    }

    public DragNDrogList() {
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        event.acceptDrag(2);
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        try {
            Transferable transferable = event.getTransferable();
            DataFlavor df = null;
            df = this.dataFlavor == null ? DataFlavor.stringFlavor : this.dataFlavor;
            if (transferable.isDataFlavorSupported(df)) {
                event.acceptDrop(2);
                Object o = transferable.getTransferData(df);
                Object s = this.getSelectedValue();
                int index = this.locationToIndex(event.getLocation());
                int selected = this.getSelectedIndex();
                if (s != null && o != null && o.equals(s) && index >= 0) {
                    this.insertElementAt(o, index);
                    if (selected > index) {
                        this.removeElementAt(selected + 1);
                    } else {
                        this.removeElementAt(selected);
                    }
                    this.orderchange = true;
                } else {
                    this.addElement(o);
                    this.orderchange = false;
                }
                event.getDropTargetContext().dropComplete(true);
                if (this.listener != null) {
                    this.listener.actionPerformed(null);
                }
            } else {
                event.rejectDrop();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            System.err.println("Exception" + exception.getMessage());
            event.rejectDrop();
        }
        catch (UnsupportedFlavorException ufException) {
            ufException.printStackTrace();
            System.err.println("Exception" + ufException.getMessage());
            event.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        Object selected = this.getSelectedValue();
        if (selected != null) {
            if (selected instanceof Transferable) {
                this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, (Transferable)selected, this);
            } else {
                StringSelection text = new StringSelection(selected.toString());
                this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, text, this);
            }
        } else {
            System.out.println("nothing was selected");
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        if (event.getDropSuccess() && !this.orderchange) {
            this.removeElement();
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    @Override
    public void removeElementAt(int index) {
        ((DefaultListModel)this.getModel()).removeElementAt(index);
    }

    @Override
    public void insertElementAt(Object s, int index) {
        ((DefaultListModel)this.getModel()).insertElementAt(s, index);
    }

    @Override
    public void addElement(Object s) {
        ((DefaultListModel)this.getModel()).addElement(s);
    }

    @Override
    public void removeElement() {
        ((DefaultListModel)this.getModel()).removeElement(this.getSelectedValue());
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }
}

