/*
 * Decompiled with CFR 0.152.
 */
package dbaut.alarm;

import dbaut.alarm.Sleeper;
import java.util.Vector;

public class Alarm {
    private Vector sleepers = new Vector();
    private AlarmThread alarmThread = new AlarmThread();

    public Alarm() {
        this.alarmThread.start();
    }

    public synchronized void setAlarm(Sleeper s, long time) {
        if (time == 0L) {
            System.out.println("Can't set timer in 0 second");
            return;
        }
        this.sleepers.addElement(s);
        this.alarmThread.setSleeper(s);
        this.alarmThread.setTime(time *= 1000L);
        this.alarmThread.interrupt();
    }

    public synchronized void setAlarmMilli(Sleeper s, int time) {
        if (time == 0) {
            System.out.println("Can't set timer in 0 millisecond");
            return;
        }
        this.sleepers.addElement(s);
        this.alarmThread.setSleeper(s);
        this.alarmThread.setTime(time);
        this.alarmThread.interrupt();
    }

    public synchronized void cancelAlarm(Sleeper s) {
        int index = this.sleepers.indexOf(s);
        if (index >= 0) {
            this.sleepers.removeElementAt(index);
        }
    }

    private synchronized void wakeUpSleeper(Sleeper s) {
        int index = this.sleepers.indexOf(s);
        if (index < 0) {
            return;
        }
        s.wakeUp();
    }

    private class AlarmThread
    extends Thread {
        Sleeper s = null;
        long sleeptime = 5000L;

        AlarmThread(Sleeper s, long time) {
            this.s = s;
            this.sleeptime = time;
        }

        AlarmThread() {
        }

        public void setSleeper(Sleeper s) {
            this.s = s;
        }

        public void setTime(long time) {
            this.sleeptime = time;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    AlarmThread.sleep(this.sleeptime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Alarm.this.wakeUpSleeper(this.s);
            }
        }
    }
}

