/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.CommonDatabaseConnectionInterface;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.locale.LocaleManager;
import dbaut.privilege.UserPrivilege;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SyscomCommonDatabaseConnection
implements CommonDatabaseConnectionInterface {
    private Connection dbconn = null;
    private final String dbLogin_String = "jdbc:dbmaker:";
    private final String dbDriverName_String = "dbmaker.sql.JdbcOdbcDriver";
    public String dbname = "";
    public String username = "";
    public String password = null;
    public boolean isConnected = false;
    private String db_dir = "";
    private Float fileversion = null;
    private Float version = null;
    public boolean isDBA = false;
    private Component dlg = null;
    private boolean isIDCAP = true;
    private boolean startDB = false;
    private boolean isTDE = false;
    private UserPrivilege userPrivilege = null;

    public SyscomCommonDatabaseConnection(String databaseName, String userName, String password, Connection conn) {
        this.dbconn = conn;
        this.dbname = databaseName;
        this.username = userName;
        this.password = password;
        this.init();
    }

    public SyscomCommonDatabaseConnection(String databaseName, String userName, String password, Component dlg) {
        Object stmt = null;
        Object rs = null;
        try {
            this.dbname = databaseName;
            this.username = userName;
            this.password = password;
            this.dlg = dlg;
            Class.forName("dbmaker.sql.JdbcOdbcDriver");
            JdmConfig config = new JdmConfig();
            if (config.isTerminalServer(this.dbname)) {
                System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
                if (!GuiUt.isWindows()) {
                    System.setProperty("DM_CONNECT_MODE", "START_DB");
                    this.startDB = true;
                } else {
                    System.setProperty("DM_CONNECT_MODE", "SQL_DMTOOL_CONNECT_DB");
                }
            } else {
                System.setProperty("DM_DRIVER_MODE", "CLIENT_SERVER");
                System.setProperty("DM_CONNECT_MODE", "SQL_DMTOOL_CONNECT_DB");
            }
            String errlcode = LocaleManager.getErrlcode();
            String conStr = "jdbc:dbmaker:" + this.dbname + ";errlcode=" + errlcode;
            this.dbconn = DriverManager.getConnection(conStr, userName, password);
            this.init();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(dlg, null, sqle);
            this.isConnected = false;
        }
        catch (ClassNotFoundException ex) {
            GuiUt.showErrorDlg(dlg, ex.getMessage(), null);
            this.isConnected = false;
        }
        catch (Exception ex) {
            GuiUt.showErrorDlg(dlg, ex.getMessage(), null);
            this.isConnected = false;
        }
        DbaObject.close(rs);
        DbaObject.close(stmt);
    }

    private void init() {
        Object stmt = null;
        Object rs = null;
        try {
            this.dbconn.setAutoCommit(true);
            ((JdbcOdbcConnection)this.dbconn).setOption(1126, 2);
            ((JdbcOdbcConnection)this.dbconn).setOption(1136, 0);
            this.setIDCAP(this.getIDCAP());
            this.isTDE = this.getTDE();
            this.isConnected = this.initPrivilege(this.dbconn, this.username, this.dlg);
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.dlg, null, sqle);
            this.isConnected = false;
        }
        catch (Exception ex) {
            GuiUt.showErrorDlg(this.dlg, ex.getMessage(), null);
            this.isConnected = false;
        }
        DbaObject.close(rs);
        DbaObject.close(stmt);
    }

    private boolean initPrivilege(Connection conn, String userName, Component comp) {
        boolean result = true;
        try {
            if (this.isIDCAP()) {
                userName = userName.toUpperCase();
            }
            this.setUserPrivilege(new UserPrivilege(conn, userName, comp));
        }
        catch (SQLException ex) {
            result = false;
            ex.printStackTrace();
        }
        return result;
    }

    public UserPrivilege getUserPrivilege() {
        return this.userPrivilege;
    }

    private void setUserPrivilege(UserPrivilege userPrivilege) {
        this.userPrivilege = userPrivilege;
    }

    public boolean isFileVersionLater35() {
        return this.fileversion != null && this.fileversion.floatValue() > 3.5f;
    }

    public boolean isVersionLaterOrEqual36() {
        return this.version != null && this.version.floatValue() >= 3.6f;
    }

    public float getFileVersion() {
        if (!this.isConnected) {
            return 0.0f;
        }
        if (this.fileversion != null) {
            return this.fileversion.floatValue();
        }
        this.getVersion();
        if (this.fileversion != null) {
            return this.fileversion.floatValue();
        }
        return 0.0f;
    }

    public float getDBMakerVersion() {
        if (!this.isConnected) {
            return 0.0f;
        }
        if (this.version != null) {
            return this.version.floatValue();
        }
        this.getVersion();
        if (this.version != null) {
            return this.version.floatValue();
        }
        return 0.0f;
    }

    private void getVersion() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.db_dir = JdmConfig.getDBDir(this.dbname);
            stmt = this.dbconn.createStatement();
            rs = stmt.executeQuery("select VALUE from SYSTEM.SYSINFO WHERE INFO in ('FILE_VERSION', 'VERSION') ORDER BY ID");
            if (rs.next()) {
                this.version = new Float(rs.getString(1));
            }
            if (rs.next()) {
                this.fileversion = new Float(rs.getString(1));
            }
            rs.close();
            if (this.version.floatValue() >= 3.6f) {
                rs = stmt.executeQuery("SELECT GETSYSINFO('DBDIR') FROM SYSTEM.SYSINFO");
                if (rs.next()) {
                    this.db_dir = rs.getString(1);
                    if (this.db_dir != null) {
                        this.db_dir = this.db_dir.trim();
                    }
                }
                rs.close();
            }
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.dlg, null, sqle);
        }
        DbaObject.close(rs);
        DbaObject.close(stmt);
    }

    @Override
    public Connection getDbConnection() {
        return this.dbconn;
    }

    @Override
    public void disconnect() {
        try {
            if (this.dbconn != null) {
                if (this.startDB) {
                    System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
                }
                this.dbconn.close();
                this.isConnected = false;
                this.dbconn = null;
            }
        }
        catch (SQLException E) {
            if (E.getErrorCode() == 5307) {
                return;
            }
            GuiUt.showSQLException(this.dlg, null, E);
            this.isConnected = false;
        }
    }

    public void setDBDir(String db_dir) {
        this.db_dir = db_dir != null ? db_dir.trim() : db_dir;
    }

    public String getDBDir() {
        return this.db_dir;
    }

    @Override
    public void setAutoCommit(boolean b) {
        try {
            this.dbconn.setAutoCommit(b);
        }
        catch (SQLException sqle) {
            System.out.println(sqle.getMessage());
        }
    }

    public long getHDBC() {
        try {
            return ((JdbcOdbcConnection)this.dbconn).getHDBC();
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public String getDatabaseName() {
        return this.dbname;
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    private boolean getIDCAP() throws SQLException {
        boolean result = false;
        int value = ((JdbcOdbcConnection)this.dbconn).getOptionInt(28);
        if (value == 1) {
            result = true;
        }
        return result;
    }

    private boolean getTDE() throws SQLException {
        boolean result = false;
        try {
            Statement stmt = this.dbconn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT VALUE FROM SYSINFO WHERE ID = '0725'");
            String tdeOpen = null;
            if (rs.next()) {
                tdeOpen = rs.getString(1).trim();
                result = tdeOpen.compareToIgnoreCase("OPEN") == 0;
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isTDE() {
        return this.isTDE;
    }

    public boolean isIDCAP() {
        return this.isIDCAP;
    }

    private void setIDCAP(boolean isIDCAP) {
        this.isIDCAP = isIDCAP;
    }
}

