/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.Address_array;
import dbaut.DbaUtDef;
import dbaut.Logical_file;
import dbaut.String_array;
import dbaut.dbalib;
import dbaut.util.SortUt;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class JdmConfig {
    public static final String CONFIG_FILE = "dmconfig.ini";
    public static final String DEFAULT_BACKUP_DIR = "backup";
    public static final String USER_DIR = System.getProperty("user.dir");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final int FILE_SEPARATOR_LEN = FILE_SEPARATOR.length();
    public static final String OFFLINE_DIR = "offline";
    private dbalib cfun = new dbalib();
    private long[] handle = null;
    private static final int LEN_FNAME = 256;
    private static final int DB_MAX_NMSTR = 8;
    public static String localHostName = null;
    public static List<String> localIpAddress = new ArrayList<String>();
    public static boolean isFileLock = false;

    public JdmConfig() {
        if (localHostName == null && localIpAddress.isEmpty()) {
            this.initialLocalHostInfo();
        }
    }

    public static synchronized int copyDBSection(String srcConfigFile, String desConfigFile, String dbName) {
        dbalib cfun = new dbalib();
        int rc = cfun.procCopySection(srcConfigFile.getBytes(), desConfigFile.getBytes(), dbName.getBytes());
        if (rc != 0) {
            System.out.println("Copy database section failed! rc=" + rc);
        }
        return rc;
    }

    public static synchronized String getDBDir(String dbName) {
        if (dbName == null) {
            return "";
        }
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen(CONFIG_FILE, dbName, "r");
        if (rc != 0) {
            return "";
        }
        String dbdir = (String)config.getPara("DB_DBDIR", 4096);
        config.fileClose();
        if (dbdir != null && dbdir.length() > 0) {
            return dbdir.trim();
        }
        return "";
    }

    public static synchronized String getOfflineBackupDir(String dbName) {
        String bkdir = null;
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen(CONFIG_FILE, dbName, "r");
        if (rc != DbaUtDef.RTN_OK) {
            System.out.println("Open dmconfig.ini error " + rc);
            return null;
        }
        String_array bkdir_sa = (String_array)config.getPara("DB_BKDIR", 53504);
        if (bkdir_sa != null && bkdir_sa.content.length > 0) {
            bkdir = bkdir_sa.content[0].toString().trim();
            if (!bkdir.startsWith("/") && !bkdir.startsWith("\\\\") && bkdir.indexOf(":") <= 0) {
                String dbdir = (String)config.getPara("DB_DBDIR", 4096);
                if (dbdir == null || dbdir.length() == 0) {
                    dbdir = USER_DIR;
                }
                bkdir = dbdir.endsWith(FILE_SEPARATOR) ? dbdir + bkdir : dbdir + FILE_SEPARATOR + bkdir;
            }
        } else {
            String dbdir = (String)config.getPara("DB_DBDIR", 4096);
            if (dbdir == null || dbdir.length() == 0) {
                dbdir = USER_DIR;
            }
            bkdir = dbdir.endsWith(FILE_SEPARATOR) ? dbdir + DEFAULT_BACKUP_DIR : dbdir + FILE_SEPARATOR + DEFAULT_BACKUP_DIR;
        }
        config.fileClose();
        bkdir = bkdir.endsWith(FILE_SEPARATOR) ? bkdir + OFFLINE_DIR : bkdir + FILE_SEPARATOR + OFFLINE_DIR;
        return JdmConfig.filterFileSeparator(bkdir);
    }

    public static synchronized String getOnlineBackupDir(String dbName) {
        String bkdir = null;
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen(CONFIG_FILE, dbName, "r");
        if (rc != DbaUtDef.RTN_OK) {
            System.out.println("Open dmconfig.ini error " + rc);
            return null;
        }
        String_array bkdir_sa = (String_array)config.getPara("DB_BKDIR", 53504);
        if (bkdir_sa != null && bkdir_sa.content.length > 0) {
            bkdir = bkdir_sa.content[0].toString().trim();
            if (!bkdir.startsWith("/") && !bkdir.startsWith("\\\\") && bkdir.indexOf(":") <= 0) {
                String dbdir = (String)config.getPara("DB_DBDIR", 4096);
                if (dbdir == null || dbdir.length() == 0) {
                    dbdir = USER_DIR;
                }
                bkdir = dbdir.endsWith(FILE_SEPARATOR) ? dbdir + bkdir : dbdir + FILE_SEPARATOR + bkdir;
            }
        } else {
            String dbdir = (String)config.getPara("DB_DBDIR", 4096);
            if (dbdir == null || dbdir.length() == 0) {
                dbdir = USER_DIR;
            }
            bkdir = dbdir.endsWith(FILE_SEPARATOR) ? dbdir + DEFAULT_BACKUP_DIR : dbdir + FILE_SEPARATOR + DEFAULT_BACKUP_DIR;
        }
        config.fileClose();
        return JdmConfig.filterFileSeparator(bkdir);
    }

    public static synchronized String getOnlineBackupDir(String configFileFullPath, String dbName) {
        String bkdir = null;
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen(configFileFullPath, dbName, "r");
        if (rc != DbaUtDef.RTN_OK) {
            System.out.println("Open " + configFileFullPath + " error " + rc);
            return null;
        }
        String_array bkdir_sa = (String_array)config.getPara("DB_BKDIR", 53504);
        if (bkdir_sa != null && bkdir_sa.content.length > 0) {
            bkdir = bkdir_sa.content[0].toString().trim();
            if (!bkdir.startsWith("/") && !bkdir.startsWith("\\\\") && bkdir.indexOf(":") <= 0) {
                String dbdir = (String)config.getPara("DB_DBDIR", 4096);
                if (dbdir == null || dbdir.length() == 0) {
                    dbdir = USER_DIR;
                }
                bkdir = dbdir.endsWith(FILE_SEPARATOR) ? dbdir + bkdir : dbdir + FILE_SEPARATOR + bkdir;
            }
        } else {
            String dbdir = (String)config.getPara("DB_DBDIR", 4096);
            if (dbdir == null || dbdir.length() == 0) {
                dbdir = USER_DIR;
            }
            bkdir = dbdir.endsWith(FILE_SEPARATOR) ? dbdir + DEFAULT_BACKUP_DIR : dbdir + FILE_SEPARATOR + DEFAULT_BACKUP_DIR;
        }
        config.fileClose();
        return JdmConfig.filterFileSeparator(bkdir);
    }

    public static synchronized String getOnlineBackupDir(String dbName, Connection connection) throws SQLException {
        String bkdir = null;
        CallableStatement cstmt = connection.prepareCall("{call GETSYSTEMOPTION('bkdir', ?)}");
        cstmt.registerOutParameter(1, 12);
        cstmt.executeQuery();
        bkdir = cstmt.getString(1);
        cstmt.close();
        if (bkdir == null) {
            return null;
        }
        if ((bkdir = bkdir.trim()).length() == 0) {
            return null;
        }
        char firstChar = bkdir.charAt(0);
        if (firstChar == '\"') {
            String str1 = bkdir.substring(1);
            if (str1.startsWith("/") || str1.startsWith("\\\\") || str1.indexOf(":") == 1) {
                int position = str1.indexOf("\"");
                if (position != -1) {
                    bkdir = bkdir.substring(1, position + 1);
                }
            } else {
                JdmConfig config;
                int rc;
                int position = str1.indexOf("\"");
                if (position != -1) {
                    bkdir = bkdir.substring(1, position + 1);
                }
                if ((rc = (config = new JdmConfig()).fileOpen(CONFIG_FILE, dbName, "r")) != DbaUtDef.RTN_OK) {
                    System.out.println("Open dmconfig.ini error " + rc);
                    return null;
                }
                String dbdir = (String)config.getPara("DB_DBDIR", 4096);
                if (dbdir == null || dbdir.length() == 0) {
                    dbdir = USER_DIR;
                }
                bkdir = dbdir.endsWith(FILE_SEPARATOR) ? dbdir + bkdir : dbdir + FILE_SEPARATOR + bkdir;
            }
        } else if (bkdir.startsWith("/") || bkdir.startsWith("\\\\") || bkdir.indexOf(":") == 1) {
            int blankPosition = bkdir.indexOf(" ");
            if (blankPosition != -1) {
                bkdir = bkdir.substring(0, blankPosition);
            }
        } else {
            JdmConfig config;
            int rc;
            int blankPosition = bkdir.indexOf(" ");
            if (blankPosition != -1) {
                bkdir = bkdir.substring(0, blankPosition);
            }
            if ((rc = (config = new JdmConfig()).fileOpen(CONFIG_FILE, dbName, "r")) != DbaUtDef.RTN_OK) {
                System.out.println("Open dmconfig.ini error " + rc);
                return null;
            }
            String dbdir = (String)config.getPara("DB_DBDIR", 4096);
            if (dbdir == null || dbdir.length() == 0) {
                dbdir = USER_DIR;
            }
            bkdir = dbdir.endsWith(FILE_SEPARATOR) ? dbdir + bkdir : dbdir + FILE_SEPARATOR + bkdir;
        }
        return JdmConfig.filterFileSeparator(bkdir);
    }

    private static synchronized String filterFileSeparator(String bkdir) {
        String result = bkdir;
        if (bkdir != null && bkdir.endsWith(FILE_SEPARATOR)) {
            result = bkdir.substring(0, bkdir.lastIndexOf(FILE_SEPARATOR));
        }
        return result;
    }

    public static synchronized String getDefaultUser(String dbname) {
        String user = JdmConfig.getUserId(dbname);
        if (user != null && user.length() > 0) {
            return user;
        }
        return "SYSADM";
    }

    public static ArrayList<String> getAllDBNames() {
        return JdmConfig.getAllDBNames(CONFIG_FILE);
    }

    public static ArrayList<String> getAllDBNames(String fileName) {
        JdmConfig config = new JdmConfig();
        ArrayList<String> dbNameList = config.fileScan(fileName, 0);
        return dbNameList;
    }

    public static ArrayList<String> getLocalDBNames() {
        return JdmConfig.getLocalDBNames(CONFIG_FILE);
    }

    public static ArrayList<String> getLocalDBNames(String fileName) {
        JdmConfig config = new JdmConfig();
        ArrayList<String> dbNameList = config.fileScan(fileName, 1);
        return dbNameList;
    }

    public static synchronized Vector<String> getDatabaseNames(String filename, boolean onlyLocalHost) {
        return JdmConfig.getDatabaseNames(filename, onlyLocalHost, false);
    }

    public static synchronized Vector<String> getDatabaseNames(String filename, boolean onlyLocalHost, boolean onlyClientServer) {
        int size;
        JdmConfig config = new JdmConfig();
        Vector<String> v = config.fileScan(filename);
        if (v == null) {
            return new Vector<String>();
        }
        int i = 0;
        int j = -1;
        while (i < v.size()) {
            String current = v.elementAt(i);
            if (onlyLocalHost && !config.isLocalHost(filename, current)) {
                v.removeElementAt(i);
                continue;
            }
            if (onlyClientServer && config.isTerminalServer(filename, current)) {
                v.removeElementAt(i);
                continue;
            }
            while ((j = v.indexOf(current, i + 1)) > 0) {
                v.removeElementAt(j);
            }
            ++i;
        }
        String next = null;
        for (int x = size = v.size(); x >= 1; --x) {
            for (int y = 1; y < x; ++y) {
                String previous = v.elementAt(y - 1);
                if (previous.compareToIgnoreCase(next = v.elementAt(y)) <= 0) continue;
                v.setElementAt(next, y - 1);
                v.setElementAt(previous, y);
            }
        }
        return v;
    }

    public static List<String> getLocalIP(boolean isup) {
        String ip = "";
        ArrayList<String> localIpAddress = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
            while (e1.hasMoreElements()) {
                NetworkInterface ni = e1.nextElement();
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ineta = e2.nextElement();
                    if (ineta.getHostAddress().indexOf(":") != -1) continue;
                    ip = ineta.getHostAddress();
                    localIpAddress.add(ip);
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return localIpAddress;
    }

    public void initialLocalHostInfo() {
        boolean isup = true;
        this.initialLocalHostInfo(isup);
    }

    public void initialLocalHostInfo(boolean isup) {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            localHostName = ia.getHostName();
            localIpAddress = JdmConfig.getLocalIP(isup);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    private boolean isLocal(String dbname) {
        String svAdr = "";
        String svr_address = (String)this.getPara("DB_SVADR", 4096);
        this.fileClose();
        if (svr_address == null || svr_address.equalsIgnoreCase(localHostName) || svr_address.equalsIgnoreCase("localhost") || svr_address.equalsIgnoreCase("127.0.0.1")) {
            return true;
        }
        ListIterator<String> iter = localIpAddress.listIterator();
        while (iter.hasNext()) {
            svAdr = iter.next();
            if (!svr_address.equalsIgnoreCase(svAdr)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isLocalHost(String dbname) {
        return this.isLocalHost(CONFIG_FILE, dbname);
    }

    public synchronized boolean isLocalHost(String filename, String dbname) {
        int rc = this.fileOpen(filename, dbname, "r");
        if (rc != 0) {
            return false;
        }
        return this.isLocal(dbname);
    }

    public synchronized boolean isTerminalServer(String dbname) {
        return this.isTerminalServer(CONFIG_FILE, dbname);
    }

    public synchronized boolean isTerminalServer(String filename, String dbname) {
        int rc = this.fileOpen(filename, dbname, "r");
        if (rc != 0) {
            return true;
        }
        String svr_address = (String)this.getPara("DB_SVADR", 4096);
        this.fileClose();
        return svr_address == null || svr_address.length() <= 0;
    }

    public synchronized String filePath(String filename) {
        byte[] filepath = new byte[2048];
        int rc = this.cfun.procFilePath(filename.getBytes(), filepath);
        if (rc == 0) {
            return new String(filepath).trim();
        }
        return null;
    }

    public synchronized Vector<String> fileScan(String filename) {
        int[] count = new int[1];
        byte[] sections = null;
        int e = 100;
        int rc = 0;
        while (true) {
            count[0] = e;
            sections = new byte[e * 129];
            rc = this.cfun.procFileScan(filename.getBytes(), sections, count, 0);
            if (rc != 0) {
                return null;
            }
            if (count[0] == 0) {
                return null;
            }
            if (count[0] != e) break;
            e *= 10;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < count[0]; ++i) {
            String name = new String(sections, i * 129, 129).trim();
            if (name.compareTo("DM_COMMON_OPTION") == 0) continue;
            v.addElement(name.trim());
        }
        return v;
    }

    public synchronized ArrayList<String> fileScan(String filename, int fLocal) {
        int[] count = new int[1];
        byte[] sections = null;
        int e = 100;
        int rc = 0;
        while (true) {
            count[0] = e;
            sections = new byte[e * 129];
            rc = this.cfun.procFileScan(filename.getBytes(), sections, count, fLocal);
            if (rc != 0 || count[0] == 0) {
                return null;
            }
            if (count[0] != e) break;
            e *= 10;
        }
        ArrayList<String> dbNameList = new ArrayList<String>();
        for (int i = 0; i < count[0]; ++i) {
            String name = new String(sections, i * 129, 129).trim();
            if (name.equalsIgnoreCase("DM_COMMON_OPTION")) continue;
            dbNameList.add(name.trim());
        }
        SortUt.sort(dbNameList);
        return dbNameList;
    }

    public synchronized int create(String filename, String dbname) {
        int rc = this.cfun.procCreate(filename.getBytes(), dbname.getBytes());
        if (rc != 0) {
            System.out.println("Error procCreate new section " + dbname + " in config file " + filename);
        }
        return rc;
    }

    public static synchronized String getUserId(String dbname) {
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen(CONFIG_FILE, dbname, "r");
        String username = null;
        if (rc == 0) {
            username = (String)config.getPara("DB_USRID", 4096);
            config.fileClose();
        } else {
            System.out.println("Error open dmconfig.ini via JdmConfig");
        }
        return username;
    }

    public synchronized int fileOpen(String filename, String dbname, String options) {
        this.handle = new long[2];
        byte[] hBuf = new byte[2048];
        if (options.equals("r+") && isFileLock) {
            return -1;
        }
        int rc = this.cfun.procFileOpen(this.handle, hBuf, filename.getBytes(), dbname.getBytes(), options.getBytes());
        if (rc != 0) {
            System.out.println("Error procFileOpen section " + dbname + " in config file " + filename);
        } else if (options.equals("r+")) {
            isFileLock = true;
        }
        return rc;
    }

    public synchronized ArrayList<String> getExistKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        int LEN = 2048;
        byte[] keyBuf = null;
        if (this.handle == null) {
            return keys;
        }
        int rc = 0;
        String key = "";
        while (rc == 0) {
            keyBuf = new byte[2048];
            rc = this.cfun.procGetNextKey(this.handle, keyBuf, 2048);
            key = new String(keyBuf).trim();
            if (key.length() <= 0) continue;
            keys.add(key.toLowerCase());
        }
        return keys;
    }

    public synchronized ArrayList<String> getExistLines() {
        ArrayList<String> lines = new ArrayList<String>();
        int LEN = 2048;
        byte[] lineBuf = null;
        if (this.handle == null) {
            return lines;
        }
        int rc = 0;
        String line = "";
        while (rc == 0) {
            lineBuf = new byte[2048];
            rc = this.cfun.procGetNextLine(this.handle, lineBuf, 2048);
            line = new String(lineBuf).trim();
            if (line.length() <= 0) continue;
            lines.add(line);
        }
        return lines;
    }

    public synchronized Object getPara(String variable, int type) {
        return this.getPara(variable, type, 0);
    }

    public synchronized Object getPara(String variable, int type, int size) {
        if (this.handle == null) {
            System.out.println("handle is null, fileOpen is required.");
            return null;
        }
        Object value = null;
        int rc = 0;
        switch (type) {
            case 53760: {
                byte[] fname = new byte[256];
                byte[] pagenum = new byte[256];
                int[] offset = new int[1];
                rc = this.cfun.procGetParaFile(this.handle, variable.getBytes(), fname, pagenum, offset);
                if (rc != 0) break;
                value = new Logical_file(variable, new String(fname, 0, 256).trim(), new String(pagenum, 0, 256).trim(), offset[0]);
                break;
            }
            case 8192: 
            case 40960: 
            case 50176: {
                int[] i_number = new int[1];
                rc = this.cfun.procGetParaInt(this.handle, variable.getBytes(), i_number, type);
                if (rc == 0) {
                    if (type == 8192) {
                        value = new Integer(i_number[0]);
                        break;
                    }
                    if (type == 40960) {
                        value = new Boolean(i_number[0] == 1);
                        break;
                    }
                    if (type != 50176) break;
                    value = new Integer(i_number[0]);
                    break;
                }
                System.out.println("procGetParaInt return rc = " + rc);
                break;
            }
            case 45056: {
                long[] l_number = new long[1];
                rc = this.cfun.procGetParaLong(this.handle, variable.getBytes(), l_number, type);
                if (rc != 0) break;
                value = new Long(l_number[0]);
                break;
            }
            case 37120: {
                byte[] address = new byte[65536];
                int[] portnum = new int[256];
                rc = this.cfun.procGetParaAdrArray(this.handle, variable.getBytes(), address, portnum);
                if (rc != 0) break;
                String[] addr = new String[256];
                for (int i = 0; i < 256; ++i) {
                    addr[i] = new String(address, i * 256, 256).trim();
                }
                value = new Address_array(addr, portnum);
                break;
            }
            case 49152: 
            case 49408: 
            case 49664: {
                if (size <= 0) {
                    size = 256;
                }
                byte[] dbf = new byte[size];
                rc = this.cfun.procGetPara(this.handle, variable.getBytes(), dbf, type, size);
                if (rc != 0) break;
                value = new String(dbf, 0, size).trim();
                break;
            }
            case 51200: {
                if (size <= 0) {
                    size = 1024;
                }
                byte[] r_buf = new byte[size];
                rc = this.cfun.procGetPara(this.handle, variable.getBytes(), r_buf, type, size);
                if (rc != 0) break;
                value = new String(r_buf, 0, size).trim();
                break;
            }
            case 53504: {
                int range = 8;
                if (variable.equalsIgnoreCase("DB_BKDIR") || variable.equalsIgnoreCase("DB_BKODR")) {
                    size = 16384;
                    range = 64;
                } else {
                    size = 2048;
                    range = 8;
                }
                byte[] j_buf = new byte[size];
                rc = this.cfun.procGetPara(this.handle, variable.getBytes(), j_buf, type, size);
                if (rc != 0) break;
                String[] files = new String[range];
                for (int i = 0; i < range; ++i) {
                    files[i] = new String(j_buf, i * 256, 256).trim();
                }
                value = new String_array(files);
                break;
            }
            default: {
                if (size <= 0) {
                    size = 1024;
                }
                byte[] buff = new byte[size];
                rc = this.cfun.procGetPara(this.handle, variable.getBytes(), buff, 4096, size);
                if (rc != 0) break;
                value = new String(buff, 0, size).trim();
            }
        }
        if (rc != 0) {
            return null;
        }
        return value;
    }

    public synchronized int fileClose() {
        int rc = this.cfun.procFileClose(this.handle);
        this.handle = null;
        isFileLock = false;
        return rc;
    }

    public synchronized int insertPara(String variable, Object value, int type) {
        if (this.handle == null) {
            System.out.println("handle is null, fileOpen is required.");
            return -1;
        }
        if (value == null) {
            System.out.println("insert parameter value is null");
            return -2;
        }
        int rc = 0;
        switch (type) {
            case 8192: {
                Integer objI = new Integer(value.toString());
                int i_value = objI;
                rc = this.cfun.procInsertInt(this.handle, variable.getBytes(), i_value, type);
                break;
            }
            case 40960: {
                int b_value = (Boolean)value != false ? 1 : 0;
                rc = this.cfun.procInsertInt(this.handle, variable.getBytes(), b_value, 8192);
                break;
            }
            case 53760: {
                String fname = ((Logical_file)value).getFilename();
                if (fname.indexOf(" ") > 0 && !fname.startsWith("\"")) {
                    fname = "\"" + fname + "\"";
                }
                String pagenum = ((Logical_file)value).getPagenum();
                int offset = ((Logical_file)value).getOffset();
                rc = this.cfun.procInsertFile(this.handle, variable.getBytes(), fname.getBytes(), pagenum.getBytes(), offset);
                break;
            }
            case 53504: {
                if (!(value instanceof String_array)) break;
                String_array sa = (String_array)value;
                byte[] m_buff = sa.toBytes();
                rc = this.cfun.procInsert(this.handle, variable.getBytes(), m_buff, 53504, ((String_array)value).size());
                break;
            }
            default: {
                String vstr = value.toString();
                byte[] buff = vstr.getBytes();
                rc = this.cfun.procInsert(this.handle, variable.getBytes(), buff, type, buff.length);
            }
        }
        return rc;
    }

    public synchronized String getFormatBackupName(String dbname, int bkid, String filename, int full_bk_id_time) {
        int dblength;
        byte[] bkname = new byte[256];
        byte[] db = dbname.getBytes();
        int rc = this.cfun.getFormatBackupName(db, dblength = db.length, bkid, filename.getBytes(), bkname, full_bk_id_time);
        if (rc == 0) {
            return new String(bkname).trim();
        }
        return null;
    }

    public synchronized int procDelete(String variable, int flag) {
        if (this.handle == null) {
            return -1;
        }
        int rc = this.cfun.procDelete(this.handle, variable.getBytes(), flag);
        return rc;
    }

    public static void setTerminalServer(boolean flag, String name, String svr_address, Integer svr_portnum) {
        JdmConfig config = new JdmConfig();
        if (flag) {
            int rc = config.fileOpen(CONFIG_FILE, name, "r+");
            if (rc != 0) {
                return;
            }
            config.procDelete("DB_SVADR", 0);
            config.procDelete("DB_PTNUM", 0);
            config.fileClose();
            System.out.println("set terminal server on!");
        } else {
            int rc = config.fileOpen(CONFIG_FILE, name, "r+");
            if (rc != 0) {
                return;
            }
            config.insertPara("DB_SVADR", svr_address, 4096);
            config.insertPara("DB_PTNUM", svr_portnum, 8192);
            config.fileClose();
            System.out.println("set terminal server off!");
        }
    }

    public static String[] getBkdirStringArray(String bkdir) {
        String[] sa = JdmConfig.parseBkdir(bkdir);
        return sa;
    }

    private static String[] parseBkdir(String bkdir) {
        String[] tokens = bkdir.split("\\s+(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
        return tokens;
    }

    public static boolean isLegalBkdir(String bkdir) {
        boolean ret = true;
        String[] list = JdmConfig.parseBkdir(bkdir);
        int len = list.length;
        for (int i = 0; i < len; ++i) {
            if (i % 2 == 0) {
                String path = list[i];
                File file = new File(path);
                if (file.exists()) {
                    ret = file.isDirectory();
                } else {
                    ret = file.mkdirs();
                    if (ret) {
                        file.delete();
                    }
                }
            } else {
                try {
                    int size = Integer.parseInt(list[i]);
                    if (size == -1 || size >= 0) {
                        ret = true;
                    }
                }
                catch (Exception e) {
                    ret = false;
                }
            }
            if (!ret) break;
        }
        return ret;
    }

    public static synchronized int getDBPageSize(String dbName) {
        JdmConfig config;
        int rc;
        int result = 8;
        if (dbName != null && (rc = (config = new JdmConfig()).fileOpen(CONFIG_FILE, dbName, "r")) == 0) {
            Integer dbPageSize = (Integer)config.getPara("DB_PGSIZ", 8192);
            result = dbPageSize;
            config.fileClose();
        }
        return result;
    }

    public static void main(String[] args) {
        JdmConfig dmconfig = new JdmConfig();
        dmconfig.fileOpen(CONFIG_FILE, "DB5", "r");
        ArrayList<String> keys = dmconfig.getExistKeys();
        for (String s : keys) {
            System.out.println(s);
        }
        dmconfig.fileClose();
    }
}

