/*
 * Decompiled with CFR 0.152.
 */
package dbatool.tableCell;

import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.resource.DBAImageResource;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class TableHeaderRenderer
extends DefaultTableCellRenderer {
    private ImageIcon notsort = new ImageIcon("");
    private ImageIcon asc = DBAImageResource.getResource(this.getClass(), "/jdbaimages/up.gif");
    private ImageIcon desc = DBAImageResource.getResource(this.getClass(), "/jdbaimages/down.gif");

    public TableHeaderRenderer() {
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.setToolTipText((String)value);
        this.setText((String)value);
        this.setBorder(BorderFactory.createEtchedBorder());
        TableModel model = table.getModel();
        if (model instanceof DBAToolAbstractTableModel) {
            String sort_column_name = ((DBAToolAbstractTableModel)model).getSortingColumn();
            boolean isDesc = ((DBAToolAbstractTableModel)model).isDescSort();
            if (sort_column_name.equals(value)) {
                ImageIcon i = isDesc ? this.desc : this.asc;
                this.setIcon(isDesc ? this.desc : this.asc);
            } else {
                this.setIcon(this.notsort);
            }
        }
        return this;
    }
}

