/*
 * Decompiled with CFR 0.152.
 */
package dbatool.tableCell;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class JSONJTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    final DataType dataType;
    final int index;
    String fieldName;
    final String value;

    public JSONJTreeNode(String fieldName, int index, JsonElement jsonElement) {
        this.index = index;
        this.fieldName = fieldName;
        if (jsonElement.isJsonArray()) {
            this.dataType = DataType.ARRAY;
            this.value = jsonElement.toString();
            this.populateChildren(jsonElement);
        } else if (jsonElement.isJsonObject()) {
            this.dataType = DataType.OBJECT;
            this.value = jsonElement.toString();
            this.populateChildren(jsonElement);
        } else if (jsonElement.isJsonPrimitive()) {
            this.dataType = DataType.VALUE;
            this.value = jsonElement.toString();
        } else if (jsonElement.isJsonNull()) {
            this.dataType = DataType.VALUE;
            this.value = jsonElement.toString();
        } else {
            throw new IllegalArgumentException("jsonElement is an unknown element type.");
        }
    }

    private void populateChildren(JsonElement myJsonElement) {
        switch (this.dataType) {
            case ARRAY: {
                int index = 0;
                for (JsonElement element : myJsonElement.getAsJsonArray()) {
                    JSONJTreeNode childNode = new JSONJTreeNode(null, index, element);
                    this.add(childNode);
                    ++index;
                }
                break;
            }
            case OBJECT: {
                for (Map.Entry entry : myJsonElement.getAsJsonObject().entrySet()) {
                    JSONJTreeNode childNode = new JSONJTreeNode((String)entry.getKey(), -1, (JsonElement)entry.getValue());
                    this.add(childNode);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Internal coding error this should never happen.");
            }
        }
    }

    public JsonElement asJsonElement() {
        StringBuilder sb = new StringBuilder();
        this.buildJsonString(sb);
        String json = sb.toString().trim();
        if (json.startsWith("{") || json.startsWith("[")) {
            return new JsonParser().parse(sb.toString());
        }
        String testValue = "{" + json + "}";
        try {
            JsonElement wrapperElt = new JsonParser().parse(testValue);
            JsonObject obj = (JsonObject)wrapperElt;
            Iterator it = obj.entrySet().iterator();
            Map.Entry entry = (Map.Entry)it.next();
            return (JsonElement)entry.getValue();
        }
        catch (JsonSyntaxException jse) {
            JsonElement rawElement = new JsonParser().parse(json);
            return rawElement;
        }
    }

    private void buildJsonString(StringBuilder sb) {
        if (this.fieldName != null && this.fieldName.length() != 0) {
            sb.append("\"" + this.fieldName + "\":");
        }
        switch (this.dataType) {
            case ARRAY: {
                sb.append("[");
                Enumeration<TreeNode> children = this.children();
                while (children.hasMoreElements()) {
                    JSONJTreeNode child = (JSONJTreeNode)children.nextElement();
                    child.buildJsonString(sb);
                    if (!children.hasMoreElements()) continue;
                    sb.append(",");
                }
                sb.append("]");
                break;
            }
            case OBJECT: {
                sb.append("{");
                Enumeration<TreeNode> children = this.children();
                while (children.hasMoreElements()) {
                    JSONJTreeNode child = (JSONJTreeNode)children.nextElement();
                    child.buildJsonString(sb);
                    if (!children.hasMoreElements()) continue;
                    sb.append(",");
                }
                sb.append("}");
                break;
            }
            default: {
                JsonElement elt = new JsonParser().parse(this.value);
                sb.append(elt.toString());
            }
        }
    }

    @Override
    public String toString() {
        switch (this.dataType) {
            case ARRAY: 
            case OBJECT: {
                if (this.index >= 0) {
                    return String.format("[%d] (%s)", this.index, this.dataType.name());
                }
                if (this.fieldName != null) {
                    return String.format("%s (%s)", this.fieldName, this.dataType.name());
                }
                return String.format("(%s)", this.dataType.name());
            }
        }
        if (this.index >= 0) {
            return String.format("[%d] %s", this.index, this.value);
        }
        if (this.fieldName != null) {
            return String.format("%s: %s", this.fieldName, this.value);
        }
        return String.format("%s", this.value);
    }

    public static enum DataType {
        ARRAY,
        OBJECT,
        VALUE;

    }
}

