/*
 * Decompiled with CFR 0.152.
 */
package dbatool.tableCell;

import java.awt.Component;
import java.sql.ResultSet;

public class BlobCellObject {
    public long size = 0L;
    public String filename = "";
    public String oid = "";
    public String table_owner = "";
    public String table_name = "";
    public String column_name = "";
    public String type = "";
    public boolean asSystemFileObject = false;
    public boolean isView = false;
    public boolean isNull = false;
    public Component comp = null;
    private ResultSet resultSet = null;
    private int rowNum = 0;
    private int colNum = 0;

    public BlobCellObject(String oid, String table_owner, String table_name, String column_name, String type, long size, boolean isNull) {
        this.oid = oid;
        this.table_owner = table_owner;
        this.table_name = table_name;
        this.column_name = column_name;
        this.type = type;
        this.isNull = isNull;
        this.size = size;
        if (this.isNull) {
            this.size = -1L;
        }
        if (this.oid != null && this.oid.equalsIgnoreCase("VIEW")) {
            this.isView = true;
        }
    }

    public BlobCellObject(ResultSet rs, int rowNum, int colNum, String table_owner, String table_name, String column_name, String type, long size, boolean isNull) {
        this.oid = "VIEW";
        this.isView = true;
        this.resultSet = rs;
        this.rowNum = rowNum;
        this.colNum = colNum;
        this.table_owner = table_owner;
        this.table_name = table_name;
        this.column_name = column_name;
        this.type = type;
        this.isNull = isNull;
        this.size = size;
        if (this.isNull) {
            this.size = -1L;
        }
    }

    public BlobCellObject(Component comp, ResultSet rs, int rowNum, int colNum, String column_name, String type, long size, boolean isNull) {
        this.comp = comp;
        this.oid = "VIEW";
        this.isView = true;
        this.resultSet = rs;
        this.rowNum = rowNum;
        this.colNum = colNum;
        this.column_name = column_name;
        this.type = type;
        this.isNull = isNull;
        this.size = size;
        if (this.isNull) {
            this.size = -1L;
        }
    }

    public String toString() {
        if (this.filename != null && this.filename.length() > 0) {
            return this.filename;
        }
        if (this.isNull || this.size == -1L) {
            return "";
        }
        if (this.type.equalsIgnoreCase("file")) {
            return new String("<FILE> " + this.size);
        }
        if (this.type.equalsIgnoreCase("long varchar")) {
            return new String("<CLOB> " + this.size);
        }
        if (this.type.equalsIgnoreCase("clob")) {
            return new String("<CLOB> " + this.size);
        }
        if (this.type.equalsIgnoreCase("nclob")) {
            return new String("<NCLOB> " + this.size);
        }
        return new String("<BLOB> " + this.size);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public int getColNum() {
        return this.colNum;
    }
}

