/*
 * Decompiled with CFR 0.152.
 */
package dbatool.User;

import dbatool.DbFrame;
import dbatool.tableModel.ColumnSorting;
import dbaut.GuiUt;
import dbaut.resource.DBAResourceBundle;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class UserTableModel
extends AbstractTableModel
implements ColumnSorting {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private String[] columnNames = new String[]{this.res.getString("Group_Name"), this.res.getString("Include")};
    private Vector data = new Vector();
    private Vector old_data = null;
    private boolean isEditable = false;

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object[] rowData = (Object[])this.data.elementAt(row);
        return rowData[col];
    }

    public Class getColumnClass(int c) {
        Object[] rowData = (Object[])this.data.elementAt(0);
        return rowData[c].getClass();
    }

    public void addValue(Object[] newData) {
        this.data.addElement(newData);
    }

    @Override
    public void switchOrder(int godown, int goup) {
        Object downRow = this.data.elementAt(godown);
        Object upRow = this.data.elementAt(goup);
        this.data.setElementAt(downRow, goup);
        this.data.setElementAt(upRow, godown);
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
        if (this.isEditable) {
            this.old_data = new Vector();
            int size = this.data.size();
            for (int i = 0; i < size; ++i) {
                this.old_data.addElement(new Boolean((Boolean)this.getValueAt(i, 1)));
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.isEditable && col == 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Object[] rowData = (Object[])this.data.elementAt(row);
        rowData[col] = value;
    }

    public void removeAll() {
        this.data.removeAllElements();
    }

    public Vector getUpdatingUser(String user) {
        Vector<String> v = new Vector<String>();
        int size = this.data.size();
        for (int i = 0; i < size; ++i) {
            Object[] cur_row = (Object[])this.data.elementAt(i);
            Boolean cur_value = (Boolean)cur_row[1];
            String group = (String)cur_row[0];
            Boolean old_value = (Boolean)this.old_data.elementAt(i);
            if (cur_value.booleanValue() && !old_value.booleanValue()) {
                v.addElement(new String("ADD  " + GuiUt.getIDString(user) + " TO GROUP " + GuiUt.getIDString(group)));
            }
            if (cur_value.booleanValue() || !old_value.booleanValue()) continue;
            v.addElement(new String("REMOVE  " + GuiUt.getIDString(user) + " FROM GROUP " + GuiUt.getIDString(group)));
        }
        return v;
    }
}

