/*
 * Decompiled with CFR 0.152.
 */
package dbatool.User;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.ComponentRole;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.LoginDlg;
import dbatool.User.PasswordDlg;
import dbatool.User.PermissionObject;
import dbatool.User.PermissionObjectRenderer;
import dbatool.User.UserPermissionRowInfo;
import dbatool.User.UserPermissionTableModel;
import dbatool.User.UserSchemaTableModel;
import dbatool.User.UserTableModel;
import dbatool.tableCell.BooleanEditor;
import dbatool.tableCell.BooleanRenderer;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.text.TextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class UserInfo
extends DbaTabbedPane
implements ComponentPrivilege,
ComponentRole {
    private static final String SYSADM = "SYSADM";
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private String user = null;
    private boolean isSYSDBA = false;
    private boolean isDBA = false;
    private boolean isResource = false;
    private JTextField User_Name = new TextField();
    private JCheckBox sysdba_CheckBox = new JCheckBox();
    private JCheckBox dba_CheckBox = new JCheckBox();
    private JCheckBox resource_CheckBox = new JCheckBox();
    private DbaButton Modify_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Modify_Button_actionPerformed"));
    private DbaButton Confirm_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Confirm_Button_actionPerformed"));
    private DbaButton Cancel_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'L', DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancel.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
    private DbaButton Password_Button = new DbaButton(new Dimension(140, 24), this.res.getString("Change_password"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/change_password.gif"), new ReflectionAction(this, "Password_Button_actionPerformed"));
    private UserTableModel model = new UserTableModel();
    private DBAToolAbstractTableModel absModel = new DBAToolAbstractTableModel(this.model);
    private JTable table = new JTable(this.absModel);
    private DbaButton Premission_Modify_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Premission_Modify_Button_actionPerformed"));
    private DbaButton Permission_Confirm_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Permission_Confirm_Button_actionPerformed"));
    private DbaButton Permission_Cancel_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'L', DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancel.gif"), new ReflectionAction(this, "Permission_Cancel_Button_actionPerformed"));
    private UserPermissionTableModel model2 = new UserPermissionTableModel();
    private DBAToolAbstractTableModel absModel2 = new DBAToolAbstractTableModel(this.model2);
    private JTable permission_table = new JTable(this.absModel2);
    private UserSchemaTableModel model3 = new UserSchemaTableModel();
    private DBAToolAbstractTableModel absModel3 = new DBAToolAbstractTableModel(this.model3);
    private JTable schema_table = new JTable(this.absModel3);

    public UserInfo(String user) {
        this.user = GuiUt.rightTrim(user);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("UserTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "user.info.properties");
        DbaPanel jPanel4 = new DbaPanel(DbFrame.helpres, "user.info.permission");
        DbaPanel jPanel5 = new DbaPanel(DbFrame.helpres, "user.info.schema");
        JPanel jPanel2 = new JPanel();
        JPanel jToolBar1 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JPanel jToolBar2 = new JPanel(new FlowLayout(0));
        JScrollPane jScrollPane1 = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.User_Name.setText(this.user);
        jPanel1.setLayout(new BorderLayout(5, 5));
        jPanel2.setLayout((LayoutManager)new VerticalFlowLayout());
        jPanel3.setLayout(new GridLayout(2, 3, 5, 5));
        jLabel1.setText(this.res.getString("User_Name_"));
        this.sysdba_CheckBox.setPreferredSize(new Dimension(49, 24));
        this.sysdba_CheckBox.setMinimumSize(new Dimension(49, 24));
        this.sysdba_CheckBox.setText(this.res.getString("SYSDBA"));
        this.dba_CheckBox.setPreferredSize(new Dimension(49, 24));
        this.dba_CheckBox.setMinimumSize(new Dimension(49, 24));
        this.dba_CheckBox.setText(this.res.getString("DBA"));
        this.resource_CheckBox.setPreferredSize(new Dimension(49, 24));
        this.resource_CheckBox.setMinimumSize(new Dimension(49, 24));
        this.resource_CheckBox.setText(this.res.getString("Resource"));
        this.User_Name.setEnabled(false);
        this.User_Name.setMinimumSize(new Dimension(4, 24));
        this.User_Name.setPreferredSize(new Dimension(4, 24));
        jPanel1.setPreferredSize(new Dimension(400, 400));
        jPanel4.setLayout(new BorderLayout(5, 5));
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel1, this.res.getTitle("Properties"));
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.add(jToolBar1);
        jToolBar1.setName("UserPropertiesToolBar");
        this.Modify_Button.setName("ModifyButton");
        this.Confirm_Button.setName("ConfirmButton");
        this.Cancel_Button.setName("CancelButton");
        this.Password_Button.setName("PasswordButton");
        jToolBar1.add((Component)this.Modify_Button, null);
        jToolBar1.add((Component)this.Confirm_Button, null);
        jToolBar1.add((Component)this.Cancel_Button, null);
        jToolBar1.add((Component)this.Password_Button, null);
        jPanel3.setPreferredSize(new Dimension(600, 60));
        jPanel3.setName("UsesPropertiesButtonPanel");
        jPanel3.add(jLabel1);
        this.User_Name.setName("UserNameField");
        this.sysdba_CheckBox.setName("SYSDBACheckBox");
        this.dba_CheckBox.setName("DBACheckBox");
        this.resource_CheckBox.setName("ResCheckBox");
        jPanel3.add(this.User_Name);
        jPanel3.add(new JLabel());
        jPanel3.add(this.sysdba_CheckBox);
        jPanel3.add(this.dba_CheckBox);
        jPanel3.add(this.resource_CheckBox);
        JPanel panel0 = new JPanel(new FlowLayout(0));
        panel0.add(jPanel3);
        jPanel2.add(panel0);
        jPanel1.add((Component)jScrollPane1, "Center");
        this.add((Component)jPanel4, this.res.getTitle("Permission"));
        jPanel4.add((Component)jToolBar2, "North");
        jToolBar2.setName("UserPermissionToolBar");
        this.Premission_Modify_Button.setName("ModifyButton");
        this.Permission_Cancel_Button.setName("CancelButton");
        this.Permission_Confirm_Button.setName("ConfirmButton");
        jToolBar2.add((Component)this.Premission_Modify_Button, null);
        jToolBar2.add((Component)this.Permission_Confirm_Button, null);
        jToolBar2.add((Component)this.Permission_Cancel_Button, null);
        jPanel4.add((Component)jScrollPane2, "Center");
        this.add((Component)jPanel5, this.res.getString("Schema"));
        jPanel5.add((Component)jScrollPane3, "Center");
        jScrollPane2.getViewport().add((Component)this.permission_table, null);
        jScrollPane1.getViewport().add((Component)this.table, null);
        jScrollPane3.getViewport().add((Component)this.schema_table, null);
        this.permission_table.setSelectionMode(0);
        this.table.setSelectionMode(0);
        this.permission_table.getTableHeader().setReorderingAllowed(false);
        this.setUpBooleanRendererEditor(this.table);
        this.setUpBooleanRendererEditor(this.permission_table);
        this.setUpPermissionObjectRenderer(this.permission_table, 0);
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.setEditable(false);
        this.setPermissionEditable(false);
        this.getUserInfo();
        this.getPermissionInfo();
        this.getSchemaInfo();
        this.initPermissionColumnSizes(this.permission_table);
        this.initSchemaColumnSize(this.schema_table);
        this.table.setName("UserPropertiesTable");
        this.permission_table.setName("UserPermissionTable");
        this.schema_table.setName("UserSchemaTable");
        this.absModel2.addMouseListenerToHeaderInTable(this.permission_table);
    }

    @Override
    public int getComponentType() {
        return 108;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Password_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        boolean isModified = !enabled && this.authority.isAboveDba();
        this.Modify_Button.setEnabled(isModified);
        this.Confirm_Button.setEnabled(enabled);
        this.Cancel_Button.setEnabled(enabled);
        boolean isAuthoritied = enabled && !this.user.equals(SYSADM) && (this.authority.isSysadm() || this.authority.isSysdba() && !this.isSYSDBA);
        boolean isSysdba = enabled && !this.user.equals(SYSADM) && this.authority.isSysadm();
        this.sysdba_CheckBox.setEnabled(isSysdba);
        this.dba_CheckBox.setEnabled(isAuthoritied);
        this.resource_CheckBox.setEnabled(isAuthoritied);
    }

    @Override
    public boolean isAuthorised() {
        return LoginDlg.loginUserName.equals(this.user) || this.authority.isSysdba() && !this.isSYSDBA && !this.user.equals(SYSADM);
    }

    private void initSchemaColumnSize(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(180);
    }

    private void initPermissionColumnSizes(JTable table) {
        TableColumn column = null;
        int[] sizes = new int[]{180, 60, 60, 60, 60, 60, 60, 60, 60};
        int length = sizes.length;
        for (int i = 0; i < length; ++i) {
            column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth(sizes[i]);
        }
    }

    private void setUpPermissionObjectRenderer(JTable table, int index) {
        TableColumn column = table.getColumnModel().getColumn(index);
        column.setCellRenderer(new PermissionObjectRenderer());
    }

    private void setUpBooleanRendererEditor(JTable table) {
        table.setDefaultEditor(Boolean.class, new BooleanEditor(table, table.getModel()));
        table.setDefaultRenderer(Boolean.class, new BooleanRenderer());
    }

    private void setPermissionEditable(boolean editable) {
        if (editable) {
            this.Premission_Modify_Button.setEnabled(false);
            this.Permission_Cancel_Button.setEnabled(true);
            this.Permission_Confirm_Button.setEnabled(true);
        } else {
            if (this.authority.isAboveDba()) {
                this.Premission_Modify_Button.setEnabled(true);
            } else {
                this.Premission_Modify_Button.setEnabled(false);
            }
            this.Permission_Cancel_Button.setEnabled(false);
            this.Permission_Confirm_Button.setEnabled(false);
        }
    }

    private void setEditable(boolean editable) {
        this.grant(editable);
    }

    private void getPermissionInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            UserPermissionRowInfo one_row;
            String name;
            String owner;
            this.model2.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select t.TABLE_OWNER, t.TABLE_NAME, t.TABLE_TYPE, sat.TABLE_NAME, SEL_ALL, DEL_ALL, INS_ALL, UPD_ALL, ALT_ALL, IDX_ALL, REF_ALL from SYSTEM.SYSTABLE t outer SYSTEM.SYSAUTHTABLE sat where t.TABLE_OWNER = sat.TABLE_OWNER and t.TABLE_NAME = sat.TABLE_NAME and sat.GRANTEE = '" + this.user + "' ";
            if (!DbFrame.frame.px.getShowSystemTable()) {
                query = query + "and t.TABLE_TYPE in ('TABLE','VIEW') ";
            }
            query = query + "order by t.TABLE_TYPE ";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                owner = GuiUt.rightTrim(rs.getString(1));
                name = GuiUt.rightTrim(rs.getString(2));
                String type = rs.getString(3).trim();
                int table_type = type.indexOf("TABLE") >= 0 ? 0 : 2;
                PermissionObject obj = new PermissionObject(table_type, null, GuiUt.rightTrim(owner), GuiUt.rightTrim(name), null);
                if (this.isSYSDBA || this.isDBA || this.isResource && this.user.equalsIgnoreCase(owner)) {
                    one_row = new UserPermissionRowInfo(obj, 1, 1, 1, 1, 1, 1, 1, 0);
                    this.model2.addValue(one_row);
                    continue;
                }
                String atname = rs.getString(4);
                one_row = !rs.wasNull() ? new UserPermissionRowInfo(obj, rs.getShort(5), rs.getShort(6), rs.getShort(7), rs.getShort(8), rs.getShort(9), rs.getShort(10), rs.getShort(11), 0) : new UserPermissionRowInfo(obj, 0, 0, 0, 0, 0, 0, 0, 0);
                this.model2.addValue(one_row);
            }
            rs.close();
            query = "select c.CMDOWNER, c.CMDNAME, a.OBJNAME from SYSTEM.SYSCMDINFO c outer SYSTEM.SYSAUTHEXE a where c.CMDOWNER = a.OWNER and c.CMDNAME = a.OBJNAME and a.OBJTYPE = 'COMMAND' and a.GRANTEE = '" + this.user + "' ";
            query = query + "order by c.CMDOWNER, c.CMDNAME ";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                owner = rs.getString(1);
                name = rs.getString(2);
                PermissionObject obj = new PermissionObject(3, null, GuiUt.rightTrim(owner), GuiUt.rightTrim(name), null);
                if (this.isSYSDBA || this.isDBA || this.isResource && this.user.equalsIgnoreCase(owner)) {
                    one_row = new UserPermissionRowInfo(obj, 0, 0, 0, 0, 0, 0, 0, 1);
                    this.model2.addValue(one_row);
                    continue;
                }
                String objname = rs.getString(3);
                one_row = !rs.wasNull() ? new UserPermissionRowInfo(obj, 0, 0, 0, 0, 0, 0, 0, 1) : new UserPermissionRowInfo(obj, 0, 0, 0, 0, 0, 0, 0, 0);
                this.model2.addValue(one_row);
            }
            rs.close();
            query = "select p.MODULENAME, p.PROC_OWNER, p.PROC_NAME, a.OBJNAME from SYSTEM.SYSPROCINFO p outer SYSTEM.SYSAUTHEXE a where p.PROC_OWNER = a.OWNER and p.PROC_NAME = a.OBJNAME and a.OBJTYPE = 'PROCEDURE' and a.GRANTEE = '" + this.user + "' ";
            query = query + "order by p.PROC_OWNER, p.PROC_NAME ";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String module = rs.getString(1);
                String owner2 = rs.getString(2);
                String name2 = rs.getString(3);
                PermissionObject obj = new PermissionObject(4, GuiUt.rightTrim(module), GuiUt.rightTrim(owner2), GuiUt.rightTrim(name2), null);
                if (this.isSYSDBA || this.isDBA || this.isResource && this.user.equalsIgnoreCase(owner2)) {
                    one_row = new UserPermissionRowInfo(obj, 0, 0, 0, 0, 0, 0, 0, 1);
                    this.model2.addValue(one_row);
                    continue;
                }
                String objname = rs.getString(4);
                one_row = !rs.wasNull() ? new UserPermissionRowInfo(obj, 0, 0, 0, 0, 0, 0, 0, 1) : new UserPermissionRowInfo(obj, 0, 0, 0, 0, 0, 0, 0, 0);
                this.model2.addValue(one_row);
            }
            rs.close();
            stmt.close();
            this.absModel2.fireTableChanged(new TableModelEvent(this.absModel2));
        }
        catch (SQLException e) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, e);
        }
    }

    private void getSchemaInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            this.model3.removeAll();
            String query = "SELECT SCHEMA_NAME FROM SYSSCHEMA WHERE SCHEMA_OWNER = '" + this.user + "' ";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                Object[] one_row = new Object[]{rs.getString(1).trim()};
                this.model3.addValue(one_row);
            }
            rs.close();
            stmt.close();
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        }
        catch (SQLException e) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, e);
        }
    }

    private void getUserInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "SELECT DBA, RESOURCE from SYSAUTHUSER WHERE USER_NAME = '" + this.user + "'";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.isSYSDBA = rs.getShort(1) == 2 || this.user.equals(SYSADM);
                this.isDBA = rs.getShort(1) == 1;
                this.isResource = rs.getShort(2) == 1;
                this.resource_CheckBox.setSelected(this.isResource);
                this.dba_CheckBox.setSelected(this.isDBA);
                this.sysdba_CheckBox.setSelected(this.isSYSDBA);
                this.model2.isResource = this.isResource;
                this.model2.user = this.user;
            }
            rs.close();
            this.model.removeAll();
            query = this.authority.isAboveDba() ? "SELECT g.GROUP_NAME, m.GROUP_NAME FROM SYSTEM.SYSAUTHGROUP g outer SYSTEM.SYSAUTHMEMBER m WHERE g.GROUP_NAME = m.GROUP_NAME AND m.MEMBER_NAME = '" + this.user + "' " : "SELECT  GROUP_NAME  FROM SYSTEM.SYSAUTHMEMBER WHERE MEMBER_NAME = '" + this.user + "' ";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                Object[] one_row = new Object[]{GuiUt.rightTrim(rs.getString(1)), new Boolean(!rs.wasNull())};
                this.model.addValue(one_row);
            }
            rs.close();
            stmt.close();
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        }
        catch (SQLException e) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, e);
        }
    }

    public void Modify_Button_actionPerformed(ActionEvent e) {
        this.fixTabbedPanelAt(this.getSelectedIndex());
        this.getUserInfo();
        this.getPermissionInfo();
        this.getSchemaInfo();
        this.setEditable(true);
        this.model.setEditable(true);
        this.revalidate();
        this.repaint();
    }

    public void Confirm_Button_actionPerformed(ActionEvent e) {
        boolean result;
        StringBuffer query_sb = new StringBuffer();
        if (!this.isResource && this.resource_CheckBox.isSelected()) {
            query_sb.append("GRANT RESOURCE TO ").append(GuiUt.getIDString(this.user)).append(";\n");
        }
        if (!this.isDBA && this.dba_CheckBox.isSelected()) {
            query_sb.append("GRANT DBA TO ").append(GuiUt.getIDString(this.user)).append(";\n");
        }
        if (!this.isSYSDBA && this.sysdba_CheckBox.isSelected()) {
            query_sb.append("GRANT SYSDBA TO ").append(GuiUt.getIDString(this.user)).append(";\n");
        }
        if (this.isSYSDBA && !this.sysdba_CheckBox.isSelected()) {
            query_sb.append("REVOKE SYSDBA FROM ").append(GuiUt.getIDString(this.user)).append(";\n");
        }
        if ((this.isSYSDBA || this.isDBA) && !this.sysdba_CheckBox.isSelected() && !this.dba_CheckBox.isSelected()) {
            query_sb.append("REVOKE DBA FROM ").append(GuiUt.getIDString(this.user)).append(";\n");
        }
        if (this.isResource && !this.resource_CheckBox.isSelected()) {
            query_sb.append("REVOKE RESOURCE FROM ").append(GuiUt.getIDString(this.user)).append(";\n");
        }
        Vector v = this.model.getUpdatingUser(this.user);
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            query_sb.append((String)v.elementAt(i)).append(";\n");
        }
        if (query_sb.length() > 0 && !(result = DatabaseConnection.executeMultiSQL(query_sb.toString()))) {
            return;
        }
        this.Cancel_Button_actionPerformed(null);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.getUserInfo();
        this.getPermissionInfo();
        this.getSchemaInfo();
        this.setEditable(false);
        this.model.setEditable(false);
        this.releaseTabbedPanel();
    }

    public void Password_Button_actionPerformed(ActionEvent e) {
        PasswordDlg dlg = DbFrame.isWindows ? new PasswordDlg((Frame)DbFrame.frame, this.user) : new PasswordDlg((Frame)DbFrame.frame, "", true, this.user);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.show();
        dlg = null;
    }

    public void Premission_Modify_Button_actionPerformed(ActionEvent e) {
        this.fixTabbedPanelAt(this.getSelectedIndex());
        this.setPermissionEditable(true);
        this.model2.setEditable(true);
        this.absModel2.fireTableChanged(new TableModelEvent(this.absModel2));
        this.revalidate();
        this.repaint();
    }

    public void Permission_Confirm_Button_actionPerformed(ActionEvent e) {
        boolean result;
        Vector v = this.model2.getUpdatingData(this.user);
        StringBuffer query_sb = new StringBuffer();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            query_sb.append((String)v.elementAt(i)).append(";\n");
        }
        if (query_sb.length() > 0 && !(result = DatabaseConnection.executeMultiSQL(query_sb.toString()))) {
            return;
        }
        this.Permission_Cancel_Button_actionPerformed(null);
    }

    public void Permission_Cancel_Button_actionPerformed(ActionEvent e) {
        this.getPermissionInfo();
        this.setPermissionEditable(false);
        this.model2.setEditable(false);
        this.releaseTabbedPanel();
    }
}

